/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The color swatch as an RGB hex value with no leading `#`. For example: `000000`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#color Environment#color}
    */
    readonly color: string;
    /**
    * Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#confirm_changes Environment#confirm_changes}
    */
    readonly confirmChanges?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/home/data-export).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#default_track_events Environment#default_track_events}
    */
    readonly defaultTrackEvents?: boolean | cdktf.IResolvable;
    /**
    * The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/home/organize/environments#ttl-settings).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#default_ttl Environment#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#id Environment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project-unique key for the environment. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#key Environment#key}
    */
    readonly key: string;
    /**
    * The name of the environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#name Environment#name}
    */
    readonly name: string;
    /**
    * The LaunchDarkly project key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#project_key Environment#project_key}
    */
    readonly projectKey: string;
    /**
    * Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#require_comments Environment#require_comments}
    */
    readonly requireComments?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#secure_mode Environment#secure_mode}
    */
    readonly secureMode?: boolean | cdktf.IResolvable;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#tags Environment#tags}
    */
    readonly tags?: string[];
    /**
    * approval_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#approval_settings Environment#approval_settings}
    */
    readonly approvalSettings?: EnvironmentApprovalSettings[] | cdktf.IResolvable;
}
export interface EnvironmentApprovalSettings {
    /**
    * Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#can_apply_declined_changes Environment#can_apply_declined_changes}
    */
    readonly canApplyDeclinedChanges?: boolean | cdktf.IResolvable;
    /**
    * Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#can_review_own_request Environment#can_review_own_request}
    */
    readonly canReviewOwnRequest?: boolean | cdktf.IResolvable;
    /**
    * The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#min_num_approvals Environment#min_num_approvals}
    */
    readonly minNumApprovals?: number;
    /**
    * Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#required Environment#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment#required_approval_tags Environment#required_approval_tags}
    */
    readonly requiredApprovalTags?: string[];
}
export declare function environmentApprovalSettingsToTerraform(struct?: EnvironmentApprovalSettings | cdktf.IResolvable): any;
export declare class EnvironmentApprovalSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EnvironmentApprovalSettings | cdktf.IResolvable | undefined;
    set internalValue(value: EnvironmentApprovalSettings | cdktf.IResolvable | undefined);
    private _canApplyDeclinedChanges?;
    get canApplyDeclinedChanges(): boolean | cdktf.IResolvable;
    set canApplyDeclinedChanges(value: boolean | cdktf.IResolvable);
    resetCanApplyDeclinedChanges(): void;
    get canApplyDeclinedChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _canReviewOwnRequest?;
    get canReviewOwnRequest(): boolean | cdktf.IResolvable;
    set canReviewOwnRequest(value: boolean | cdktf.IResolvable);
    resetCanReviewOwnRequest(): void;
    get canReviewOwnRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _minNumApprovals?;
    get minNumApprovals(): number;
    set minNumApprovals(value: number);
    resetMinNumApprovals(): void;
    get minNumApprovalsInput(): number | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredApprovalTags?;
    get requiredApprovalTags(): string[];
    set requiredApprovalTags(value: string[]);
    resetRequiredApprovalTags(): void;
    get requiredApprovalTagsInput(): string[] | undefined;
}
export declare class EnvironmentApprovalSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EnvironmentApprovalSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EnvironmentApprovalSettingsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment launchdarkly_environment}
*/
export declare class Environment extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_environment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/environment launchdarkly_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: EnvironmentConfig);
    get apiKey(): string;
    get clientSideId(): string;
    private _color?;
    get color(): string;
    set color(value: string);
    get colorInput(): string | undefined;
    private _confirmChanges?;
    get confirmChanges(): boolean | cdktf.IResolvable;
    set confirmChanges(value: boolean | cdktf.IResolvable);
    resetConfirmChanges(): void;
    get confirmChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultTrackEvents?;
    get defaultTrackEvents(): boolean | cdktf.IResolvable;
    set defaultTrackEvents(value: boolean | cdktf.IResolvable);
    resetDefaultTrackEvents(): void;
    get defaultTrackEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get mobileKey(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _requireComments?;
    get requireComments(): boolean | cdktf.IResolvable;
    set requireComments(value: boolean | cdktf.IResolvable);
    resetRequireComments(): void;
    get requireCommentsInput(): boolean | cdktf.IResolvable | undefined;
    private _secureMode?;
    get secureMode(): boolean | cdktf.IResolvable;
    set secureMode(value: boolean | cdktf.IResolvable);
    resetSecureMode(): void;
    get secureModeInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _approvalSettings;
    get approvalSettings(): EnvironmentApprovalSettingsList;
    putApprovalSettings(value: EnvironmentApprovalSettings[] | cdktf.IResolvable): void;
    resetApprovalSettings(): void;
    get approvalSettingsInput(): cdktf.IResolvable | EnvironmentApprovalSettings[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
