/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FeatureFlagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether the flag is archived or not. Note that you cannot create a new flag that is archived, but can update a flag to be archived.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#archived FeatureFlag#archived}
    */
    readonly archived?: boolean | cdktf.IResolvable;
    /**
    * The feature flag's description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#description FeatureFlag#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#id FeatureFlag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether this flag should be made available to the client-side JavaScript SDK using the client-side Id. This value gets its default from your project configuration if not set. `include_in_snippet` is now deprecated. Please migrate to `client_side_availability.using_environment_id` to maintain future compatibility.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#include_in_snippet FeatureFlag#include_in_snippet}
    */
    readonly includeInSnippet?: boolean | cdktf.IResolvable;
    /**
    * The unique feature flag key that references the flag in your application code. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#key FeatureFlag#key}
    */
    readonly key: string;
    /**
    * The feature flag maintainer's 24 character alphanumeric team member ID. If not set, it will automatically be or stay set to the member ID associated with the API key used by your LaunchDarkly Terraform provider or the most recently-set maintainer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#maintainer_id FeatureFlag#maintainer_id}
    */
    readonly maintainerId?: string;
    /**
    * The human-readable name of the feature flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#name FeatureFlag#name}
    */
    readonly name: string;
    /**
    * The feature flag's project key. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#project_key FeatureFlag#project_key}
    */
    readonly projectKey: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#tags FeatureFlag#tags}
    */
    readonly tags?: string[];
    /**
    * Specifies whether the flag is a temporary flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#temporary FeatureFlag#temporary}
    */
    readonly temporary?: boolean | cdktf.IResolvable;
    /**
    * The feature flag's variation type: `boolean`, `string`, `number` or `json`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#variation_type FeatureFlag#variation_type}
    */
    readonly variationType: string;
    /**
    * client_side_availability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#client_side_availability FeatureFlag#client_side_availability}
    */
    readonly clientSideAvailability?: FeatureFlagClientSideAvailability[] | cdktf.IResolvable;
    /**
    * custom_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#custom_properties FeatureFlag#custom_properties}
    */
    readonly customProperties?: FeatureFlagCustomProperties[] | cdktf.IResolvable;
    /**
    * defaults block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#defaults FeatureFlag#defaults}
    */
    readonly defaults?: FeatureFlagDefaults;
    /**
    * variations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#variations FeatureFlag#variations}
    */
    readonly variations?: FeatureFlagVariations[] | cdktf.IResolvable;
}
export interface FeatureFlagClientSideAvailability {
    /**
    * Whether this flag is available to SDKs using the client-side ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#using_environment_id FeatureFlag#using_environment_id}
    */
    readonly usingEnvironmentId?: boolean | cdktf.IResolvable;
    /**
    * Whether this flag is available to SDKs using a mobile key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#using_mobile_key FeatureFlag#using_mobile_key}
    */
    readonly usingMobileKey?: boolean | cdktf.IResolvable;
}
export declare function featureFlagClientSideAvailabilityToTerraform(struct?: FeatureFlagClientSideAvailability | cdktf.IResolvable): any;
export declare class FeatureFlagClientSideAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagClientSideAvailability | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagClientSideAvailability | cdktf.IResolvable | undefined);
    private _usingEnvironmentId?;
    get usingEnvironmentId(): boolean | cdktf.IResolvable;
    set usingEnvironmentId(value: boolean | cdktf.IResolvable);
    resetUsingEnvironmentId(): void;
    get usingEnvironmentIdInput(): boolean | cdktf.IResolvable | undefined;
    private _usingMobileKey?;
    get usingMobileKey(): boolean | cdktf.IResolvable;
    set usingMobileKey(value: boolean | cdktf.IResolvable);
    resetUsingMobileKey(): void;
    get usingMobileKeyInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class FeatureFlagClientSideAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagClientSideAvailability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagClientSideAvailabilityOutputReference;
}
export interface FeatureFlagCustomProperties {
    /**
    * The unique custom property key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#key FeatureFlag#key}
    */
    readonly key: string;
    /**
    * The name of the custom property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#name FeatureFlag#name}
    */
    readonly name: string;
    /**
    * The list of custom property value strings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#value FeatureFlag#value}
    */
    readonly value: string[];
}
export declare function featureFlagCustomPropertiesToTerraform(struct?: FeatureFlagCustomProperties | cdktf.IResolvable): any;
export declare class FeatureFlagCustomPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagCustomProperties | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagCustomProperties | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string[];
    set value(value: string[]);
    get valueInput(): string[] | undefined;
}
export declare class FeatureFlagCustomPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagCustomProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagCustomPropertiesOutputReference;
}
export interface FeatureFlagDefaults {
    /**
    * The index of the variation the flag will default to in all new environments when off.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#off_variation FeatureFlag#off_variation}
    */
    readonly offVariation: number;
    /**
    * The index of the variation the flag will default to in all new environments when on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#on_variation FeatureFlag#on_variation}
    */
    readonly onVariation: number;
}
export declare function featureFlagDefaultsToTerraform(struct?: FeatureFlagDefaultsOutputReference | FeatureFlagDefaults): any;
export declare class FeatureFlagDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FeatureFlagDefaults | undefined;
    set internalValue(value: FeatureFlagDefaults | undefined);
    private _offVariation?;
    get offVariation(): number;
    set offVariation(value: number);
    get offVariationInput(): number | undefined;
    private _onVariation?;
    get onVariation(): number;
    set onVariation(value: number);
    get onVariationInput(): number | undefined;
}
export interface FeatureFlagVariations {
    /**
    * The variation's description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#description FeatureFlag#description}
    */
    readonly description?: string;
    /**
    * The name of the variation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#name FeatureFlag#name}
    */
    readonly name?: string;
    /**
    * The variation value. The value's type must correspond to the `variation_type` argument. For example: `variation_type = "boolean"` accepts only `true` or `false`. The `number` variation type accepts both floats and ints, but please note that any trailing zeroes on floats will be trimmed (i.e. `1.1` and `1.100` will both be converted to `1.1`).
  
  If you wish to define an empty string variation, you must still define the value field on the variations block like so:
  
  ```terraform
  variations {
    value = ""
  }
  ```
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag#value FeatureFlag#value}
    */
    readonly value: string;
}
export declare function featureFlagVariationsToTerraform(struct?: FeatureFlagVariations | cdktf.IResolvable): any;
export declare class FeatureFlagVariationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FeatureFlagVariations | cdktf.IResolvable | undefined;
    set internalValue(value: FeatureFlagVariations | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class FeatureFlagVariationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FeatureFlagVariations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FeatureFlagVariationsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag launchdarkly_feature_flag}
*/
export declare class FeatureFlag extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_feature_flag";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/feature_flag launchdarkly_feature_flag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FeatureFlagConfig
    */
    constructor(scope: Construct, id: string, config: FeatureFlagConfig);
    private _archived?;
    get archived(): boolean | cdktf.IResolvable;
    set archived(value: boolean | cdktf.IResolvable);
    resetArchived(): void;
    get archivedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeInSnippet?;
    get includeInSnippet(): boolean | cdktf.IResolvable;
    set includeInSnippet(value: boolean | cdktf.IResolvable);
    resetIncludeInSnippet(): void;
    get includeInSnippetInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _maintainerId?;
    get maintainerId(): string;
    set maintainerId(value: string);
    resetMaintainerId(): void;
    get maintainerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _temporary?;
    get temporary(): boolean | cdktf.IResolvable;
    set temporary(value: boolean | cdktf.IResolvable);
    resetTemporary(): void;
    get temporaryInput(): boolean | cdktf.IResolvable | undefined;
    private _variationType?;
    get variationType(): string;
    set variationType(value: string);
    get variationTypeInput(): string | undefined;
    private _clientSideAvailability;
    get clientSideAvailability(): FeatureFlagClientSideAvailabilityList;
    putClientSideAvailability(value: FeatureFlagClientSideAvailability[] | cdktf.IResolvable): void;
    resetClientSideAvailability(): void;
    get clientSideAvailabilityInput(): cdktf.IResolvable | FeatureFlagClientSideAvailability[] | undefined;
    private _customProperties;
    get customProperties(): FeatureFlagCustomPropertiesList;
    putCustomProperties(value: FeatureFlagCustomProperties[] | cdktf.IResolvable): void;
    resetCustomProperties(): void;
    get customPropertiesInput(): cdktf.IResolvable | FeatureFlagCustomProperties[] | undefined;
    private _defaults;
    get defaults(): FeatureFlagDefaultsOutputReference;
    putDefaults(value: FeatureFlagDefaults): void;
    resetDefaults(): void;
    get defaultsInput(): FeatureFlagDefaults | undefined;
    private _variations;
    get variations(): FeatureFlagVariationsList;
    putVariations(value: FeatureFlagVariations[] | cdktf.IResolvable): void;
    resetVariations(): void;
    get variationsInput(): cdktf.IResolvable | FeatureFlagVariations[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
