/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FlagTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the trigger is currently active or not. This property defaults to true upon creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#enabled FlagTrigger#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The LaunchDarkly environment key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#env_key FlagTrigger#env_key}
    */
    readonly envKey: string;
    /**
    * The key of the feature flag the trigger acts upon
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#flag_key FlagTrigger#flag_key}
    */
    readonly flagKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#id FlagTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The unique identifier of the integration you intend to set your trigger up with. "generic-trigger" should be used for integrations not explicitly supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#integration_key FlagTrigger#integration_key}
    */
    readonly integrationKey: string;
    /**
    * The LaunchDarkly project key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#project_key FlagTrigger#project_key}
    */
    readonly projectKey: string;
    /**
    * instructions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#instructions FlagTrigger#instructions}
    */
    readonly instructions: FlagTriggerInstructions;
}
export interface FlagTriggerInstructions {
    /**
    * The action to perform when triggering. Currently supported flag actions are "turnFlagOn" and "turnFlagOff".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger#kind FlagTrigger#kind}
    */
    readonly kind: string;
}
export declare function flagTriggerInstructionsToTerraform(struct?: FlagTriggerInstructionsOutputReference | FlagTriggerInstructions): any;
export declare class FlagTriggerInstructionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FlagTriggerInstructions | undefined;
    set internalValue(value: FlagTriggerInstructions | undefined);
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger launchdarkly_flag_trigger}
*/
export declare class FlagTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_flag_trigger";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/flag_trigger launchdarkly_flag_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FlagTriggerConfig
    */
    constructor(scope: Construct, id: string, config: FlagTriggerConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _flagKey?;
    get flagKey(): string;
    set flagKey(value: string);
    get flagKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationKey?;
    get integrationKey(): string;
    set integrationKey(value: string);
    get integrationKeyInput(): string | undefined;
    get maintainerId(): string;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    get triggerUrl(): string;
    private _instructions;
    get instructions(): FlagTriggerInstructionsOutputReference;
    putInstructions(value: FlagTriggerInstructions): void;
    get instructionsInput(): FlagTriggerInstructions | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
