/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LaunchdarklyProviderConfig {
    /**
    * The [personal access token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#personal-tokens) or [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens) used to authenticate with LaunchDarkly. You can also set this with the `LAUNCHDARKLY_ACCESS_TOKEN` environment variable. You must provide either `access_token` or `oauth_token`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs#access_token LaunchdarklyProvider#access_token}
    */
    readonly accessToken?: string;
    /**
    * The LaunchDarkly host address. If this argument is not specified, the default host address is `https://app.launchdarkly.com`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs#api_host LaunchdarklyProvider#api_host}
    */
    readonly apiHost?: string;
    /**
    * The HTTP timeout (in seconds) when making API calls to LaunchDarkly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs#http_timeout LaunchdarklyProvider#http_timeout}
    */
    readonly httpTimeout?: number;
    /**
    * An OAuth V2 token you use to authenticate with LaunchDarkly. You can also set this with the `LAUNCHDARKLY_OAUTH_TOKEN` environment variable. You must provide either `access_token` or `oauth_token`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs#oauth_token LaunchdarklyProvider#oauth_token}
    */
    readonly oauthToken?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs#alias LaunchdarklyProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs launchdarkly}
*/
export declare class LaunchdarklyProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "launchdarkly";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs launchdarkly} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LaunchdarklyProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: LaunchdarklyProviderConfig);
    private _accessToken?;
    get accessToken(): string | undefined;
    set accessToken(value: string | undefined);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _apiHost?;
    get apiHost(): string | undefined;
    set apiHost(value: string | undefined);
    resetApiHost(): void;
    get apiHostInput(): string | undefined;
    private _httpTimeout?;
    get httpTimeout(): number | undefined;
    set httpTimeout(value: number | undefined);
    resetHttpTimeout(): void;
    get httpTimeoutInput(): number | undefined;
    private _oauthToken?;
    get oauthToken(): string | undefined;
    set oauthToken(value: string | undefined);
    resetOauthToken(): void;
    get oauthTokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
