"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchdarklyProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs launchdarkly}
*/
class LaunchdarklyProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs launchdarkly} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LaunchdarklyProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'launchdarkly',
            terraformGeneratorMetadata: {
                providerName: 'launchdarkly',
                providerVersion: '2.15.1',
                providerVersionConstraint: '~> 2.13'
            },
            terraformProviderSource: 'launchdarkly/launchdarkly'
        });
        this._accessToken = config.accessToken;
        this._apiHost = config.apiHost;
        this._httpTimeout = config.httpTimeout;
        this._oauthToken = config.oauthToken;
        this._alias = config.alias;
    }
    get accessToken() {
        return this._accessToken;
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get apiHost() {
        return this._apiHost;
    }
    set apiHost(value) {
        this._apiHost = value;
    }
    resetApiHost() {
        this._apiHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiHostInput() {
        return this._apiHost;
    }
    get httpTimeout() {
        return this._httpTimeout;
    }
    set httpTimeout(value) {
        this._httpTimeout = value;
    }
    resetHttpTimeout() {
        this._httpTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpTimeoutInput() {
        return this._httpTimeout;
    }
    get oauthToken() {
        return this._oauthToken;
    }
    set oauthToken(value) {
        this._oauthToken = value;
    }
    resetOauthToken() {
        this._oauthToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthTokenInput() {
        return this._oauthToken;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_token: cdktf.stringToTerraform(this._accessToken),
            api_host: cdktf.stringToTerraform(this._apiHost),
            http_timeout: cdktf.numberToTerraform(this._httpTimeout),
            oauth_token: cdktf.stringToTerraform(this._oauthToken),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.LaunchdarklyProvider = LaunchdarklyProvider;
_a = JSII_RTTI_SYMBOL_1;
LaunchdarklyProvider[_a] = { fqn: "@cdktf/provider-launchdarkly.provider.LaunchdarklyProvider", version: "2.0.1" };
// =================
// STATIC PROPERTIES
// =================
LaunchdarklyProvider.tfResourceType = "launchdarkly";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJvdmlkZXIvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFTQSwrQkFBK0I7QUFxQy9COztFQUVFO0FBQ0YsTUFBYSxvQkFBcUIsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBTy9ELGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFNBQXFDLEVBQUU7UUFDdEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxjQUFjO1lBQ3JDLDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsY0FBYztnQkFDNUIsZUFBZSxFQUFFLFFBQVE7Z0JBQ3pCLHlCQUF5QixFQUFFLFNBQVM7YUFDckM7WUFDRCx1QkFBdUIsRUFBRSwyQkFBMkI7U0FDckQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBUUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBeUI7UUFDOUMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBeUI7UUFDMUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUF5QjtRQUM5QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUF5QjtRQUM3QyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBQ0QsSUFBVyxLQUFLLENBQUMsS0FBeUI7UUFDeEMsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDdEIsQ0FBQztJQUNNLFVBQVU7UUFDZixJQUFJLENBQUMsTUFBTSxHQUFHLFNBQVMsQ0FBQztJQUMxQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3hELFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoRCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELEtBQUssRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztTQUM1QyxDQUFDO0lBQ0osQ0FBQzs7QUFuSUgsb0RBb0lDOzs7QUFsSUMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyxtQ0FBYyxHQUFHLGNBQWMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluYy5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG4gKi9cblxuLy8gaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2xhdW5jaGRhcmtseS9sYXVuY2hkYXJrbHkvMi4xNS4xL2RvY3Ncbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBMYXVuY2hkYXJrbHlQcm92aWRlckNvbmZpZyB7XG4gIC8qKlxuICAqIFRoZSBbcGVyc29uYWwgYWNjZXNzIHRva2VuXShodHRwczovL2RvY3MubGF1bmNoZGFya2x5LmNvbS9ob21lL2FjY291bnQtc2VjdXJpdHkvYXBpLWFjY2Vzcy10b2tlbnMjcGVyc29uYWwtdG9rZW5zKSBvciBbc2VydmljZSB0b2tlbl0oaHR0cHM6Ly9kb2NzLmxhdW5jaGRhcmtseS5jb20vaG9tZS9hY2NvdW50LXNlY3VyaXR5L2FwaS1hY2Nlc3MtdG9rZW5zI3NlcnZpY2UtdG9rZW5zKSB1c2VkIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIExhdW5jaERhcmtseS4gWW91IGNhbiBhbHNvIHNldCB0aGlzIHdpdGggdGhlIGBMQVVOQ0hEQVJLTFlfQUNDRVNTX1RPS0VOYCBlbnZpcm9ubWVudCB2YXJpYWJsZS4gWW91IG11c3QgcHJvdmlkZSBlaXRoZXIgYGFjY2Vzc190b2tlbmAgb3IgYG9hdXRoX3Rva2VuYC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2xhdW5jaGRhcmtseS9sYXVuY2hkYXJrbHkvMi4xNS4xL2RvY3MjYWNjZXNzX3Rva2VuIExhdW5jaGRhcmtseVByb3ZpZGVyI2FjY2Vzc190b2tlbn1cbiAgKi9cbiAgcmVhZG9ubHkgYWNjZXNzVG9rZW4/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBMYXVuY2hEYXJrbHkgaG9zdCBhZGRyZXNzLiBJZiB0aGlzIGFyZ3VtZW50IGlzIG5vdCBzcGVjaWZpZWQsIHRoZSBkZWZhdWx0IGhvc3QgYWRkcmVzcyBpcyBgaHR0cHM6Ly9hcHAubGF1bmNoZGFya2x5LmNvbWBcbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2xhdW5jaGRhcmtseS9sYXVuY2hkYXJrbHkvMi4xNS4xL2RvY3MjYXBpX2hvc3QgTGF1bmNoZGFya2x5UHJvdmlkZXIjYXBpX2hvc3R9XG4gICovXG4gIHJlYWRvbmx5IGFwaUhvc3Q/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBIVFRQIHRpbWVvdXQgKGluIHNlY29uZHMpIHdoZW4gbWFraW5nIEFQSSBjYWxscyB0byBMYXVuY2hEYXJrbHkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9sYXVuY2hkYXJrbHkvbGF1bmNoZGFya2x5LzIuMTUuMS9kb2NzI2h0dHBfdGltZW91dCBMYXVuY2hkYXJrbHlQcm92aWRlciNodHRwX3RpbWVvdXR9XG4gICovXG4gIHJlYWRvbmx5IGh0dHBUaW1lb3V0PzogbnVtYmVyO1xuICAvKipcbiAgKiBBbiBPQXV0aCBWMiB0b2tlbiB5b3UgdXNlIHRvIGF1dGhlbnRpY2F0ZSB3aXRoIExhdW5jaERhcmtseS4gWW91IGNhbiBhbHNvIHNldCB0aGlzIHdpdGggdGhlIGBMQVVOQ0hEQVJLTFlfT0FVVEhfVE9LRU5gIGVudmlyb25tZW50IHZhcmlhYmxlLiBZb3UgbXVzdCBwcm92aWRlIGVpdGhlciBgYWNjZXNzX3Rva2VuYCBvciBgb2F1dGhfdG9rZW5gLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvbGF1bmNoZGFya2x5L2xhdW5jaGRhcmtseS8yLjE1LjEvZG9jcyNvYXV0aF90b2tlbiBMYXVuY2hkYXJrbHlQcm92aWRlciNvYXV0aF90b2tlbn1cbiAgKi9cbiAgcmVhZG9ubHkgb2F1dGhUb2tlbj86IHN0cmluZztcbiAgLyoqXG4gICogQWxpYXMgbmFtZVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvbGF1bmNoZGFya2x5L2xhdW5jaGRhcmtseS8yLjE1LjEvZG9jcyNhbGlhcyBMYXVuY2hkYXJrbHlQcm92aWRlciNhbGlhc31cbiAgKi9cbiAgcmVhZG9ubHkgYWxpYXM/OiBzdHJpbmc7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9sYXVuY2hkYXJrbHkvbGF1bmNoZGFya2x5LzIuMTUuMS9kb2NzIGxhdW5jaGRhcmtseX1cbiovXG5leHBvcnQgY2xhc3MgTGF1bmNoZGFya2x5UHJvdmlkZXIgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1Qcm92aWRlciB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwibGF1bmNoZGFya2x5XCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9sYXVuY2hkYXJrbHkvbGF1bmNoZGFya2x5LzIuMTUuMS9kb2NzIGxhdW5jaGRhcmtseX0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgTGF1bmNoZGFya2x5UHJvdmlkZXJDb25maWcgPSB7fVxuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBMYXVuY2hkYXJrbHlQcm92aWRlckNvbmZpZyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdsYXVuY2hkYXJrbHknLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnbGF1bmNoZGFya2x5JyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnMi4xNS4xJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDIuMTMnXG4gICAgICB9LFxuICAgICAgdGVycmFmb3JtUHJvdmlkZXJTb3VyY2U6ICdsYXVuY2hkYXJrbHkvbGF1bmNoZGFya2x5J1xuICAgIH0pO1xuICAgIHRoaXMuX2FjY2Vzc1Rva2VuID0gY29uZmlnLmFjY2Vzc1Rva2VuO1xuICAgIHRoaXMuX2FwaUhvc3QgPSBjb25maWcuYXBpSG9zdDtcbiAgICB0aGlzLl9odHRwVGltZW91dCA9IGNvbmZpZy5odHRwVGltZW91dDtcbiAgICB0aGlzLl9vYXV0aFRva2VuID0gY29uZmlnLm9hdXRoVG9rZW47XG4gICAgdGhpcy5fYWxpYXMgPSBjb25maWcuYWxpYXM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFjY2Vzc190b2tlbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hY2Nlc3NUb2tlbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYWNjZXNzVG9rZW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjY2Vzc1Rva2VuO1xuICB9XG4gIHB1YmxpYyBzZXQgYWNjZXNzVG9rZW4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2FjY2Vzc1Rva2VuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWNjZXNzVG9rZW4oKSB7XG4gICAgdGhpcy5fYWNjZXNzVG9rZW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFjY2Vzc1Rva2VuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjY2Vzc1Rva2VuO1xuICB9XG5cbiAgLy8gYXBpX2hvc3QgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXBpSG9zdD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYXBpSG9zdCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXBpSG9zdDtcbiAgfVxuICBwdWJsaWMgc2V0IGFwaUhvc3QodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2FwaUhvc3QgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBcGlIb3N0KCkge1xuICAgIHRoaXMuX2FwaUhvc3QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFwaUhvc3RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXBpSG9zdDtcbiAgfVxuXG4gIC8vIGh0dHBfdGltZW91dCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9odHRwVGltZW91dD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaHR0cFRpbWVvdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBUaW1lb3V0O1xuICB9XG4gIHB1YmxpYyBzZXQgaHR0cFRpbWVvdXQodmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2h0dHBUaW1lb3V0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SHR0cFRpbWVvdXQoKSB7XG4gICAgdGhpcy5faHR0cFRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGh0dHBUaW1lb3V0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBUaW1lb3V0O1xuICB9XG5cbiAgLy8gb2F1dGhfdG9rZW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2F1dGhUb2tlbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgb2F1dGhUb2tlbigpIHtcbiAgICByZXR1cm4gdGhpcy5fb2F1dGhUb2tlbjtcbiAgfVxuICBwdWJsaWMgc2V0IG9hdXRoVG9rZW4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX29hdXRoVG9rZW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPYXV0aFRva2VuKCkge1xuICAgIHRoaXMuX29hdXRoVG9rZW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG9hdXRoVG9rZW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fb2F1dGhUb2tlbjtcbiAgfVxuXG4gIC8vIGFsaWFzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsaWFzPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhbGlhcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cbiAgcHVibGljIHNldCBhbGlhcyh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWxpYXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGlhcygpIHtcbiAgICB0aGlzLl9hbGlhcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWxpYXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFjY2Vzc190b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWNjZXNzVG9rZW4pLFxuICAgICAgYXBpX2hvc3Q6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2FwaUhvc3QpLFxuICAgICAgaHR0cF90aW1lb3V0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9odHRwVGltZW91dCksXG4gICAgICBvYXV0aF90b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fb2F1dGhUb2tlbiksXG4gICAgICBhbGlhczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWxpYXMpLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==