/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CustomRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base permission level - either reader or no_access. Defaults to reader
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#base_permissions CustomRole#base_permissions}
    */
    readonly basePermissions?: string;
    /**
    * Description of the custom role
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#description CustomRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#id CustomRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A unique key that will be used to reference the custom role in your code
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#key CustomRole#key}
    */
    readonly key: string;
    /**
    * A name for the custom role
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#name CustomRole#name}
    */
    readonly name: string;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#policy CustomRole#policy}
    */
    readonly policy?: CustomRolePolicy[] | cdktf.IResolvable;
    /**
    * policy_statements block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#policy_statements CustomRole#policy_statements}
    */
    readonly policyStatements?: CustomRolePolicyStatements[] | cdktf.IResolvable;
}
export interface CustomRolePolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#actions CustomRole#actions}
    */
    readonly actions: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#effect CustomRole#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#resources CustomRole#resources}
    */
    readonly resources: string[];
}
export declare function customRolePolicyToTerraform(struct?: CustomRolePolicy | cdktf.IResolvable): any;
export declare class CustomRolePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CustomRolePolicy | cdktf.IResolvable | undefined;
    set internalValue(value: CustomRolePolicy | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    get resourcesInput(): string[] | undefined;
}
export declare class CustomRolePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CustomRolePolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CustomRolePolicyOutputReference;
}
export interface CustomRolePolicyStatements {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
  Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#actions CustomRole#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#effect CustomRole#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#not_actions CustomRole#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#not_resources CustomRole#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role#resources CustomRole#resources}
    */
    readonly resources?: string[];
}
export declare function customRolePolicyStatementsToTerraform(struct?: CustomRolePolicyStatements | cdktf.IResolvable): any;
export declare class CustomRolePolicyStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CustomRolePolicyStatements | cdktf.IResolvable | undefined;
    set internalValue(value: CustomRolePolicyStatements | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class CustomRolePolicyStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CustomRolePolicyStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CustomRolePolicyStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role launchdarkly_custom_role}
*/
export declare class CustomRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_custom_role";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/custom_role launchdarkly_custom_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CustomRoleConfig
    */
    constructor(scope: Construct, id: string, config: CustomRoleConfig);
    private _basePermissions?;
    get basePermissions(): string;
    set basePermissions(value: string);
    resetBasePermissions(): void;
    get basePermissionsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy;
    get policy(): CustomRolePolicyList;
    putPolicy(value: CustomRolePolicy[] | cdktf.IResolvable): void;
    resetPolicy(): void;
    get policyInput(): cdktf.IResolvable | CustomRolePolicy[] | undefined;
    private _policyStatements;
    get policyStatements(): CustomRolePolicyStatementsList;
    putPolicyStatements(value: CustomRolePolicyStatements[] | cdktf.IResolvable): void;
    resetPolicyStatements(): void;
    get policyStatementsInput(): cdktf.IResolvable | CustomRolePolicyStatements[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
