/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyFeatureFlagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/feature_flag#id DataLaunchdarklyFeatureFlag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The unique feature flag key that references the flag in your application code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/feature_flag#key DataLaunchdarklyFeatureFlag#key}
    */
    readonly key: string;
    /**
    * The feature flag's project key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/feature_flag#project_key DataLaunchdarklyFeatureFlag#project_key}
    */
    readonly projectKey: string;
}
export interface DataLaunchdarklyFeatureFlagClientSideAvailability {
}
export declare function dataLaunchdarklyFeatureFlagClientSideAvailabilityToTerraform(struct?: DataLaunchdarklyFeatureFlagClientSideAvailability): any;
export declare class DataLaunchdarklyFeatureFlagClientSideAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagClientSideAvailability | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagClientSideAvailability | undefined);
    get usingEnvironmentId(): cdktf.IResolvable;
    get usingMobileKey(): cdktf.IResolvable;
}
export declare class DataLaunchdarklyFeatureFlagClientSideAvailabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagClientSideAvailabilityOutputReference;
}
export interface DataLaunchdarklyFeatureFlagCustomProperties {
}
export declare function dataLaunchdarklyFeatureFlagCustomPropertiesToTerraform(struct?: DataLaunchdarklyFeatureFlagCustomProperties): any;
export declare class DataLaunchdarklyFeatureFlagCustomPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagCustomProperties | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagCustomProperties | undefined);
    get key(): string;
    get name(): string;
    get value(): string[];
}
export declare class DataLaunchdarklyFeatureFlagCustomPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagCustomPropertiesOutputReference;
}
export interface DataLaunchdarklyFeatureFlagDefaults {
}
export declare function dataLaunchdarklyFeatureFlagDefaultsToTerraform(struct?: DataLaunchdarklyFeatureFlagDefaults): any;
export declare class DataLaunchdarklyFeatureFlagDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagDefaults | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagDefaults | undefined);
    get offVariation(): number;
    get onVariation(): number;
}
export declare class DataLaunchdarklyFeatureFlagDefaultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagDefaultsOutputReference;
}
export interface DataLaunchdarklyFeatureFlagVariations {
}
export declare function dataLaunchdarklyFeatureFlagVariationsToTerraform(struct?: DataLaunchdarklyFeatureFlagVariations): any;
export declare class DataLaunchdarklyFeatureFlagVariationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagVariations | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagVariations | undefined);
    get description(): string;
    get name(): string;
    get value(): string;
}
export declare class DataLaunchdarklyFeatureFlagVariationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagVariationsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/feature_flag launchdarkly_feature_flag}
*/
export declare class DataLaunchdarklyFeatureFlag extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_feature_flag";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/feature_flag launchdarkly_feature_flag} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyFeatureFlagConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyFeatureFlagConfig);
    get archived(): cdktf.IResolvable;
    private _clientSideAvailability;
    get clientSideAvailability(): DataLaunchdarklyFeatureFlagClientSideAvailabilityList;
    private _customProperties;
    get customProperties(): DataLaunchdarklyFeatureFlagCustomPropertiesList;
    private _defaults;
    get defaults(): DataLaunchdarklyFeatureFlagDefaultsList;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get includeInSnippet(): cdktf.IResolvable;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get maintainerId(): string;
    get name(): string;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    get tags(): string[];
    get temporary(): cdktf.IResolvable;
    get variationType(): string;
    private _variations;
    get variations(): DataLaunchdarklyFeatureFlagVariationsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
