/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyTeamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/team_member#email DataLaunchdarklyTeamMember#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/team_member#id DataLaunchdarklyTeamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/team_member launchdarkly_team_member}
*/
export declare class DataLaunchdarklyTeamMember extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_team_member";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/team_member launchdarkly_team_member} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyTeamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyTeamMemberConfig);
    get customRoles(): string[];
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get firstName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastName(): string;
    get role(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
