/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetricConfig extends cdktf.TerraformMetaArguments {
    /**
    * A short description of what the metric will be used for
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#description Metric#description}
    */
    readonly description?: string;
    /**
    * The event key for your metric (if custom metric)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#event_key Metric#event_key}
    */
    readonly eventKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#id Metric#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the metric is active
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#is_active Metric#is_active}
    */
    readonly isActive?: boolean | cdktf.IResolvable;
    /**
    * Whether the metric is numeric
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#is_numeric Metric#is_numeric}
    */
    readonly isNumeric?: boolean | cdktf.IResolvable;
    /**
    * A unique key that will be used to reference the metric in your code
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#key Metric#key}
    */
    readonly key: string;
    /**
    * The metric type -available choices are 'pageview', 'click', and 'custom'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#kind Metric#kind}
    */
    readonly kind: string;
    /**
    * The LaunchDarkly ID of the user who will maintain the metric. If not set, the API will automatically apply the member associated with your Terraform API key or the most recently-set maintainer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#maintainer_id Metric#maintainer_id}
    */
    readonly maintainerId?: string;
    /**
    * A human-readable name for your metric
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#name Metric#name}
    */
    readonly name: string;
    /**
    * The LaunchDarkly project key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#project_key Metric#project_key}
    */
    readonly projectKey: string;
    /**
    * A set of one or more context kinds that this metric can measure events from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#randomization_units Metric#randomization_units}
    */
    readonly randomizationUnits?: string[];
    /**
    * The CSS selector for your metric (if click metric)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#selector Metric#selector}
    */
    readonly selector?: string;
    /**
    * The success criteria for your metric (if numeric metric)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#success_criteria Metric#success_criteria}
    */
    readonly successCriteria?: string;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#tags Metric#tags}
    */
    readonly tags?: string[];
    /**
    * The unit for your metric (if numeric metric)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#unit Metric#unit}
    */
    readonly unit?: string;
    /**
    * urls block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#urls Metric#urls}
    */
    readonly urls?: MetricUrls[] | cdktf.IResolvable;
}
export interface MetricUrls {
    /**
    * The url type - available choices are 'exact', 'canonical', 'substring' and 'regex'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#kind Metric#kind}
    */
    readonly kind: string;
    /**
    * The URL-matching regex
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#pattern Metric#pattern}
    */
    readonly pattern?: string;
    /**
    * The URL substring
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#substring Metric#substring}
    */
    readonly substring?: string;
    /**
    * The exact or canonical URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric#url Metric#url}
    */
    readonly url?: string;
}
export declare function metricUrlsToTerraform(struct?: MetricUrls | cdktf.IResolvable): any;
export declare class MetricUrlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MetricUrls | cdktf.IResolvable | undefined;
    set internalValue(value: MetricUrls | cdktf.IResolvable | undefined);
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _substring?;
    get substring(): string;
    set substring(value: string);
    resetSubstring(): void;
    get substringInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export declare class MetricUrlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MetricUrls[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MetricUrlsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric launchdarkly_metric}
*/
export declare class Metric extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_metric";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/metric launchdarkly_metric} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetricConfig
    */
    constructor(scope: Construct, id: string, config: MetricConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventKey?;
    get eventKey(): string;
    set eventKey(value: string);
    resetEventKey(): void;
    get eventKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isActive?;
    get isActive(): boolean | cdktf.IResolvable;
    set isActive(value: boolean | cdktf.IResolvable);
    resetIsActive(): void;
    get isActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _isNumeric?;
    get isNumeric(): boolean | cdktf.IResolvable;
    set isNumeric(value: boolean | cdktf.IResolvable);
    resetIsNumeric(): void;
    get isNumericInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _maintainerId?;
    get maintainerId(): string;
    set maintainerId(value: string);
    resetMaintainerId(): void;
    get maintainerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _randomizationUnits?;
    get randomizationUnits(): string[];
    set randomizationUnits(value: string[]);
    resetRandomizationUnits(): void;
    get randomizationUnitsInput(): string[] | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _successCriteria?;
    get successCriteria(): string;
    set successCriteria(value: string);
    resetSuccessCriteria(): void;
    get successCriteriaInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _urls;
    get urls(): MetricUrlsList;
    putUrls(value: MetricUrls[] | cdktf.IResolvable): void;
    resetUrls(): void;
    get urlsInput(): cdktf.IResolvable | MetricUrls[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
