/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RelayProxyConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#id RelayProxyConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A human-friendly name for the Relay Proxy configuration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#name RelayProxyConfiguration#name}
    */
    readonly name: string;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#policy RelayProxyConfiguration#policy}
    */
    readonly policy: RelayProxyConfigurationPolicy[] | cdktf.IResolvable;
}
export interface RelayProxyConfigurationPolicy {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
  Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#actions RelayProxyConfiguration#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#effect RelayProxyConfiguration#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#not_actions RelayProxyConfiguration#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#not_resources RelayProxyConfiguration#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration#resources RelayProxyConfiguration#resources}
    */
    readonly resources?: string[];
}
export declare function relayProxyConfigurationPolicyToTerraform(struct?: RelayProxyConfigurationPolicy | cdktf.IResolvable): any;
export declare class RelayProxyConfigurationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RelayProxyConfigurationPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: RelayProxyConfigurationPolicy | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class RelayProxyConfigurationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RelayProxyConfigurationPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RelayProxyConfigurationPolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration launchdarkly_relay_proxy_configuration}
*/
export declare class RelayProxyConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_relay_proxy_configuration";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/relay_proxy_configuration launchdarkly_relay_proxy_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RelayProxyConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: RelayProxyConfigurationConfig);
    get displayKey(): string;
    get fullKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy;
    get policy(): RelayProxyConfigurationPolicyList;
    putPolicy(value: RelayProxyConfigurationPolicy[] | cdktf.IResolvable): void;
    get policyInput(): cdktf.IResolvable | RelayProxyConfigurationPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
