/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom role keys for the team
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#custom_role_keys Team#custom_role_keys}
    */
    readonly customRoleKeys?: string[];
    /**
    * The team's description
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#description Team#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#id Team#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The team's unique key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#key Team#key}
    */
    readonly key: string;
    /**
    * A list of team maintainer IDs as strings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#maintainers Team#maintainers}
    */
    readonly maintainers?: string[];
    /**
    * A list of team member IDs as strings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#member_ids Team#member_ids}
    */
    readonly memberIds?: string[];
    /**
    * The team's human-readable name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team#name Team#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team launchdarkly_team}
*/
export declare class Team extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_team";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/team launchdarkly_team} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamConfig
    */
    constructor(scope: Construct, id: string, config: TeamConfig);
    private _customRoleKeys?;
    get customRoleKeys(): string[];
    set customRoleKeys(value: string[]);
    resetCustomRoleKeys(): void;
    get customRoleKeysInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _maintainers?;
    get maintainers(): string[];
    set maintainers(value: string[]);
    resetMaintainers(): void;
    get maintainersInput(): string[] | undefined;
    private _memberIds?;
    get memberIds(): string[];
    set memberIds(value: string[]);
    resetMemberIds(): void;
    get memberIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
