# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: controller/readout.proto, controller/job.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto


class ControllerJobExecutionResultStatus(betterproto.Enum):
    UNKNOWN = 0
    SUCCESS = 1
    FAILURE = 2


@dataclass
class Complex64(betterproto.Message):
    """
    Complex64 is a 64-bit complex value with float32 real and imaginary parts
    """

    real: float = betterproto.float_field(1)
    imaginary: float = betterproto.float_field(2)


@dataclass
class ReadoutValues(betterproto.Message):
    """
    ReadoutValues are data readout values that have been read out from the
    quantum processor and optionally processed by a readout transformation
    pipeline.
    """

    integer_values: "IntegerReadoutValues" = betterproto.message_field(1, group="values")
    complex_values: "Complex64ReadoutValues" = betterproto.message_field(2, group="values")


@dataclass
class IntegerReadoutValues(betterproto.Message):
    """
    IntegerReadoutValues are integer arrays emitted by a readout receiver or
    transformation pipeline. These may include (but are not limited to) qudit
    values or raw ADC capture data.
    """

    values: List[int] = betterproto.int32_field(1)


@dataclass
class Complex64ReadoutValues(betterproto.Message):
    """
    Complex64ReadoutValues are arrays of complex numbers emitted by a readout
    receiver or transformation pipeline.
    """

    values: List["Complex64"] = betterproto.message_field(1)


@dataclass
class EncryptedControllerJob(betterproto.Message):
    """
    An EncryptedControllerJob includes the configuration necessary to execute
    an instance of the contained job data on control hardware.
    """

    # Encrypted form of ControllerJobData.
    data: bytes = betterproto.bytes_field(1)
    # Information about the means by which `data` was encrypted.
    encryption: "JobEncryption" = betterproto.message_field(2)
    # Memory values to be patched into the program by the Controller Service
    # prior to execution. The string key is used to match the name of the memory
    # region as defined in the InstrumentProgram. The type of the DataValue must
    # match the defined type of the region.
    memory_values: Dict[str, "DataValue"] = betterproto.map_field(3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)


@dataclass
class JobEncryption(betterproto.Message):
    """
    Information about the means by which ControllerJobData was encrypted.
    """

    key_id: str = betterproto.string_field(1)


@dataclass
class DataValue(betterproto.Message):
    """
    The value of the data to insert into memory corresponding to a
    MemoryRegion.
    """

    # Binary value, corresponding to both BIT and OCTET data types in Quil.
    binary: "BinaryDataValue" = betterproto.message_field(101, group="value")
    # Signed integer value, corresponding to INTEGER in Quil.
    integer: "IntegerDataValue" = betterproto.message_field(102, group="value")
    # Real number value, corresponding to REAL in Quil.
    real: "RealDataValue" = betterproto.message_field(103, group="value")


@dataclass
class BinaryDataValue(betterproto.Message):
    """
    Binary value, corresponding to both BIT and OCTET data types in Quil.
    """

    data: bytes = betterproto.bytes_field(1)


@dataclass
class IntegerDataValue(betterproto.Message):
    """Signed integer value, corresponding to INTEGER in Quil."""

    data: List[int] = betterproto.int64_field(1)


@dataclass
class RealDataValue(betterproto.Message):
    """Real number value, corresponding to REAL in Quil."""

    data: List[float] = betterproto.double_field(1)


@dataclass
class ControllerJobExecutionResult(betterproto.Message):
    """
    A ControllerJobExecutionResult includes the result data from a single
    execution of a ControllerJob.
    """

    # The contents of each memory region, keyed on region name
    memory_values: Dict[str, "DataValue"] = betterproto.map_field(1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    # The contents of readout data published by the readout transformation
    # pipeline,  keyed on the node ID of the publishing readout transformation
    # node.
    readout_values: Dict[str, "ReadoutValues"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    status: "ControllerJobExecutionResultStatus" = betterproto.enum_field(3)
