"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'comprehendmedical';
        this.accessLevelList = {
            Read: [
                'DescribeEntitiesDetectionV2Job',
                'DescribeICD10CMInferenceJob',
                'DescribePHIDetectionJob',
                'DescribeRxNormInferenceJob',
                'DescribeSNOMEDCTInferenceJob',
                'DetectEntitiesV2',
                'DetectPHI',
                'InferICD10CM',
                'InferRxNorm',
                'InferSNOMEDCT',
                'ListEntitiesDetectionV2Jobs',
                'ListICD10CMInferenceJobs',
                'ListPHIDetectionJobs',
                'ListRxNormInferenceJobs',
                'ListSNOMEDCTInferenceJobs'
            ],
            Write: [
                'StartEntitiesDetectionV2Job',
                'StartICD10CMInferenceJob',
                'StartPHIDetectionJob',
                'StartRxNormInferenceJob',
                'StartSNOMEDCTInferenceJob',
                'StopEntitiesDetectionV2Job',
                'StopICD10CMInferenceJob',
                'StopPHIDetectionJob',
                'StopRxNormInferenceJob',
                'StopSNOMEDCTInferenceJob'
            ]
        };
    }
    /**
     * Grants permission to describe the properties of a medical entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeEntitiesDetectionV2Job.html
     */
    toDescribeEntitiesDetectionV2Job() {
        return this.to('DescribeEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeICD10CMInferenceJob.html
     */
    toDescribeICD10CMInferenceJob() {
        return this.to('DescribeICD10CMInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a PHI entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribePHIDetectionJob.html
     */
    toDescribePHIDetectionJob() {
        return this.to('DescribePHIDetectionJob');
    }
    /**
     * Grants permission to describe the properties of an RxNorm linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeRxNormInferenceJob.html
     */
    toDescribeRxNormInferenceJob() {
        return this.to('DescribeRxNormInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a SNOMED-CT linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeSNOMEDCTInferenceJob.html
     */
    toDescribeSNOMEDCTInferenceJob() {
        return this.to('DescribeSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to detect the named medical entities, and their relationships and traits within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DetectEntitiesV2.html
     */
    toDetectEntitiesV2() {
        return this.to('DetectEntitiesV2');
    }
    /**
     * Grants permission to detect the protected health information (PHI) entities within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DetectPHI.html
     */
    toDetectPHI() {
        return this.to('DetectPHI');
    }
    /**
     * Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferICD10CM.html
     */
    toInferICD10CM() {
        return this.to('InferICD10CM');
    }
    /**
     * Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferRxNorm.html
     */
    toInferRxNorm() {
        return this.to('InferRxNorm');
    }
    /**
     * Grants permission to detect the medical condition, anatomy, and test, treatment, and procedure entities within the given text document and link them to SNOMED-CT codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferSNOMEDCT.html
     */
    toInferSNOMEDCT() {
        return this.to('InferSNOMEDCT');
    }
    /**
     * Grants permission to list the medical entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListEntitiesDetectionV2Jobs.html
     */
    toListEntitiesDetectionV2Jobs() {
        return this.to('ListEntitiesDetectionV2Jobs');
    }
    /**
     * Grants permission to list the ICD-10-CM linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListICD10CMInferenceJobs.html
     */
    toListICD10CMInferenceJobs() {
        return this.to('ListICD10CMInferenceJobs');
    }
    /**
     * Grants permission to list the PHI entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListPHIDetectionJobs.html
     */
    toListPHIDetectionJobs() {
        return this.to('ListPHIDetectionJobs');
    }
    /**
     * Grants permission to list the RxNorm linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListRxNormInferenceJobs.html
     */
    toListRxNormInferenceJobs() {
        return this.to('ListRxNormInferenceJobs');
    }
    /**
     * Grants permission to list the SNOMED-CT linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListSNOMEDCTInferenceJobs.html
     */
    toListSNOMEDCTInferenceJobs() {
        return this.to('ListSNOMEDCTInferenceJobs');
    }
    /**
     * Grants permission to start an asynchronous medical entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartEntitiesDetectionV2Job.html
     */
    toStartEntitiesDetectionV2Job() {
        return this.to('StartEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartICD10CMInferenceJob.html
     */
    toStartICD10CMInferenceJob() {
        return this.to('StartICD10CMInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous PHI entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartPHIDetectionJob.html
     */
    toStartPHIDetectionJob() {
        return this.to('StartPHIDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous RxNorm linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartRxNormInferenceJob.html
     */
    toStartRxNormInferenceJob() {
        return this.to('StartRxNormInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous SNOMED-CT linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartSNOMEDCTInferenceJob.html
     */
    toStartSNOMEDCTInferenceJob() {
        return this.to('StartSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to stop a medical entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopEntitiesDetectionV2Job.html
     */
    toStopEntitiesDetectionV2Job() {
        return this.to('StopEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to stop an ICD-10-CM linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopICD10CMInferenceJob.html
     */
    toStopICD10CMInferenceJob() {
        return this.to('StopICD10CMInferenceJob');
    }
    /**
     * Grants permission to stop a PHI entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopPHIDetectionJob.html
     */
    toStopPHIDetectionJob() {
        return this.to('StopPHIDetectionJob');
    }
    /**
     * Grants permission to stop an RxNorm linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopRxNormInferenceJob.html
     */
    toStopRxNormInferenceJob() {
        return this.to('StopRxNormInferenceJob');
    }
    /**
     * Grants permission to stop a SNOMED-CT linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopSNOMEDCTInferenceJob.html
     */
    toStopSNOMEDCTInferenceJob() {
        return this.to('StopSNOMEDCTInferenceJob');
    }
}
exports.Comprehendmedical = Comprehendmedical;
_a = JSII_RTTI_SYMBOL_1;
Comprehendmedical[_a] = { fqn: "cdk-iam-floyd.Comprehendmedical", version: "0.343.0" };
//# sourceMappingURL=data:application/json;base64,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