"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schemas = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [schemas](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgeschemas.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Schemas extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [schemas](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgeschemas.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'schemas';
        this.accessLevelList = {
            Write: [
                'CreateDiscoverer',
                'CreateRegistry',
                'CreateSchema',
                'DeleteDiscoverer',
                'DeleteRegistry',
                'DeleteResourcePolicy',
                'DeleteSchema',
                'DeleteSchemaVersion',
                'PutCodeBinding',
                'PutResourcePolicy',
                'StartDiscoverer',
                'StopDiscoverer',
                'UpdateDiscoverer',
                'UpdateRegistry',
                'UpdateSchema'
            ],
            Read: [
                'DescribeCodeBinding',
                'DescribeDiscoverer',
                'DescribeRegistry',
                'DescribeSchema',
                'ExportSchema',
                'GetCodeBindingSource',
                'GetDiscoveredSchema',
                'GetResourcePolicy'
            ],
            List: [
                'ListDiscoverers',
                'ListRegistries',
                'ListSchemaVersions',
                'ListSchemas',
                'ListTagsForResource',
                'SearchSchemas'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Creates an event schema discoverer. Once created, your events will be automatically map into corresponding schema documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#CreateDiscoverer
     */
    toCreateDiscoverer() {
        return this.to('CreateDiscoverer');
    }
    /**
     * Create a new schema registry in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#CreateRegistry
     */
    toCreateRegistry() {
        return this.to('CreateRegistry');
    }
    /**
     * Create a new schema in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#CreateSchema
     */
    toCreateSchema() {
        return this.to('CreateSchema');
    }
    /**
     * Deletes discoverer in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#DeleteDiscoverer
     */
    toDeleteDiscoverer() {
        return this.to('DeleteDiscoverer');
    }
    /**
     * Deletes an existing registry in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#DeleteRegistry
     */
    toDeleteRegistry() {
        return this.to('DeleteRegistry');
    }
    /**
     * Delete the resource-based policy attached to a given registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#DeleteResourcePolicy
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Deletes an existing schema in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#DeleteSchema
     */
    toDeleteSchema() {
        return this.to('DeleteSchema');
    }
    /**
     * Deletes a specific version of schema in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-version-schemaversion.html#DeleteSchemaVersion
     */
    toDeleteSchemaVersion() {
        return this.to('DeleteSchemaVersion');
    }
    /**
     * Retrieves metadata for generated code for specific schema in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language.html#DescribeCodeBinding
     */
    toDescribeCodeBinding() {
        return this.to('DescribeCodeBinding');
    }
    /**
     * Retrieves discoverer metadata in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#DescribeDiscoverer
     */
    toDescribeDiscoverer() {
        return this.to('DescribeDiscoverer');
    }
    /**
     * Describes an existing registry metadata in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#DescribeRegistry
     */
    toDescribeRegistry() {
        return this.to('DescribeRegistry');
    }
    /**
     * Retrieves an existing schema in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#DescribeSchema
     */
    toDescribeSchema() {
        return this.to('DescribeSchema');
    }
    /**
     * Allows exporting AWS registry or discovered schemas in OpenAPI 3 format to JSONSchema format.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#ExportSchema
     */
    toExportSchema() {
        return this.to('ExportSchema');
    }
    /**
     * Retrieves metadata for generated code for specific schema in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language-source.html#GetCodeBindingSource
     */
    toGetCodeBindingSource() {
        return this.to('GetCodeBindingSource');
    }
    /**
     * Retrieves schema for the provided list of sample events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discover.html#GetDiscoveredSchema
     */
    toGetDiscoveredSchema() {
        return this.to('GetDiscoveredSchema');
    }
    /**
     * Retrieves the resource-based policy attached to a given registry.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#GetResourcePolicy
     */
    toGetResourcePolicy() {
        return this.to('GetResourcePolicy');
    }
    /**
     * Lists all the discoverers in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#ListDiscoverers
     */
    toListDiscoverers() {
        return this.to('ListDiscoverers');
    }
    /**
     * List all discoverers in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries.html#ListRegistries
     */
    toListRegistries() {
        return this.to('ListRegistries');
    }
    /**
     * List all versions of a schema.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-versions.html#ListSchemaVersions
     */
    toListSchemaVersions() {
        return this.to('ListSchemaVersions');
    }
    /**
     * List all schemas.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas.html#ListSchemas
     */
    toListSchemas() {
        return this.to('ListSchemas');
    }
    /**
     * This action lists tags for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#ListTagsForResource
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Generates code for specific schema in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname-language-language.html#PutCodeBinding
     */
    toPutCodeBinding() {
        return this.to('PutCodeBinding');
    }
    /**
     * Attach resource-based policy to the specific registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-policy.html#PutResourcePolicy
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Searches schemas based on specified keywords in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-search.html#SearchSchemas
     */
    toSearchSchemas() {
        return this.to('SearchSchemas');
    }
    /**
     * Starts the specified discoverer. Once started the discoverer will automatically register schemas for published events to configured source in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#StartDiscoverer
     */
    toStartDiscoverer() {
        return this.to('StartDiscoverer');
    }
    /**
     * Starts the specified discoverer. Once started the discoverer will automatically register schemas for published events to configured source in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#StopDiscoverer
     */
    toStopDiscoverer() {
        return this.to('StopDiscoverer');
    }
    /**
     * This action tags an resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#TagResource
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * This action removes a tag from on a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/tags-resource-arn.html#UntagResource
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Updates an existing discoverer in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers-id-discovererid.html#UpdateDiscoverer
     */
    toUpdateDiscoverer() {
        return this.to('UpdateDiscoverer');
    }
    /**
     * Updates an existing registry metadata in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname.html#UpdateRegistry
     */
    toUpdateRegistry() {
        return this.to('UpdateRegistry');
    }
    /**
     * Updates an existing schema in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-registries-name-registryname-schemas-name-schemaname.html#UpdateSchema
     */
    toUpdateSchema() {
        return this.to('UpdateSchema');
    }
    /**
     * Adds a resource of type discoverer to the statement
     *
     * https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html
     *
     * @param discovererId - Identifier for the discovererId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDiscoverer(discovererId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:schemas:${region || '*'}:${account || '*'}:discoverer/${discovererId}`);
    }
    /**
     * Adds a resource of type registry to the statement
     *
     * https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html
     *
     * @param registryName - Identifier for the registryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRegistry(registryName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:schemas:${region || '*'}:${account || '*'}:registry/${registryName}`);
    }
    /**
     * Adds a resource of type schema to the statement
     *
     * https://docs.aws.amazon.com/eventbridge/latest/userguide/iam-identity-based-access-control-eventbridge.html
     *
     * @param registryName - Identifier for the registryName.
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSchema(registryName, schemaName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:schemas:${region || '*'}:${account || '*'}:schema/${registryName}/${schemaName}`);
    }
}
exports.Schemas = Schemas;
_a = JSII_RTTI_SYMBOL_1;
Schemas[_a] = { fqn: "cdk-iam-floyd.Schemas", version: "0.343.0" };
//# sourceMappingURL=data:application/json;base64,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