"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'inspector';
        this.accessLevelList = {
            Write: [
                'AddAttributesToFindings',
                'CreateAssessmentTarget',
                'CreateAssessmentTemplate',
                'CreateExclusionsPreview',
                'CreateResourceGroup',
                'DeleteAssessmentRun',
                'DeleteAssessmentTarget',
                'DeleteAssessmentTemplate',
                'RegisterCrossAccountAccessRole',
                'RemoveAttributesFromFindings',
                'StartAssessmentRun',
                'StopAssessmentRun',
                'SubscribeToEvent',
                'UnsubscribeFromEvent',
                'UpdateAssessmentTarget'
            ],
            Read: [
                'DescribeAssessmentRuns',
                'DescribeAssessmentTargets',
                'DescribeAssessmentTemplates',
                'DescribeCrossAccountAccessRole',
                'DescribeExclusions',
                'DescribeFindings',
                'DescribeResourceGroups',
                'DescribeRulesPackages',
                'GetAssessmentReport',
                'GetExclusionsPreview',
                'GetTelemetryMetadata',
                'ListTagsForResource',
                'PreviewAgents'
            ],
            List: [
                'ListAssessmentRunAgents',
                'ListAssessmentRuns',
                'ListAssessmentTargets',
                'ListAssessmentTemplates',
                'ListEventSubscriptions',
                'ListExclusions',
                'ListFindings',
                'ListRulesPackages'
            ],
            Tagging: [
                'SetTagsForResource'
            ]
        };
    }
    /**
     * Grants permission to assign attributes (key and value pairs) to the findings that are specified by the ARNs of the findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    toAddAttributesToFindings() {
        return this.to('AddAttributesToFindings');
    }
    /**
     * Grants permission to create a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    toCreateAssessmentTarget() {
        return this.to('CreateAssessmentTarget');
    }
    /**
     * Grants permission to create an assessment template for the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    toCreateAssessmentTemplate() {
        return this.to('CreateAssessmentTemplate');
    }
    /**
     * Grants permission to start the generation of an exclusions preview for the specified assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateExclusionsPreview.html
     */
    toCreateExclusionsPreview() {
        return this.to('CreateExclusionsPreview');
    }
    /**
     * Grants permission to create a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    toCreateResourceGroup() {
        return this.to('CreateResourceGroup');
    }
    /**
     * Grants permission to delete the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    toDeleteAssessmentRun() {
        return this.to('DeleteAssessmentRun');
    }
    /**
     * Grants permission to delete the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    toDeleteAssessmentTarget() {
        return this.to('DeleteAssessmentTarget');
    }
    /**
     * Grants permission to delete the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    toDeleteAssessmentTemplate() {
        return this.to('DeleteAssessmentTemplate');
    }
    /**
     * Grants permission to describe the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    toDescribeAssessmentRuns() {
        return this.to('DescribeAssessmentRuns');
    }
    /**
     * Grants permission to describe the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    toDescribeAssessmentTargets() {
        return this.to('DescribeAssessmentTargets');
    }
    /**
     * Grants permission to describe the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    toDescribeAssessmentTemplates() {
        return this.to('DescribeAssessmentTemplates');
    }
    /**
     * Grants permission to describe the IAM role that enables Amazon Inspector to access your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    toDescribeCrossAccountAccessRole() {
        return this.to('DescribeCrossAccountAccessRole');
    }
    /**
     * Grants permission to describe the exclusions that are specified by the exclusions' ARNs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeExclusions.html
     */
    toDescribeExclusions() {
        return this.to('DescribeExclusions');
    }
    /**
     * Grants permission to describe the findings that are specified by the ARNs of the findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    toDescribeFindings() {
        return this.to('DescribeFindings');
    }
    /**
     * Grants permission to describe the resource groups that are specified by the ARNs of the resource groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    toDescribeResourceGroups() {
        return this.to('DescribeResourceGroups');
    }
    /**
     * Grants permission to describe the rules packages that are specified by the ARNs of the rules packages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    toDescribeRulesPackages() {
        return this.to('DescribeRulesPackages');
    }
    /**
     * Grants permission to produce an assessment report that includes detailed and comprehensive results of a specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetAssessmentReport.html
     */
    toGetAssessmentReport() {
        return this.to('GetAssessmentReport');
    }
    /**
     * Grants permission to retrieve the exclusions preview (a list of ExclusionPreview objects) specified by the preview token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetExclusionsPreview.html
     */
    toGetExclusionsPreview() {
        return this.to('GetExclusionsPreview');
    }
    /**
     * Grants permission to get information about the data that is collected for the specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    toGetTelemetryMetadata() {
        return this.to('GetTelemetryMetadata');
    }
    /**
     * Grants permission to list the agents of the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    toListAssessmentRunAgents() {
        return this.to('ListAssessmentRunAgents');
    }
    /**
     * Grants permission to list the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    toListAssessmentRuns() {
        return this.to('ListAssessmentRuns');
    }
    /**
     * Grants permission to list the ARNs of the assessment targets within this AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    toListAssessmentTargets() {
        return this.to('ListAssessmentTargets');
    }
    /**
     * Grants permission to list the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    toListAssessmentTemplates() {
        return this.to('ListAssessmentTemplates');
    }
    /**
     * Grants permission to list all the event subscriptions for the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    toListEventSubscriptions() {
        return this.to('ListEventSubscriptions');
    }
    /**
     * Grants permission to list exclusions that are generated by the assessment run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListExclusions.html
     */
    toListExclusions() {
        return this.to('ListExclusions');
    }
    /**
     * Grants permission to list findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * Grants permission to list all available Amazon Inspector rules packages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    toListRulesPackages() {
        return this.to('ListRulesPackages');
    }
    /**
     * Grants permission to list all tags associated with an assessment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to preview the agents installed on the EC2 instances that are part of the specified assessment target
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    toPreviewAgents() {
        return this.to('PreviewAgents');
    }
    /**
     * Grants permission to register the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    toRegisterCrossAccountAccessRole() {
        return this.to('RegisterCrossAccountAccessRole');
    }
    /**
     * Grants permission to remove entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    toRemoveAttributesFromFindings() {
        return this.to('RemoveAttributesFromFindings');
    }
    /**
     * Grants permission to set tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    toSetTagsForResource() {
        return this.to('SetTagsForResource');
    }
    /**
     * Grants permission to start the assessment run specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    toStartAssessmentRun() {
        return this.to('StartAssessmentRun');
    }
    /**
     * Grants permission to stop the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    toStopAssessmentRun() {
        return this.to('StopAssessmentRun');
    }
    /**
     * Grants permission to enable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    toSubscribeToEvent() {
        return this.to('SubscribeToEvent');
    }
    /**
     * Grants permission to disable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    toUnsubscribeFromEvent() {
        return this.to('UnsubscribeFromEvent');
    }
    /**
     * Grants permission to update the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    toUpdateAssessmentTarget() {
        return this.to('UpdateAssessmentTarget');
    }
}
exports.Inspector = Inspector;
_a = JSII_RTTI_SYMBOL_1;
Inspector[_a] = { fqn: "cdk-iam-floyd.Inspector", version: "0.343.0" };
//# sourceMappingURL=data:application/json;base64,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