"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TypeVar

from mastapy.bearings.bearing_designs.rolling import _2178
from mastapy._internal import mixins
from mastapy._internal.python_net import python_net_import

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_HeightSeries",)


Self = TypeVar("Self", bound="Overridable_HeightSeries")


class Overridable_HeightSeries(mixins.OverridableMixin, Enum):
    """Overridable_HeightSeries

    A specific implementation of 'Overridable' for 'HeightSeries' types.
    """

    __qualname__ = "HeightSeries"

    @classmethod
    def wrapper_type(cls) -> "_OVERRIDABLE":
        """Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _OVERRIDABLE

    @classmethod
    def wrapped_type(cls) -> "_2178.HeightSeries":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly
        """

        return _2178.HeightSeries

    @classmethod
    def implicit_type(cls) -> "_2178.HeightSeries.type_()":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _2178.HeightSeries.type_()

    @property
    def value(self: Self) -> "_2178.HeightSeries":
        """mastapy.bearings.bearing_designs.rolling.HeightSeries

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: Self) -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: Self) -> "_2178.HeightSeries":
        """mastapy.bearings.bearing_designs.rolling.HeightSeries

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: Self) -> "_2178.HeightSeries":
        """mastapy.bearings.bearing_designs.rolling.HeightSeries

        Note:
            This property is readonly.
        """
        return None
