"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TypeVar

from mastapy.system_model.analyses_and_results.static_loads import _6945
from mastapy._internal import mixins
from mastapy._internal.python_net import python_net_import

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_MeshStiffnessSource",)


Self = TypeVar("Self", bound="Overridable_MeshStiffnessSource")


class Overridable_MeshStiffnessSource(mixins.OverridableMixin, Enum):
    """Overridable_MeshStiffnessSource

    A specific implementation of 'Overridable' for 'MeshStiffnessSource' types.
    """

    __qualname__ = "MeshStiffnessSource"

    @classmethod
    def wrapper_type(cls) -> "_OVERRIDABLE":
        """Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _OVERRIDABLE

    @classmethod
    def wrapped_type(cls) -> "_6945.MeshStiffnessSource":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly
        """

        return _6945.MeshStiffnessSource

    @classmethod
    def implicit_type(cls) -> "_6945.MeshStiffnessSource.type_()":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _6945.MeshStiffnessSource.type_()

    @property
    def value(self: Self) -> "_6945.MeshStiffnessSource":
        """mastapy.system_model.analyses_and_results.static_loads.MeshStiffnessSource

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: Self) -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: Self) -> "_6945.MeshStiffnessSource":
        """mastapy.system_model.analyses_and_results.static_loads.MeshStiffnessSource

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: Self) -> "_6945.MeshStiffnessSource":
        """mastapy.system_model.analyses_and_results.static_loads.MeshStiffnessSource

        Note:
            This property is readonly.
        """
        return None
