"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TypeVar

from mastapy.system_model.fe import _2422
from mastapy._internal import mixins
from mastapy._internal.python_net import python_net_import

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_NodeSelectionDepthOption",)


Self = TypeVar("Self", bound="Overridable_NodeSelectionDepthOption")


class Overridable_NodeSelectionDepthOption(mixins.OverridableMixin, Enum):
    """Overridable_NodeSelectionDepthOption

    A specific implementation of 'Overridable' for 'NodeSelectionDepthOption' types.
    """

    __qualname__ = "NodeSelectionDepthOption"

    @classmethod
    def wrapper_type(cls) -> "_OVERRIDABLE":
        """Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _OVERRIDABLE

    @classmethod
    def wrapped_type(cls) -> "_2422.NodeSelectionDepthOption":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly
        """

        return _2422.NodeSelectionDepthOption

    @classmethod
    def implicit_type(cls) -> "_2422.NodeSelectionDepthOption.type_()":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _2422.NodeSelectionDepthOption.type_()

    @property
    def value(self: Self) -> "_2422.NodeSelectionDepthOption":
        """mastapy.system_model.fe.NodeSelectionDepthOption

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: Self) -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: Self) -> "_2422.NodeSelectionDepthOption":
        """mastapy.system_model.fe.NodeSelectionDepthOption

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: Self) -> "_2422.NodeSelectionDepthOption":
        """mastapy.system_model.fe.NodeSelectionDepthOption

        Note:
            This property is readonly.
        """
        return None
