"""RollerBearingUserSpecifiedProfile"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy.bearings.roller_bearing_profiles import _1956
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_ROLLER_BEARING_USER_SPECIFIED_PROFILE = python_net_import(
    "SMT.MastaAPI.Bearings.RollerBearingProfiles", "RollerBearingUserSpecifiedProfile"
)

if TYPE_CHECKING:
    from mastapy.bearings.roller_bearing_profiles import _1947, _1949, _1959


__docformat__ = "restructuredtext en"
__all__ = ("RollerBearingUserSpecifiedProfile",)


Self = TypeVar("Self", bound="RollerBearingUserSpecifiedProfile")


class RollerBearingUserSpecifiedProfile(_1956.RollerBearingProfile):
    """RollerBearingUserSpecifiedProfile

    This is a mastapy class.
    """

    TYPE = _ROLLER_BEARING_USER_SPECIFIED_PROFILE
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_RollerBearingUserSpecifiedProfile")

    class _Cast_RollerBearingUserSpecifiedProfile:
        """Special nested class for casting RollerBearingUserSpecifiedProfile to subclasses."""

        def __init__(
            self: "RollerBearingUserSpecifiedProfile._Cast_RollerBearingUserSpecifiedProfile",
            parent: "RollerBearingUserSpecifiedProfile",
        ):
            self._parent = parent

        @property
        def roller_bearing_profile(
            self: "RollerBearingUserSpecifiedProfile._Cast_RollerBearingUserSpecifiedProfile",
        ) -> "_1956.RollerBearingProfile":
            return self._parent._cast(_1956.RollerBearingProfile)

        @property
        def roller_bearing_user_specified_profile(
            self: "RollerBearingUserSpecifiedProfile._Cast_RollerBearingUserSpecifiedProfile",
        ) -> "RollerBearingUserSpecifiedProfile":
            return self._parent

        def __getattr__(
            self: "RollerBearingUserSpecifiedProfile._Cast_RollerBearingUserSpecifiedProfile",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "RollerBearingUserSpecifiedProfile.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def data_to_use(self: Self) -> "_1947.ProfileDataToUse":
        """mastapy.bearings.roller_bearing_profiles.ProfileDataToUse"""
        temp = self.wrapped.DataToUse

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp, "SMT.MastaAPI.Bearings.RollerBearingProfiles.ProfileDataToUse"
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy.bearings.roller_bearing_profiles._1947", "ProfileDataToUse"
        )(value)

    @data_to_use.setter
    @enforce_parameter_types
    def data_to_use(self: Self, value: "_1947.ProfileDataToUse"):
        value = conversion.mp_to_pn_enum(
            value, "SMT.MastaAPI.Bearings.RollerBearingProfiles.ProfileDataToUse"
        )
        self.wrapped.DataToUse = value

    @property
    def number_of_points(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfPoints

        if temp is None:
            return 0

        return temp

    @number_of_points.setter
    @enforce_parameter_types
    def number_of_points(self: Self, value: "int"):
        self.wrapped.NumberOfPoints = int(value) if value is not None else 0

    @property
    def profile_to_fit(self: Self) -> "_1949.ProfileToFit":
        """mastapy.bearings.roller_bearing_profiles.ProfileToFit"""
        temp = self.wrapped.ProfileToFit

        if temp is None:
            return None

        value = conversion.pn_to_mp_enum(
            temp, "SMT.MastaAPI.Bearings.RollerBearingProfiles.ProfileToFit"
        )

        if value is None:
            return None

        return constructor.new_from_mastapy(
            "mastapy.bearings.roller_bearing_profiles._1949", "ProfileToFit"
        )(value)

    @profile_to_fit.setter
    @enforce_parameter_types
    def profile_to_fit(self: Self, value: "_1949.ProfileToFit"):
        value = conversion.mp_to_pn_enum(
            value, "SMT.MastaAPI.Bearings.RollerBearingProfiles.ProfileToFit"
        )
        self.wrapped.ProfileToFit = value

    @property
    def points(self: Self) -> "List[_1959.UserSpecifiedProfilePoint]":
        """List[mastapy.bearings.roller_bearing_profiles.UserSpecifiedProfilePoint]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Points

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    def set_to_full_range(self: Self):
        """Method does not return."""
        self.wrapped.SetToFullRange()

    @property
    def cast_to(
        self: Self,
    ) -> "RollerBearingUserSpecifiedProfile._Cast_RollerBearingUserSpecifiedProfile":
        return self._Cast_RollerBearingUserSpecifiedProfile(self)
