"""SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal import conversion
from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
    _3655,
)
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_SPECIALISED_ASSEMBLY_COMPOUND_STEADY_STATE_SYNCHRONOUS_RESPONSE_AT_A_SPEED = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.SteadyStateSynchronousResponsesAtASpeed.Compound",
    "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
)

if TYPE_CHECKING:
    from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed import (
        _3623,
    )
    from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
        _3661,
        _3665,
        _3668,
        _3673,
        _3675,
        _3676,
        _3681,
        _3686,
        _3689,
        _3692,
        _3696,
        _3698,
        _3704,
        _3710,
        _3712,
        _3715,
        _3719,
        _3723,
        _3726,
        _3729,
        _3735,
        _3739,
        _3746,
        _3756,
        _3757,
        _3762,
        _3765,
        _3768,
        _3772,
        _3780,
        _3783,
        _3734,
    )
    from mastapy.system_model.analyses_and_results.analysis_cases import _7567, _7564
    from mastapy.system_model.analyses_and_results import _2672


__docformat__ = "restructuredtext en"
__all__ = ("SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",)


Self = TypeVar(
    "Self", bound="SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed"
)


class SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed(
    _3655.AbstractAssemblyCompoundSteadyStateSynchronousResponseAtASpeed
):
    """SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed

    This is a mastapy class.
    """

    TYPE = _SPECIALISED_ASSEMBLY_COMPOUND_STEADY_STATE_SYNCHRONOUS_RESPONSE_AT_A_SPEED
    _CastSelf = TypeVar(
        "_CastSelf",
        bound="_Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
    )

    class _Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed:
        """Special nested class for casting SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed to subclasses."""

        def __init__(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
            parent: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ):
            self._parent = parent

        @property
        def abstract_assembly_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3655.AbstractAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
            return self._parent._cast(
                _3655.AbstractAssemblyCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def part_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3734.PartCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3734,
            )

            return self._parent._cast(
                _3734.PartCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def part_compound_analysis(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_7567.PartCompoundAnalysis":
            from mastapy.system_model.analyses_and_results.analysis_cases import _7567

            return self._parent._cast(_7567.PartCompoundAnalysis)

        @property
        def design_entity_compound_analysis(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_7564.DesignEntityCompoundAnalysis":
            from mastapy.system_model.analyses_and_results.analysis_cases import _7564

            return self._parent._cast(_7564.DesignEntityCompoundAnalysis)

        @property
        def design_entity_analysis(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_2672.DesignEntityAnalysis":
            from mastapy.system_model.analyses_and_results import _2672

            return self._parent._cast(_2672.DesignEntityAnalysis)

        @property
        def agma_gleason_conical_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3661.AGMAGleasonConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3661,
            )

            return self._parent._cast(
                _3661.AGMAGleasonConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def belt_drive_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3665.BeltDriveCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3665,
            )

            return self._parent._cast(
                _3665.BeltDriveCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def bevel_differential_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3668.BevelDifferentialGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3668,
            )

            return self._parent._cast(
                _3668.BevelDifferentialGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def bevel_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3673.BevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3673,
            )

            return self._parent._cast(
                _3673.BevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def bolted_joint_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3675.BoltedJointCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3675,
            )

            return self._parent._cast(
                _3675.BoltedJointCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def clutch_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3676.ClutchCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3676,
            )

            return self._parent._cast(
                _3676.ClutchCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def concept_coupling_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3681.ConceptCouplingCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3681,
            )

            return self._parent._cast(
                _3681.ConceptCouplingCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def concept_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3686.ConceptGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3686,
            )

            return self._parent._cast(
                _3686.ConceptGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def conical_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3689.ConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3689,
            )

            return self._parent._cast(
                _3689.ConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def coupling_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3692.CouplingCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3692,
            )

            return self._parent._cast(
                _3692.CouplingCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def cvt_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3696.CVTCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3696,
            )

            return self._parent._cast(
                _3696.CVTCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def cycloidal_assembly_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3698.CycloidalAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3698,
            )

            return self._parent._cast(
                _3698.CycloidalAssemblyCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def cylindrical_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3704.CylindricalGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3704,
            )

            return self._parent._cast(
                _3704.CylindricalGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def face_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3710.FaceGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3710,
            )

            return self._parent._cast(
                _3710.FaceGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def flexible_pin_assembly_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3712.FlexiblePinAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3712,
            )

            return self._parent._cast(
                _3712.FlexiblePinAssemblyCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3715.GearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3715,
            )

            return self._parent._cast(
                _3715.GearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def hypoid_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3719.HypoidGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3719,
            )

            return self._parent._cast(
                _3719.HypoidGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def klingelnberg_cyclo_palloid_conical_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3723.KlingelnbergCycloPalloidConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3723,
            )

            return self._parent._cast(
                _3723.KlingelnbergCycloPalloidConicalGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def klingelnberg_cyclo_palloid_hypoid_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3726.KlingelnbergCycloPalloidHypoidGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3726,
            )

            return self._parent._cast(
                _3726.KlingelnbergCycloPalloidHypoidGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def klingelnberg_cyclo_palloid_spiral_bevel_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3729.KlingelnbergCycloPalloidSpiralBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3729,
            )

            return self._parent._cast(
                _3729.KlingelnbergCycloPalloidSpiralBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def part_to_part_shear_coupling_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3735.PartToPartShearCouplingCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3735,
            )

            return self._parent._cast(
                _3735.PartToPartShearCouplingCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def planetary_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3739.PlanetaryGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3739,
            )

            return self._parent._cast(
                _3739.PlanetaryGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def rolling_ring_assembly_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3746.RollingRingAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3746,
            )

            return self._parent._cast(
                _3746.RollingRingAssemblyCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def spiral_bevel_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3756.SpiralBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3756,
            )

            return self._parent._cast(
                _3756.SpiralBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def spring_damper_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3757.SpringDamperCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3757,
            )

            return self._parent._cast(
                _3757.SpringDamperCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def straight_bevel_diff_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3762.StraightBevelDiffGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3762,
            )

            return self._parent._cast(
                _3762.StraightBevelDiffGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def straight_bevel_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3765.StraightBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3765,
            )

            return self._parent._cast(
                _3765.StraightBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def synchroniser_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3768.SynchroniserCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3768,
            )

            return self._parent._cast(
                _3768.SynchroniserCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def torque_converter_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3772.TorqueConverterCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3772,
            )

            return self._parent._cast(
                _3772.TorqueConverterCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def worm_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3780.WormGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3780,
            )

            return self._parent._cast(
                _3780.WormGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def zerol_bevel_gear_set_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "_3783.ZerolBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed":
            from mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.compound import (
                _3783,
            )

            return self._parent._cast(
                _3783.ZerolBevelGearSetCompoundSteadyStateSynchronousResponseAtASpeed
            )

        @property
        def specialised_assembly_compound_steady_state_synchronous_response_at_a_speed(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
        ) -> "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
            return self._parent

        def __getattr__(
            self: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self,
        instance_to_wrap: "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed.TYPE",
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def assembly_analysis_cases(
        self: Self,
    ) -> "List[_3623.SpecialisedAssemblySteadyStateSynchronousResponseAtASpeed]":
        """List[mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.SpecialisedAssemblySteadyStateSynchronousResponseAtASpeed]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.AssemblyAnalysisCases

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def assembly_analysis_cases_ready(
        self: Self,
    ) -> "List[_3623.SpecialisedAssemblySteadyStateSynchronousResponseAtASpeed]":
        """List[mastapy.system_model.analyses_and_results.steady_state_synchronous_responses_at_a_speed.SpecialisedAssemblySteadyStateSynchronousResponseAtASpeed]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.AssemblyAnalysisCasesReady

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cast_to(
        self: Self,
    ) -> "SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed":
        return self._Cast_SpecialisedAssemblyCompoundSteadyStateSynchronousResponseAtASpeed(
            self
        )
