# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigArgs', 'Config']

@pulumi.input_type
class ConfigArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 monitor_type: pulumi.Input[str],
                 repeat_interval_in_seconds: pulumi.Input[int],
                 vantage_points: pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]],
                 availability_configuration: Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']] = None,
                 batch_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 configuration: Optional[pulumi.Input['ConfigConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_run_now: Optional[pulumi.Input[bool]] = None,
                 is_run_once: Optional[pulumi.Input[bool]] = None,
                 maintenance_window_schedule: Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']] = None,
                 scheduling_policy: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Config resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[str] monitor_type: Type of monitor.
        :param pulumi.Input[int] repeat_interval_in_seconds: (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]] vantage_points: (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['ConfigAvailabilityConfigurationArgs'] availability_configuration: (Updatable) Monitor availability configuration details.
        :param pulumi.Input[int] batch_interval_in_seconds: (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        :param pulumi.Input['ConfigConfigurationArgs'] configuration: (Updatable) Details of monitor configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_run_now: (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        :param pulumi.Input[bool] is_run_once: (Updatable) If runOnce is enabled, then the monitor will run once.
        :param pulumi.Input['ConfigMaintenanceWindowScheduleArgs'] maintenance_window_schedule: (Updatable) Details required to schedule maintenance window.
        :param pulumi.Input[str] scheduling_policy: (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        :param pulumi.Input[str] script_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        :param pulumi.Input[str] script_name: Name of the script.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]] script_parameters: (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        :param pulumi.Input[str] status: (Updatable) Enables or disables the monitor.
        :param pulumi.Input[str] target: (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "monitor_type", monitor_type)
        pulumi.set(__self__, "repeat_interval_in_seconds", repeat_interval_in_seconds)
        pulumi.set(__self__, "vantage_points", vantage_points)
        if availability_configuration is not None:
            pulumi.set(__self__, "availability_configuration", availability_configuration)
        if batch_interval_in_seconds is not None:
            pulumi.set(__self__, "batch_interval_in_seconds", batch_interval_in_seconds)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_run_now is not None:
            pulumi.set(__self__, "is_run_now", is_run_now)
        if is_run_once is not None:
            pulumi.set(__self__, "is_run_once", is_run_once)
        if maintenance_window_schedule is not None:
            pulumi.set(__self__, "maintenance_window_schedule", maintenance_window_schedule)
        if scheduling_policy is not None:
            pulumi.set(__self__, "scheduling_policy", scheduling_policy)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if script_parameters is not None:
            pulumi.set(__self__, "script_parameters", script_parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> pulumi.Input[str]:
        """
        Type of monitor.
        """
        return pulumi.get(self, "monitor_type")

    @monitor_type.setter
    def monitor_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor_type", value)

    @property
    @pulumi.getter(name="repeatIntervalInSeconds")
    def repeat_interval_in_seconds(self) -> pulumi.Input[int]:
        """
        (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        """
        return pulumi.get(self, "repeat_interval_in_seconds")

    @repeat_interval_in_seconds.setter
    def repeat_interval_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "repeat_interval_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePoints")
    def vantage_points(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]]:
        """
        (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_points")

    @vantage_points.setter
    def vantage_points(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]]):
        pulumi.set(self, "vantage_points", value)

    @property
    @pulumi.getter(name="availabilityConfiguration")
    def availability_configuration(self) -> Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']]:
        """
        (Updatable) Monitor availability configuration details.
        """
        return pulumi.get(self, "availability_configuration")

    @availability_configuration.setter
    def availability_configuration(self, value: Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']]):
        pulumi.set(self, "availability_configuration", value)

    @property
    @pulumi.getter(name="batchIntervalInSeconds")
    def batch_interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        """
        return pulumi.get(self, "batch_interval_in_seconds")

    @batch_interval_in_seconds.setter
    def batch_interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_interval_in_seconds", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConfigConfigurationArgs']]:
        """
        (Updatable) Details of monitor configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConfigConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isRunNow")
    def is_run_now(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        """
        return pulumi.get(self, "is_run_now")

    @is_run_now.setter
    def is_run_now(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_run_now", value)

    @property
    @pulumi.getter(name="isRunOnce")
    def is_run_once(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If runOnce is enabled, then the monitor will run once.
        """
        return pulumi.get(self, "is_run_once")

    @is_run_once.setter
    def is_run_once(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_run_once", value)

    @property
    @pulumi.getter(name="maintenanceWindowSchedule")
    def maintenance_window_schedule(self) -> Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']]:
        """
        (Updatable) Details required to schedule maintenance window.
        """
        return pulumi.get(self, "maintenance_window_schedule")

    @maintenance_window_schedule.setter
    def maintenance_window_schedule(self, value: Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']]):
        pulumi.set(self, "maintenance_window_schedule", value)

    @property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        """
        return pulumi.get(self, "scheduling_policy")

    @scheduling_policy.setter
    def scheduling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the script.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]]:
        """
        (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]]):
        pulumi.set(self, "script_parameters", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enables or disables the monitor.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)


@pulumi.input_type
class _ConfigState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 availability_configuration: Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']] = None,
                 batch_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 configuration: Optional[pulumi.Input['ConfigConfigurationArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_run_now: Optional[pulumi.Input[bool]] = None,
                 is_run_once: Optional[pulumi.Input[bool]] = None,
                 maintenance_window_schedule: Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 repeat_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 scheduling_policy: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_point_count: Optional[pulumi.Input[int]] = None,
                 vantage_points: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]]] = None):
        """
        Input properties used for looking up and filtering Config resources.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input['ConfigAvailabilityConfigurationArgs'] availability_configuration: (Updatable) Monitor availability configuration details.
        :param pulumi.Input[int] batch_interval_in_seconds: (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        :param pulumi.Input['ConfigConfigurationArgs'] configuration: (Updatable) Details of monitor configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_run_now: (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        :param pulumi.Input[bool] is_run_once: (Updatable) If runOnce is enabled, then the monitor will run once.
        :param pulumi.Input['ConfigMaintenanceWindowScheduleArgs'] maintenance_window_schedule: (Updatable) Details required to schedule maintenance window.
        :param pulumi.Input[str] monitor_type: Type of monitor.
        :param pulumi.Input[int] repeat_interval_in_seconds: (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        :param pulumi.Input[str] scheduling_policy: (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        :param pulumi.Input[str] script_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        :param pulumi.Input[str] script_name: Name of the script.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]] script_parameters: (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        :param pulumi.Input[str] status: (Updatable) Enables or disables the monitor.
        :param pulumi.Input[str] target: (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        :param pulumi.Input[int] vantage_point_count: Number of vantage points where monitor is running.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]] vantage_points: (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if availability_configuration is not None:
            pulumi.set(__self__, "availability_configuration", availability_configuration)
        if batch_interval_in_seconds is not None:
            pulumi.set(__self__, "batch_interval_in_seconds", batch_interval_in_seconds)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_run_now is not None:
            pulumi.set(__self__, "is_run_now", is_run_now)
        if is_run_once is not None:
            pulumi.set(__self__, "is_run_once", is_run_once)
        if maintenance_window_schedule is not None:
            pulumi.set(__self__, "maintenance_window_schedule", maintenance_window_schedule)
        if monitor_type is not None:
            pulumi.set(__self__, "monitor_type", monitor_type)
        if repeat_interval_in_seconds is not None:
            pulumi.set(__self__, "repeat_interval_in_seconds", repeat_interval_in_seconds)
        if scheduling_policy is not None:
            pulumi.set(__self__, "scheduling_policy", scheduling_policy)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if script_parameters is not None:
            pulumi.set(__self__, "script_parameters", script_parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if vantage_point_count is not None:
            pulumi.set(__self__, "vantage_point_count", vantage_point_count)
        if vantage_points is not None:
            pulumi.set(__self__, "vantage_points", vantage_points)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="availabilityConfiguration")
    def availability_configuration(self) -> Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']]:
        """
        (Updatable) Monitor availability configuration details.
        """
        return pulumi.get(self, "availability_configuration")

    @availability_configuration.setter
    def availability_configuration(self, value: Optional[pulumi.Input['ConfigAvailabilityConfigurationArgs']]):
        pulumi.set(self, "availability_configuration", value)

    @property
    @pulumi.getter(name="batchIntervalInSeconds")
    def batch_interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        """
        return pulumi.get(self, "batch_interval_in_seconds")

    @batch_interval_in_seconds.setter
    def batch_interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_interval_in_seconds", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConfigConfigurationArgs']]:
        """
        (Updatable) Details of monitor configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConfigConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isRunNow")
    def is_run_now(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        """
        return pulumi.get(self, "is_run_now")

    @is_run_now.setter
    def is_run_now(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_run_now", value)

    @property
    @pulumi.getter(name="isRunOnce")
    def is_run_once(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If runOnce is enabled, then the monitor will run once.
        """
        return pulumi.get(self, "is_run_once")

    @is_run_once.setter
    def is_run_once(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_run_once", value)

    @property
    @pulumi.getter(name="maintenanceWindowSchedule")
    def maintenance_window_schedule(self) -> Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']]:
        """
        (Updatable) Details required to schedule maintenance window.
        """
        return pulumi.get(self, "maintenance_window_schedule")

    @maintenance_window_schedule.setter
    def maintenance_window_schedule(self, value: Optional[pulumi.Input['ConfigMaintenanceWindowScheduleArgs']]):
        pulumi.set(self, "maintenance_window_schedule", value)

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of monitor.
        """
        return pulumi.get(self, "monitor_type")

    @monitor_type.setter
    def monitor_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_type", value)

    @property
    @pulumi.getter(name="repeatIntervalInSeconds")
    def repeat_interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        """
        return pulumi.get(self, "repeat_interval_in_seconds")

    @repeat_interval_in_seconds.setter
    def repeat_interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "repeat_interval_in_seconds", value)

    @property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        """
        return pulumi.get(self, "scheduling_policy")

    @scheduling_policy.setter
    def scheduling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the script.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]]:
        """
        (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigScriptParameterArgs']]]]):
        pulumi.set(self, "script_parameters", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Enables or disables the monitor.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="vantagePointCount")
    def vantage_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of vantage points where monitor is running.
        """
        return pulumi.get(self, "vantage_point_count")

    @vantage_point_count.setter
    def vantage_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vantage_point_count", value)

    @property
    @pulumi.getter(name="vantagePoints")
    def vantage_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]]]:
        """
        (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_points")

    @vantage_points.setter
    def vantage_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVantagePointArgs']]]]):
        pulumi.set(self, "vantage_points", value)


class Config(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 availability_configuration: Optional[pulumi.Input[pulumi.InputType['ConfigAvailabilityConfigurationArgs']]] = None,
                 batch_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ConfigConfigurationArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_run_now: Optional[pulumi.Input[bool]] = None,
                 is_run_once: Optional[pulumi.Input[bool]] = None,
                 maintenance_window_schedule: Optional[pulumi.Input[pulumi.InputType['ConfigMaintenanceWindowScheduleArgs']]] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 repeat_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 scheduling_policy: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigScriptParameterArgs']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_points: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigVantagePointArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Monitor resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Creates a new monitor.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitor = oci.apm_synthetics.Config("testMonitor",
            apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
            display_name=var["monitor_display_name"],
            monitor_type=var["monitor_monitor_type"],
            repeat_interval_in_seconds=var["monitor_repeat_interval_in_seconds"],
            vantage_points=[oci.apm_synthetics.ConfigVantagePointArgs(
                name=var["monitor_vantage_points_name"],
                display_name=var["monitor_vantage_points_param_display_name"],
            )],
            availability_configuration=oci.apm_synthetics.ConfigAvailabilityConfigurationArgs(
                max_allowed_failures_per_interval=var["monitor_availability_configuration_max_allowed_failures_per_interval"],
                min_allowed_runs_per_interval=var["monitor_availability_configuration_min_allowed_runs_per_interval"],
            ),
            batch_interval_in_seconds=var["monitor_batch_interval_in_seconds"],
            configuration=oci.apm_synthetics.ConfigConfigurationArgs(
                client_certificate_details=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsArgs(
                    client_certificate=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsClientCertificateArgs(
                        content=var["monitor_configuration_client_certificate_details_client_certificate_content"],
                        file_name=var["monitor_configuration_client_certificate_details_client_certificate_file_name"],
                    ),
                    private_key=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsPrivateKeyArgs(
                        content=var["monitor_configuration_client_certificate_details_private_key_content"],
                        file_name=var["monitor_configuration_client_certificate_details_private_key_file_name"],
                    ),
                ),
                config_type=var["monitor_configuration_config_type"],
                dns_configuration=oci.apm_synthetics.ConfigConfigurationDnsConfigurationArgs(
                    is_override_dns=var["monitor_configuration_dns_configuration_is_override_dns"],
                    override_dns_ip=var["monitor_configuration_dns_configuration_override_dns_ip"],
                ),
                is_certificate_validation_enabled=var["monitor_configuration_is_certificate_validation_enabled"],
                is_default_snapshot_enabled=var["monitor_configuration_is_default_snapshot_enabled"],
                is_failure_retried=var["monitor_configuration_is_failure_retried"],
                is_query_recursive=var["monitor_configuration_is_query_recursive"],
                is_redirection_enabled=var["monitor_configuration_is_redirection_enabled"],
                name_server=var["monitor_configuration_name_server"],
                network_configuration=oci.apm_synthetics.ConfigConfigurationNetworkConfigurationArgs(
                    number_of_hops=var["monitor_configuration_network_configuration_number_of_hops"],
                    probe_mode=var["monitor_configuration_network_configuration_probe_mode"],
                    probe_per_hop=var["monitor_configuration_network_configuration_probe_per_hop"],
                    protocol=var["monitor_configuration_network_configuration_protocol"],
                    transmission_rate=var["monitor_configuration_network_configuration_transmission_rate"],
                ),
                protocol=var["monitor_configuration_protocol"],
                record_type=var["monitor_configuration_record_type"],
                req_authentication_details=oci.apm_synthetics.ConfigConfigurationReqAuthenticationDetailsArgs(
                    auth_headers=[oci.apm_synthetics.ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs(
                        header_name=var["monitor_configuration_req_authentication_details_auth_headers_header_name"],
                        header_value=var["monitor_configuration_req_authentication_details_auth_headers_header_value"],
                    )],
                    auth_request_method=var["monitor_configuration_req_authentication_details_auth_request_method"],
                    auth_request_post_body=var["monitor_configuration_req_authentication_details_auth_request_post_body"],
                    auth_token=var["monitor_configuration_req_authentication_details_auth_token"],
                    auth_url=var["monitor_configuration_req_authentication_details_auth_url"],
                    auth_user_name=oci_identity_user["test_user"]["name"],
                    auth_user_password=var["monitor_configuration_req_authentication_details_auth_user_password"],
                    oauth_scheme=var["monitor_configuration_req_authentication_details_oauth_scheme"],
                ),
                req_authentication_scheme=var["monitor_configuration_req_authentication_scheme"],
                request_headers=[oci.apm_synthetics.ConfigConfigurationRequestHeaderArgs(
                    header_name=var["monitor_configuration_request_headers_header_name"],
                    header_value=var["monitor_configuration_request_headers_header_value"],
                )],
                request_method=var["monitor_configuration_request_method"],
                request_post_body=var["monitor_configuration_request_post_body"],
                request_query_params=[oci.apm_synthetics.ConfigConfigurationRequestQueryParamArgs(
                    param_name=var["monitor_configuration_request_query_params_param_name"],
                    param_value=var["monitor_configuration_request_query_params_param_value"],
                )],
                verify_response_codes=var["monitor_configuration_verify_response_codes"],
                verify_response_content=var["monitor_configuration_verify_response_content"],
                verify_texts=[oci.apm_synthetics.ConfigConfigurationVerifyTextArgs(
                    text=var["monitor_configuration_verify_texts_text"],
                )],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_run_now=var["monitor_is_run_now"],
            is_run_once=var["monitor_is_run_once"],
            maintenance_window_schedule=oci.apm_synthetics.ConfigMaintenanceWindowScheduleArgs(
                time_ended=var["monitor_maintenance_window_schedule_time_ended"],
                time_started=var["monitor_maintenance_window_schedule_time_started"],
            ),
            scheduling_policy=var["monitor_scheduling_policy"],
            script_id=oci_apm_synthetics_script["test_script"]["id"],
            script_parameters=[oci.apm_synthetics.ConfigScriptParameterArgs(
                param_name=var["monitor_script_parameters_param_name"],
                param_value=var["monitor_script_parameters_param_value"],
            )],
            status=var["monitor_status"],
            target=var["monitor_target"],
            timeout_in_seconds=var["monitor_timeout_in_seconds"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Monitors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/config:Config test_monitor "monitors/{monitorId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[pulumi.InputType['ConfigAvailabilityConfigurationArgs']] availability_configuration: (Updatable) Monitor availability configuration details.
        :param pulumi.Input[int] batch_interval_in_seconds: (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        :param pulumi.Input[pulumi.InputType['ConfigConfigurationArgs']] configuration: (Updatable) Details of monitor configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_run_now: (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        :param pulumi.Input[bool] is_run_once: (Updatable) If runOnce is enabled, then the monitor will run once.
        :param pulumi.Input[pulumi.InputType['ConfigMaintenanceWindowScheduleArgs']] maintenance_window_schedule: (Updatable) Details required to schedule maintenance window.
        :param pulumi.Input[str] monitor_type: Type of monitor.
        :param pulumi.Input[int] repeat_interval_in_seconds: (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        :param pulumi.Input[str] scheduling_policy: (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        :param pulumi.Input[str] script_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        :param pulumi.Input[str] script_name: Name of the script.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigScriptParameterArgs']]]] script_parameters: (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        :param pulumi.Input[str] status: (Updatable) Enables or disables the monitor.
        :param pulumi.Input[str] target: (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigVantagePointArgs']]]] vantage_points: (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitor resource in Oracle Cloud Infrastructure Apm Synthetics service.

        Creates a new monitor.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitor = oci.apm_synthetics.Config("testMonitor",
            apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
            display_name=var["monitor_display_name"],
            monitor_type=var["monitor_monitor_type"],
            repeat_interval_in_seconds=var["monitor_repeat_interval_in_seconds"],
            vantage_points=[oci.apm_synthetics.ConfigVantagePointArgs(
                name=var["monitor_vantage_points_name"],
                display_name=var["monitor_vantage_points_param_display_name"],
            )],
            availability_configuration=oci.apm_synthetics.ConfigAvailabilityConfigurationArgs(
                max_allowed_failures_per_interval=var["monitor_availability_configuration_max_allowed_failures_per_interval"],
                min_allowed_runs_per_interval=var["monitor_availability_configuration_min_allowed_runs_per_interval"],
            ),
            batch_interval_in_seconds=var["monitor_batch_interval_in_seconds"],
            configuration=oci.apm_synthetics.ConfigConfigurationArgs(
                client_certificate_details=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsArgs(
                    client_certificate=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsClientCertificateArgs(
                        content=var["monitor_configuration_client_certificate_details_client_certificate_content"],
                        file_name=var["monitor_configuration_client_certificate_details_client_certificate_file_name"],
                    ),
                    private_key=oci.apm_synthetics.ConfigConfigurationClientCertificateDetailsPrivateKeyArgs(
                        content=var["monitor_configuration_client_certificate_details_private_key_content"],
                        file_name=var["monitor_configuration_client_certificate_details_private_key_file_name"],
                    ),
                ),
                config_type=var["monitor_configuration_config_type"],
                dns_configuration=oci.apm_synthetics.ConfigConfigurationDnsConfigurationArgs(
                    is_override_dns=var["monitor_configuration_dns_configuration_is_override_dns"],
                    override_dns_ip=var["monitor_configuration_dns_configuration_override_dns_ip"],
                ),
                is_certificate_validation_enabled=var["monitor_configuration_is_certificate_validation_enabled"],
                is_default_snapshot_enabled=var["monitor_configuration_is_default_snapshot_enabled"],
                is_failure_retried=var["monitor_configuration_is_failure_retried"],
                is_query_recursive=var["monitor_configuration_is_query_recursive"],
                is_redirection_enabled=var["monitor_configuration_is_redirection_enabled"],
                name_server=var["monitor_configuration_name_server"],
                network_configuration=oci.apm_synthetics.ConfigConfigurationNetworkConfigurationArgs(
                    number_of_hops=var["monitor_configuration_network_configuration_number_of_hops"],
                    probe_mode=var["monitor_configuration_network_configuration_probe_mode"],
                    probe_per_hop=var["monitor_configuration_network_configuration_probe_per_hop"],
                    protocol=var["monitor_configuration_network_configuration_protocol"],
                    transmission_rate=var["monitor_configuration_network_configuration_transmission_rate"],
                ),
                protocol=var["monitor_configuration_protocol"],
                record_type=var["monitor_configuration_record_type"],
                req_authentication_details=oci.apm_synthetics.ConfigConfigurationReqAuthenticationDetailsArgs(
                    auth_headers=[oci.apm_synthetics.ConfigConfigurationReqAuthenticationDetailsAuthHeaderArgs(
                        header_name=var["monitor_configuration_req_authentication_details_auth_headers_header_name"],
                        header_value=var["monitor_configuration_req_authentication_details_auth_headers_header_value"],
                    )],
                    auth_request_method=var["monitor_configuration_req_authentication_details_auth_request_method"],
                    auth_request_post_body=var["monitor_configuration_req_authentication_details_auth_request_post_body"],
                    auth_token=var["monitor_configuration_req_authentication_details_auth_token"],
                    auth_url=var["monitor_configuration_req_authentication_details_auth_url"],
                    auth_user_name=oci_identity_user["test_user"]["name"],
                    auth_user_password=var["monitor_configuration_req_authentication_details_auth_user_password"],
                    oauth_scheme=var["monitor_configuration_req_authentication_details_oauth_scheme"],
                ),
                req_authentication_scheme=var["monitor_configuration_req_authentication_scheme"],
                request_headers=[oci.apm_synthetics.ConfigConfigurationRequestHeaderArgs(
                    header_name=var["monitor_configuration_request_headers_header_name"],
                    header_value=var["monitor_configuration_request_headers_header_value"],
                )],
                request_method=var["monitor_configuration_request_method"],
                request_post_body=var["monitor_configuration_request_post_body"],
                request_query_params=[oci.apm_synthetics.ConfigConfigurationRequestQueryParamArgs(
                    param_name=var["monitor_configuration_request_query_params_param_name"],
                    param_value=var["monitor_configuration_request_query_params_param_value"],
                )],
                verify_response_codes=var["monitor_configuration_verify_response_codes"],
                verify_response_content=var["monitor_configuration_verify_response_content"],
                verify_texts=[oci.apm_synthetics.ConfigConfigurationVerifyTextArgs(
                    text=var["monitor_configuration_verify_texts_text"],
                )],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_run_now=var["monitor_is_run_now"],
            is_run_once=var["monitor_is_run_once"],
            maintenance_window_schedule=oci.apm_synthetics.ConfigMaintenanceWindowScheduleArgs(
                time_ended=var["monitor_maintenance_window_schedule_time_ended"],
                time_started=var["monitor_maintenance_window_schedule_time_started"],
            ),
            scheduling_policy=var["monitor_scheduling_policy"],
            script_id=oci_apm_synthetics_script["test_script"]["id"],
            script_parameters=[oci.apm_synthetics.ConfigScriptParameterArgs(
                param_name=var["monitor_script_parameters_param_name"],
                param_value=var["monitor_script_parameters_param_value"],
            )],
            status=var["monitor_status"],
            target=var["monitor_target"],
            timeout_in_seconds=var["monitor_timeout_in_seconds"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Monitors can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/config:Config test_monitor "monitors/{monitorId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[str]] = None,
                 availability_configuration: Optional[pulumi.Input[pulumi.InputType['ConfigAvailabilityConfigurationArgs']]] = None,
                 batch_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ConfigConfigurationArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_run_now: Optional[pulumi.Input[bool]] = None,
                 is_run_once: Optional[pulumi.Input[bool]] = None,
                 maintenance_window_schedule: Optional[pulumi.Input[pulumi.InputType['ConfigMaintenanceWindowScheduleArgs']]] = None,
                 monitor_type: Optional[pulumi.Input[str]] = None,
                 repeat_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 scheduling_policy: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 script_name: Optional[pulumi.Input[str]] = None,
                 script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigScriptParameterArgs']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 vantage_points: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigVantagePointArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigArgs.__new__(ConfigArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["availability_configuration"] = availability_configuration
            __props__.__dict__["batch_interval_in_seconds"] = batch_interval_in_seconds
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_run_now"] = is_run_now
            __props__.__dict__["is_run_once"] = is_run_once
            __props__.__dict__["maintenance_window_schedule"] = maintenance_window_schedule
            if monitor_type is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_type'")
            __props__.__dict__["monitor_type"] = monitor_type
            if repeat_interval_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'repeat_interval_in_seconds'")
            __props__.__dict__["repeat_interval_in_seconds"] = repeat_interval_in_seconds
            __props__.__dict__["scheduling_policy"] = scheduling_policy
            __props__.__dict__["script_id"] = script_id
            __props__.__dict__["script_name"] = script_name
            __props__.__dict__["script_parameters"] = script_parameters
            __props__.__dict__["status"] = status
            __props__.__dict__["target"] = target
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            if vantage_points is None and not opts.urn:
                raise TypeError("Missing required property 'vantage_points'")
            __props__.__dict__["vantage_points"] = vantage_points
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["vantage_point_count"] = None
        super(Config, __self__).__init__(
            'oci:ApmSynthetics/config:Config',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[str]] = None,
            availability_configuration: Optional[pulumi.Input[pulumi.InputType['ConfigAvailabilityConfigurationArgs']]] = None,
            batch_interval_in_seconds: Optional[pulumi.Input[int]] = None,
            configuration: Optional[pulumi.Input[pulumi.InputType['ConfigConfigurationArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_run_now: Optional[pulumi.Input[bool]] = None,
            is_run_once: Optional[pulumi.Input[bool]] = None,
            maintenance_window_schedule: Optional[pulumi.Input[pulumi.InputType['ConfigMaintenanceWindowScheduleArgs']]] = None,
            monitor_type: Optional[pulumi.Input[str]] = None,
            repeat_interval_in_seconds: Optional[pulumi.Input[int]] = None,
            scheduling_policy: Optional[pulumi.Input[str]] = None,
            script_id: Optional[pulumi.Input[str]] = None,
            script_name: Optional[pulumi.Input[str]] = None,
            script_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigScriptParameterArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            target: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            vantage_point_count: Optional[pulumi.Input[int]] = None,
            vantage_points: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigVantagePointArgs']]]]] = None) -> 'Config':
        """
        Get an existing Config resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[pulumi.InputType['ConfigAvailabilityConfigurationArgs']] availability_configuration: (Updatable) Monitor availability configuration details.
        :param pulumi.Input[int] batch_interval_in_seconds: (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        :param pulumi.Input[pulumi.InputType['ConfigConfigurationArgs']] configuration: (Updatable) Details of monitor configuration.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Unique name that can be edited. The name should not contain any confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_run_now: (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        :param pulumi.Input[bool] is_run_once: (Updatable) If runOnce is enabled, then the monitor will run once.
        :param pulumi.Input[pulumi.InputType['ConfigMaintenanceWindowScheduleArgs']] maintenance_window_schedule: (Updatable) Details required to schedule maintenance window.
        :param pulumi.Input[str] monitor_type: Type of monitor.
        :param pulumi.Input[int] repeat_interval_in_seconds: (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        :param pulumi.Input[str] scheduling_policy: (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        :param pulumi.Input[str] script_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        :param pulumi.Input[str] script_name: Name of the script.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigScriptParameterArgs']]]] script_parameters: (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        :param pulumi.Input[str] status: (Updatable) Enables or disables the monitor.
        :param pulumi.Input[str] target: (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        :param pulumi.Input[str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        :param pulumi.Input[int] timeout_in_seconds: (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        :param pulumi.Input[int] vantage_point_count: Number of vantage points where monitor is running.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigVantagePointArgs']]]] vantage_points: (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigState.__new__(_ConfigState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["availability_configuration"] = availability_configuration
        __props__.__dict__["batch_interval_in_seconds"] = batch_interval_in_seconds
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_run_now"] = is_run_now
        __props__.__dict__["is_run_once"] = is_run_once
        __props__.__dict__["maintenance_window_schedule"] = maintenance_window_schedule
        __props__.__dict__["monitor_type"] = monitor_type
        __props__.__dict__["repeat_interval_in_seconds"] = repeat_interval_in_seconds
        __props__.__dict__["scheduling_policy"] = scheduling_policy
        __props__.__dict__["script_id"] = script_id
        __props__.__dict__["script_name"] = script_name
        __props__.__dict__["script_parameters"] = script_parameters
        __props__.__dict__["status"] = status
        __props__.__dict__["target"] = target
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["vantage_point_count"] = vantage_point_count
        __props__.__dict__["vantage_points"] = vantage_points
        return Config(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="availabilityConfiguration")
    def availability_configuration(self) -> pulumi.Output['outputs.ConfigAvailabilityConfiguration']:
        """
        (Updatable) Monitor availability configuration details.
        """
        return pulumi.get(self, "availability_configuration")

    @property
    @pulumi.getter(name="batchIntervalInSeconds")
    def batch_interval_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Time interval between 2 runs in round robin batch mode (*SchedulingPolicy - BATCHED_ROUND_ROBIN).
        """
        return pulumi.get(self, "batch_interval_in_seconds")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.ConfigConfiguration']:
        """
        (Updatable) Details of monitor configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isRunNow")
    def is_run_now(self) -> pulumi.Output[bool]:
        """
        (Updatable) If isRunNow is enabled, then the monitor will run immediately.
        """
        return pulumi.get(self, "is_run_now")

    @property
    @pulumi.getter(name="isRunOnce")
    def is_run_once(self) -> pulumi.Output[bool]:
        """
        (Updatable) If runOnce is enabled, then the monitor will run once.
        """
        return pulumi.get(self, "is_run_once")

    @property
    @pulumi.getter(name="maintenanceWindowSchedule")
    def maintenance_window_schedule(self) -> pulumi.Output['outputs.ConfigMaintenanceWindowSchedule']:
        """
        (Updatable) Details required to schedule maintenance window.
        """
        return pulumi.get(self, "maintenance_window_schedule")

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> pulumi.Output[str]:
        """
        Type of monitor.
        """
        return pulumi.get(self, "monitor_type")

    @property
    @pulumi.getter(name="repeatIntervalInSeconds")
    def repeat_interval_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Interval in seconds after the start time when the job should be repeated. Minimum repeatIntervalInSeconds should be 300 seconds for Scripted REST, Scripted Browser and Browser monitors, and 60 seconds for REST monitor.
        """
        return pulumi.get(self, "repeat_interval_in_seconds")

    @property
    @pulumi.getter(name="schedulingPolicy")
    def scheduling_policy(self) -> pulumi.Output[str]:
        """
        (Updatable) Scheduling policy to decide the distribution of monitor executions on vantage points.
        """
        return pulumi.get(self, "scheduling_policy")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[str]:
        """
        Name of the script.
        """
        return pulumi.get(self, "script_name")

    @property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> pulumi.Output[Sequence['outputs.ConfigScriptParameter']]:
        """
        (Updatable) List of script parameters in the monitor. This is valid only for SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null. Example: `[{"paramName": "userid", "paramValue":"testuser"}]`
        """
        return pulumi.get(self, "script_parameters")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Enables or disables the monitor.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[str]:
        """
        (Updatable) Specify the endpoint on which to run the monitor. For BROWSER, REST and NETWORK monitor types, target is mandatory. If target is specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script (specified by scriptId in monitor) against the specified target endpoint. If target is not specified in the SCRIPTED_BROWSER monitor type, then the monitor will run the selected script as it is. For NETWORK monitor with TCP protocol, a port needs to be provided along with target. Example: 192.168.0.1:80
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Timeout in seconds. If isFailureRetried is true, then timeout cannot be more than 30%!o(MISSING)f repeatIntervalInSeconds time for monitors. If isFailureRetried is false, then timeout cannot be more than 50%!o(MISSING)f repeatIntervalInSeconds time for monitors. Also, timeoutInSeconds should be a multiple of 60 for Scripted REST, Scripted Browser and Browser monitors. Monitor will be allowed to run only for timeoutInSeconds time. It would be terminated after that.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="vantagePointCount")
    def vantage_point_count(self) -> pulumi.Output[int]:
        """
        Number of vantage points where monitor is running.
        """
        return pulumi.get(self, "vantage_point_count")

    @property
    @pulumi.getter(name="vantagePoints")
    def vantage_points(self) -> pulumi.Output[Sequence['outputs.ConfigVantagePoint']]:
        """
        (Updatable) A list of public and dedicated vantage points from which to execute the monitor. Use /publicVantagePoints to fetch public vantage points, and /dedicatedVantagePoints to fetch dedicated vantage points. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vantage_points")

