# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternalOccAvailabilityCatalogsResult',
    'AwaitableGetInternalOccAvailabilityCatalogsResult',
    'get_internal_occ_availability_catalogs',
    'get_internal_occ_availability_catalogs_output',
]

@pulumi.output_type
class GetInternalOccAvailabilityCatalogsResult:
    """
    A collection of values returned by getInternalOccAvailabilityCatalogs.
    """
    def __init__(__self__, catalog_state=None, compartment_id=None, display_name=None, filters=None, id=None, namespace=None, occ_availability_catalog_collections=None, occ_customer_group_id=None):
        if catalog_state and not isinstance(catalog_state, str):
            raise TypeError("Expected argument 'catalog_state' to be a str")
        pulumi.set(__self__, "catalog_state", catalog_state)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if occ_availability_catalog_collections and not isinstance(occ_availability_catalog_collections, list):
            raise TypeError("Expected argument 'occ_availability_catalog_collections' to be a list")
        pulumi.set(__self__, "occ_availability_catalog_collections", occ_availability_catalog_collections)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)

    @property
    @pulumi.getter(name="catalogState")
    def catalog_state(self) -> Optional[str]:
        """
        Represents whether this version of the availability catalog has been made available to the customer. The state is No by default.
        """
        return pulumi.get(self, "catalog_state")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy where the availability catalog resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        An user-friendly name for the availability catalog. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternalOccAvailabilityCatalogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the availability catalog.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="occAvailabilityCatalogCollections")
    def occ_availability_catalog_collections(self) -> Sequence['outputs.GetInternalOccAvailabilityCatalogsOccAvailabilityCatalogCollectionResult']:
        """
        The list of occ_availability_catalog_collection.
        """
        return pulumi.get(self, "occ_availability_catalog_collections")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> Optional[str]:
        """
        The Customer Group OCID to which the availability catalog belongs.
        """
        return pulumi.get(self, "occ_customer_group_id")


class AwaitableGetInternalOccAvailabilityCatalogsResult(GetInternalOccAvailabilityCatalogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalOccAvailabilityCatalogsResult(
            catalog_state=self.catalog_state,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            namespace=self.namespace,
            occ_availability_catalog_collections=self.occ_availability_catalog_collections,
            occ_customer_group_id=self.occ_customer_group_id)


def get_internal_occ_availability_catalogs(catalog_state: Optional[str] = None,
                                           compartment_id: Optional[str] = None,
                                           display_name: Optional[str] = None,
                                           filters: Optional[Sequence[pulumi.InputType['GetInternalOccAvailabilityCatalogsFilterArgs']]] = None,
                                           id: Optional[str] = None,
                                           namespace: Optional[str] = None,
                                           occ_customer_group_id: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalOccAvailabilityCatalogsResult:
    """
    This data source provides the list of Internal Occ Availability Catalogs in Oracle Cloud Infrastructure Capacity Management service.

    An internal api to list availability catalogs.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occ_availability_catalogs = oci.CapacityManagement.get_internal_occ_availability_catalogs(compartment_id=var["compartment_id"],
        catalog_state=var["internal_occ_availability_catalog_catalog_state"],
        display_name=var["internal_occ_availability_catalog_display_name"],
        id=var["internal_occ_availability_catalog_id"],
        namespace=var["internal_occ_availability_catalog_namespace"],
        occ_customer_group_id=oci_capacity_management_occ_customer_group["test_occ_customer_group"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_state: Filter the list of availability catalogs based on the catalog state.
    :param str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param str id: The OCID of the availability catalog to filter the list of availability catalogs.
    :param str namespace: The namespace by which we would filter the list.
    :param str occ_customer_group_id: The customer group ocid by which we would filter the list.
    """
    __args__ = dict()
    __args__['catalogState'] = catalog_state
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['namespace'] = namespace
    __args__['occCustomerGroupId'] = occ_customer_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getInternalOccAvailabilityCatalogs:getInternalOccAvailabilityCatalogs', __args__, opts=opts, typ=GetInternalOccAvailabilityCatalogsResult).value

    return AwaitableGetInternalOccAvailabilityCatalogsResult(
        catalog_state=pulumi.get(__ret__, 'catalog_state'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        occ_availability_catalog_collections=pulumi.get(__ret__, 'occ_availability_catalog_collections'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'))


@_utilities.lift_output_func(get_internal_occ_availability_catalogs)
def get_internal_occ_availability_catalogs_output(catalog_state: Optional[pulumi.Input[Optional[str]]] = None,
                                                  compartment_id: Optional[pulumi.Input[str]] = None,
                                                  display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInternalOccAvailabilityCatalogsFilterArgs']]]]] = None,
                                                  id: Optional[pulumi.Input[Optional[str]]] = None,
                                                  namespace: Optional[pulumi.Input[Optional[str]]] = None,
                                                  occ_customer_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInternalOccAvailabilityCatalogsResult]:
    """
    This data source provides the list of Internal Occ Availability Catalogs in Oracle Cloud Infrastructure Capacity Management service.

    An internal api to list availability catalogs.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occ_availability_catalogs = oci.CapacityManagement.get_internal_occ_availability_catalogs(compartment_id=var["compartment_id"],
        catalog_state=var["internal_occ_availability_catalog_catalog_state"],
        display_name=var["internal_occ_availability_catalog_display_name"],
        id=var["internal_occ_availability_catalog_id"],
        namespace=var["internal_occ_availability_catalog_namespace"],
        occ_customer_group_id=oci_capacity_management_occ_customer_group["test_occ_customer_group"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_state: Filter the list of availability catalogs based on the catalog state.
    :param str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param str display_name: A filter to return only the resources that match the entire display name. The match is not case sensitive.
    :param str id: The OCID of the availability catalog to filter the list of availability catalogs.
    :param str namespace: The namespace by which we would filter the list.
    :param str occ_customer_group_id: The customer group ocid by which we would filter the list.
    """
    ...
