# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProblemEntitiesResult',
    'AwaitableGetProblemEntitiesResult',
    'get_problem_entities',
    'get_problem_entities_output',
]

@pulumi.output_type
class GetProblemEntitiesResult:
    """
    A collection of values returned by getProblemEntities.
    """
    def __init__(__self__, filters=None, id=None, problem_entity_collections=None, problem_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if problem_entity_collections and not isinstance(problem_entity_collections, list):
            raise TypeError("Expected argument 'problem_entity_collections' to be a list")
        pulumi.set(__self__, "problem_entity_collections", problem_entity_collections)
        if problem_id and not isinstance(problem_id, str):
            raise TypeError("Expected argument 'problem_id' to be a str")
        pulumi.set(__self__, "problem_id", problem_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProblemEntitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="problemEntityCollections")
    def problem_entity_collections(self) -> Sequence['outputs.GetProblemEntitiesProblemEntityCollectionResult']:
        """
        The list of problem_entity_collection.
        """
        return pulumi.get(self, "problem_entity_collections")

    @property
    @pulumi.getter(name="problemId")
    def problem_id(self) -> str:
        """
        Attached problem id
        """
        return pulumi.get(self, "problem_id")


class AwaitableGetProblemEntitiesResult(GetProblemEntitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProblemEntitiesResult(
            filters=self.filters,
            id=self.id,
            problem_entity_collections=self.problem_entity_collections,
            problem_id=self.problem_id)


def get_problem_entities(filters: Optional[Sequence[pulumi.InputType['GetProblemEntitiesFilterArgs']]] = None,
                         problem_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProblemEntitiesResult:
    """
    This data source provides the list of Problem Entities in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of entities for a CloudGuard Problem

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_problem_entities = oci.CloudGuard.get_problem_entities(problem_id=oci_cloud_guard_problem["test_problem"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str problem_id: OCId of the problem.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['problemId'] = problem_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getProblemEntities:getProblemEntities', __args__, opts=opts, typ=GetProblemEntitiesResult).value

    return AwaitableGetProblemEntitiesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        problem_entity_collections=pulumi.get(__ret__, 'problem_entity_collections'),
        problem_id=pulumi.get(__ret__, 'problem_id'))


@_utilities.lift_output_func(get_problem_entities)
def get_problem_entities_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetProblemEntitiesFilterArgs']]]]] = None,
                                problem_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProblemEntitiesResult]:
    """
    This data source provides the list of Problem Entities in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of entities for a CloudGuard Problem

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_problem_entities = oci.CloudGuard.get_problem_entities(problem_id=oci_cloud_guard_problem["test_problem"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str problem_id: OCId of the problem.
    """
    ...
