# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AddonAddonErrorArgs',
    'AddonConfigurationArgs',
    'ClusterClusterPodNetworkOptionArgs',
    'ClusterEndpointArgs',
    'ClusterEndpointConfigArgs',
    'ClusterImagePolicyConfigArgs',
    'ClusterImagePolicyConfigKeyDetailArgs',
    'ClusterMetadataArgs',
    'ClusterOptionsArgs',
    'ClusterOptionsAddOnsArgs',
    'ClusterOptionsAdmissionControllerOptionsArgs',
    'ClusterOptionsKubernetesNetworkConfigArgs',
    'ClusterOptionsPersistentVolumeConfigArgs',
    'ClusterOptionsServiceLbConfigArgs',
    'ContainerInstanceContainerArgs',
    'ContainerInstanceContainerHealthCheckArgs',
    'ContainerInstanceContainerHealthCheckHeaderArgs',
    'ContainerInstanceContainerResourceConfigArgs',
    'ContainerInstanceContainerSecurityContextArgs',
    'ContainerInstanceContainerSecurityContextCapabilitiesArgs',
    'ContainerInstanceContainerVolumeMountArgs',
    'ContainerInstanceDnsConfigArgs',
    'ContainerInstanceImagePullSecretArgs',
    'ContainerInstanceShapeConfigArgs',
    'ContainerInstanceVnicArgs',
    'ContainerInstanceVolumeArgs',
    'ContainerInstanceVolumeConfigArgs',
    'NodePoolInitialNodeLabelArgs',
    'NodePoolNodeArgs',
    'NodePoolNodeConfigDetailsArgs',
    'NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs',
    'NodePoolNodeConfigDetailsPlacementConfigArgs',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs',
    'NodePoolNodeErrorArgs',
    'NodePoolNodeEvictionNodePoolSettingsArgs',
    'NodePoolNodePoolCyclingDetailsArgs',
    'NodePoolNodeShapeConfigArgs',
    'NodePoolNodeSourceArgs',
    'NodePoolNodeSourceDetailsArgs',
    'VirtualNodePoolInitialVirtualNodeLabelArgs',
    'VirtualNodePoolPlacementConfigurationArgs',
    'VirtualNodePoolPodConfigurationArgs',
    'VirtualNodePoolTaintArgs',
    'VirtualNodePoolVirtualNodeTagsArgs',
    'GetAddonOptionsFilterArgs',
    'GetAddonsFilterArgs',
    'GetClusterWorkloadMappingsFilterArgs',
    'GetClustersFilterArgs',
    'GetNodePoolsFilterArgs',
    'GetPodShapesFilterArgs',
    'GetVirtualNodePoolsFilterArgs',
    'GetWorkRequestErrorsFilterArgs',
    'GetWorkRequestLogEntriesFilterArgs',
    'GetWorkRequestsFilterArgs',
]

@pulumi.input_type
class AddonAddonErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param pulumi.Input[str] message: A human-readable error string of the upstream error.
        :param pulumi.Input[str] status: The status of the HTTP response encountered in the upstream error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class AddonConfigurationArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) configuration key name
        :param pulumi.Input[str] value: (Updatable) configuration value name
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) configuration key name
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) configuration value name
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ClusterClusterPodNetworkOptionArgs:
    def __init__(__self__, *,
                 cni_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cni_type: The CNI used by the node pools of this cluster
        """
        pulumi.set(__self__, "cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> pulumi.Input[str]:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")

    @cni_type.setter
    def cni_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "cni_type", value)


@pulumi.input_type
class ClusterEndpointArgs:
    def __init__(__self__, *,
                 kubernetes: Optional[pulumi.Input[str]] = None,
                 private_endpoint: Optional[pulumi.Input[str]] = None,
                 public_endpoint: Optional[pulumi.Input[str]] = None,
                 vcn_hostname_endpoint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kubernetes: The non-native networking Kubernetes API server endpoint.
        :param pulumi.Input[str] private_endpoint: The private native networking Kubernetes API server endpoint.
        :param pulumi.Input[str] public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param pulumi.Input[str] vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if vcn_hostname_endpoint is not None:
            pulumi.set(__self__, "vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input[str]]:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")

    @vcn_hostname_endpoint.setter
    def vcn_hostname_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_hostname_endpoint", value)


@pulumi.input_type
class ClusterEndpointConfigArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 is_public_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        :param pulumi.Input[bool] is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if is_public_ip_enabled is not None:
            pulumi.set(__self__, "is_public_ip_enabled", is_public_ip_enabled)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @is_public_ip_enabled.setter
    def is_public_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public_ip_enabled", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)


@pulumi.input_type
class ClusterImagePolicyConfigArgs:
    def __init__(__self__, *,
                 is_policy_enabled: Optional[pulumi.Input[bool]] = None,
                 key_details: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterImagePolicyConfigKeyDetailArgs']]]] = None):
        """
        :param pulumi.Input[bool] is_policy_enabled: (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterImagePolicyConfigKeyDetailArgs']]] key_details: (Updatable) A list of KMS key details.
        """
        if is_policy_enabled is not None:
            pulumi.set(__self__, "is_policy_enabled", is_policy_enabled)
        if key_details is not None:
            pulumi.set(__self__, "key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @is_policy_enabled.setter
    def is_policy_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_policy_enabled", value)

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterImagePolicyConfigKeyDetailArgs']]]]:
        """
        (Updatable) A list of KMS key details.
        """
        return pulumi.get(self, "key_details")

    @key_details.setter
    def key_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterImagePolicyConfigKeyDetailArgs']]]]):
        pulumi.set(self, "key_details", value)


@pulumi.input_type
class ClusterImagePolicyConfigKeyDetailArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


@pulumi.input_type
class ClusterMetadataArgs:
    def __init__(__self__, *,
                 created_by_user_id: Optional[pulumi.Input[str]] = None,
                 created_by_work_request_id: Optional[pulumi.Input[str]] = None,
                 deleted_by_user_id: Optional[pulumi.Input[str]] = None,
                 deleted_by_work_request_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_credential_expiration: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 updated_by_user_id: Optional[pulumi.Input[str]] = None,
                 updated_by_work_request_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] created_by_user_id: The user who created the cluster.
        :param pulumi.Input[str] created_by_work_request_id: The OCID of the work request which created the cluster.
        :param pulumi.Input[str] deleted_by_user_id: The user who deleted the cluster.
        :param pulumi.Input[str] deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param pulumi.Input[str] time_created: The time the cluster was created.
        :param pulumi.Input[str] time_credential_expiration: The time until which the cluster credential is valid.
        :param pulumi.Input[str] time_deleted: The time the cluster was deleted.
        :param pulumi.Input[str] time_updated: The time the cluster was updated.
        :param pulumi.Input[str] updated_by_user_id: The user who updated the cluster.
        :param pulumi.Input[str] updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        if created_by_user_id is not None:
            pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        if created_by_work_request_id is not None:
            pulumi.set(__self__, "created_by_work_request_id", created_by_work_request_id)
        if deleted_by_user_id is not None:
            pulumi.set(__self__, "deleted_by_user_id", deleted_by_user_id)
        if deleted_by_work_request_id is not None:
            pulumi.set(__self__, "deleted_by_work_request_id", deleted_by_work_request_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_credential_expiration is not None:
            pulumi.set(__self__, "time_credential_expiration", time_credential_expiration)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if updated_by_user_id is not None:
            pulumi.set(__self__, "updated_by_user_id", updated_by_user_id)
        if updated_by_work_request_id is not None:
            pulumi.set(__self__, "updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @created_by_user_id.setter
    def created_by_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by_user_id", value)

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @created_by_work_request_id.setter
    def created_by_work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by_work_request_id", value)

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @deleted_by_user_id.setter
    def deleted_by_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_by_user_id", value)

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @deleted_by_work_request_id.setter
    def deleted_by_work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_by_work_request_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @time_credential_expiration.setter
    def time_credential_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_credential_expiration", value)

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deleted", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @updated_by_user_id.setter
    def updated_by_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_by_user_id", value)

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")

    @updated_by_work_request_id.setter
    def updated_by_work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_by_work_request_id", value)


@pulumi.input_type
class ClusterOptionsArgs:
    def __init__(__self__, *,
                 add_ons: Optional[pulumi.Input['ClusterOptionsAddOnsArgs']] = None,
                 admission_controller_options: Optional[pulumi.Input['ClusterOptionsAdmissionControllerOptionsArgs']] = None,
                 kubernetes_network_config: Optional[pulumi.Input['ClusterOptionsKubernetesNetworkConfigArgs']] = None,
                 persistent_volume_config: Optional[pulumi.Input['ClusterOptionsPersistentVolumeConfigArgs']] = None,
                 service_lb_config: Optional[pulumi.Input['ClusterOptionsServiceLbConfigArgs']] = None,
                 service_lb_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input['ClusterOptionsAddOnsArgs'] add_ons: Configurable cluster add-ons
        :param pulumi.Input['ClusterOptionsAdmissionControllerOptionsArgs'] admission_controller_options: (Updatable) Configurable cluster admission controllers
        :param pulumi.Input['ClusterOptionsKubernetesNetworkConfigArgs'] kubernetes_network_config: Network configuration for Kubernetes.
        :param pulumi.Input['ClusterOptionsPersistentVolumeConfigArgs'] persistent_volume_config: (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param pulumi.Input['ClusterOptionsServiceLbConfigArgs'] service_lb_config: (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        if add_ons is not None:
            pulumi.set(__self__, "add_ons", add_ons)
        if admission_controller_options is not None:
            pulumi.set(__self__, "admission_controller_options", admission_controller_options)
        if kubernetes_network_config is not None:
            pulumi.set(__self__, "kubernetes_network_config", kubernetes_network_config)
        if persistent_volume_config is not None:
            pulumi.set(__self__, "persistent_volume_config", persistent_volume_config)
        if service_lb_config is not None:
            pulumi.set(__self__, "service_lb_config", service_lb_config)
        if service_lb_subnet_ids is not None:
            pulumi.set(__self__, "service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Optional[pulumi.Input['ClusterOptionsAddOnsArgs']]:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @add_ons.setter
    def add_ons(self, value: Optional[pulumi.Input['ClusterOptionsAddOnsArgs']]):
        pulumi.set(self, "add_ons", value)

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Optional[pulumi.Input['ClusterOptionsAdmissionControllerOptionsArgs']]:
        """
        (Updatable) Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @admission_controller_options.setter
    def admission_controller_options(self, value: Optional[pulumi.Input['ClusterOptionsAdmissionControllerOptionsArgs']]):
        pulumi.set(self, "admission_controller_options", value)

    @property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> Optional[pulumi.Input['ClusterOptionsKubernetesNetworkConfigArgs']]:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @kubernetes_network_config.setter
    def kubernetes_network_config(self, value: Optional[pulumi.Input['ClusterOptionsKubernetesNetworkConfigArgs']]):
        pulumi.set(self, "kubernetes_network_config", value)

    @property
    @pulumi.getter(name="persistentVolumeConfig")
    def persistent_volume_config(self) -> Optional[pulumi.Input['ClusterOptionsPersistentVolumeConfigArgs']]:
        """
        (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_config")

    @persistent_volume_config.setter
    def persistent_volume_config(self, value: Optional[pulumi.Input['ClusterOptionsPersistentVolumeConfigArgs']]):
        pulumi.set(self, "persistent_volume_config", value)

    @property
    @pulumi.getter(name="serviceLbConfig")
    def service_lb_config(self) -> Optional[pulumi.Input['ClusterOptionsServiceLbConfigArgs']]:
        """
        (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_config")

    @service_lb_config.setter
    def service_lb_config(self, value: Optional[pulumi.Input['ClusterOptionsServiceLbConfigArgs']]):
        pulumi.set(self, "service_lb_config", value)

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")

    @service_lb_subnet_ids.setter
    def service_lb_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_lb_subnet_ids", value)


@pulumi.input_type
class ClusterOptionsAddOnsArgs:
    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: Optional[pulumi.Input[bool]] = None,
                 is_tiller_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param pulumi.Input[bool] is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        if is_kubernetes_dashboard_enabled is not None:
            pulumi.set(__self__, "is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        if is_tiller_enabled is not None:
            pulumi.set(__self__, "is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @is_kubernetes_dashboard_enabled.setter
    def is_kubernetes_dashboard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kubernetes_dashboard_enabled", value)

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")

    @is_tiller_enabled.setter
    def is_tiller_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_tiller_enabled", value)


@pulumi.input_type
class ClusterOptionsAdmissionControllerOptionsArgs:
    def __init__(__self__, *,
                 is_pod_security_policy_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_pod_security_policy_enabled: (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        if is_pod_security_policy_enabled is not None:
            pulumi.set(__self__, "is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")

    @is_pod_security_policy_enabled.setter
    def is_pod_security_policy_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pod_security_policy_enabled", value)


@pulumi.input_type
class ClusterOptionsKubernetesNetworkConfigArgs:
    def __init__(__self__, *,
                 pods_cidr: Optional[pulumi.Input[str]] = None,
                 services_cidr: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] pods_cidr: The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        :param pulumi.Input[str] services_cidr: The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        if pods_cidr is not None:
            pulumi.set(__self__, "pods_cidr", pods_cidr)
        if services_cidr is not None:
            pulumi.set(__self__, "services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        """
        return pulumi.get(self, "pods_cidr")

    @pods_cidr.setter
    def pods_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pods_cidr", value)

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        return pulumi.get(self, "services_cidr")

    @services_cidr.setter
    def services_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_cidr", value)


@pulumi.input_type
class ClusterOptionsPersistentVolumeConfigArgs:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class ClusterOptionsServiceLbConfigArgs:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class ContainerInstanceContainerArgs:
    def __init__(__self__, *,
                 image_url: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 container_id: Optional[pulumi.Input[str]] = None,
                 container_instance_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 exit_code: Optional[pulumi.Input[int]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckArgs']]]] = None,
                 is_resource_principal_disabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 resource_config: Optional[pulumi.Input['ContainerInstanceContainerResourceConfigArgs']] = None,
                 security_context: Optional[pulumi.Input['ContainerInstanceContainerSecurityContextArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_terminated: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerVolumeMountArgs']]]] = None,
                 working_directory: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image_url: A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.
               
               If no registry is provided, will default the registry to public docker hub `docker.io/library`.
               
               The registry used for container image must be reachable over the Container Instance's VNIC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] arguments: A list of string arguments for a container's ENTRYPOINT process.
               
               Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.
               
               The total size of all arguments combined must be 64 KB or smaller.
        :param pulumi.Input[str] availability_domain: The availability domain where the container instance runs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The list of strings that will be simplified to a single command for checking the status of the container.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment OCID.
        :param pulumi.Input[str] container_id: The OCID of the container.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.
               
               The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        :param pulumi.Input[str] fault_domain: The fault domain where the container instance runs.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckArgs']]] health_checks: list of container health checks to check container status and take appropriate action if container status is failed. There are three types of health checks that we currently support HTTP, TCP, and Command.
        :param pulumi.Input[bool] is_resource_principal_disabled: Determines if the container will have access to the container instance resource principal.
               
               This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        :param pulumi.Input[str] lifecycle_details: A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        :param pulumi.Input['ContainerInstanceContainerResourceConfigArgs'] resource_config: The size and amount of resources available to the container.
        :param pulumi.Input['ContainerInstanceContainerSecurityContextArgs'] security_context: Security context for container.
        :param pulumi.Input[str] state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        :param pulumi.Input[str] time_created: The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[str] time_updated: The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerVolumeMountArgs']]] volume_mounts: List of the volume mounts.
        :param pulumi.Input[str] working_directory: The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        pulumi.set(__self__, "image_url", image_url)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_instance_id is not None:
            pulumi.set(__self__, "container_instance_id", container_instance_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if is_resource_principal_disabled is not None:
            pulumi.set(__self__, "is_resource_principal_disabled", is_resource_principal_disabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if resource_config is not None:
            pulumi.set(__self__, "resource_config", resource_config)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_terminated is not None:
            pulumi.set(__self__, "time_terminated", time_terminated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Input[str]:
        """
        A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.

        If no registry is provided, will default the registry to public docker hub `docker.io/library`.

        The registry used for container image must be reachable over the Container Instance's VNIC.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of string arguments for a container's ENTRYPOINT process.

        Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.

        The total size of all arguments combined must be 64 KB or smaller.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of strings that will be simplified to a single command for checking the status of the container.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="containerInstanceId")
    def container_instance_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_instance_id")

    @container_instance_id.setter
    def container_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_instance_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.

        The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "exit_code")

    @exit_code.setter
    def exit_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "exit_code", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckArgs']]]]:
        """
        list of container health checks to check container status and take appropriate action if container status is failed. There are three types of health checks that we currently support HTTP, TCP, and Command.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckArgs']]]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter(name="isResourcePrincipalDisabled")
    def is_resource_principal_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the container will have access to the container instance resource principal.

        This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        """
        return pulumi.get(self, "is_resource_principal_disabled")

    @is_resource_principal_disabled.setter
    def is_resource_principal_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_resource_principal_disabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> Optional[pulumi.Input['ContainerInstanceContainerResourceConfigArgs']]:
        """
        The size and amount of resources available to the container.
        """
        return pulumi.get(self, "resource_config")

    @resource_config.setter
    def resource_config(self, value: Optional[pulumi.Input['ContainerInstanceContainerResourceConfigArgs']]):
        pulumi.set(self, "resource_config", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['ContainerInstanceContainerSecurityContextArgs']]:
        """
        Security context for container.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['ContainerInstanceContainerSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_terminated")

    @time_terminated.setter
    def time_terminated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_terminated", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerVolumeMountArgs']]]]:
        """
        List of the volume mounts.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class ContainerInstanceContainerHealthCheckArgs:
    def __init__(__self__, *,
                 health_check_type: pulumi.Input[str],
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 failure_action: Optional[pulumi.Input[str]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckHeaderArgs']]]] = None,
                 initial_delay_in_seconds: Optional[pulumi.Input[int]] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_details: Optional[pulumi.Input[str]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] health_check_type: Container health check type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The list of strings that will be simplified to a single command for checking the status of the container.
        :param pulumi.Input[str] failure_action: The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        :param pulumi.Input[int] failure_threshold: Number of consecutive failures at which we consider the check failed.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckHeaderArgs']]] headers: Container health check HTTP headers.
        :param pulumi.Input[int] initial_delay_in_seconds: The initial delay in seconds before start checking container health status.
        :param pulumi.Input[int] interval_in_seconds: Number of seconds between two consecutive runs for checking container health.
        :param pulumi.Input[str] name: The name of the volume. This must be unique within a single container instance.
        :param pulumi.Input[str] path: (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        :param pulumi.Input[int] port: Container health check HTTP port.
        :param pulumi.Input[int] success_threshold: Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        :param pulumi.Input[int] timeout_in_seconds: Length of waiting time in seconds before marking health check failed.
        """
        pulumi.set(__self__, "health_check_type", health_check_type)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if initial_delay_in_seconds is not None:
            pulumi.set(__self__, "initial_delay_in_seconds", initial_delay_in_seconds)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Input[str]:
        """
        Container health check type.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of strings that will be simplified to a single command for checking the status of the container.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        """
        return pulumi.get(self, "failure_action")

    @failure_action.setter
    def failure_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_action", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive failures at which we consider the check failed.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckHeaderArgs']]]]:
        """
        Container health check HTTP headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceContainerHealthCheckHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="initialDelayInSeconds")
    def initial_delay_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The initial delay in seconds before start checking container health status.
        """
        return pulumi.get(self, "initial_delay_in_seconds")

    @initial_delay_in_seconds.setter
    def initial_delay_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_in_seconds", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds between two consecutive runs for checking container health.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Container health check HTTP port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status_details")

    @status_details.setter
    def status_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_details", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Length of waiting time in seconds before marking health check failed.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)


@pulumi.input_type
class ContainerInstanceContainerHealthCheckHeaderArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the volume. This must be unique within a single container instance.
        :param pulumi.Input[str] value: Container HTTP header value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Container HTTP header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerInstanceContainerResourceConfigArgs:
    def __init__(__self__, *,
                 memory_limit_in_gbs: Optional[pulumi.Input[float]] = None,
                 vcpus_limit: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_limit_in_gbs: The maximum amount of memory that can be consumed by the container's process.
               
               If you do not set a value, then the process may use all available memory on the instance.
        :param pulumi.Input[float] vcpus_limit: The maximum amount of CPUs that can be consumed by the container's process.
               
               If you do not set a value, then the process can use all available CPU resources on the instance.
               
               CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.
               
               A container with a 2.0 vcpusLimit could consume up to 100%!o(MISSING)f the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        if memory_limit_in_gbs is not None:
            pulumi.set(__self__, "memory_limit_in_gbs", memory_limit_in_gbs)
        if vcpus_limit is not None:
            pulumi.set(__self__, "vcpus_limit", vcpus_limit)

    @property
    @pulumi.getter(name="memoryLimitInGbs")
    def memory_limit_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of memory that can be consumed by the container's process.

        If you do not set a value, then the process may use all available memory on the instance.
        """
        return pulumi.get(self, "memory_limit_in_gbs")

    @memory_limit_in_gbs.setter
    def memory_limit_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_limit_in_gbs", value)

    @property
    @pulumi.getter(name="vcpusLimit")
    def vcpus_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum amount of CPUs that can be consumed by the container's process.

        If you do not set a value, then the process can use all available CPU resources on the instance.

        CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.

        A container with a 2.0 vcpusLimit could consume up to 100%!o(MISSING)f the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        return pulumi.get(self, "vcpus_limit")

    @vcpus_limit.setter
    def vcpus_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "vcpus_limit", value)


@pulumi.input_type
class ContainerInstanceContainerSecurityContextArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input['ContainerInstanceContainerSecurityContextCapabilitiesArgs']] = None,
                 is_non_root_user_check_enabled: Optional[pulumi.Input[bool]] = None,
                 is_root_file_system_readonly: Optional[pulumi.Input[bool]] = None,
                 run_as_group: Optional[pulumi.Input[int]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None,
                 security_context_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ContainerInstanceContainerSecurityContextCapabilitiesArgs'] capabilities: Linux Container capabilities to configure capabilities of container.
        :param pulumi.Input[bool] is_non_root_user_check_enabled: Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        :param pulumi.Input[bool] is_root_file_system_readonly: Determines if the container will have a read-only root file system. Default value is false.
        :param pulumi.Input[int] run_as_group: The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        :param pulumi.Input[int] run_as_user: The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        :param pulumi.Input[str] security_context_type: The type of security context
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if is_non_root_user_check_enabled is not None:
            pulumi.set(__self__, "is_non_root_user_check_enabled", is_non_root_user_check_enabled)
        if is_root_file_system_readonly is not None:
            pulumi.set(__self__, "is_root_file_system_readonly", is_root_file_system_readonly)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if security_context_type is not None:
            pulumi.set(__self__, "security_context_type", security_context_type)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['ContainerInstanceContainerSecurityContextCapabilitiesArgs']]:
        """
        Linux Container capabilities to configure capabilities of container.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['ContainerInstanceContainerSecurityContextCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="isNonRootUserCheckEnabled")
    def is_non_root_user_check_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        """
        return pulumi.get(self, "is_non_root_user_check_enabled")

    @is_non_root_user_check_enabled.setter
    def is_non_root_user_check_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_non_root_user_check_enabled", value)

    @property
    @pulumi.getter(name="isRootFileSystemReadonly")
    def is_root_file_system_readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the container will have a read-only root file system. Default value is false.
        """
        return pulumi.get(self, "is_root_file_system_readonly")

    @is_root_file_system_readonly.setter
    def is_root_file_system_readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_root_file_system_readonly", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[int]]:
        """
        The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        """
        The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="securityContextType")
    def security_context_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of security context
        """
        return pulumi.get(self, "security_context_type")

    @security_context_type.setter
    def security_context_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_context_type", value)


@pulumi.input_type
class ContainerInstanceContainerSecurityContextCapabilitiesArgs:
    def __init__(__self__, *,
                 add_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drop_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add_capabilities: A list of additional configurable container capabilities.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drop_capabilities: A list of container capabilities that can be dropped.
        """
        if add_capabilities is not None:
            pulumi.set(__self__, "add_capabilities", add_capabilities)
        if drop_capabilities is not None:
            pulumi.set(__self__, "drop_capabilities", drop_capabilities)

    @property
    @pulumi.getter(name="addCapabilities")
    def add_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of additional configurable container capabilities.
        """
        return pulumi.get(self, "add_capabilities")

    @add_capabilities.setter
    def add_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add_capabilities", value)

    @property
    @pulumi.getter(name="dropCapabilities")
    def drop_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of container capabilities that can be dropped.
        """
        return pulumi.get(self, "drop_capabilities")

    @drop_capabilities.setter
    def drop_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drop_capabilities", value)


@pulumi.input_type
class ContainerInstanceContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 volume_name: pulumi.Input[str],
                 is_read_only: Optional[pulumi.Input[bool]] = None,
                 partition: Optional[pulumi.Input[int]] = None,
                 sub_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mount_path: The volume access path.
        :param pulumi.Input[str] volume_name: The name of the volume. Avoid entering confidential information.
        :param pulumi.Input[bool] is_read_only: Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        :param pulumi.Input[int] partition: If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        :param pulumi.Input[str] sub_path: A subpath inside the referenced volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "volume_name", volume_name)
        if is_read_only is not None:
            pulumi.set(__self__, "is_read_only", is_read_only)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        The volume access path.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[str]:
        """
        The name of the volume. Avoid entering confidential information.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        """
        return pulumi.get(self, "is_read_only")

    @is_read_only.setter
    def is_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_only", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[int]]:
        """
        If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[str]]:
        """
        A subpath inside the referenced volume.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_path", value)


@pulumi.input_type
class ContainerInstanceDnsConfigArgs:
    def __init__(__self__, *,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nameservers: IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] searches: Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        return pulumi.get(self, "searches")

    @searches.setter
    def searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "searches", value)


@pulumi.input_type
class ContainerInstanceImagePullSecretArgs:
    def __init__(__self__, *,
                 registry_endpoint: pulumi.Input[str],
                 secret_type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_endpoint: The registry endpoint of the container image.
        :param pulumi.Input[str] secret_type: The type of ImagePullSecret.
        :param pulumi.Input[str] password: The password which should be used with the registry for authentication. The value is expected in base64 format.
        :param pulumi.Input[str] secret_id: The OCID of the secret for registry credentials.
        :param pulumi.Input[str] username: The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        pulumi.set(__self__, "registry_endpoint", registry_endpoint)
        pulumi.set(__self__, "secret_type", secret_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="registryEndpoint")
    def registry_endpoint(self) -> pulumi.Input[str]:
        """
        The registry endpoint of the container image.
        """
        return pulumi.get(self, "registry_endpoint")

    @registry_endpoint.setter
    def registry_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_endpoint", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Input[str]:
        """
        The type of ImagePullSecret.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the secret for registry credentials.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ContainerInstanceShapeConfigArgs:
    def __init__(__self__, *,
                 ocpus: pulumi.Input[float],
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 networking_bandwidth_in_gbps: Optional[pulumi.Input[float]] = None,
                 processor_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[float] ocpus: The total number of OCPUs available to the container instance.
        :param pulumi.Input[float] memory_in_gbs: The total amount of memory available to the container instance (GB).
        :param pulumi.Input[float] networking_bandwidth_in_gbps: The networking bandwidth available to the container instance, in gigabits per second.
        :param pulumi.Input[str] processor_description: A short description of the container instance's processor (CPU).
        """
        pulumi.set(__self__, "ocpus", ocpus)
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if networking_bandwidth_in_gbps is not None:
            pulumi.set(__self__, "networking_bandwidth_in_gbps", networking_bandwidth_in_gbps)
        if processor_description is not None:
            pulumi.set(__self__, "processor_description", processor_description)

    @property
    @pulumi.getter
    def ocpus(self) -> pulumi.Input[float]:
        """
        The total number of OCPUs available to the container instance.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: pulumi.Input[float]):
        pulumi.set(self, "ocpus", value)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total amount of memory available to the container instance (GB).
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter(name="networkingBandwidthInGbps")
    def networking_bandwidth_in_gbps(self) -> Optional[pulumi.Input[float]]:
        """
        The networking bandwidth available to the container instance, in gigabits per second.
        """
        return pulumi.get(self, "networking_bandwidth_in_gbps")

    @networking_bandwidth_in_gbps.setter
    def networking_bandwidth_in_gbps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "networking_bandwidth_in_gbps", value)

    @property
    @pulumi.getter(name="processorDescription")
    def processor_description(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of the container instance's processor (CPU).
        """
        return pulumi.get(self, "processor_description")

    @processor_description.setter
    def processor_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "processor_description", value)


@pulumi.input_type
class ContainerInstanceVnicArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 is_public_ip_assigned: Optional[pulumi.Input[bool]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 skip_source_dest_check: Optional[pulumi.Input[bool]] = None,
                 vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subnet_id: The OCID of the subnet to create the VNIC in.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param pulumi.Input[str] display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname_label: The hostname for the VNIC's primary private IP. Used for DNS.
        :param pulumi.Input[bool] is_public_ip_assigned: Whether the VNIC should be assigned a public IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        :param pulumi.Input[str] private_ip: A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        :param pulumi.Input[bool] skip_source_dest_check: Whether the source/destination check is disabled on the VNIC.
        :param pulumi.Input[str] vnic_id: The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if is_public_ip_assigned is not None:
            pulumi.set(__self__, "is_public_ip_assigned", is_public_ip_assigned)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if skip_source_dest_check is not None:
            pulumi.set(__self__, "skip_source_dest_check", skip_source_dest_check)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The OCID of the subnet to create the VNIC in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the VNIC's primary private IP. Used for DNS.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter(name="isPublicIpAssigned")
    def is_public_ip_assigned(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the VNIC should be assigned a public IP address.
        """
        return pulumi.get(self, "is_public_ip_assigned")

    @is_public_ip_assigned.setter
    def is_public_ip_assigned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public_ip_assigned", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="skipSourceDestCheck")
    def skip_source_dest_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the source/destination check is disabled on the VNIC.
        """
        return pulumi.get(self, "skip_source_dest_check")

    @skip_source_dest_check.setter
    def skip_source_dest_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_source_dest_check", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_id", value)


@pulumi.input_type
class ContainerInstanceVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 volume_type: pulumi.Input[str],
                 backing_store: Optional[pulumi.Input[str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeConfigArgs']]]] = None):
        """
        :param pulumi.Input[str] name: The name of the volume. This must be unique within a single container instance.
        :param pulumi.Input[str] volume_type: The type of volume.
        :param pulumi.Input[str] backing_store: The volume type of the empty directory, can be either File Storage or Memory.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeConfigArgs']]] configs: Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_type", volume_type)
        if backing_store is not None:
            pulumi.set(__self__, "backing_store", backing_store)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        The type of volume.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="backingStore")
    def backing_store(self) -> Optional[pulumi.Input[str]]:
        """
        The volume type of the empty directory, can be either File Storage or Memory.
        """
        return pulumi.get(self, "backing_store")

    @backing_store.setter
    def backing_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backing_store", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeConfigArgs']]]]:
        """
        Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerInstanceVolumeConfigArgs']]]]):
        pulumi.set(self, "configs", value)


@pulumi.input_type
class ContainerInstanceVolumeConfigArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data: The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        :param pulumi.Input[str] file_name: The name of the file. The fileName should be unique across the volume.
        :param pulumi.Input[str] path: (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file. The fileName should be unique across the volume.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class NodePoolInitialNodeLabelArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) The key of the pair.
        :param pulumi.Input[str] value: (Updatable) The value of the pair.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NodePoolNodeArgs:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeErrorArgs']]]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_pool_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_domain: (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolNodeErrorArgs']]] errors: An error that may be associated with the node.
        :param pulumi.Input[str] fault_domain: The fault domain of this node.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] id: The OCID of the compute instance backing this node.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the node.
        :param pulumi.Input[str] name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param pulumi.Input[str] node_pool_id: The OCID of the node pool to which this node belongs.
        :param pulumi.Input[str] private_ip: The private IP address of this node.
        :param pulumi.Input[str] public_ip: The public IP address of this node.
        :param pulumi.Input[str] state: The state of the nodepool.
        :param pulumi.Input[str] subnet_id: (Updatable) The OCID of the subnet in which to place nodes.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_id is not None:
            pulumi.set(__self__, "node_pool_id", node_pool_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeErrorArgs']]]]:
        """
        An error that may be associated with the node.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain of this node.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compute instance backing this node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the node pool to which this node belongs.
        """
        return pulumi.get(self, "node_pool_id")

    @node_pool_id.setter
    def node_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_pool_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of this node.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public IP address of this node.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class NodePoolNodeConfigDetailsArgs:
    def __init__(__self__, *,
                 placement_configs: pulumi.Input[Sequence[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigArgs']]],
                 size: pulumi.Input[int],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 node_pool_pod_network_option_details: Optional[pulumi.Input['NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs']] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigArgs']]] placement_configs: (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
               
               To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param pulumi.Input[int] size: (Updatable) The number of nodes that should be in the node pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_pv_encryption_in_transit_enabled: (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param pulumi.Input[str] kms_key_id: (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        :param pulumi.Input['NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs'] node_pool_pod_network_option_details: (Updatable) The CNI related configuration of pods in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        pulumi.set(__self__, "placement_configs", placement_configs)
        pulumi.set(__self__, "size", size)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if node_pool_pod_network_option_details is not None:
            pulumi.set(__self__, "node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> pulumi.Input[Sequence[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigArgs']]]:
        """
        (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.

        To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configs")

    @placement_configs.setter
    def placement_configs(self, value: pulumi.Input[Sequence[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigArgs']]]):
        pulumi.set(self, "placement_configs", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of nodes that should be in the node pool.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pv_encryption_in_transit_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Optional[pulumi.Input['NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs']]:
        """
        (Updatable) The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @node_pool_pod_network_option_details.setter
    def node_pool_pod_network_option_details(self, value: Optional[pulumi.Input['NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs']]):
        pulumi.set(self, "node_pool_pod_network_option_details", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)


@pulumi.input_type
class NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs:
    def __init__(__self__, *,
                 cni_type: pulumi.Input[str],
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 pod_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] cni_type: (Updatable) The CNI plugin used by this node pool
        :param pulumi.Input[int] max_pods_per_node: (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_subnet_ids: (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        pulumi.set(__self__, "cni_type", cni_type)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if pod_nsg_ids is not None:
            pulumi.set(__self__, "pod_nsg_ids", pod_nsg_ids)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @cni_type.setter
    def cni_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "cni_type", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @pod_nsg_ids.setter
    def pod_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_nsg_ids", value)

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")

    @pod_subnet_ids.setter
    def pod_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_subnet_ids", value)


@pulumi.input_type
class NodePoolNodeConfigDetailsPlacementConfigArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preemptible_node_config: Optional[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs']] = None):
        """
        :param pulumi.Input[str] availability_domain: (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] subnet_id: (Updatable) The OCID of the subnet in which to place nodes.
        :param pulumi.Input[str] capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: (Updatable) A list of fault domains in which to place nodes.
        :param pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs'] preemptible_node_config: (Updatable) Configuration options for preemptible nodes.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if preemptible_node_config is not None:
            pulumi.set(__self__, "preemptible_node_config", preemptible_node_config)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter(name="preemptibleNodeConfig")
    def preemptible_node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs']]:
        """
        (Updatable) Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_config")

    @preemptible_node_config.setter
    def preemptible_node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs']]):
        pulumi.set(self, "preemptible_node_config", value)


@pulumi.input_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs:
    def __init__(__self__, *,
                 preemption_action: pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs']):
        """
        :param pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs'] preemption_action: (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        pulumi.set(__self__, "preemption_action", preemption_action)

    @property
    @pulumi.getter(name="preemptionAction")
    def preemption_action(self) -> pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs']:
        """
        (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_action")

    @preemption_action.setter
    def preemption_action(self, value: pulumi.Input['NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs']):
        pulumi.set(self, "preemption_action", value)


@pulumi.input_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 is_preserve_boot_volume: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param pulumi.Input[bool] is_preserve_boot_volume: (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        pulumi.set(__self__, "type", type)
        if is_preserve_boot_volume is not None:
            pulumi.set(__self__, "is_preserve_boot_volume", is_preserve_boot_volume)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")

    @is_preserve_boot_volume.setter
    def is_preserve_boot_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preserve_boot_volume", value)


@pulumi.input_type
class NodePoolNodeErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param pulumi.Input[str] message: A human-readable error string of the upstream error.
        :param pulumi.Input[str] status: The status of the HTTP response encountered in the upstream error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NodePoolNodeEvictionNodePoolSettingsArgs:
    def __init__(__self__, *,
                 eviction_grace_duration: Optional[pulumi.Input[str]] = None,
                 is_force_delete_after_grace_duration: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] eviction_grace_duration: (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param pulumi.Input[bool] is_force_delete_after_grace_duration: (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        if eviction_grace_duration is not None:
            pulumi.set(__self__, "eviction_grace_duration", eviction_grace_duration)
        if is_force_delete_after_grace_duration is not None:
            pulumi.set(__self__, "is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @eviction_grace_duration.setter
    def eviction_grace_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eviction_grace_duration", value)

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")

    @is_force_delete_after_grace_duration.setter
    def is_force_delete_after_grace_duration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_delete_after_grace_duration", value)


@pulumi.input_type
class NodePoolNodePoolCyclingDetailsArgs:
    def __init__(__self__, *,
                 is_node_cycling_enabled: Optional[pulumi.Input[bool]] = None,
                 maximum_surge: Optional[pulumi.Input[str]] = None,
                 maximum_unavailable: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_node_cycling_enabled: (Updatable) If nodes in the nodepool will be cycled to have new changes.
        :param pulumi.Input[str] maximum_surge: (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0%!t(MISSING)o 100%!
               (MISSING)
        :param pulumi.Input[str] maximum_unavailable: (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0%!t(MISSING)o 100%!
               (MISSING)
        """
        if is_node_cycling_enabled is not None:
            pulumi.set(__self__, "is_node_cycling_enabled", is_node_cycling_enabled)
        if maximum_surge is not None:
            pulumi.set(__self__, "maximum_surge", maximum_surge)
        if maximum_unavailable is not None:
            pulumi.set(__self__, "maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If nodes in the nodepool will be cycled to have new changes.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @is_node_cycling_enabled.setter
    def is_node_cycling_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_node_cycling_enabled", value)

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0%!t(MISSING)o 100%!
        (MISSING)
        """
        return pulumi.get(self, "maximum_surge")

    @maximum_surge.setter
    def maximum_surge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_surge", value)

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0%!t(MISSING)o 100%!
        (MISSING)
        """
        return pulumi.get(self, "maximum_unavailable")

    @maximum_unavailable.setter
    def maximum_unavailable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_unavailable", value)


@pulumi.input_type
class NodePoolNodeShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: (Updatable) The total amount of memory available to each node, in gigabytes.
        :param pulumi.Input[float] ocpus: (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class NodePoolNodeSourceArgs:
    def __init__(__self__, *,
                 image_id: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image_id: (Updatable) The OCID of the image used to boot the node.
        :param pulumi.Input[str] source_name: The user-friendly name of the entity corresponding to the OCID.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class NodePoolNodeSourceDetailsArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 source_type: pulumi.Input[str],
                 boot_volume_size_in_gbs: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image_id: (Updatable) The OCID of the image used to boot the node.
        :param pulumi.Input[str] source_type: (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        :param pulumi.Input[str] boot_volume_size_in_gbs: (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "source_type", source_type)
        if boot_volume_size_in_gbs is not None:
            pulumi.set(__self__, "boot_volume_size_in_gbs", boot_volume_size_in_gbs)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")

    @boot_volume_size_in_gbs.setter
    def boot_volume_size_in_gbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_volume_size_in_gbs", value)


@pulumi.input_type
class VirtualNodePoolInitialVirtualNodeLabelArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) The key of the pair.
        :param pulumi.Input[str] value: (Updatable) The value of the pair.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VirtualNodePoolPlacementConfigurationArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 fault_domains: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] availability_domain: (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: (Updatable) The fault domain of this virtual node.
        :param pulumi.Input[str] subnet_id: (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "fault_domains", fault_domains)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class VirtualNodePoolPodConfigurationArgs:
    def __init__(__self__, *,
                 shape: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] shape: (Updatable) Shape of the pods.
        :param pulumi.Input[str] subnet_id: (Updatable) The regional subnet where pods' VNIC will be placed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        (Updatable) Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)


@pulumi.input_type
class VirtualNodePoolTaintArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] effect: (Updatable) The effect of the pair.
        :param pulumi.Input[str] key: (Updatable) The key of the pair.
        :param pulumi.Input[str] value: (Updatable) The value of the pair.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VirtualNodePoolVirtualNodeTagsArgs:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class GetAddonOptionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the addon and it would be unique.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the addon and it would be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetAddonsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetClusterWorkloadMappingsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetClustersFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetNodePoolsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetPodShapesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetVirtualNodePoolsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetWorkRequestErrorsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetWorkRequestLogEntriesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetWorkRequestsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


