# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPublicIpPoolsResult',
    'AwaitableGetPublicIpPoolsResult',
    'get_public_ip_pools',
    'get_public_ip_pools_output',
]

@pulumi.output_type
class GetPublicIpPoolsResult:
    """
    A collection of values returned by getPublicIpPools.
    """
    def __init__(__self__, byoip_range_id=None, compartment_id=None, display_name=None, filters=None, id=None, public_ip_pool_collections=None):
        if byoip_range_id and not isinstance(byoip_range_id, str):
            raise TypeError("Expected argument 'byoip_range_id' to be a str")
        pulumi.set(__self__, "byoip_range_id", byoip_range_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_ip_pool_collections and not isinstance(public_ip_pool_collections, list):
            raise TypeError("Expected argument 'public_ip_pool_collections' to be a list")
        pulumi.set(__self__, "public_ip_pool_collections", public_ip_pool_collections)

    @property
    @pulumi.getter(name="byoipRangeId")
    def byoip_range_id(self) -> Optional[str]:
        return pulumi.get(self, "byoip_range_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing this pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPublicIpPoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicIpPoolCollections")
    def public_ip_pool_collections(self) -> Sequence['outputs.GetPublicIpPoolsPublicIpPoolCollectionResult']:
        """
        The list of public_ip_pool_collection.
        """
        return pulumi.get(self, "public_ip_pool_collections")


class AwaitableGetPublicIpPoolsResult(GetPublicIpPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpPoolsResult(
            byoip_range_id=self.byoip_range_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            public_ip_pool_collections=self.public_ip_pool_collections)


def get_public_ip_pools(byoip_range_id: Optional[str] = None,
                        compartment_id: Optional[str] = None,
                        display_name: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetPublicIpPoolsFilterArgs']]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpPoolsResult:
    """
    This data source provides the list of Public Ip Pools in Oracle Cloud Infrastructure Core service.

    Lists the public IP pools in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_ip_pools = oci.Core.get_public_ip_pools(compartment_id=var["compartment_id"],
        byoip_range_id=oci_core_byoip_range["test_byoip_range"]["id"],
        display_name=var["public_ip_pool_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str byoip_range_id: A filter to return only resources that match the given BYOIP CIDR block.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    """
    __args__ = dict()
    __args__['byoipRangeId'] = byoip_range_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getPublicIpPools:getPublicIpPools', __args__, opts=opts, typ=GetPublicIpPoolsResult).value

    return AwaitableGetPublicIpPoolsResult(
        byoip_range_id=pulumi.get(__ret__, 'byoip_range_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        public_ip_pool_collections=pulumi.get(__ret__, 'public_ip_pool_collections'))


@_utilities.lift_output_func(get_public_ip_pools)
def get_public_ip_pools_output(byoip_range_id: Optional[pulumi.Input[Optional[str]]] = None,
                               compartment_id: Optional[pulumi.Input[str]] = None,
                               display_name: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPublicIpPoolsFilterArgs']]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicIpPoolsResult]:
    """
    This data source provides the list of Public Ip Pools in Oracle Cloud Infrastructure Core service.

    Lists the public IP pools in the specified compartment.
    You can filter the list using query parameters.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_public_ip_pools = oci.Core.get_public_ip_pools(compartment_id=var["compartment_id"],
        byoip_range_id=oci_core_byoip_range["test_byoip_range"]["id"],
        display_name=var["public_ip_pool_display_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str byoip_range_id: A filter to return only resources that match the given BYOIP CIDR block.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    """
    ...
