# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMaskingPoliciesMaskingColumnResult',
    'AwaitableGetMaskingPoliciesMaskingColumnResult',
    'get_masking_policies_masking_column',
    'get_masking_policies_masking_column_output',
]

@pulumi.output_type
class GetMaskingPoliciesMaskingColumnResult:
    """
    A collection of values returned by getMaskingPoliciesMaskingColumn.
    """
    def __init__(__self__, child_columns=None, column_name=None, data_type=None, id=None, is_masking_enabled=None, key=None, lifecycle_details=None, masking_column_group=None, masking_column_key=None, masking_formats=None, masking_policy_id=None, object=None, object_type=None, schema_name=None, sensitive_type_id=None, state=None, time_created=None, time_updated=None):
        if child_columns and not isinstance(child_columns, list):
            raise TypeError("Expected argument 'child_columns' to be a list")
        pulumi.set(__self__, "child_columns", child_columns)
        if column_name and not isinstance(column_name, str):
            raise TypeError("Expected argument 'column_name' to be a str")
        pulumi.set(__self__, "column_name", column_name)
        if data_type and not isinstance(data_type, str):
            raise TypeError("Expected argument 'data_type' to be a str")
        pulumi.set(__self__, "data_type", data_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_masking_enabled and not isinstance(is_masking_enabled, bool):
            raise TypeError("Expected argument 'is_masking_enabled' to be a bool")
        pulumi.set(__self__, "is_masking_enabled", is_masking_enabled)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if masking_column_group and not isinstance(masking_column_group, str):
            raise TypeError("Expected argument 'masking_column_group' to be a str")
        pulumi.set(__self__, "masking_column_group", masking_column_group)
        if masking_column_key and not isinstance(masking_column_key, str):
            raise TypeError("Expected argument 'masking_column_key' to be a str")
        pulumi.set(__self__, "masking_column_key", masking_column_key)
        if masking_formats and not isinstance(masking_formats, list):
            raise TypeError("Expected argument 'masking_formats' to be a list")
        pulumi.set(__self__, "masking_formats", masking_formats)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if object_type and not isinstance(object_type, str):
            raise TypeError("Expected argument 'object_type' to be a str")
        pulumi.set(__self__, "object_type", object_type)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)
        if sensitive_type_id and not isinstance(sensitive_type_id, str):
            raise TypeError("Expected argument 'sensitive_type_id' to be a str")
        pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="childColumns")
    def child_columns(self) -> Sequence[str]:
        """
        An array of child columns that are in referential relationship with the masking column.
        """
        return pulumi.get(self, "child_columns")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> str:
        """
        The name of the substitution column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        The data type of the masking column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isMaskingEnabled")
    def is_masking_enabled(self) -> bool:
        """
        Indicates whether data masking is enabled for the masking column.
        """
        return pulumi.get(self, "is_masking_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique key that identifies the masking column. It's numeric and unique within a masking policy.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the masking column.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maskingColumnGroup")
    def masking_column_group(self) -> str:
        """
        The group of the masking column. All the columns in a group are masked together to ensure  that the masked data across these columns continue to retain the same logical relationship.  For more details, check <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        """
        return pulumi.get(self, "masking_column_group")

    @property
    @pulumi.getter(name="maskingColumnKey")
    def masking_column_key(self) -> str:
        return pulumi.get(self, "masking_column_key")

    @property
    @pulumi.getter(name="maskingFormats")
    def masking_formats(self) -> Sequence['outputs.GetMaskingPoliciesMaskingColumnMaskingFormatResult']:
        """
        An array of masking formats assigned to the masking column.
        """
        return pulumi.get(self, "masking_formats")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> str:
        """
        The OCID of the masking policy that contains the masking column.
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The name of the object (table or editioning view) that contains the database column.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        The type of the object that contains the database column.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        The name of the schema that contains the database column.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> str:
        """
        The OCID of the sensitive type associated with the masking column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the masking column.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the masking column was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the masking column was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMaskingPoliciesMaskingColumnResult(GetMaskingPoliciesMaskingColumnResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingPoliciesMaskingColumnResult(
            child_columns=self.child_columns,
            column_name=self.column_name,
            data_type=self.data_type,
            id=self.id,
            is_masking_enabled=self.is_masking_enabled,
            key=self.key,
            lifecycle_details=self.lifecycle_details,
            masking_column_group=self.masking_column_group,
            masking_column_key=self.masking_column_key,
            masking_formats=self.masking_formats,
            masking_policy_id=self.masking_policy_id,
            object=self.object,
            object_type=self.object_type,
            schema_name=self.schema_name,
            sensitive_type_id=self.sensitive_type_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_masking_policies_masking_column(masking_column_key: Optional[str] = None,
                                        masking_policy_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingPoliciesMaskingColumnResult:
    """
    This data source provides details about a specific Masking Policies Masking Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking column.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policies_masking_column = oci.DataSafe.get_masking_policies_masking_column(masking_column_key=var["masking_policies_masking_column_masking_column_key"],
        masking_policy_id=oci_data_safe_masking_policy["test_masking_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str masking_column_key: The unique key that identifies the masking column. It's numeric and unique within a masking policy.
    :param str masking_policy_id: The OCID of the masking policy.
    """
    __args__ = dict()
    __args__['maskingColumnKey'] = masking_column_key
    __args__['maskingPolicyId'] = masking_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingPoliciesMaskingColumn:getMaskingPoliciesMaskingColumn', __args__, opts=opts, typ=GetMaskingPoliciesMaskingColumnResult).value

    return AwaitableGetMaskingPoliciesMaskingColumnResult(
        child_columns=pulumi.get(__ret__, 'child_columns'),
        column_name=pulumi.get(__ret__, 'column_name'),
        data_type=pulumi.get(__ret__, 'data_type'),
        id=pulumi.get(__ret__, 'id'),
        is_masking_enabled=pulumi.get(__ret__, 'is_masking_enabled'),
        key=pulumi.get(__ret__, 'key'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        masking_column_group=pulumi.get(__ret__, 'masking_column_group'),
        masking_column_key=pulumi.get(__ret__, 'masking_column_key'),
        masking_formats=pulumi.get(__ret__, 'masking_formats'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        object=pulumi.get(__ret__, 'object'),
        object_type=pulumi.get(__ret__, 'object_type'),
        schema_name=pulumi.get(__ret__, 'schema_name'),
        sensitive_type_id=pulumi.get(__ret__, 'sensitive_type_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_masking_policies_masking_column)
def get_masking_policies_masking_column_output(masking_column_key: Optional[pulumi.Input[str]] = None,
                                               masking_policy_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaskingPoliciesMaskingColumnResult]:
    """
    This data source provides details about a specific Masking Policies Masking Column resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking column.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policies_masking_column = oci.DataSafe.get_masking_policies_masking_column(masking_column_key=var["masking_policies_masking_column_masking_column_key"],
        masking_policy_id=oci_data_safe_masking_policy["test_masking_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str masking_column_key: The unique key that identifies the masking column. It's numeric and unique within a masking policy.
    :param str masking_policy_id: The OCID of the masking policy.
    """
    ...
