# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpensearchVersionResult',
    'AwaitableGetOpensearchVersionResult',
    'get_opensearch_version',
    'get_opensearch_version_output',
]

@pulumi.output_type
class GetOpensearchVersionResult:
    """
    A collection of values returned by getOpensearchVersion.
    """
    def __init__(__self__, compartment_id=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOpensearchVersionItemResult']:
        """
        A list of OpenSearch versions.
        """
        return pulumi.get(self, "items")


class AwaitableGetOpensearchVersionResult(GetOpensearchVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchVersionResult(
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items)


def get_opensearch_version(compartment_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchVersionResult:
    """
    This data source provides details about a specific Opensearch Version resource in Oracle Cloud Infrastructure Opensearch service.

    Lists the supported Opensearch versions

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment
    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    ```
    <!--End PulumiCodeChooser -->

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_version = oci.Opensearch.get_opensearch_version(compartment_id=var["compartment_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opensearch/getOpensearchVersion:getOpensearchVersion', __args__, opts=opts, typ=GetOpensearchVersionResult).value

    return AwaitableGetOpensearchVersionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_opensearch_version)
def get_opensearch_version_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpensearchVersionResult]:
    """
    This data source provides details about a specific Opensearch Version resource in Oracle Cloud Infrastructure Opensearch service.

    Lists the supported Opensearch versions

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment
    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    ```
    <!--End PulumiCodeChooser -->

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_version = oci.Opensearch.get_opensearch_version(compartment_id=var["compartment_id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    ...
