"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import IMessage, SampleSizes
from zospy.api._ZOSAPI.Common import IMetadata, ZemaxColor, ZemaxOpacity
from zospy.api._ZOSAPI.Editors import (
    DirectionOfRayTravel,
    IEditor,
    IEditorCell,
    IEditorRow,
    ReflectTransmitCode,
    SampleSides,
    Samplings,
)

__all__ = (
    "ApertureShapes",
    "ArrayMode",
    "BirefringentMode",
    "BirefringentReflections",
    "DetectorDataType",
    "DetectorShowAsType",
    "DiffractionSplitType",
    "DiffractiveFaceChoices",
    "DrawingResolutionType",
    "EfficiencySpectrumType",
    "EndCapOptions",
    "FaceIsType",
    "HologramTypes",
    "IFaceData",
    "IImportanceSamplingSettings",
    "IIMS_Birefringent",
    "IIMS_GRIN",
    "IIMS_Isotropic",
    "IIndexModelSettings",
    "INCECADData",
    "INCECoatingPerformanceData",
    "INCECoatingPerformanceFaceData",
    "INCECoatScatterData",
    "INCECoatScatterFaceData",
    "INCEDiffractionData",
    "INCEDrawData",
    "INCEIndexData",
    "INCERow",
    "INCEScatterToData",
    "INCESourcesData",
    "INCETypeData",
    "INCEVolumePhysicsData",
    "INonSeqEditor",
    "InterpolateChoices",
    "IObject",
    "IObjectAnnularAsphericLens",
    "IObjectAnnularAxialLens",
    "IObjectAnnularVolume",
    "IObjectAnnulus",
    "IObjectArray",
    "IObjectArrayRing",
    "IObjectAsphericSurface",
    "IObjectAsphericSurface2",
    "IObjectAxiconSurface",
    "IObjectBiconicLens",
    "IObjectBiconicSurface",
    "IObjectBiconicZernike",
    "IObjectBiconicZernikeSurface",
    "IObjectBinary1",
    "IObjectBinary2",
    "IObjectBinary2A",
    "IObjectBoolean",
    "IObjectBooleanNative",
    "IObjectCADAssemblyAutodeskInventor",
    "IObjectCADAssemblyCreoParametric",
    "IObjectCADAssemblySolidWorks",
    "IObjectCADPartAutodeskInventor",
    "IObjectCADPartCreoParametric",
    "IObjectCADPartSolidWorks",
    "IObjectCADPartSTEPIGESSAT",
    "IObjectCADPartSTL",
    "IObjectCADPartZPD",
    "IObjectCompoundLens",
    "IObjectCone",
    "IObjectCPC",
    "IObjectCPCRectangular",
    "IObjectCylinder2Pipe",
    "IObjectCylinder2Volume",
    "IObjectCylinderPipe",
    "IObjectCylinderVolume",
    "IObjectDetector",
    "IObjectDetectorColor",
    "IObjectDetectorPolar",
    "IObjectDetectorRectangle",
    "IObjectDetectorSurface",
    "IObjectDetectorVolume",
    "IObjectDiffractionGrating",
    "IObjectDualBEFSurface",
    "IObjectEllipse",
    "IObjectEllipticalVolume",
    "IObjectEvenAsphereLens",
    "IObjectExtendedOddAsphereLens",
    "IObjectExtendedPolynomialLens",
    "IObjectExtendedPolynomialSurface",
    "IObjectExtruded",
    "IObjectFacetedSurface",
    "IObjectFreeformZ",
    "IObjectFresnel1",
    "IObjectFresnel2",
    "IObjectGridSagFrontBack",
    "IObjectGridSagLens",
    "IObjectGridSagSurface",
    "IObjectHexagonalLensletArray",
    "IObjectHologramLens",
    "IObjectHologramSurface",
    "IObjectJonesMatrix",
    "IObjectLensletArray1",
    "IObjectLensletArray2",
    "IObjectMEMS",
    "IObjectNullObject",
    "IObjectOddAsphereLens",
    "IObjectOffAxisMirror",
    "IObjectParaxialLens",
    "IObjectPolygon",
    "IObjectQTypeAsphereSurface",
    "IObjectRayRotator",
    "IObjectRectangle",
    "IObjectRectangularCorner",
    "IObjectRectangularPipe",
    "IObjectRectangularPipeGrating",
    "IObjectRectangularRoof",
    "IObjectRectangularTorusSurface",
    "IObjectRectangularTorusVolume",
    "IObjectRectangularVolume",
    "IObjectRectangularVolumeGrating",
    "IObjectReverseRadianceDetector",
    "IObjectReverseRadianceTarget",
    "IObjectScatteringSettings",
    "IObjectSlide",
    "IObjectSourceDiffractive",
    "IObjectSourceDiode",
    "IObjectSourceDLL",
    "IObjectSourceEllipse",
    "IObjectSourceEULUMDATFile",
    "IObjectSourceFilament",
    "IObjectSourceFile",
    "IObjectSourceGaussian",
    "IObjectSourceIESNAFile",
    "IObjectSourceImported",
    "IObjectSourceObject",
    "IObjectSourcePoint",
    "IObjectSourceRadial",
    "IObjectSourceRay",
    "IObjectSourceRectangle",
    "IObjectSources",
    "IObjectSourceTube",
    "IObjectSourceTwoAngle",
    "IObjectSourceVolumeCylindrical",
    "IObjectSourceVolumeElliptical",
    "IObjectSourceVolumeRectangular",
    "IObjectSphere",
    "IObjectStandardLens",
    "IObjectStandardSurface",
    "IObjectSwept",
    "IObjectTabulatedFactedRadial",
    "IObjectTabulatedFactedToroid",
    "IObjectTabulatedFrenselRadial",
    "IObjectToroidalHologram",
    "IObjectToroidalLens",
    "IObjectToroidalSurface",
    "IObjectToroidalSurfaceOddASphere",
    "IObjectTorusSurface",
    "IObjectTorusVolume",
    "IObjectTriangle",
    "IObjectTriangularCorner",
    "IObjectTypeSettings",
    "IObjectUserDefinedObject",
    "IObjectWolterSurface",
    "IObjectXYPolynomial",
    "IObjectZernikeSurface",
    "IOSS_ABg",
    "IOSS_ABgFile",
    "IOSS_BSDF",
    "IOSS_Gaussian",
    "IOSS_ISScatterCatalog",
    "IOSS_Lambertian",
    "IOSS_None",
    "IOSS_User",
    "ISCS_BlackBodySpectrum",
    "ISCS_CIE1931Chromaticity",
    "ISCS_CIE1931RGB",
    "ISCS_CIE1931Tristimulus",
    "ISCS_CIE1976",
    "ISCS_ColorTemperature",
    "ISCS_D65White",
    "ISCS_SpectrumFile",
    "ISCS_SystemWavelengths",
    "ISCS_UniformPowerSpectrum",
    "ISourceColorSettings",
    "IVMPS_AngleScattering",
    "IVMPS_DLLDefinedScattering",
    "IVMPS_PhotoluminscenceModel",
    "IVolumePhysicsModelSettings",
    "IVPMS_None",
    "NCEIndexType",
    "ObjectColumn",
    "ObjectScatteringTypes",
    "ObjectType",
    "OrderChoices",
    "PixelAddressing",
    "PolarDetectorDataType",
    "RaysIgnoreObjectType",
    "RayTraceModes",
    "ScatterToType",
    "ShapeChoices",
    "SourceBulkScatterMode",
    "SourceColorMode",
    "SourceSamplingMethod",
    "UniformAngleChoices",
    "VolumePhysicsModelType",
)

class ApertureShapes:
    Annular = 0
    Elliptical = 1
    Rectangular = 2
    CyliderWithRectangular = 3

class ArrayMode:
    # None = 0
    Rectangular = 1
    Circular = 2
    Hexapolar = 3
    Hexagonal = 4

class BirefringentMode:
    TraceOrdinayAndExtraordinary = 0
    TraceOrdinaryOnly = 1
    TraceExtraordinaryOnly = 2
    Waveplate = 3

class BirefringentReflections:
    TraceReflectedAndRefracted = 0
    TraceRefractedOnly = 1
    TraceReflectedOnly = 2

class DetectorDataType:
    Real = 0
    Imaginary = 1
    Amplitude = 2
    Power = 3

class DetectorShowAsType:
    GreyScaleFlux = 0
    InverseGreyScaleFlux = 1
    FalseColorFlux = 2
    InverseFalseColorFlux = 3
    GreyScaleIrradiance = 4
    InverseGreyScaleIrradiance = 5
    FalseColorIrradiance = 6
    InverseFalseColorIrradiance = 7

class DiffractionSplitType:
    DontSplitByOrder = 0
    SplitByTable = 1
    SplitByDLL = 2

class DiffractiveFaceChoices:
    FrontFace = 1
    BackFace = 2

class DrawingResolutionType:
    Standard = 0
    Medium = 1
    High = 2
    Presentation = 3
    Custom = 4

class EfficiencySpectrumType:
    QuantumYield = 0
    Excitation = 1

class EndCapOptions:
    # None = 0
    First = 1
    Second = 2
    Both = 3

class FaceIsType:
    ObjectDefault = 0
    Reflective = 1
    Absorbing = 2

class HologramTypes:
    Type_1 = 1
    Type_2 = 2

class IFaceData:
    @property
    def NumberOfFaces(self) -> int: ...
    @property
    def CurrentFace(self) -> int: ...
    @CurrentFace.setter
    def CurrentFace(self, value: int) -> None: ...
    @property
    def ConvertToGlobal(self) -> bool: ...
    @ConvertToGlobal.setter
    def ConvertToGlobal(self, value: bool) -> None: ...
    @property
    def NumberOfVertices(self) -> int: ...
    @property
    def Flux(self) -> float: ...
    @property
    def Irradiance(self) -> float: ...
    @property
    def AbsorbedFlux(self) -> float: ...
    @property
    def AbsorbedIrradiance(self) -> float: ...
    def FillData(
        self,
        size: int,
        X: list[float],
        Y: list[float],
        Z: list[float],
        XNorm: list[float],
        YNorm: list[float],
        ZNorm: list[float],
    ) -> bool: ...
    def GetVertex(self, vertexNumber: int) -> tuple[bool, float, float, float]: ...
    def GetVertexNormal(self, vertexNumber: int) -> tuple[bool, float, float, float]: ...

class IImportanceSamplingSettings:
    @property
    def Towards(self) -> int: ...
    @Towards.setter
    def Towards(self, value: int) -> None: ...
    @property
    def Size(self) -> float: ...
    @Size.setter
    def Size(self, value: float) -> None: ...
    @property
    def Limit(self) -> float: ...
    @Limit.setter
    def Limit(self, value: float) -> None: ...

class IIMS_Birefringent(IIndexModelSettings):
    @property
    def Mode(self) -> BirefringentMode: ...
    @Mode.setter
    def Mode(self, value: BirefringentMode) -> None: ...
    @property
    def Reflections(self) -> BirefringentReflections: ...
    @Reflections.setter
    def Reflections(self, value: BirefringentReflections) -> None: ...
    @property
    def Ax(self) -> float: ...
    @Ax.setter
    def Ax(self, value: float) -> None: ...
    @property
    def Ay(self) -> float: ...
    @Ay.setter
    def Ay(self, value: float) -> None: ...
    @property
    def Az(self) -> float: ...
    @Az.setter
    def Az(self, value: float) -> None: ...
    @property
    def AxisLength(self) -> float: ...
    @AxisLength.setter
    def AxisLength(self, value: float) -> None: ...

class IIMS_GRIN(IIndexModelSettings):
    @property
    def DLL(self) -> str: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @property
    def File(self) -> str: ...
    @File.setter
    def File(self, value: str) -> None: ...
    @property
    def UsesFile(self) -> bool: ...
    @property
    def MaximumStepSize(self) -> float: ...
    @MaximumStepSize.setter
    def MaximumStepSize(self, value: float) -> None: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetAvailableFiles(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class IIMS_Isotropic(IIndexModelSettings): ...

class IIndexModelSettings:
    @property
    def Type(self) -> NCEIndexType: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def _S_Isotropic(self) -> IIMS_Isotropic: ...
    @property
    def _S_Birefringent(self) -> IIMS_Birefringent: ...
    @property
    def _S_GRIN(self) -> IIMS_GRIN: ...

class INCECADData:
    @property
    def IsCADAvailable(self) -> bool: ...
    @property
    def HasChordTolerance(self) -> bool: ...
    @property
    def ChordTolerance(self) -> float: ...
    @ChordTolerance.setter
    def ChordTolerance(self, value: float) -> None: ...
    @property
    def HasSurfaceTolerance(self) -> bool: ...
    @property
    def SurfaceTolerance(self) -> int: ...
    @SurfaceTolerance.setter
    def SurfaceTolerance(self, value: int) -> None: ...
    @property
    def HasFaceParameters(self) -> bool: ...
    @property
    def FaceAngle(self) -> float: ...
    @FaceAngle.setter
    def FaceAngle(self, value: float) -> None: ...
    @property
    def FaceMode(self) -> int: ...
    @FaceMode.setter
    def FaceMode(self, value: int) -> None: ...
    @property
    def HasMergeSurfaces(self) -> bool: ...
    @property
    def MergeSurfaces(self) -> bool: ...
    @MergeSurfaces.setter
    def MergeSurfaces(self, value: bool) -> None: ...
    @property
    def HasFaceData(self) -> bool: ...
    @property
    def NumberOfSurfaces(self) -> int: ...
    @property
    def HasPartData(self) -> bool: ...
    @property
    def NumberOfConfigurations(self) -> int: ...
    @property
    def CurrentConfiguration(self) -> int: ...
    @CurrentConfiguration.setter
    def CurrentConfiguration(self, value: int) -> None: ...
    @property
    def NumberOfParts(self) -> int: ...
    @property
    def HasEdgeLength(self) -> bool: ...
    @property
    def MaxEdgeLength(self) -> float: ...
    @MaxEdgeLength.setter
    def MaxEdgeLength(self, value: float) -> None: ...
    @property
    def HasTraceMode(self) -> bool: ...
    @property
    def TraceMode(self) -> RayTraceModes: ...
    @TraceMode.setter
    def TraceMode(self, value: RayTraceModes) -> None: ...
    def GetConfigurationName(self, configIdx: int) -> str: ...
    def GetPartExposed(self, partIdx: int) -> bool: ...
    def GetPartName(self, partIdx: int) -> str: ...
    def GetSurfaceFace(self, surfaceIdx: int) -> int: ...
    def GetSurfaceName(self, surfaceIdx: int) -> str: ...
    def SetAllPartsExposed(self, exposed: bool) -> bool: ...
    def SetPartExposed(self, partIdx: int, exposed: bool) -> bool: ...
    def SetSurfaceFace(self, surfaceIdx: int, face: int) -> bool: ...
    def SetSurfaceName(self, surfaceIdx: int, name: str) -> bool: ...

class INCECoatingPerformanceData:
    @property
    def NumberOfFaces(self) -> int: ...
    def GetFaceData(self, faceNumber: int) -> INCECoatingPerformanceFaceData: ...

class INCECoatingPerformanceFaceData:
    @property
    def IsValid(self) -> bool: ...
    @property
    def FaceNumber(self) -> int: ...
    @property
    def Reflection(self) -> ICoatingParameter: ...
    @property
    def Transmission(self) -> ICoatingParameter: ...
    @property
    def Absorption(self) -> ICoatingParameter: ...
    @property
    def Diattenuation(self) -> ICoatingParameter: ...
    @property
    def Phase(self) -> ICoatingParameter: ...
    @property
    def Retardation(self) -> ICoatingParameter: ...
    def GetCoatingPerformance(self, AOI: float, wavelen: float, direction: DirectionOfRayTravel) -> None: ...

class INCECoatScatterData:
    @property
    def IsCoatScatterAvailable(self) -> bool: ...
    @property
    def NumberOfFaces(self) -> int: ...
    def CopySettingsToAllFaces(self, fromFace: INCECoatScatterFaceData) -> None: ...
    def GetFaceData(self, faceNumber: int) -> INCECoatScatterFaceData: ...

class INCECoatScatterFaceData:
    @property
    def IsValid(self) -> bool: ...
    @property
    def FaceNumber(self) -> int: ...
    @property
    def FaceName(self) -> str: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsCustom(self) -> bool: ...
    @property
    def IsProfile(self) -> bool: ...
    @property
    def ProfileName(self) -> str: ...
    @property
    def FaceIs(self) -> FaceIsType: ...
    @FaceIs.setter
    def FaceIs(self, value: FaceIsType) -> None: ...
    @property
    def Coating(self) -> str: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @property
    def CurrentScatterModel(self) -> ObjectScatteringTypes: ...
    @property
    def CurrentScatterModelSettings(self) -> IObjectScatteringSettings: ...
    @property
    def ThinWindowScattering(self) -> bool: ...
    @ThinWindowScattering.setter
    def ThinWindowScattering(self, value: bool) -> None: ...
    @property
    def NumberOfRays(self) -> int: ...
    @NumberOfRays.setter
    def NumberOfRays(self, value: int) -> None: ...
    def ChangeScatterModelSettings(self, newSettings: IObjectScatteringSettings) -> bool: ...
    def CopySettingsFrom(self, fromFace: INCECoatScatterFaceData) -> None: ...
    def CreateScatterModelSettings(self, type: ObjectScatteringTypes) -> IObjectScatteringSettings: ...
    def DeleteProfile(self) -> bool: ...
    def GetAvailableCoatings(self) -> list[str]: ...
    def GetAvailableProfiles(self) -> list[str]: ...
    def SaveProfile(self, profileName: str) -> bool: ...
    def UseCustomSettings(self) -> bool: ...
    def UseProfile(self, profile: str) -> bool: ...

class INCEDiffractionData:
    @property
    def IsDiffractionAvailable(self) -> bool: ...
    @property
    def Split(self) -> DiffractionSplitType: ...
    @Split.setter
    def Split(self, value: DiffractionSplitType) -> None: ...
    @property
    def DLL(self) -> str: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @property
    def IsDLLRequired(self) -> bool: ...
    @property
    def StartOrder(self) -> int: ...
    @StartOrder.setter
    def StartOrder(self, value: int) -> None: ...
    @property
    def StopOrder(self) -> int: ...
    @StopOrder.setter
    def StopOrder(self, value: int) -> None: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetReflectParameterName(self, paramIdx: int) -> str: ...
    def GetReflectParameterValue(self, paramIdx: int) -> float: ...
    def GetTransmitParamaterName(self, paramIdx: int) -> str: ...
    def GetTransmitParameterValue(self, paramIdx: int) -> float: ...
    def SetReflectParameterValue(self, paramIdx: int, Value: float) -> bool: ...
    def SetTransmitParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class INCEDrawData:
    @property
    def DoNotDrawObject(self) -> bool: ...
    @DoNotDrawObject.setter
    def DoNotDrawObject(self, value: bool) -> None: ...
    @property
    def DrawLocalAxis(self) -> bool: ...
    @DrawLocalAxis.setter
    def DrawLocalAxis(self, value: bool) -> None: ...
    @property
    def SupportsDrawingResolution(self) -> bool: ...
    @property
    def DrawingResolution(self) -> DrawingResolutionType: ...
    @DrawingResolution.setter
    def DrawingResolution(self, value: DrawingResolutionType) -> None: ...
    @property
    def NumSegments1(self) -> int: ...
    @NumSegments1.setter
    def NumSegments1(self, value: int) -> None: ...
    @property
    def Segments1Type(self) -> str: ...
    @property
    def NumSegments2(self) -> int: ...
    @NumSegments2.setter
    def NumSegments2(self, value: int) -> None: ...
    @property
    def Segments2Type(self) -> str: ...
    @property
    def ExportAsTriangles(self) -> bool: ...
    @ExportAsTriangles.setter
    def ExportAsTriangles(self, value: bool) -> None: ...
    @property
    def IncreaseResolutionOnShadedModelLayouts(self) -> bool: ...
    @IncreaseResolutionOnShadedModelLayouts.setter
    def IncreaseResolutionOnShadedModelLayouts(self, value: bool) -> None: ...
    @property
    def Opacity(self) -> ZemaxOpacity: ...
    @Opacity.setter
    def Opacity(self, value: ZemaxOpacity) -> None: ...
    @property
    def ObjectColor(self) -> ZemaxColor: ...
    @ObjectColor.setter
    def ObjectColor(self, value: ZemaxColor) -> None: ...
    def MakeAllObjectsDrawLikeThisOne(self) -> bool: ...

class INCEIndexData:
    @property
    def IsIndexAvailable(self) -> bool: ...
    @property
    def IndexType(self) -> NCEIndexType: ...
    @IndexType.setter
    def IndexType(self, value: NCEIndexType) -> None: ...
    @property
    def ModelSettings(self) -> IIndexModelSettings: ...

class INCERow(IEditorRow):
    @property
    def IsActive(self) -> bool: ...
    @property
    def ObjectNumber(self) -> int: ...
    @property
    def TypeName(self) -> str: ...
    @property
    def Type(self) -> ObjectType: ...
    @property
    def CurrentTypeSettings(self) -> IObjectTypeSettings: ...
    @property
    def ObjectData(self) -> IObject: ...
    @property
    def TypeData(self) -> INCETypeData: ...
    @property
    def DrawData(self) -> INCEDrawData: ...
    @property
    def SourcesData(self) -> INCESourcesData: ...
    @property
    def CoatScatterData(self) -> INCECoatScatterData: ...
    @property
    def ScatterToData(self) -> INCEScatterToData: ...
    @property
    def VolumePhysicsData(self) -> INCEVolumePhysicsData: ...
    @property
    def IndexData(self) -> INCEIndexData: ...
    @property
    def DiffractionData(self) -> INCEDiffractionData: ...
    @property
    def CADData(self) -> INCECADData: ...
    @property
    def Comment(self) -> str: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @property
    def CommentCell(self) -> IEditorCell: ...
    @property
    def RefObject(self) -> int: ...
    @RefObject.setter
    def RefObject(self, value: int) -> None: ...
    @property
    def RefObjectCell(self) -> IEditorCell: ...
    @property
    def InsideOf(self) -> int: ...
    @InsideOf.setter
    def InsideOf(self, value: int) -> None: ...
    @property
    def InsideOfCell(self) -> IEditorCell: ...
    @property
    def XPosition(self) -> float: ...
    @XPosition.setter
    def XPosition(self, value: float) -> None: ...
    @property
    def XPositionCell(self) -> IEditorCell: ...
    @property
    def YPosition(self) -> float: ...
    @YPosition.setter
    def YPosition(self, value: float) -> None: ...
    @property
    def YPositionCell(self) -> IEditorCell: ...
    @property
    def ZPosition(self) -> float: ...
    @ZPosition.setter
    def ZPosition(self, value: float) -> None: ...
    @property
    def ZPositionCell(self) -> IEditorCell: ...
    @property
    def TiltAboutX(self) -> float: ...
    @TiltAboutX.setter
    def TiltAboutX(self, value: float) -> None: ...
    @property
    def TiltAboutXCell(self) -> IEditorCell: ...
    @property
    def TiltAboutY(self) -> float: ...
    @TiltAboutY.setter
    def TiltAboutY(self, value: float) -> None: ...
    @property
    def TiltAboutYCell(self) -> IEditorCell: ...
    @property
    def TiltAboutZ(self) -> float: ...
    @TiltAboutZ.setter
    def TiltAboutZ(self, value: float) -> None: ...
    @property
    def TiltAboutZCell(self) -> IEditorCell: ...
    @property
    def Material(self) -> str: ...
    @Material.setter
    def Material(self, value: str) -> None: ...
    @property
    def MaterialCell(self) -> IEditorCell: ...
    @property
    def ObjectId(self) -> int: ...
    def AvailableObjectTypes(self) -> list[ObjectType]: ...
    def AvailableParameters(self) -> list[str]: ...
    def ChangeType(self, settings: IObjectTypeSettings) -> bool: ...
    def FindMaterialCatalog(self) -> str: ...
    def GetCoatingPerformanceData(self) -> INCECoatingPerformanceData: ...
    def GetFacetedObjectData(self) -> IFaceData: ...
    def GetMetadata(self) -> IMetadata: ...
    def GetObjectCell(self, Col: ObjectColumn) -> IEditorCell: ...
    def GetObjectTypeSettings(self, type: ObjectType) -> IObjectTypeSettings: ...

class INCEScatterToData:
    @property
    def IsScatterToAvailable(self) -> bool: ...
    @property
    def ScatterToMethod(self) -> ScatterToType: ...
    @ScatterToMethod.setter
    def ScatterToMethod(self, value: ScatterToType) -> None: ...
    @property
    def ScatterToList(self) -> str: ...
    @ScatterToList.setter
    def ScatterToList(self, value: str) -> None: ...
    @property
    def NumberOfRayData(self) -> int: ...
    def GetRayData(self, rayIndex: int) -> IImportanceSamplingSettings: ...
    def SetRayData(self, rayIndex: int, Data: IImportanceSamplingSettings) -> bool: ...

class INCESourcesData:
    @property
    def IsSourcesAvailable(self) -> bool: ...
    @property
    def RandomPolarization(self) -> bool: ...
    @RandomPolarization.setter
    def RandomPolarization(self, value: bool) -> None: ...
    @property
    def InitialPhaseDeg(self) -> float: ...
    @InitialPhaseDeg.setter
    def InitialPhaseDeg(self, value: float) -> None: ...
    @property
    def CoherenceLength(self) -> float: ...
    @CoherenceLength.setter
    def CoherenceLength(self, value: float) -> None: ...
    @property
    def Jx(self) -> float: ...
    @Jx.setter
    def Jx(self, value: float) -> None: ...
    @property
    def Jy(self) -> float: ...
    @Jy.setter
    def Jy(self, value: float) -> None: ...
    @property
    def XPhase(self) -> float: ...
    @XPhase.setter
    def XPhase(self, value: float) -> None: ...
    @property
    def YPhase(self) -> float: ...
    @YPhase.setter
    def YPhase(self, value: float) -> None: ...
    @property
    def ReverseRays(self) -> bool: ...
    @ReverseRays.setter
    def ReverseRays(self, value: bool) -> None: ...
    @property
    def PrePropagation(self) -> float: ...
    @PrePropagation.setter
    def PrePropagation(self, value: float) -> None: ...
    @property
    def BulkScatter(self) -> SourceBulkScatterMode: ...
    @BulkScatter.setter
    def BulkScatter(self, value: SourceBulkScatterMode) -> None: ...
    @property
    def SamplingMethod(self) -> SourceSamplingMethod: ...
    @SamplingMethod.setter
    def SamplingMethod(self, value: SourceSamplingMethod) -> None: ...
    @property
    def ArrayType(self) -> ArrayMode: ...
    @ArrayType.setter
    def ArrayType(self, value: ArrayMode) -> None: ...
    @property
    def ArrayNumberX(self) -> int: ...
    @ArrayNumberX.setter
    def ArrayNumberX(self, value: int) -> None: ...
    @property
    def ArrayNumberY(self) -> int: ...
    @ArrayNumberY.setter
    def ArrayNumberY(self, value: int) -> None: ...
    @property
    def ArraySpacingX(self) -> float: ...
    @ArraySpacingX.setter
    def ArraySpacingX(self, value: float) -> None: ...
    @property
    def ArraySpacingY(self) -> float: ...
    @ArraySpacingY.setter
    def ArraySpacingY(self, value: float) -> None: ...
    @property
    def ArrayNumber(self) -> int: ...
    @ArrayNumber.setter
    def ArrayNumber(self, value: int) -> None: ...
    @property
    def ArrayRadius(self) -> float: ...
    @ArrayRadius.setter
    def ArrayRadius(self, value: float) -> None: ...
    @property
    def ArrayRings(self) -> int: ...
    @ArrayRings.setter
    def ArrayRings(self, value: int) -> None: ...
    @property
    def ArraySpacing(self) -> float: ...
    @ArraySpacing.setter
    def ArraySpacing(self, value: float) -> None: ...
    @property
    def SourceColor(self) -> SourceColorMode: ...
    @SourceColor.setter
    def SourceColor(self, value: SourceColorMode) -> None: ...
    @property
    def SourceColorSettings(self) -> ISourceColorSettings: ...

class INCETypeData:
    @property
    def AreUDASettingsAvailable(self) -> bool: ...
    @property
    def UserDefinedAperture(self) -> bool: ...
    @UserDefinedAperture.setter
    def UserDefinedAperture(self, value: bool) -> None: ...
    @property
    def UDAScale(self) -> float: ...
    @UDAScale.setter
    def UDAScale(self, value: float) -> None: ...
    @property
    def UDAFile(self) -> str: ...
    @UDAFile.setter
    def UDAFile(self, value: str) -> None: ...
    @property
    def RowColor(self) -> ZemaxColor: ...
    @RowColor.setter
    def RowColor(self, value: ZemaxColor) -> None: ...
    @property
    def UseGlobalXYZRotationOrder(self) -> bool: ...
    @UseGlobalXYZRotationOrder.setter
    def UseGlobalXYZRotationOrder(self, value: bool) -> None: ...
    @property
    def ConvertImportedFilesToZOF(self) -> bool: ...
    @ConvertImportedFilesToZOF.setter
    def ConvertImportedFilesToZOF(self, value: bool) -> None: ...
    @property
    def ConsiderObjects(self) -> str: ...
    @ConsiderObjects.setter
    def ConsiderObjects(self, value: str) -> None: ...
    @property
    def IgnoreObjects(self) -> str: ...
    @IgnoreObjects.setter
    def IgnoreObjects(self, value: str) -> None: ...
    @property
    def RaysIgnoreObject(self) -> RaysIgnoreObjectType: ...
    @RaysIgnoreObject.setter
    def RaysIgnoreObject(self, value: RaysIgnoreObjectType) -> None: ...
    @property
    def UseConsiderIgnoreWhenSplitting(self) -> bool: ...
    @UseConsiderIgnoreWhenSplitting.setter
    def UseConsiderIgnoreWhenSplitting(self, value: bool) -> None: ...
    @property
    def FastRayTrace(self) -> bool: ...
    @FastRayTrace.setter
    def FastRayTrace(self, value: bool) -> None: ...
    @property
    def UseFastApproximateRayTrace(self) -> bool: ...
    @UseFastApproximateRayTrace.setter
    def UseFastApproximateRayTrace(self, value: bool) -> None: ...
    @property
    def ObjectIsADetector(self) -> bool: ...
    @ObjectIsADetector.setter
    def ObjectIsADetector(self, value: bool) -> None: ...
    @property
    def DetectorShowAs(self) -> DetectorShowAsType: ...
    @DetectorShowAs.setter
    def DetectorShowAs(self, value: DetectorShowAsType) -> None: ...
    @property
    def UsePixelInterpolation(self) -> bool: ...
    @UsePixelInterpolation.setter
    def UsePixelInterpolation(self, value: bool) -> None: ...
    @property
    def NormalizeCoherentPower(self) -> bool: ...
    @NormalizeCoherentPower.setter
    def NormalizeCoherentPower(self, value: bool) -> None: ...
    @property
    def RecordSpectralData(self) -> bool: ...
    @RecordSpectralData.setter
    def RecordSpectralData(self, value: bool) -> None: ...
    @property
    def NumberOfSpectralData(self) -> int: ...
    @NumberOfSpectralData.setter
    def NumberOfSpectralData(self, value: int) -> None: ...
    @property
    def SpectralDataMinWave(self) -> float: ...
    @SpectralDataMinWave.setter
    def SpectralDataMinWave(self, value: float) -> None: ...
    @property
    def SpectralDataMaxWave(self) -> float: ...
    @SpectralDataMaxWave.setter
    def SpectralDataMaxWave(self, value: float) -> None: ...
    @property
    def RecordPixelSpectralData(self) -> bool: ...
    @RecordPixelSpectralData.setter
    def RecordPixelSpectralData(self, value: bool) -> None: ...
    def GetAvailableUDAFiles(self) -> list[str]: ...
    def GetUDAFileFullPath(self) -> str: ...

class INCEVolumePhysicsData:
    @property
    def IsVolumePhysicsAvailable(self) -> bool: ...
    @property
    def Model(self) -> VolumePhysicsModelType: ...
    @Model.setter
    def Model(self, value: VolumePhysicsModelType) -> None: ...
    @property
    def ModelSettings(self) -> IVolumePhysicsModelSettings: ...
    @property
    def WavelengthShift(self) -> str: ...
    @WavelengthShift.setter
    def WavelengthShift(self, value: str) -> None: ...

class INonSeqEditor(IEditor):
    @property
    def RowToObjectOffset(self) -> int: ...
    @property
    def ActiveSurface(self) -> int: ...
    @property
    def NumberOfObjects(self) -> int: ...
    @property
    def FirstColumn(self) -> ObjectColumn: ...
    @property
    def LastColumn(self) -> ObjectColumn: ...
    def AddObject(self) -> INCERow: ...
    def AllAvailableObjectNames(self) -> list[str]: ...
    def AvailableDetectorNames(self) -> list[str]: ...
    def AvailableObjectNames(self) -> list[str]: ...
    def AvailableSourceNames(self) -> list[str]: ...
    def CopyObjects(self, fromObjectNumber: int, NumberOfObjects: int, toObjectNumber: int) -> int: ...
    def CopyObjectsFrom(
        self, fromEditor: INonSeqEditor, fromObjectNumber: int, NumberOfObjects: int, toObjectNumber: int
    ) -> int: ...
    def GetAllCoherentData(
        self, ObjectNumber: int, Data: DetectorDataType, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllCoherentDataSafe(self, ObjectNumber: int, Data: DetectorDataType) -> list[list[float]]: ...
    def GetAllColorDetectorData(
        self, ObjectNumber: int, angleSpace: bool, Data: int, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllColorDetectorDataSafe(self, ObjectNumber: int, angleSpace: bool, Data: int) -> list[list[float]]: ...
    def GetAllDetectorData(self, ObjectNumber: int, Data: int, numPixels: int) -> tuple[bool, list[float]]: ...
    def GetAllDetectorDataSafe(self, ObjectNumber: int, Data: int) -> list[list[float]]: ...
    def GetAllPolarDetectorData(
        self, ObjectNumber: int, Data: PolarDetectorDataType, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllPolarDetectorDataSafe(self, ObjectNumber: int, Data: PolarDetectorDataType) -> list[list[float]]: ...
    def GetClosestGlass(self, ObjectNumber: int) -> str: ...
    def GetCoherentData(self, ObjectNumber: int, pixel: int, Data: DetectorDataType) -> tuple[bool, float]: ...
    def GetColorDetectorData(
        self, ObjectNumber: int, pixel: int, angleSpace: bool, Data: int, numIgnoredPixels: int, Wavelength: float
    ) -> tuple[bool, float]: ...
    def GetDetectorData(self, ObjectNumber: int, pixel: int, Data: int) -> tuple[bool, float]: ...
    def GetDetectorDimensions(self, ObjectNumber: int) -> tuple[bool, int, int]: ...
    def GetDetectorSize(self, ObjectNumber: int) -> int: ...
    def GetGlass(self, ObjectNumber: int) -> tuple[bool, str, float, float, float]: ...
    def GetId(self, objectNumber: int) -> int: ...
    def GetIndex(self, ObjectNumber: int, NumberOfWavelengths: int) -> tuple[int, list[float]]: ...
    def GetMatrix(
        self, ObjectNumber: int
    ) -> tuple[bool, float, float, float, float, float, float, float, float, float, float, float, float]: ...
    def GetObjectAt(self, ObjectNumber: int) -> INCERow: ...
    def GetPolarDetectorData(
        self, ObjectNumber: int, pixel: int, Data: PolarDetectorDataType
    ) -> tuple[bool, float]: ...
    def HideNCE(self) -> None: ...
    def InsertNewObjectAt(self, ObjectNumber: int) -> INCERow: ...
    def LoadDetector(self, ObjectNumber: int, fileName: str, appendData: bool) -> bool: ...
    def ModifyReferenceObjects(self, first: int, last: int, reference: int) -> IMessage: ...
    def NextNSCGroup(self) -> bool: ...
    def ObjectNameFromObjectType(self, objectType: ObjectType) -> str: ...
    def ObjectTypeFromObjectName(self, objectName: str) -> ObjectType: ...
    def PrevNSCGroup(self) -> bool: ...
    def ReloadAllObjects(self) -> None: ...
    def ReloadObject(self, ObjectNumber: int) -> None: ...
    def RemoveObjectAt(self, ObjectNumber: int) -> bool: ...
    def RemoveObjectsAt(self, ObjectNumber: int, numObjects: int) -> int: ...
    def ReplicateObject(
        self,
        ObjectNumber: int,
        NumX: int,
        NumY: int,
        NumZ: int,
        DeltaX: float,
        DeltaY: float,
        DeltaZ: float,
        AddPickupSolves: bool,
        RelativeReferences: bool,
    ) -> IMessage: ...
    def SaveDetector(self, ObjectNumber: int, fileName: str) -> bool: ...
    def SetActiveSurface(self, SurfaceNumber: int) -> bool: ...
    def ShowNCE(self) -> bool: ...

class InterpolateChoices:
    Bicubic = 0
    Linear = 1

class IObject:
    @property
    def Type(self) -> ObjectType: ...
    @property
    def Row(self) -> INCERow: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Id(self) -> int: ...

class IObjectAnnularAsphericLens(IObject):
    @property
    def MinFrontApertureCell(self) -> IEditorCell: ...
    @property
    def MaxFrontApertureCell(self) -> IEditorCell: ...
    @property
    def MinBackApertureCell(self) -> IEditorCell: ...
    @property
    def MaxBackApertureCell(self) -> IEditorCell: ...
    @property
    def ThkApertureCell(self) -> IEditorCell: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def MinFrontAperture(self) -> float: ...
    @MinFrontAperture.setter
    def MinFrontAperture(self, value: float) -> None: ...
    @property
    def MaxFrontAperture(self) -> float: ...
    @MaxFrontAperture.setter
    def MaxFrontAperture(self, value: float) -> None: ...
    @property
    def MinBackAperture(self) -> float: ...
    @MinBackAperture.setter
    def MinBackAperture(self, value: float) -> None: ...
    @property
    def MaxBackAperture(self) -> float: ...
    @MaxBackAperture.setter
    def MaxBackAperture(self, value: float) -> None: ...
    @property
    def ThkAperture(self) -> float: ...
    @ThkAperture.setter
    def ThkAperture(self, value: float) -> None: ...
    @property
    def RearRadius(self) -> float: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @property
    def RearConic(self) -> float: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RearRPower2(self) -> float: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @property
    def RearRPower4(self) -> float: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @property
    def RearRPower6(self) -> float: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @property
    def RearRPower8(self) -> float: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @property
    def RearRPower10(self) -> float: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @property
    def RearRPower12(self) -> float: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @property
    def RearRPower14(self) -> float: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @property
    def RearRPower16(self) -> float: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...
    @property
    def FrontRadius(self) -> float: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @property
    def FrontConic(self) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @property
    def FrontRPower2(self) -> float: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @property
    def FrontRPower4(self) -> float: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @property
    def FrontRPower6(self) -> float: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @property
    def FrontRPower8(self) -> float: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @property
    def FrontRPower10(self) -> float: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @property
    def FrontRPower12(self) -> float: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @property
    def FrontRPower14(self) -> float: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @property
    def FrontRPower16(self) -> float: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...

class IObjectAnnularAxialLens(IObject):
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def ApertureCell(self) -> IEditorCell: ...
    @property
    def RevolutionCell(self) -> IEditorCell: ...
    @property
    def DecenterCell(self) -> IEditorCell: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @property
    def FrontConic(self) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @property
    def RearRadius(self) -> float: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @property
    def RearConic(self) -> float: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Aperture(self) -> float: ...
    @Aperture.setter
    def Aperture(self, value: float) -> None: ...
    @property
    def Revolution(self) -> float: ...
    @Revolution.setter
    def Revolution(self, value: float) -> None: ...
    @property
    def Decenter(self) -> float: ...
    @Decenter.setter
    def Decenter(self, value: float) -> None: ...
    @property
    def FrontRPower2(self) -> float: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @property
    def FrontRPower4(self) -> float: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @property
    def FrontRPower6(self) -> float: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @property
    def FrontRPower8(self) -> float: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @property
    def FrontRPower10(self) -> float: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @property
    def FrontRPower12(self) -> float: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @property
    def FrontRPower14(self) -> float: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @property
    def FrontRPower16(self) -> float: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @property
    def RearRPower2(self) -> float: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @property
    def RearRPower4(self) -> float: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @property
    def RearRPower6(self) -> float: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @property
    def RearRPower8(self) -> float: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @property
    def RearRPower10(self) -> float: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @property
    def RearRPower12(self) -> float: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @property
    def RearRPower14(self) -> float: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @property
    def RearRPower16(self) -> float: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...

class IObjectAnnularVolume(IObject):
    @property
    def FrontXMinCell(self) -> IEditorCell: ...
    @property
    def FrontYMinCell(self) -> IEditorCell: ...
    @property
    def RearXMinCell(self) -> IEditorCell: ...
    @property
    def RearYMinCell(self) -> IEditorCell: ...
    @property
    def FrontXMaxCell(self) -> IEditorCell: ...
    @property
    def FrontYMaxCell(self) -> IEditorCell: ...
    @property
    def RearXMaxCell(self) -> IEditorCell: ...
    @property
    def RearYMaxCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def BackXAngleCell(self) -> IEditorCell: ...
    @property
    def BackYAngleCell(self) -> IEditorCell: ...
    @property
    def FrontXMin(self) -> float: ...
    @FrontXMin.setter
    def FrontXMin(self, value: float) -> None: ...
    @property
    def FrontYMin(self) -> float: ...
    @FrontYMin.setter
    def FrontYMin(self, value: float) -> None: ...
    @property
    def RearXMin(self) -> float: ...
    @RearXMin.setter
    def RearXMin(self, value: float) -> None: ...
    @property
    def RearYMin(self) -> float: ...
    @RearYMin.setter
    def RearYMin(self, value: float) -> None: ...
    @property
    def FrontXMax(self) -> float: ...
    @FrontXMax.setter
    def FrontXMax(self, value: float) -> None: ...
    @property
    def FrontYMax(self) -> float: ...
    @FrontYMax.setter
    def FrontYMax(self, value: float) -> None: ...
    @property
    def RearXMax(self) -> float: ...
    @RearXMax.setter
    def RearXMax(self, value: float) -> None: ...
    @property
    def RearYMax(self) -> float: ...
    @RearYMax.setter
    def RearYMax(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def FrontXAngle(self) -> float: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @property
    def FrontYAngle(self) -> float: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @property
    def BackXAngle(self) -> float: ...
    @BackXAngle.setter
    def BackXAngle(self, value: float) -> None: ...
    @property
    def BackYAngle(self) -> float: ...
    @BackYAngle.setter
    def BackYAngle(self, value: float) -> None: ...

class IObjectAnnulus(IObject):
    @property
    def MaxXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MaxYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MaxXHalfWidth(self) -> float: ...
    @MaxXHalfWidth.setter
    def MaxXHalfWidth(self, value: float) -> None: ...
    @property
    def MaxYHalfWidth(self) -> float: ...
    @MaxYHalfWidth.setter
    def MaxYHalfWidth(self, value: float) -> None: ...
    @property
    def MinXHalfWidth(self) -> float: ...
    @MinXHalfWidth.setter
    def MinXHalfWidth(self, value: float) -> None: ...
    @property
    def MinYHalfWidth(self) -> float: ...
    @MinYHalfWidth.setter
    def MinYHalfWidth(self, value: float) -> None: ...

class IObjectArray(IObject):
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def NumberXCell(self) -> IEditorCell: ...
    @property
    def NumberYCell(self) -> IEditorCell: ...
    @property
    def NumberZCell(self) -> IEditorCell: ...
    @property
    def Delta1XCell(self) -> IEditorCell: ...
    @property
    def Delta1YCell(self) -> IEditorCell: ...
    @property
    def Delta1ZCell(self) -> IEditorCell: ...
    @property
    def XminusXCell(self) -> IEditorCell: ...
    @property
    def XminusYCell(self) -> IEditorCell: ...
    @property
    def XminusZCell(self) -> IEditorCell: ...
    @property
    def YminusXCell(self) -> IEditorCell: ...
    @property
    def YminusYCell(self) -> IEditorCell: ...
    @property
    def YminusZCell(self) -> IEditorCell: ...
    @property
    def ZminusXCell(self) -> IEditorCell: ...
    @property
    def ZminusYCell(self) -> IEditorCell: ...
    @property
    def ZminusZCell(self) -> IEditorCell: ...
    @property
    def TiltXCell(self) -> IEditorCell: ...
    @property
    def TiltYCell(self) -> IEditorCell: ...
    @property
    def TiltZCell(self) -> IEditorCell: ...
    @property
    def DrawLimitCell(self) -> IEditorCell: ...
    @property
    def DrawBoundaryCell(self) -> IEditorCell: ...
    @property
    def Delta2XCell(self) -> IEditorCell: ...
    @property
    def Delta2YCell(self) -> IEditorCell: ...
    @property
    def Delta2ZCell(self) -> IEditorCell: ...
    @property
    def Delta3XCell(self) -> IEditorCell: ...
    @property
    def Delta3YCell(self) -> IEditorCell: ...
    @property
    def Delta3ZCell(self) -> IEditorCell: ...
    @property
    def Delta4XCell(self) -> IEditorCell: ...
    @property
    def Delta4YCell(self) -> IEditorCell: ...
    @property
    def Delta4ZCell(self) -> IEditorCell: ...
    @property
    def MaximumXCell(self) -> IEditorCell: ...
    @property
    def MaximumYCell(self) -> IEditorCell: ...
    @property
    def MaximumZCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @property
    def NumberX(self) -> int: ...
    @NumberX.setter
    def NumberX(self, value: int) -> None: ...
    @property
    def NumberY(self) -> int: ...
    @NumberY.setter
    def NumberY(self, value: int) -> None: ...
    @property
    def NumberZ(self) -> int: ...
    @NumberZ.setter
    def NumberZ(self, value: int) -> None: ...
    @property
    def Delta1X(self) -> float: ...
    @Delta1X.setter
    def Delta1X(self, value: float) -> None: ...
    @property
    def Delta1Y(self) -> float: ...
    @Delta1Y.setter
    def Delta1Y(self, value: float) -> None: ...
    @property
    def Delta1Z(self) -> float: ...
    @Delta1Z.setter
    def Delta1Z(self, value: float) -> None: ...
    @property
    def XminusX(self) -> float: ...
    @XminusX.setter
    def XminusX(self, value: float) -> None: ...
    @property
    def XminusY(self) -> float: ...
    @XminusY.setter
    def XminusY(self, value: float) -> None: ...
    @property
    def XminusZ(self) -> float: ...
    @XminusZ.setter
    def XminusZ(self, value: float) -> None: ...
    @property
    def YminusX(self) -> float: ...
    @YminusX.setter
    def YminusX(self, value: float) -> None: ...
    @property
    def YminusY(self) -> float: ...
    @YminusY.setter
    def YminusY(self, value: float) -> None: ...
    @property
    def YminusZ(self) -> float: ...
    @YminusZ.setter
    def YminusZ(self, value: float) -> None: ...
    @property
    def ZminusX(self) -> float: ...
    @ZminusX.setter
    def ZminusX(self, value: float) -> None: ...
    @property
    def ZminusY(self) -> float: ...
    @ZminusY.setter
    def ZminusY(self, value: float) -> None: ...
    @property
    def ZminusZ(self) -> float: ...
    @ZminusZ.setter
    def ZminusZ(self, value: float) -> None: ...
    @property
    def TiltX(self) -> float: ...
    @TiltX.setter
    def TiltX(self, value: float) -> None: ...
    @property
    def TiltY(self) -> float: ...
    @TiltY.setter
    def TiltY(self, value: float) -> None: ...
    @property
    def TiltZ(self) -> float: ...
    @TiltZ.setter
    def TiltZ(self, value: float) -> None: ...
    @property
    def DrawLimit(self) -> int: ...
    @DrawLimit.setter
    def DrawLimit(self, value: int) -> None: ...
    @property
    def DrawBoundary(self) -> int: ...
    @DrawBoundary.setter
    def DrawBoundary(self, value: int) -> None: ...
    @property
    def Delta2X(self) -> float: ...
    @Delta2X.setter
    def Delta2X(self, value: float) -> None: ...
    @property
    def Delta2Y(self) -> float: ...
    @Delta2Y.setter
    def Delta2Y(self, value: float) -> None: ...
    @property
    def Delta2Z(self) -> float: ...
    @Delta2Z.setter
    def Delta2Z(self, value: float) -> None: ...
    @property
    def Delta3X(self) -> float: ...
    @Delta3X.setter
    def Delta3X(self, value: float) -> None: ...
    @property
    def Delta3Y(self) -> float: ...
    @Delta3Y.setter
    def Delta3Y(self, value: float) -> None: ...
    @property
    def Delta3Z(self) -> float: ...
    @Delta3Z.setter
    def Delta3Z(self, value: float) -> None: ...
    @property
    def Delta4X(self) -> float: ...
    @Delta4X.setter
    def Delta4X(self, value: float) -> None: ...
    @property
    def Delta4Y(self) -> float: ...
    @Delta4Y.setter
    def Delta4Y(self, value: float) -> None: ...
    @property
    def Delta4Z(self) -> float: ...
    @Delta4Z.setter
    def Delta4Z(self, value: float) -> None: ...
    @property
    def MaximumX(self) -> float: ...
    @MaximumX.setter
    def MaximumX(self, value: float) -> None: ...
    @property
    def MaximumY(self) -> float: ...
    @MaximumY.setter
    def MaximumY(self, value: float) -> None: ...
    @property
    def MaximumZ(self) -> float: ...
    @MaximumZ.setter
    def MaximumZ(self, value: float) -> None: ...

class IObjectArrayRing(IObject):
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberOfElementsCell(self) -> IEditorCell: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def GammaCell(self) -> IEditorCell: ...
    @property
    def DeltaCell(self) -> IEditorCell: ...
    @property
    def EpsilonCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @property
    def Mode(self) -> int: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @property
    def NumberOfElements(self) -> int: ...
    @NumberOfElements.setter
    def NumberOfElements(self, value: int) -> None: ...
    @property
    def RadiusA(self) -> float: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @property
    def Alpha(self) -> float: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @property
    def Beta(self) -> float: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...
    @property
    def Gamma(self) -> float: ...
    @Gamma.setter
    def Gamma(self, value: float) -> None: ...
    @property
    def Delta(self) -> float: ...
    @Delta.setter
    def Delta(self, value: float) -> None: ...
    @property
    def Epsilon(self) -> float: ...
    @Epsilon.setter
    def Epsilon(self, value: float) -> None: ...

class IObjectAsphericSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectAsphericSurface2(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxXCell(self) -> IEditorCell: ...
    @property
    def MaxYCell(self) -> IEditorCell: ...
    @property
    def MinXCell(self) -> IEditorCell: ...
    @property
    def MinYCell(self) -> IEditorCell: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxX(self) -> float: ...
    @MaxX.setter
    def MaxX(self, value: float) -> None: ...
    @property
    def MaxY(self) -> float: ...
    @MaxY.setter
    def MaxY(self, value: float) -> None: ...
    @property
    def MinX(self) -> float: ...
    @MinX.setter
    def MinX(self, value: float) -> None: ...
    @property
    def MinY(self) -> float: ...
    @MinY.setter
    def MinY(self, value: float) -> None: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @property
    def IsRectangle(self) -> bool: ...
    @IsRectangle.setter
    def IsRectangle(self, value: bool) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectAxiconSurface(IObject):
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def CzCell(self) -> IEditorCell: ...
    @property
    def CyCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def Cz(self) -> float: ...
    @Cz.setter
    def Cz(self, value: float) -> None: ...
    @property
    def Cy(self) -> float: ...
    @Cy.setter
    def Cy(self, value: float) -> None: ...

class IObjectBiconicLens(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RX1Cell(self) -> IEditorCell: ...
    @property
    def RY1Cell(self) -> IEditorCell: ...
    @property
    def KX1Cell(self) -> IEditorCell: ...
    @property
    def KY1Cell(self) -> IEditorCell: ...
    @property
    def RX2Cell(self) -> IEditorCell: ...
    @property
    def RY2Cell(self) -> IEditorCell: ...
    @property
    def KX2Cell(self) -> IEditorCell: ...
    @property
    def KY2Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RX1(self) -> float: ...
    @RX1.setter
    def RX1(self, value: float) -> None: ...
    @property
    def RY1(self) -> float: ...
    @RY1.setter
    def RY1(self, value: float) -> None: ...
    @property
    def KX1(self) -> float: ...
    @KX1.setter
    def KX1(self, value: float) -> None: ...
    @property
    def KY1(self) -> float: ...
    @KY1.setter
    def KY1(self, value: float) -> None: ...
    @property
    def RX2(self) -> float: ...
    @RX2.setter
    def RX2(self, value: float) -> None: ...
    @property
    def RY2(self) -> float: ...
    @RY2.setter
    def RY2(self, value: float) -> None: ...
    @property
    def KX2(self) -> float: ...
    @KX2.setter
    def KX2(self, value: float) -> None: ...
    @property
    def KY2(self) -> float: ...
    @KY2.setter
    def KY2(self, value: float) -> None: ...

class IObjectBiconicSurface(IObject):
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def RadiusYCell(self) -> IEditorCell: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def ConicYCell(self) -> IEditorCell: ...
    @property
    def MaxXApertureCell(self) -> IEditorCell: ...
    @property
    def MaxYApertureCell(self) -> IEditorCell: ...
    @property
    def MinXApertureCell(self) -> IEditorCell: ...
    @property
    def MinYApertureCell(self) -> IEditorCell: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def IsTopHyperCell(self) -> IEditorCell: ...
    @property
    def IsBottomHyperCell(self) -> IEditorCell: ...
    @property
    def RadiusX(self) -> float: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @property
    def RadiusY(self) -> float: ...
    @RadiusY.setter
    def RadiusY(self, value: float) -> None: ...
    @property
    def ConicX(self) -> float: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @property
    def ConicY(self) -> float: ...
    @ConicY.setter
    def ConicY(self, value: float) -> None: ...
    @property
    def MaxXAperture(self) -> float: ...
    @MaxXAperture.setter
    def MaxXAperture(self, value: float) -> None: ...
    @property
    def MaxYAperture(self) -> float: ...
    @MaxYAperture.setter
    def MaxYAperture(self, value: float) -> None: ...
    @property
    def MinXAperture(self) -> float: ...
    @MinXAperture.setter
    def MinXAperture(self, value: float) -> None: ...
    @property
    def MinYAperture(self) -> float: ...
    @MinYAperture.setter
    def MinYAperture(self, value: float) -> None: ...
    @property
    def IsRectangle(self) -> bool: ...
    @IsRectangle.setter
    def IsRectangle(self, value: bool) -> None: ...
    @property
    def IsTopHyper(self) -> bool: ...
    @IsTopHyper.setter
    def IsTopHyper(self, value: bool) -> None: ...
    @property
    def IsBottomHyper(self) -> bool: ...
    @IsBottomHyper.setter
    def IsBottomHyper(self, value: bool) -> None: ...

class IObjectBiconicZernike(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def RearRadiusXCell(self) -> IEditorCell: ...
    @property
    def RearRadiusYCell(self) -> IEditorCell: ...
    @property
    def RearConicXCell(self) -> IEditorCell: ...
    @property
    def RearConicYCell(self) -> IEditorCell: ...
    @property
    def NumberZernikeTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def FrontRadius(self) -> float: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @property
    def FrontConic(self) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @property
    def RearRadiusX(self) -> float: ...
    @RearRadiusX.setter
    def RearRadiusX(self, value: float) -> None: ...
    @property
    def RearRadiusY(self) -> float: ...
    @RearRadiusY.setter
    def RearRadiusY(self, value: float) -> None: ...
    @property
    def RearConicX(self) -> float: ...
    @RearConicX.setter
    def RearConicX(self, value: float) -> None: ...
    @property
    def RearConicY(self) -> float: ...
    @RearConicY.setter
    def RearConicY(self, value: float) -> None: ...
    @property
    def NumberZernikeTerms(self) -> int: ...
    @NumberZernikeTerms.setter
    def NumberZernikeTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetXPowerI(self, i: int) -> float: ...
    def GetYPowerI(self, i: int) -> float: ...
    def GetZPowerI(self, i: int) -> float: ...
    def SetXPowerI(self, i: int, v: float) -> None: ...
    def SetYPowerI(self, i: int, v: float) -> None: ...
    def SetZPowerI(self, i: int, v: float) -> None: ...
    def XPowerICell(self, i: int) -> IEditorCell: ...
    def YPowerICell(self, i: int) -> IEditorCell: ...
    def ZPowerICell(self, i: int) -> IEditorCell: ...

class IObjectBiconicZernikeSurface(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def RadiusYCell(self) -> IEditorCell: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def ConicYCell(self) -> IEditorCell: ...
    @property
    def BiconicDecXCell(self) -> IEditorCell: ...
    @property
    def BiconicDecYCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecXCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecYCell(self) -> IEditorCell: ...
    @property
    def NumberZernikeTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RadiusX(self) -> float: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @property
    def RadiusY(self) -> float: ...
    @RadiusY.setter
    def RadiusY(self, value: float) -> None: ...
    @property
    def ConicX(self) -> float: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @property
    def ConicY(self) -> float: ...
    @ConicY.setter
    def ConicY(self, value: float) -> None: ...
    @property
    def BiconicDecX(self) -> float: ...
    @BiconicDecX.setter
    def BiconicDecX(self, value: float) -> None: ...
    @property
    def BiconicDecY(self) -> float: ...
    @BiconicDecY.setter
    def BiconicDecY(self, value: float) -> None: ...
    @property
    def ZernikeDecX(self) -> float: ...
    @ZernikeDecX.setter
    def ZernikeDecX(self, value: float) -> None: ...
    @property
    def ZernikeDecY(self) -> float: ...
    @ZernikeDecY.setter
    def ZernikeDecY(self, value: float) -> None: ...
    @property
    def NumberZernikeTerms(self) -> int: ...
    @NumberZernikeTerms.setter
    def NumberZernikeTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetXPowerI(self, i: int) -> float: ...
    def GetYPowerI(self, i: int) -> float: ...
    def GetZPowerI(self, i: int) -> float: ...
    def SetXPowerI(self, i: int, v: float) -> None: ...
    def SetYPowerI(self, i: int, v: float) -> None: ...
    def SetZPowerI(self, i: int, v: float) -> None: ...
    def XPowerICell(self, i: int) -> IEditorCell: ...
    def YPowerICell(self, i: int) -> IEditorCell: ...
    def ZPowerICell(self, i: int) -> IEditorCell: ...

class IObjectBinary1(IObjectXYPolynomial, IObject):
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...

class IObjectBinary2(IObject):
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower18Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower20Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower22Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower24Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower26Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower28Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower30Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower32Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...
    @property
    def CoeffOnPPower2(self) -> float: ...
    @CoeffOnPPower2.setter
    def CoeffOnPPower2(self, value: float) -> None: ...
    @property
    def CoeffOnPPower4(self) -> float: ...
    @CoeffOnPPower4.setter
    def CoeffOnPPower4(self, value: float) -> None: ...
    @property
    def CoeffOnPPower6(self) -> float: ...
    @CoeffOnPPower6.setter
    def CoeffOnPPower6(self, value: float) -> None: ...
    @property
    def CoeffOnPPower8(self) -> float: ...
    @CoeffOnPPower8.setter
    def CoeffOnPPower8(self, value: float) -> None: ...
    @property
    def CoeffOnPPower10(self) -> float: ...
    @CoeffOnPPower10.setter
    def CoeffOnPPower10(self, value: float) -> None: ...
    @property
    def CoeffOnPPower12(self) -> float: ...
    @CoeffOnPPower12.setter
    def CoeffOnPPower12(self, value: float) -> None: ...
    @property
    def CoeffOnPPower14(self) -> float: ...
    @CoeffOnPPower14.setter
    def CoeffOnPPower14(self, value: float) -> None: ...
    @property
    def CoeffOnPPower16(self) -> float: ...
    @CoeffOnPPower16.setter
    def CoeffOnPPower16(self, value: float) -> None: ...
    @property
    def CoeffOnPPower18(self) -> float: ...
    @CoeffOnPPower18.setter
    def CoeffOnPPower18(self, value: float) -> None: ...
    @property
    def CoeffOnPPower20(self) -> float: ...
    @CoeffOnPPower20.setter
    def CoeffOnPPower20(self, value: float) -> None: ...
    @property
    def CoeffOnPPower22(self) -> float: ...
    @CoeffOnPPower22.setter
    def CoeffOnPPower22(self, value: float) -> None: ...
    @property
    def CoeffOnPPower24(self) -> float: ...
    @CoeffOnPPower24.setter
    def CoeffOnPPower24(self, value: float) -> None: ...
    @property
    def CoeffOnPPower26(self) -> float: ...
    @CoeffOnPPower26.setter
    def CoeffOnPPower26(self, value: float) -> None: ...
    @property
    def CoeffOnPPower28(self) -> float: ...
    @CoeffOnPPower28.setter
    def CoeffOnPPower28(self, value: float) -> None: ...
    @property
    def CoeffOnPPower30(self) -> float: ...
    @CoeffOnPPower30.setter
    def CoeffOnPPower30(self, value: float) -> None: ...
    @property
    def CoeffOnPPower32(self) -> float: ...
    @CoeffOnPPower32.setter
    def CoeffOnPPower32(self, value: float) -> None: ...

class IObjectBinary2A(IObject):
    @property
    def RadialApertureCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower18Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower20Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower22Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower24Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower18Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower20Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower22Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower24Cell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower18Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower20Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower22Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower24Cell(self) -> IEditorCell: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def RadialAperture(self) -> float: ...
    @RadialAperture.setter
    def RadialAperture(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower2(self) -> float: ...
    @Coeff1OnRPower2.setter
    def Coeff1OnRPower2(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower4(self) -> float: ...
    @Coeff1OnRPower4.setter
    def Coeff1OnRPower4(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower6(self) -> float: ...
    @Coeff1OnRPower6.setter
    def Coeff1OnRPower6(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower8(self) -> float: ...
    @Coeff1OnRPower8.setter
    def Coeff1OnRPower8(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower10(self) -> float: ...
    @Coeff1OnRPower10.setter
    def Coeff1OnRPower10(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower12(self) -> float: ...
    @Coeff1OnRPower12.setter
    def Coeff1OnRPower12(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower14(self) -> float: ...
    @Coeff1OnRPower14.setter
    def Coeff1OnRPower14(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower16(self) -> float: ...
    @Coeff1OnRPower16.setter
    def Coeff1OnRPower16(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower18(self) -> float: ...
    @Coeff1OnRPower18.setter
    def Coeff1OnRPower18(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower20(self) -> float: ...
    @Coeff1OnRPower20.setter
    def Coeff1OnRPower20(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower22(self) -> float: ...
    @Coeff1OnRPower22.setter
    def Coeff1OnRPower22(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower24(self) -> float: ...
    @Coeff1OnRPower24.setter
    def Coeff1OnRPower24(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower2(self) -> float: ...
    @Coeff2OnRPower2.setter
    def Coeff2OnRPower2(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower4(self) -> float: ...
    @Coeff2OnRPower4.setter
    def Coeff2OnRPower4(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower6(self) -> float: ...
    @Coeff2OnRPower6.setter
    def Coeff2OnRPower6(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower8(self) -> float: ...
    @Coeff2OnRPower8.setter
    def Coeff2OnRPower8(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower10(self) -> float: ...
    @Coeff2OnRPower10.setter
    def Coeff2OnRPower10(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower12(self) -> float: ...
    @Coeff2OnRPower12.setter
    def Coeff2OnRPower12(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower14(self) -> float: ...
    @Coeff2OnRPower14.setter
    def Coeff2OnRPower14(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower16(self) -> float: ...
    @Coeff2OnRPower16.setter
    def Coeff2OnRPower16(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower18(self) -> float: ...
    @Coeff2OnRPower18.setter
    def Coeff2OnRPower18(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower20(self) -> float: ...
    @Coeff2OnRPower20.setter
    def Coeff2OnRPower20(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower22(self) -> float: ...
    @Coeff2OnRPower22.setter
    def Coeff2OnRPower22(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower24(self) -> float: ...
    @Coeff2OnRPower24.setter
    def Coeff2OnRPower24(self, value: float) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...
    @property
    def CoeffOnPPower2(self) -> float: ...
    @CoeffOnPPower2.setter
    def CoeffOnPPower2(self, value: float) -> None: ...
    @property
    def CoeffOnPPower4(self) -> float: ...
    @CoeffOnPPower4.setter
    def CoeffOnPPower4(self, value: float) -> None: ...
    @property
    def CoeffOnPPower6(self) -> float: ...
    @CoeffOnPPower6.setter
    def CoeffOnPPower6(self, value: float) -> None: ...
    @property
    def CoeffOnPPower8(self) -> float: ...
    @CoeffOnPPower8.setter
    def CoeffOnPPower8(self, value: float) -> None: ...
    @property
    def CoeffOnPPower10(self) -> float: ...
    @CoeffOnPPower10.setter
    def CoeffOnPPower10(self, value: float) -> None: ...
    @property
    def CoeffOnPPower12(self) -> float: ...
    @CoeffOnPPower12.setter
    def CoeffOnPPower12(self, value: float) -> None: ...
    @property
    def CoeffOnPPower14(self) -> float: ...
    @CoeffOnPPower14.setter
    def CoeffOnPPower14(self, value: float) -> None: ...
    @property
    def CoeffOnPPower16(self) -> float: ...
    @CoeffOnPPower16.setter
    def CoeffOnPPower16(self, value: float) -> None: ...
    @property
    def CoeffOnPPower18(self) -> float: ...
    @CoeffOnPPower18.setter
    def CoeffOnPPower18(self, value: float) -> None: ...
    @property
    def CoeffOnPPower20(self) -> float: ...
    @CoeffOnPPower20.setter
    def CoeffOnPPower20(self, value: float) -> None: ...
    @property
    def CoeffOnPPower22(self) -> float: ...
    @CoeffOnPPower22.setter
    def CoeffOnPPower22(self, value: float) -> None: ...
    @property
    def CoeffOnPPower24(self) -> float: ...
    @CoeffOnPPower24.setter
    def CoeffOnPPower24(self, value: float) -> None: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...

class IObjectBoolean(IObject):
    @property
    def SplineCell(self) -> IEditorCell: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberXminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def NumberYminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def NumberZminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def ObjectACell(self) -> IEditorCell: ...
    @property
    def ObjectBCell(self) -> IEditorCell: ...
    @property
    def ObjectCCell(self) -> IEditorCell: ...
    @property
    def ObjectDCell(self) -> IEditorCell: ...
    @property
    def ObjectECell(self) -> IEditorCell: ...
    @property
    def ObjectFCell(self) -> IEditorCell: ...
    @property
    def ObjectGCell(self) -> IEditorCell: ...
    @property
    def ObjectHCell(self) -> IEditorCell: ...
    @property
    def ObjectICell(self) -> IEditorCell: ...
    @property
    def ObjectJCell(self) -> IEditorCell: ...
    @property
    def Spline(self) -> int: ...
    @Spline.setter
    def Spline(self, value: int) -> None: ...
    @property
    def Mode(self) -> int: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @property
    def NumberXminusVoxels(self) -> int: ...
    @NumberXminusVoxels.setter
    def NumberXminusVoxels(self, value: int) -> None: ...
    @property
    def NumberYminusVoxels(self) -> int: ...
    @NumberYminusVoxels.setter
    def NumberYminusVoxels(self, value: int) -> None: ...
    @property
    def NumberZminusVoxels(self) -> int: ...
    @NumberZminusVoxels.setter
    def NumberZminusVoxels(self, value: int) -> None: ...
    @property
    def ObjectA(self) -> int: ...
    @ObjectA.setter
    def ObjectA(self, value: int) -> None: ...
    @property
    def ObjectB(self) -> int: ...
    @ObjectB.setter
    def ObjectB(self, value: int) -> None: ...
    @property
    def ObjectC(self) -> int: ...
    @ObjectC.setter
    def ObjectC(self, value: int) -> None: ...
    @property
    def ObjectD(self) -> int: ...
    @ObjectD.setter
    def ObjectD(self, value: int) -> None: ...
    @property
    def ObjectE(self) -> int: ...
    @ObjectE.setter
    def ObjectE(self, value: int) -> None: ...
    @property
    def ObjectF(self) -> int: ...
    @ObjectF.setter
    def ObjectF(self, value: int) -> None: ...
    @property
    def ObjectG(self) -> int: ...
    @ObjectG.setter
    def ObjectG(self, value: int) -> None: ...
    @property
    def ObjectH(self) -> int: ...
    @ObjectH.setter
    def ObjectH(self, value: int) -> None: ...
    @property
    def ObjectI(self) -> int: ...
    @ObjectI.setter
    def ObjectI(self, value: int) -> None: ...
    @property
    def ObjectJ(self) -> int: ...
    @ObjectJ.setter
    def ObjectJ(self, value: int) -> None: ...

class IObjectBooleanNative(IObject):
    @property
    def SplineCell(self) -> IEditorCell: ...
    @property
    def ObjectACell(self) -> IEditorCell: ...
    @property
    def ObjectBCell(self) -> IEditorCell: ...
    @property
    def ObjectCCell(self) -> IEditorCell: ...
    @property
    def ObjectDCell(self) -> IEditorCell: ...
    @property
    def ObjectECell(self) -> IEditorCell: ...
    @property
    def ObjectFCell(self) -> IEditorCell: ...
    @property
    def ObjectGCell(self) -> IEditorCell: ...
    @property
    def ObjectHCell(self) -> IEditorCell: ...
    @property
    def ObjectICell(self) -> IEditorCell: ...
    @property
    def ObjectJCell(self) -> IEditorCell: ...
    @property
    def Spline(self) -> int: ...
    @Spline.setter
    def Spline(self, value: int) -> None: ...
    @property
    def ObjectA(self) -> int: ...
    @ObjectA.setter
    def ObjectA(self, value: int) -> None: ...
    @property
    def ObjectB(self) -> int: ...
    @ObjectB.setter
    def ObjectB(self, value: int) -> None: ...
    @property
    def ObjectC(self) -> int: ...
    @ObjectC.setter
    def ObjectC(self, value: int) -> None: ...
    @property
    def ObjectD(self) -> int: ...
    @ObjectD.setter
    def ObjectD(self, value: int) -> None: ...
    @property
    def ObjectE(self) -> int: ...
    @ObjectE.setter
    def ObjectE(self, value: int) -> None: ...
    @property
    def ObjectF(self) -> int: ...
    @ObjectF.setter
    def ObjectF(self, value: int) -> None: ...
    @property
    def ObjectG(self) -> int: ...
    @ObjectG.setter
    def ObjectG(self, value: int) -> None: ...
    @property
    def ObjectH(self) -> int: ...
    @ObjectH.setter
    def ObjectH(self, value: int) -> None: ...
    @property
    def ObjectI(self) -> int: ...
    @ObjectI.setter
    def ObjectI(self, value: int) -> None: ...
    @property
    def ObjectJ(self) -> int: ...
    @ObjectJ.setter
    def ObjectJ(self, value: int) -> None: ...

class IObjectCADAssemblyAutodeskInventor(IObject):
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @property
    def Explode(self) -> bool: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADAssemblyCreoParametric(IObject):
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @property
    def Explode(self) -> bool: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADAssemblySolidWorks(IObject):
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @property
    def Explode(self) -> bool: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADPartAutodeskInventor(IObject): ...
class IObjectCADPartCreoParametric(IObject): ...
class IObjectCADPartSolidWorks(IObject): ...

class IObjectCADPartSTEPIGESSAT(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberXMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def NumberYMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def NumberZMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def Mode(self) -> int: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @property
    def NumberXMinusVoxels(self) -> int: ...
    @NumberXMinusVoxels.setter
    def NumberXMinusVoxels(self, value: int) -> None: ...
    @property
    def NumberYMinusVoxels(self) -> int: ...
    @NumberYMinusVoxels.setter
    def NumberYMinusVoxels(self, value: int) -> None: ...
    @property
    def NumberZMinusVoxels(self) -> int: ...
    @NumberZMinusVoxels.setter
    def NumberZMinusVoxels(self, value: int) -> None: ...
    @property
    def Explode(self) -> bool: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADPartSTL(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectCADPartZPD(IObject): ...

class IObjectCompoundLens(IObject):
    @property
    def FrontSurfaceCell(self) -> IEditorCell: ...
    @property
    def RearSurfaceCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def MirrorSpaceCell(self) -> IEditorCell: ...
    @property
    def FrontClearRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontChipRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontEdgeRadiusCell(self) -> IEditorCell: ...
    @property
    def RearClearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearChipRadiusCell(self) -> IEditorCell: ...
    @property
    def RearEdgeRadiusCell(self) -> IEditorCell: ...
    @property
    def HalfWidthXCell(self) -> IEditorCell: ...
    @property
    def HalfWidthYCell(self) -> IEditorCell: ...
    @property
    def FrontClearHalfWidthXCell(self) -> IEditorCell: ...
    @property
    def FrontClearHalfWidthYCell(self) -> IEditorCell: ...
    @property
    def RearClearHalfWidthXCell(self) -> IEditorCell: ...
    @property
    def RearClearHalfWidthYCell(self) -> IEditorCell: ...
    @property
    def FrontSurface(self) -> int: ...
    @FrontSurface.setter
    def FrontSurface(self, value: int) -> None: ...
    @property
    def RearSurface(self) -> int: ...
    @RearSurface.setter
    def RearSurface(self, value: int) -> None: ...
    @property
    def IsRectangle(self) -> int: ...
    @IsRectangle.setter
    def IsRectangle(self, value: int) -> None: ...
    @property
    def MirrorSpace(self) -> int: ...
    @MirrorSpace.setter
    def MirrorSpace(self, value: int) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def FrontClearRadius(self) -> float: ...
    @FrontClearRadius.setter
    def FrontClearRadius(self, value: float) -> None: ...
    @property
    def FrontChipRadius(self) -> float: ...
    @FrontChipRadius.setter
    def FrontChipRadius(self, value: float) -> None: ...
    @property
    def FrontEdgeRadius(self) -> float: ...
    @FrontEdgeRadius.setter
    def FrontEdgeRadius(self, value: float) -> None: ...
    @property
    def RearClearRadius(self) -> float: ...
    @RearClearRadius.setter
    def RearClearRadius(self, value: float) -> None: ...
    @property
    def RearChipRadius(self) -> float: ...
    @RearChipRadius.setter
    def RearChipRadius(self, value: float) -> None: ...
    @property
    def RearEdgeRadius(self) -> float: ...
    @RearEdgeRadius.setter
    def RearEdgeRadius(self, value: float) -> None: ...
    @property
    def HalfWidthX(self) -> float: ...
    @HalfWidthX.setter
    def HalfWidthX(self, value: float) -> None: ...
    @property
    def HalfWidthY(self) -> float: ...
    @HalfWidthY.setter
    def HalfWidthY(self, value: float) -> None: ...
    @property
    def FrontClearHalfWidthX(self) -> float: ...
    @FrontClearHalfWidthX.setter
    def FrontClearHalfWidthX(self, value: float) -> None: ...
    @property
    def FrontClearHalfWidthY(self) -> float: ...
    @FrontClearHalfWidthY.setter
    def FrontClearHalfWidthY(self, value: float) -> None: ...
    @property
    def RearClearHalfWidthX(self) -> float: ...
    @RearClearHalfWidthX.setter
    def RearClearHalfWidthX(self, value: float) -> None: ...
    @property
    def RearClearHalfWidthY(self) -> float: ...
    @RearClearHalfWidthY.setter
    def RearClearHalfWidthY(self, value: float) -> None: ...

class IObjectCone(IObject):
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Z2(self) -> float: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...

class IObjectCPC(IObject):
    @property
    def RadialApertureCell(self) -> IEditorCell: ...
    @property
    def AngleDegreesCell(self) -> IEditorCell: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def VolumeIndexCell(self) -> IEditorCell: ...
    @property
    def RadialAperture(self) -> float: ...
    @RadialAperture.setter
    def RadialAperture(self, value: float) -> None: ...
    @property
    def AngleDegrees(self) -> float: ...
    @AngleDegrees.setter
    def AngleDegrees(self, value: float) -> None: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @property
    def VolumeIndex(self) -> float: ...
    @VolumeIndex.setter
    def VolumeIndex(self, value: float) -> None: ...

class IObjectCPCRectangular(IObject):
    @property
    def XApertureCell(self) -> IEditorCell: ...
    @property
    def XAngleDegreesCell(self) -> IEditorCell: ...
    @property
    def YApertureCell(self) -> IEditorCell: ...
    @property
    def YAngleDegreesCell(self) -> IEditorCell: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def VolumeIndexCell(self) -> IEditorCell: ...
    @property
    def XAperture(self) -> float: ...
    @XAperture.setter
    def XAperture(self, value: float) -> None: ...
    @property
    def XAngleDegrees(self) -> float: ...
    @XAngleDegrees.setter
    def XAngleDegrees(self, value: float) -> None: ...
    @property
    def YAperture(self) -> float: ...
    @YAperture.setter
    def YAperture(self, value: float) -> None: ...
    @property
    def YAngleDegrees(self) -> float: ...
    @YAngleDegrees.setter
    def YAngleDegrees(self, value: float) -> None: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @property
    def VolumeIndex(self) -> float: ...
    @VolumeIndex.setter
    def VolumeIndex(self, value: float) -> None: ...

class IObjectCylinder2Pipe(IObject):
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def FrontAngleAlongY(self) -> float: ...
    @FrontAngleAlongY.setter
    def FrontAngleAlongY(self, value: float) -> None: ...
    @property
    def BackAngleAlongY(self) -> float: ...
    @BackAngleAlongY.setter
    def BackAngleAlongY(self, value: float) -> None: ...
    @property
    def FrontAngleAlongX(self) -> float: ...
    @FrontAngleAlongX.setter
    def FrontAngleAlongX(self, value: float) -> None: ...
    @property
    def BackAngleAlongX(self) -> float: ...
    @BackAngleAlongX.setter
    def BackAngleAlongX(self, value: float) -> None: ...

class IObjectCylinder2Volume(IObject):
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def FrontAngleAlongY(self) -> float: ...
    @FrontAngleAlongY.setter
    def FrontAngleAlongY(self, value: float) -> None: ...
    @property
    def BackAngleAlongY(self) -> float: ...
    @BackAngleAlongY.setter
    def BackAngleAlongY(self, value: float) -> None: ...
    @property
    def FrontAngleAlongX(self) -> float: ...
    @FrontAngleAlongX.setter
    def FrontAngleAlongX(self, value: float) -> None: ...
    @property
    def BackAngleAlongX(self) -> float: ...
    @BackAngleAlongX.setter
    def BackAngleAlongX(self, value: float) -> None: ...

class IObjectCylinderPipe(IObject):
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def BackRCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def BackR(self) -> float: ...
    @BackR.setter
    def BackR(self, value: float) -> None: ...

class IObjectCylinderVolume(IObject):
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def BackRCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def BackR(self) -> float: ...
    @BackR.setter
    def BackR(self, value: float) -> None: ...

class IObjectDetector(IObject):
    def GetColCount(self) -> int: ...
    def GetDetectorDimensions(self) -> tuple[bool, int, int]: ...
    def GetDetectorSize(self) -> int: ...
    def GetRowCount(self) -> int: ...

class IObjectDetectorColor(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def SmoothingCell(self) -> IEditorCell: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def PlotScaleCell(self) -> IEditorCell: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def XAngleMinCell(self) -> IEditorCell: ...
    @property
    def XAngleMaxCell(self) -> IEditorCell: ...
    @property
    def YAngleMinCell(self) -> IEditorCell: ...
    @property
    def YAngleMaxCell(self) -> IEditorCell: ...
    @property
    def PolarizationCell(self) -> IEditorCell: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def NumberXPixels(self) -> int: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @property
    def NumberYPixels(self) -> int: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @property
    def DataType(self) -> int: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @property
    def Color(self) -> int: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @property
    def Smoothing(self) -> int: ...
    @Smoothing.setter
    def Smoothing(self, value: int) -> None: ...
    @property
    def Scale(self) -> int: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @property
    def FrontOnly(self) -> int: ...
    @FrontOnly.setter
    def FrontOnly(self, value: int) -> None: ...
    @property
    def XAngleMin(self) -> float: ...
    @XAngleMin.setter
    def XAngleMin(self, value: float) -> None: ...
    @property
    def XAngleMax(self) -> float: ...
    @XAngleMax.setter
    def XAngleMax(self, value: float) -> None: ...
    @property
    def YAngleMin(self) -> float: ...
    @YAngleMin.setter
    def YAngleMin(self, value: float) -> None: ...
    @property
    def YAngleMax(self) -> float: ...
    @YAngleMax.setter
    def YAngleMax(self, value: float) -> None: ...
    @property
    def Polarization(self) -> int: ...
    @Polarization.setter
    def Polarization(self, value: int) -> None: ...
    @property
    def Mirroring(self) -> int: ...
    @Mirroring.setter
    def Mirroring(self, value: int) -> None: ...

class IObjectDetectorPolar(IObject):
    @property
    def MaxAngleCell(self) -> IEditorCell: ...
    @property
    def RadialSizeCell(self) -> IEditorCell: ...
    @property
    def NumberPPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberAPixelsCell(self) -> IEditorCell: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def MaxAngle(self) -> float: ...
    @MaxAngle.setter
    def MaxAngle(self, value: float) -> None: ...
    @property
    def RadialSize(self) -> float: ...
    @RadialSize.setter
    def RadialSize(self, value: float) -> None: ...
    @property
    def NumberPPixels(self) -> int: ...
    @NumberPPixels.setter
    def NumberPPixels(self, value: int) -> None: ...
    @property
    def NumberAPixels(self) -> int: ...
    @NumberAPixels.setter
    def NumberAPixels(self, value: int) -> None: ...
    @property
    def Mirroring(self) -> bool: ...
    @Mirroring.setter
    def Mirroring(self, value: bool) -> None: ...

class IObjectDetectorRectangle(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def SmoothingCell(self) -> IEditorCell: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def PlotScaleCell(self) -> IEditorCell: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def PsfWaveNumberCell(self) -> IEditorCell: ...
    @property
    def XAngleMinCell(self) -> IEditorCell: ...
    @property
    def XAngleMaxCell(self) -> IEditorCell: ...
    @property
    def YAngleMinCell(self) -> IEditorCell: ...
    @property
    def YAngleMaxCell(self) -> IEditorCell: ...
    @property
    def PolarizationCell(self) -> IEditorCell: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def NumberXPixels(self) -> int: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @property
    def NumberYPixels(self) -> int: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @property
    def DataType(self) -> int: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @property
    def Color(self) -> int: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @property
    def Smoothing(self) -> int: ...
    @Smoothing.setter
    def Smoothing(self, value: int) -> None: ...
    @property
    def Scale(self) -> int: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    @property
    def PlotScale(self) -> float: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @property
    def FrontOnly(self) -> int: ...
    @FrontOnly.setter
    def FrontOnly(self, value: int) -> None: ...
    @property
    def PsfWaveNumber(self) -> int: ...
    @PsfWaveNumber.setter
    def PsfWaveNumber(self, value: int) -> None: ...
    @property
    def XAngleMin(self) -> float: ...
    @XAngleMin.setter
    def XAngleMin(self, value: float) -> None: ...
    @property
    def XAngleMax(self) -> float: ...
    @XAngleMax.setter
    def XAngleMax(self, value: float) -> None: ...
    @property
    def YAngleMin(self) -> float: ...
    @YAngleMin.setter
    def YAngleMin(self, value: float) -> None: ...
    @property
    def YAngleMax(self) -> float: ...
    @YAngleMax.setter
    def YAngleMax(self, value: float) -> None: ...
    @property
    def Polarization(self) -> int: ...
    @Polarization.setter
    def Polarization(self, value: int) -> None: ...
    @property
    def Mirroring(self) -> int: ...
    @Mirroring.setter
    def Mirroring(self, value: int) -> None: ...

class IObjectDetectorSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def NumberAZonesCell(self) -> IEditorCell: ...
    @property
    def NumberRZonesCell(self) -> IEditorCell: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def MaxScaleCell(self) -> IEditorCell: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @property
    def NumberAZones(self) -> int: ...
    @NumberAZones.setter
    def NumberAZones(self, value: int) -> None: ...
    @property
    def NumberRZones(self) -> int: ...
    @NumberRZones.setter
    def NumberRZones(self, value: int) -> None: ...
    @property
    def DataType(self) -> int: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @property
    def Color(self) -> int: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @property
    def Scale(self) -> int: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    @property
    def MaxScale(self) -> float: ...
    @MaxScale.setter
    def MaxScale(self, value: float) -> None: ...
    @property
    def FrontOnly(self) -> bool: ...
    @FrontOnly.setter
    def FrontOnly(self, value: bool) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectDetectorVolume(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberZPixelsCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...
    @property
    def NumberXPixels(self) -> int: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @property
    def NumberYPixels(self) -> int: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @property
    def NumberZPixels(self) -> int: ...
    @NumberZPixels.setter
    def NumberZPixels(self, value: int) -> None: ...

class IObjectDiffractionGrating(IObject):
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def LinesPerMicronCell(self) -> IEditorCell: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def FormulaCell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower1Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower4Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @property
    def LinesPerMicron(self) -> float: ...
    @LinesPerMicron.setter
    def LinesPerMicron(self, value: float) -> None: ...
    @property
    def DiffOrder(self) -> float: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @property
    def Formula(self) -> int: ...
    @Formula.setter
    def Formula(self, value: int) -> None: ...
    @property
    def CoeffOnYPower1(self) -> float: ...
    @CoeffOnYPower1.setter
    def CoeffOnYPower1(self, value: float) -> None: ...
    @property
    def CoeffOnYPower2(self) -> float: ...
    @CoeffOnYPower2.setter
    def CoeffOnYPower2(self, value: float) -> None: ...
    @property
    def CoeffOnYPower3(self) -> float: ...
    @CoeffOnYPower3.setter
    def CoeffOnYPower3(self, value: float) -> None: ...
    @property
    def CoeffOnYPower4(self) -> float: ...
    @CoeffOnYPower4.setter
    def CoeffOnYPower4(self, value: float) -> None: ...

class IObjectDualBEFSurface(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RXCell(self) -> IEditorCell: ...
    @property
    def RYCell(self) -> IEditorCell: ...
    @property
    def TXCell(self) -> IEditorCell: ...
    @property
    def TYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RX(self) -> float: ...
    @RX.setter
    def RX(self, value: float) -> None: ...
    @property
    def RY(self) -> float: ...
    @RY.setter
    def RY(self, value: float) -> None: ...
    @property
    def TX(self) -> float: ...
    @TX.setter
    def TX(self, value: float) -> None: ...
    @property
    def TY(self) -> float: ...
    @TY.setter
    def TY(self, value: float) -> None: ...

class IObjectEllipse(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectEllipticalVolume(IObject):
    @property
    def FrontXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def BackXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def BackYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def FrontXHalfWidth(self) -> float: ...
    @FrontXHalfWidth.setter
    def FrontXHalfWidth(self, value: float) -> None: ...
    @property
    def FrontYHalfWidth(self) -> float: ...
    @FrontYHalfWidth.setter
    def FrontYHalfWidth(self, value: float) -> None: ...
    @property
    def BackXHalfWidth(self) -> float: ...
    @BackXHalfWidth.setter
    def BackXHalfWidth(self, value: float) -> None: ...
    @property
    def BackYHalfWidth(self) -> float: ...
    @BackYHalfWidth.setter
    def BackYHalfWidth(self, value: float) -> None: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectEvenAsphereLens(IObject):
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower2(self) -> float: ...
    @Coeff1OnRPower2.setter
    def Coeff1OnRPower2(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower4(self) -> float: ...
    @Coeff1OnRPower4.setter
    def Coeff1OnRPower4(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower6(self) -> float: ...
    @Coeff1OnRPower6.setter
    def Coeff1OnRPower6(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower8(self) -> float: ...
    @Coeff1OnRPower8.setter
    def Coeff1OnRPower8(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower10(self) -> float: ...
    @Coeff1OnRPower10.setter
    def Coeff1OnRPower10(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower12(self) -> float: ...
    @Coeff1OnRPower12.setter
    def Coeff1OnRPower12(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower14(self) -> float: ...
    @Coeff1OnRPower14.setter
    def Coeff1OnRPower14(self, value: float) -> None: ...
    @property
    def Coeff1OnRPower16(self) -> float: ...
    @Coeff1OnRPower16.setter
    def Coeff1OnRPower16(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower2(self) -> float: ...
    @Coeff2OnRPower2.setter
    def Coeff2OnRPower2(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower4(self) -> float: ...
    @Coeff2OnRPower4.setter
    def Coeff2OnRPower4(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower6(self) -> float: ...
    @Coeff2OnRPower6.setter
    def Coeff2OnRPower6(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower8(self) -> float: ...
    @Coeff2OnRPower8.setter
    def Coeff2OnRPower8(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower10(self) -> float: ...
    @Coeff2OnRPower10.setter
    def Coeff2OnRPower10(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower12(self) -> float: ...
    @Coeff2OnRPower12.setter
    def Coeff2OnRPower12(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower14(self) -> float: ...
    @Coeff2OnRPower14.setter
    def Coeff2OnRPower14(self, value: float) -> None: ...
    @property
    def Coeff2OnRPower16(self) -> float: ...
    @Coeff2OnRPower16.setter
    def Coeff2OnRPower16(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...

class IObjectExtendedOddAsphereLens(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def FrontKCell(self) -> IEditorCell: ...
    @property
    def FrontNormRadCell(self) -> IEditorCell: ...
    @property
    def FrontNumTermsCell(self) -> IEditorCell: ...
    @property
    def RearRCell(self) -> IEditorCell: ...
    @property
    def RearKCell(self) -> IEditorCell: ...
    @property
    def RearNormRadCell(self) -> IEditorCell: ...
    @property
    def RearNumTermsCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def FrontR(self) -> float: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @property
    def FrontK(self) -> float: ...
    @FrontK.setter
    def FrontK(self, value: float) -> None: ...
    @property
    def FrontNormRad(self) -> float: ...
    @FrontNormRad.setter
    def FrontNormRad(self, value: float) -> None: ...
    @property
    def FrontNumTerms(self) -> int: ...
    @FrontNumTerms.setter
    def FrontNumTerms(self, value: int) -> None: ...
    @property
    def RearR(self) -> float: ...
    @RearR.setter
    def RearR(self, value: float) -> None: ...
    @property
    def RearK(self) -> float: ...
    @RearK.setter
    def RearK(self, value: float) -> None: ...
    @property
    def RearNormRad(self) -> float: ...
    @RearNormRad.setter
    def RearNormRad(self, value: float) -> None: ...
    @property
    def RearNumTerms(self) -> int: ...
    @RearNumTerms.setter
    def RearNumTerms(self, value: int) -> None: ...
    def GetFrontTerm(self, termNumber: int) -> float: ...
    def GetFrontTermCell(self, termNumber: int) -> IEditorCell: ...
    def GetRearTerm(self, termNumber: int) -> float: ...
    def GetRearTermCell(self, termNumber: int) -> IEditorCell: ...
    def SetFrontTerm(self, termNumber: int, Value: float) -> None: ...
    def SetRearTerm(self, termNumber: int, Value: float) -> None: ...

class IObjectExtendedPolynomialLens(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def FrontKCell(self) -> IEditorCell: ...
    @property
    def FrontNormRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontNumTermsCell(self) -> IEditorCell: ...
    @property
    def RearRCell(self) -> IEditorCell: ...
    @property
    def RearKCell(self) -> IEditorCell: ...
    @property
    def RearNormRadiusCell(self) -> IEditorCell: ...
    @property
    def RearNumTermsCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def FrontR(self) -> float: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @property
    def FrontK(self) -> float: ...
    @FrontK.setter
    def FrontK(self, value: float) -> None: ...
    @property
    def FrontNormRadius(self) -> float: ...
    @FrontNormRadius.setter
    def FrontNormRadius(self, value: float) -> None: ...
    @property
    def FrontNumTerms(self) -> int: ...
    @FrontNumTerms.setter
    def FrontNumTerms(self, value: int) -> None: ...
    @property
    def RearR(self) -> float: ...
    @RearR.setter
    def RearR(self, value: float) -> None: ...
    @property
    def RearK(self) -> float: ...
    @RearK.setter
    def RearK(self, value: float) -> None: ...
    @property
    def RearNormRadius(self) -> float: ...
    @RearNormRadius.setter
    def RearNormRadius(self, value: float) -> None: ...
    @property
    def RearNumTerms(self) -> int: ...
    @RearNumTerms.setter
    def RearNumTerms(self, value: int) -> None: ...
    def GetFrontTerm(self, termNumber: int) -> float: ...
    def GetFrontTermCell(self, termNumber: int) -> IEditorCell: ...
    def GetRearTerm(self, termNumber: int) -> float: ...
    def GetRearTermCell(self, termNumber: int) -> IEditorCell: ...
    def SetFrontTerm(self, termNumber: int, Value: float) -> None: ...
    def SetRearTerm(self, termNumber: int, Value: float) -> None: ...

class IObjectExtendedPolynomialSurface(IObjectXYPolynomial, IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def NormRadCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def NormRad(self) -> float: ...
    @NormRad.setter
    def NormRad(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...

class IObjectExtruded(IObject):
    @property
    def LengthZCell(self) -> IEditorCell: ...
    @property
    def FrontXScaleCell(self) -> IEditorCell: ...
    @property
    def FrontYScaleCell(self) -> IEditorCell: ...
    @property
    def RearXScaleCell(self) -> IEditorCell: ...
    @property
    def RearYScaleCell(self) -> IEditorCell: ...
    @property
    def RearXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearYDecenterCell(self) -> IEditorCell: ...
    @property
    def LengthZ(self) -> float: ...
    @LengthZ.setter
    def LengthZ(self, value: float) -> None: ...
    @property
    def FrontXScale(self) -> float: ...
    @FrontXScale.setter
    def FrontXScale(self, value: float) -> None: ...
    @property
    def FrontYScale(self) -> float: ...
    @FrontYScale.setter
    def FrontYScale(self, value: float) -> None: ...
    @property
    def RearXScale(self) -> float: ...
    @RearXScale.setter
    def RearXScale(self, value: float) -> None: ...
    @property
    def RearYScale(self) -> float: ...
    @RearYScale.setter
    def RearYScale(self, value: float) -> None: ...
    @property
    def RearXDecenter(self) -> float: ...
    @RearXDecenter.setter
    def RearXDecenter(self, value: float) -> None: ...
    @property
    def RearYDecenter(self) -> float: ...
    @RearYDecenter.setter
    def RearYDecenter(self, value: float) -> None: ...

class IObjectFacetedSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RadFacetsCell(self) -> IEditorCell: ...
    @property
    def XFacetsCell(self) -> IEditorCell: ...
    @property
    def AngFacetsCell(self) -> IEditorCell: ...
    @property
    def YFacetsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def Shape(self) -> ApertureShapes: ...
    @Shape.setter
    def Shape(self, value: ApertureShapes) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RadFacets(self) -> int: ...
    @RadFacets.setter
    def RadFacets(self, value: int) -> None: ...
    @property
    def XFacets(self) -> int: ...
    @XFacets.setter
    def XFacets(self, value: int) -> None: ...
    @property
    def AngFacets(self) -> int: ...
    @AngFacets.setter
    def AngFacets(self, value: int) -> None: ...
    @property
    def YFacets(self) -> int: ...
    @YFacets.setter
    def YFacets(self, value: int) -> None: ...

class IObjectFreeformZ(IObject):
    @property
    def NumberOfPointsCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def NumberOfPoints(self) -> int: ...
    @NumberOfPoints.setter
    def NumberOfPoints(self, value: int) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    def GetY(self, pointN: int) -> float: ...
    def GetYCell(self, pointN: int) -> IEditorCell: ...
    def GetZ(self, pointN: int) -> float: ...
    def GetZCell(self, pointN: int) -> IEditorCell: ...
    def SetY(self, pointN: int, Value: float) -> None: ...
    def SetZ(self, pointN: int, Value: float) -> None: ...

class IObjectFresnel1(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def PlusDepthPerMinusFreqCell(self) -> IEditorCell: ...
    @property
    def PitchDegCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def NumberOfSegements16Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def PlusDepthPerMinusFreq(self) -> float: ...
    @PlusDepthPerMinusFreq.setter
    def PlusDepthPerMinusFreq(self, value: float) -> None: ...
    @property
    def PitchDeg(self) -> float: ...
    @PitchDeg.setter
    def PitchDeg(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def NumberOfSegements(self) -> int: ...
    @NumberOfSegements.setter
    def NumberOfSegements(self, value: int) -> None: ...

class IObjectFresnel2(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def IsCylinderCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower16Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def IsCylinder(self) -> bool: ...
    @IsCylinder.setter
    def IsCylinder(self, value: bool) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @property
    def CoeffYPower10(self) -> float: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...
    @property
    def CoeffYPower16(self) -> float: ...
    @CoeffYPower16.setter
    def CoeffYPower16(self, value: float) -> None: ...

class IObjectGridSagFrontBack(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontInterpolateCell(self) -> IEditorCell: ...
    @property
    def FrontXDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontYDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontTiltXCell(self) -> IEditorCell: ...
    @property
    def FrontTiltYCell(self) -> IEditorCell: ...
    @property
    def FrontTiltZCell(self) -> IEditorCell: ...
    @property
    def FrontOrderCell(self) -> IEditorCell: ...
    @property
    def FrontGridXDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontGridYDecenterCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def RearInterpolateCell(self) -> IEditorCell: ...
    @property
    def RearXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearYDecenterCell(self) -> IEditorCell: ...
    @property
    def RearTiltXCell(self) -> IEditorCell: ...
    @property
    def RearTiltYCell(self) -> IEditorCell: ...
    @property
    def RearTiltZCell(self) -> IEditorCell: ...
    @property
    def RearOrderCell(self) -> IEditorCell: ...
    @property
    def RearGridXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearGridYDecenterCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def FrontRadius(self) -> float: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @property
    def FrontConic(self) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @property
    def FrontRPower2(self) -> float: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @property
    def FrontRPower4(self) -> float: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @property
    def FrontRPower6(self) -> float: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @property
    def FrontRPower8(self) -> float: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @property
    def FrontRPower10(self) -> float: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @property
    def FrontRPower12(self) -> float: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @property
    def FrontRPower14(self) -> float: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @property
    def FrontRPower16(self) -> float: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @property
    def FrontInterpolate(self) -> InterpolateChoices: ...
    @FrontInterpolate.setter
    def FrontInterpolate(self, value: InterpolateChoices) -> None: ...
    @property
    def FrontXDecenter(self) -> float: ...
    @FrontXDecenter.setter
    def FrontXDecenter(self, value: float) -> None: ...
    @property
    def FrontYDecenter(self) -> float: ...
    @FrontYDecenter.setter
    def FrontYDecenter(self, value: float) -> None: ...
    @property
    def FrontTiltX(self) -> float: ...
    @FrontTiltX.setter
    def FrontTiltX(self, value: float) -> None: ...
    @property
    def FrontTiltY(self) -> float: ...
    @FrontTiltY.setter
    def FrontTiltY(self, value: float) -> None: ...
    @property
    def FrontTiltZ(self) -> float: ...
    @FrontTiltZ.setter
    def FrontTiltZ(self, value: float) -> None: ...
    @property
    def FrontOrder(self) -> OrderChoices: ...
    @FrontOrder.setter
    def FrontOrder(self, value: OrderChoices) -> None: ...
    @property
    def FrontGridXDecenter(self) -> float: ...
    @FrontGridXDecenter.setter
    def FrontGridXDecenter(self, value: float) -> None: ...
    @property
    def FrontGridYDecenter(self) -> float: ...
    @FrontGridYDecenter.setter
    def FrontGridYDecenter(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RearRadius(self) -> float: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @property
    def RearConic(self) -> float: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @property
    def RearRPower2(self) -> float: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @property
    def RearRPower4(self) -> float: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @property
    def RearRPower6(self) -> float: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @property
    def RearRPower8(self) -> float: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @property
    def RearRPower10(self) -> float: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @property
    def RearRPower12(self) -> float: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @property
    def RearRPower14(self) -> float: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @property
    def RearRPower16(self) -> float: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...
    @property
    def RearInterpolate(self) -> InterpolateChoices: ...
    @RearInterpolate.setter
    def RearInterpolate(self, value: InterpolateChoices) -> None: ...
    @property
    def RearXDecenter(self) -> float: ...
    @RearXDecenter.setter
    def RearXDecenter(self, value: float) -> None: ...
    @property
    def RearYDecenter(self) -> float: ...
    @RearYDecenter.setter
    def RearYDecenter(self, value: float) -> None: ...
    @property
    def RearTiltX(self) -> float: ...
    @RearTiltX.setter
    def RearTiltX(self, value: float) -> None: ...
    @property
    def RearTiltY(self) -> float: ...
    @RearTiltY.setter
    def RearTiltY(self, value: float) -> None: ...
    @property
    def RearTiltZ(self) -> float: ...
    @RearTiltZ.setter
    def RearTiltZ(self, value: float) -> None: ...
    @property
    def RearOrder(self) -> OrderChoices: ...
    @RearOrder.setter
    def RearOrder(self, value: OrderChoices) -> None: ...
    @property
    def RearGridXDecenter(self) -> float: ...
    @RearGridXDecenter.setter
    def RearGridXDecenter(self, value: float) -> None: ...
    @property
    def RearGridYDecenter(self) -> float: ...
    @RearGridYDecenter.setter
    def RearGridYDecenter(self, value: float) -> None: ...

class IObjectGridSagLens(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def BackRadiusCell(self) -> IEditorCell: ...
    @property
    def BackConicCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def FrontRadius(self) -> float: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @property
    def FrontConic(self) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Interpolate(self) -> InterpolateChoices: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolateChoices) -> None: ...
    @property
    def BackRadius(self) -> float: ...
    @BackRadius.setter
    def BackRadius(self, value: float) -> None: ...
    @property
    def BackConic(self) -> float: ...
    @BackConic.setter
    def BackConic(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...

class IObjectGridSagSurface(IObject):
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def Interpolate(self) -> InterpolateChoices: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolateChoices) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...

class IObjectHexagonalLensletArray(IObject):
    @property
    def NumberOfColumnsCell(self) -> IEditorCell: ...
    @property
    def NumberOfRowsCell(self) -> IEditorCell: ...
    @property
    def DrawAsFlatCell(self) -> IEditorCell: ...
    @property
    def WidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def NumberOfColumns(self) -> int: ...
    @NumberOfColumns.setter
    def NumberOfColumns(self, value: int) -> None: ...
    @property
    def NumberOfRows(self) -> int: ...
    @NumberOfRows.setter
    def NumberOfRows(self, value: int) -> None: ...
    @property
    def DrawAsFlat(self) -> bool: ...
    @DrawAsFlat.setter
    def DrawAsFlat(self, value: bool) -> None: ...
    @property
    def Width(self) -> float: ...
    @Width.setter
    def Width(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...

class IObjectHologramLens(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def ConsWaveCell(self) -> IEditorCell: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def HologramType(self) -> int: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def ConsWave(self) -> float: ...
    @ConsWave.setter
    def ConsWave(self, value: float) -> None: ...
    @property
    def X1(self) -> float: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @property
    def Y1(self) -> float: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @property
    def Z1(self) -> float: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @property
    def X2(self) -> float: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @property
    def Y2(self) -> float: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @property
    def Z2(self) -> float: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class IObjectHologramSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def ConsWaveCell(self) -> IEditorCell: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @property
    def HologramType(self) -> int: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def ConsWave(self) -> float: ...
    @ConsWave.setter
    def ConsWave(self, value: float) -> None: ...
    @property
    def X1(self) -> float: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @property
    def Y1(self) -> float: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @property
    def Z1(self) -> float: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @property
    def X2(self) -> float: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @property
    def Y2(self) -> float: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @property
    def Z2(self) -> float: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectJonesMatrix(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ARealCell(self) -> IEditorCell: ...
    @property
    def AImagCell(self) -> IEditorCell: ...
    @property
    def BRealCell(self) -> IEditorCell: ...
    @property
    def BImagCell(self) -> IEditorCell: ...
    @property
    def CRealCell(self) -> IEditorCell: ...
    @property
    def CImagCell(self) -> IEditorCell: ...
    @property
    def DRealCell(self) -> IEditorCell: ...
    @property
    def DImagCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def AReal(self) -> float: ...
    @AReal.setter
    def AReal(self, value: float) -> None: ...
    @property
    def AImag(self) -> float: ...
    @AImag.setter
    def AImag(self, value: float) -> None: ...
    @property
    def BReal(self) -> float: ...
    @BReal.setter
    def BReal(self, value: float) -> None: ...
    @property
    def BImag(self) -> float: ...
    @BImag.setter
    def BImag(self, value: float) -> None: ...
    @property
    def CReal(self) -> float: ...
    @CReal.setter
    def CReal(self, value: float) -> None: ...
    @property
    def CImag(self) -> float: ...
    @CImag.setter
    def CImag(self, value: float) -> None: ...
    @property
    def DReal(self) -> float: ...
    @DReal.setter
    def DReal(self, value: float) -> None: ...
    @property
    def DImag(self) -> float: ...
    @DImag.setter
    def DImag(self, value: float) -> None: ...

class IObjectLensletArray1(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def IsToricCell(self) -> IEditorCell: ...
    @property
    def ToricRCell(self) -> IEditorCell: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower16Cell(self) -> IEditorCell: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def NumberInXCell(self) -> IEditorCell: ...
    @property
    def NumberInYCell(self) -> IEditorCell: ...
    @property
    def DiffractiveFaceCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def IsToric(self) -> bool: ...
    @IsToric.setter
    def IsToric(self, value: bool) -> None: ...
    @property
    def ToricR(self) -> float: ...
    @ToricR.setter
    def ToricR(self, value: float) -> None: ...
    @property
    def LinesPerUM(self) -> float: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @property
    def DiffOrder(self) -> float: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @property
    def CoeffYPower10(self) -> float: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...
    @property
    def CoeffYPower16(self) -> float: ...
    @CoeffYPower16.setter
    def CoeffYPower16(self, value: float) -> None: ...
    @property
    def DecenterX(self) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @property
    def DecenterY(self) -> float: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @property
    def NumberInX(self) -> int: ...
    @NumberInX.setter
    def NumberInX(self, value: int) -> None: ...
    @property
    def NumberInY(self) -> int: ...
    @NumberInY.setter
    def NumberInY(self, value: int) -> None: ...
    @property
    def DiffractiveFace(self) -> DiffractiveFaceChoices: ...
    @DiffractiveFace.setter
    def DiffractiveFace(self, value: DiffractiveFaceChoices) -> None: ...

class IObjectLensletArray2(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def NumberInXCell(self) -> IEditorCell: ...
    @property
    def NumberInYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def NumberInX(self) -> int: ...
    @NumberInX.setter
    def NumberInX(self, value: int) -> None: ...
    @property
    def NumberInY(self) -> int: ...
    @NumberInY.setter
    def NumberInY(self, value: int) -> None: ...

class IObjectMEMS(IObject):
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def XMinusWidthCell(self) -> IEditorCell: ...
    @property
    def YMinusWidthCell(self) -> IEditorCell: ...
    @property
    def Angle0Cell(self) -> IEditorCell: ...
    @property
    def Angle1Cell(self) -> IEditorCell: ...
    @property
    def Angle2Cell(self) -> IEditorCell: ...
    @property
    def RotationAngleCell(self) -> IEditorCell: ...
    @property
    def PFlagCell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @property
    def XMinusWidth(self) -> float: ...
    @XMinusWidth.setter
    def XMinusWidth(self, value: float) -> None: ...
    @property
    def YMinusWidth(self) -> float: ...
    @YMinusWidth.setter
    def YMinusWidth(self, value: float) -> None: ...
    @property
    def Angle0(self) -> float: ...
    @Angle0.setter
    def Angle0(self, value: float) -> None: ...
    @property
    def Angle1(self) -> float: ...
    @Angle1.setter
    def Angle1(self, value: float) -> None: ...
    @property
    def Angle2(self) -> float: ...
    @Angle2.setter
    def Angle2(self, value: float) -> None: ...
    @property
    def RotationAngle(self) -> float: ...
    @RotationAngle.setter
    def RotationAngle(self, value: float) -> None: ...
    @property
    def PFlag(self) -> PixelAddressing: ...
    @PFlag.setter
    def PFlag(self, value: PixelAddressing) -> None: ...
    def GetPixelAddressGroupN(self, n: int) -> int: ...
    def PixelAddressGroupNCell(self, n: int) -> IEditorCell: ...
    def SetPixelAddressGroupN(self, n: int, Value: int) -> None: ...

class IObjectNullObject(IObject): ...

class IObjectOddAsphereLens(IObject):
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff2RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff3RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff4RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff5RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff6RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff7RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff8RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff9RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff10RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff11RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff12RPower1Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff3RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff4RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff5RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff6RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff7RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff8RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff9RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff10RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff11RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff12RPower2Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Coeff1RPower1(self) -> float: ...
    @Coeff1RPower1.setter
    def Coeff1RPower1(self, value: float) -> None: ...
    @property
    def Coeff2RPower1(self) -> float: ...
    @Coeff2RPower1.setter
    def Coeff2RPower1(self, value: float) -> None: ...
    @property
    def Coeff3RPower1(self) -> float: ...
    @Coeff3RPower1.setter
    def Coeff3RPower1(self, value: float) -> None: ...
    @property
    def Coeff4RPower1(self) -> float: ...
    @Coeff4RPower1.setter
    def Coeff4RPower1(self, value: float) -> None: ...
    @property
    def Coeff5RPower1(self) -> float: ...
    @Coeff5RPower1.setter
    def Coeff5RPower1(self, value: float) -> None: ...
    @property
    def Coeff6RPower1(self) -> float: ...
    @Coeff6RPower1.setter
    def Coeff6RPower1(self, value: float) -> None: ...
    @property
    def Coeff7RPower1(self) -> float: ...
    @Coeff7RPower1.setter
    def Coeff7RPower1(self, value: float) -> None: ...
    @property
    def Coeff8RPower1(self) -> float: ...
    @Coeff8RPower1.setter
    def Coeff8RPower1(self, value: float) -> None: ...
    @property
    def Coeff9RPower1(self) -> float: ...
    @Coeff9RPower1.setter
    def Coeff9RPower1(self, value: float) -> None: ...
    @property
    def Coeff10RPower1(self) -> float: ...
    @Coeff10RPower1.setter
    def Coeff10RPower1(self, value: float) -> None: ...
    @property
    def Coeff11RPower1(self) -> float: ...
    @Coeff11RPower1.setter
    def Coeff11RPower1(self, value: float) -> None: ...
    @property
    def Coeff12RPower1(self) -> float: ...
    @Coeff12RPower1.setter
    def Coeff12RPower1(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Coeff1RPower2(self) -> float: ...
    @Coeff1RPower2.setter
    def Coeff1RPower2(self, value: float) -> None: ...
    @property
    def Coeff2RPower2(self) -> float: ...
    @Coeff2RPower2.setter
    def Coeff2RPower2(self, value: float) -> None: ...
    @property
    def Coeff3RPower2(self) -> float: ...
    @Coeff3RPower2.setter
    def Coeff3RPower2(self, value: float) -> None: ...
    @property
    def Coeff4RPower2(self) -> float: ...
    @Coeff4RPower2.setter
    def Coeff4RPower2(self, value: float) -> None: ...
    @property
    def Coeff5RPower2(self) -> float: ...
    @Coeff5RPower2.setter
    def Coeff5RPower2(self, value: float) -> None: ...
    @property
    def Coeff6RPower2(self) -> float: ...
    @Coeff6RPower2.setter
    def Coeff6RPower2(self, value: float) -> None: ...
    @property
    def Coeff7RPower2(self) -> float: ...
    @Coeff7RPower2.setter
    def Coeff7RPower2(self, value: float) -> None: ...
    @property
    def Coeff8RPower2(self) -> float: ...
    @Coeff8RPower2.setter
    def Coeff8RPower2(self, value: float) -> None: ...
    @property
    def Coeff9RPower2(self) -> float: ...
    @Coeff9RPower2.setter
    def Coeff9RPower2(self, value: float) -> None: ...
    @property
    def Coeff10RPower2(self) -> float: ...
    @Coeff10RPower2.setter
    def Coeff10RPower2(self, value: float) -> None: ...
    @property
    def Coeff11RPower2(self) -> float: ...
    @Coeff11RPower2.setter
    def Coeff11RPower2(self, value: float) -> None: ...
    @property
    def Coeff12RPower2(self) -> float: ...
    @Coeff12RPower2.setter
    def Coeff12RPower2(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...

class IObjectOffAxisMirror(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def OffAxisCell(self) -> IEditorCell: ...
    @property
    def NumTermsCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Shape(self) -> int: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def OffAxis(self) -> float: ...
    @OffAxis.setter
    def OffAxis(self, value: float) -> None: ...
    @property
    def NumTerms(self) -> int: ...
    @NumTerms.setter
    def NumTerms(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def GetCoefficient(self, term: int) -> float: ...
    def GetCoefficientCell(self, termNumber: int) -> IEditorCell: ...
    def SetCoefficient(self, term: int, value: float) -> None: ...

class IObjectParaxialLens(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XFocalLengthCell(self) -> IEditorCell: ...
    @property
    def YFocalLengthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def XFocalLength(self) -> float: ...
    @XFocalLength.setter
    def XFocalLength(self, value: float) -> None: ...
    @property
    def YFocalLength(self) -> float: ...
    @YFocalLength.setter
    def YFocalLength(self, value: float) -> None: ...

class IObjectPolygon(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectQTypeAsphereSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def ModelTypeCell(self) -> IEditorCell: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @property
    def ModelType(self) -> int: ...
    @ModelType.setter
    def ModelType(self, value: int) -> None: ...
    @property
    def NormRadius(self) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def CoefficientICell(self, i: int) -> IEditorCell: ...
    def GetCoefficientI(self, i: int) -> float: ...
    def SetCoefficientI(self, i: int, v: float) -> None: ...

class IObjectRayRotator(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RotateZCell(self) -> IEditorCell: ...
    @property
    def RotateYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RotateZ(self) -> float: ...
    @RotateZ.setter
    def RotateZ(self, value: float) -> None: ...
    @property
    def RotateY(self) -> float: ...
    @RotateY.setter
    def RotateY(self, value: float) -> None: ...

class IObjectRectangle(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectRectangularCorner(IObject):
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...

class IObjectRectangularPipe(IObject):
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @property
    def FrontXAngle(self) -> float: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @property
    def FrontYAngle(self) -> float: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @property
    def RearXAngle(self) -> float: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @property
    def RearYAngle(self) -> float: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...

class IObjectRectangularPipeGrating(IObject):
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @property
    def FrontXAngle(self) -> float: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @property
    def FrontYAngle(self) -> float: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @property
    def RearXAngle(self) -> float: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @property
    def RearYAngle(self) -> float: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @property
    def LinesPerUM(self) -> float: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @property
    def DiffOrder(self) -> float: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...

class IObjectRectangularRoof(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...

class IObjectRectangularTorusSurface(IObject):
    @property
    def OuterRCell(self) -> IEditorCell: ...
    @property
    def InnerRCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def OuterR(self) -> float: ...
    @OuterR.setter
    def OuterR(self, value: float) -> None: ...
    @property
    def InnerR(self) -> float: ...
    @InnerR.setter
    def InnerR(self, value: float) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectRectangularTorusVolume(IObject):
    @property
    def OuterRCell(self) -> IEditorCell: ...
    @property
    def InnerRCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def OuterR(self) -> float: ...
    @OuterR.setter
    def OuterR(self, value: float) -> None: ...
    @property
    def InnerR(self) -> float: ...
    @InnerR.setter
    def InnerR(self, value: float) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectRectangularVolume(IObject):
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @property
    def FrontXAngle(self) -> float: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @property
    def FrontYAngle(self) -> float: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @property
    def RearXAngle(self) -> float: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @property
    def RearYAngle(self) -> float: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...

class IObjectRectangularVolumeGrating(IObject):
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @property
    def FrontXAngle(self) -> float: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @property
    def FrontYAngle(self) -> float: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @property
    def RearXAngle(self) -> float: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @property
    def RearYAngle(self) -> float: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @property
    def LinesPerUM(self) -> float: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @property
    def DiffOrder(self) -> float: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...

class IObjectReverseRadianceDetector(IObject):
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfAPixelsCell(self) -> IEditorCell: ...
    @property
    def SourceObjectCell(self) -> IEditorCell: ...
    @property
    def TargetObjectCell(self) -> IEditorCell: ...
    @property
    def BoundaryObjectCell(self) -> IEditorCell: ...
    @property
    def ReverseRayColorCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> ShapeChoices: ...
    @Shape.setter
    def Shape(self, value: ShapeChoices) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @property
    def NumberOfPPixels(self) -> int: ...
    @NumberOfPPixels.setter
    def NumberOfPPixels(self, value: int) -> None: ...
    @property
    def NumberOfAPixels(self) -> int: ...
    @NumberOfAPixels.setter
    def NumberOfAPixels(self, value: int) -> None: ...
    @property
    def SourceObject(self) -> int: ...
    @SourceObject.setter
    def SourceObject(self, value: int) -> None: ...
    @property
    def TargetObject(self) -> int: ...
    @TargetObject.setter
    def TargetObject(self, value: int) -> None: ...
    @property
    def BoundaryObject(self) -> int: ...
    @BoundaryObject.setter
    def BoundaryObject(self, value: int) -> None: ...
    @property
    def ReverseRayColor(self) -> int: ...
    @ReverseRayColor.setter
    def ReverseRayColor(self, value: int) -> None: ...

class IObjectReverseRadianceTarget(IObject):
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfAPixelsCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> ShapeChoices: ...
    @Shape.setter
    def Shape(self, value: ShapeChoices) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @property
    def NumberOfPPixels(self) -> int: ...
    @NumberOfPPixels.setter
    def NumberOfPPixels(self, value: int) -> None: ...
    @property
    def NumberOfAPixels(self) -> int: ...
    @NumberOfAPixels.setter
    def NumberOfAPixels(self, value: int) -> None: ...

class IObjectScatteringSettings:
    @property
    def Type(self) -> ObjectScatteringTypes: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def _S_None(self) -> IOSS_None: ...
    @property
    def _S_Lambertian(self) -> IOSS_Lambertian: ...
    @property
    def _S_Gaussian(self) -> IOSS_Gaussian: ...
    @property
    def _S_ABg(self) -> IOSS_ABg: ...
    @property
    def _S_ABgFile(self) -> IOSS_ABgFile: ...
    @property
    def _S_BSDF(self) -> IOSS_BSDF: ...
    @property
    def _S_User(self) -> IOSS_User: ...
    @property
    def _S_ISScatterCatalog(self) -> IOSS_ISScatterCatalog: ...

class IObjectSlide(IObject):
    @property
    def XFullWidthCell(self) -> IEditorCell: ...
    @property
    def AspectRatioCell(self) -> IEditorCell: ...
    @property
    def XFullWidth(self) -> float: ...
    @XFullWidth.setter
    def XFullWidth(self, value: float) -> None: ...
    @property
    def AspectRatio(self) -> float: ...
    @AspectRatio.setter
    def AspectRatio(self, value: float) -> None: ...

class IObjectSourceDiffractive(IObjectSources, IObject):
    @property
    def SamplingCell(self) -> IEditorCell: ...
    @property
    def Sampling(self) -> SampleSizes: ...
    @Sampling.setter
    def Sampling(self, value: SampleSizes) -> None: ...

class IObjectSourceDiode(IObjectSources, IObject):
    @property
    def AstigmatismCell(self) -> IEditorCell: ...
    @property
    def XMinusDivergenceCell(self) -> IEditorCell: ...
    @property
    def XMinusSuperGaussCell(self) -> IEditorCell: ...
    @property
    def YMinusDivergenceCell(self) -> IEditorCell: ...
    @property
    def YMinusSuperGaussCell(self) -> IEditorCell: ...
    @property
    def NumberXCell(self) -> IEditorCell: ...
    @property
    def NumberYCell(self) -> IEditorCell: ...
    @property
    def DeltaXCell(self) -> IEditorCell: ...
    @property
    def DeltaYCell(self) -> IEditorCell: ...
    @property
    def XMinusWidthCell(self) -> IEditorCell: ...
    @property
    def XMinusSigmaCell(self) -> IEditorCell: ...
    @property
    def XMinusWidthHXCell(self) -> IEditorCell: ...
    @property
    def YMinusWidthCell(self) -> IEditorCell: ...
    @property
    def YMinusSigmaCell(self) -> IEditorCell: ...
    @property
    def YMinusWidthHYCell(self) -> IEditorCell: ...
    @property
    def Astigmatism(self) -> float: ...
    @Astigmatism.setter
    def Astigmatism(self, value: float) -> None: ...
    @property
    def XMinusDivergence(self) -> float: ...
    @XMinusDivergence.setter
    def XMinusDivergence(self, value: float) -> None: ...
    @property
    def XMinusSuperGauss(self) -> float: ...
    @XMinusSuperGauss.setter
    def XMinusSuperGauss(self, value: float) -> None: ...
    @property
    def YMinusDivergence(self) -> float: ...
    @YMinusDivergence.setter
    def YMinusDivergence(self, value: float) -> None: ...
    @property
    def YMinusSuperGauss(self) -> float: ...
    @YMinusSuperGauss.setter
    def YMinusSuperGauss(self, value: float) -> None: ...
    @property
    def NumberX(self) -> int: ...
    @NumberX.setter
    def NumberX(self, value: int) -> None: ...
    @property
    def NumberY(self) -> int: ...
    @NumberY.setter
    def NumberY(self, value: int) -> None: ...
    @property
    def DeltaX(self) -> float: ...
    @DeltaX.setter
    def DeltaX(self, value: float) -> None: ...
    @property
    def DeltaY(self) -> float: ...
    @DeltaY.setter
    def DeltaY(self, value: float) -> None: ...
    @property
    def XMinusWidth(self) -> float: ...
    @XMinusWidth.setter
    def XMinusWidth(self, value: float) -> None: ...
    @property
    def XMinusSigma(self) -> float: ...
    @XMinusSigma.setter
    def XMinusSigma(self, value: float) -> None: ...
    @property
    def XMinusWidthHX(self) -> float: ...
    @XMinusWidthHX.setter
    def XMinusWidthHX(self, value: float) -> None: ...
    @property
    def YMinusWidth(self) -> float: ...
    @YMinusWidth.setter
    def YMinusWidth(self, value: float) -> None: ...
    @property
    def YMinusSigma(self) -> float: ...
    @YMinusSigma.setter
    def YMinusSigma(self, value: float) -> None: ...
    @property
    def YMinusWidthHY(self) -> float: ...
    @YMinusWidthHY.setter
    def YMinusWidthHY(self, value: float) -> None: ...

class IObjectSourceDLL(IObjectSources, IObject): ...

class IObjectSourceEllipse(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def SourceDistanceCell(self) -> IEditorCell: ...
    @property
    def CosineExponentCell(self) -> IEditorCell: ...
    @property
    def GaussGXCell(self) -> IEditorCell: ...
    @property
    def GaussGYCell(self) -> IEditorCell: ...
    @property
    def SourceXCell(self) -> IEditorCell: ...
    @property
    def SourceYCell(self) -> IEditorCell: ...
    @property
    def MinXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def SourceDistance(self) -> float: ...
    @SourceDistance.setter
    def SourceDistance(self, value: float) -> None: ...
    @property
    def CosineExponent(self) -> float: ...
    @CosineExponent.setter
    def CosineExponent(self, value: float) -> None: ...
    @property
    def GaussGX(self) -> float: ...
    @GaussGX.setter
    def GaussGX(self, value: float) -> None: ...
    @property
    def GaussGY(self) -> float: ...
    @GaussGY.setter
    def GaussGY(self, value: float) -> None: ...
    @property
    def SourceX(self) -> float: ...
    @SourceX.setter
    def SourceX(self, value: float) -> None: ...
    @property
    def SourceY(self) -> float: ...
    @SourceY.setter
    def SourceY(self, value: float) -> None: ...
    @property
    def MinXHalfWidth(self) -> float: ...
    @MinXHalfWidth.setter
    def MinXHalfWidth(self, value: float) -> None: ...
    @property
    def MinYHalfWidth(self) -> float: ...
    @MinYHalfWidth.setter
    def MinYHalfWidth(self, value: float) -> None: ...

class IObjectSourceEULUMDATFile(IObjectSources, IObject):
    @property
    def LumensInFileCell(self) -> IEditorCell: ...
    @property
    def LumensInFile(self) -> float: ...
    @LumensInFile.setter
    def LumensInFile(self, value: float) -> None: ...

class IObjectSourceFilament(IObjectSources, IObject):
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def TurnsCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def RadiusA(self) -> float: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @property
    def Turns(self) -> float: ...
    @Turns.setter
    def Turns(self, value: float) -> None: ...

class IObjectSourceFile(IObjectSources, IObject):
    @property
    def RandomizeCell(self) -> IEditorCell: ...
    @property
    def Randomize(self) -> bool: ...
    @Randomize.setter
    def Randomize(self, value: bool) -> None: ...
    @property
    def SourceUnits(self) -> float: ...
    @property
    def MinWave(self) -> float: ...
    @property
    def MaxWave(self) -> float: ...

class IObjectSourceGaussian(IObjectSources, IObject):
    @property
    def BeamSizeCell(self) -> IEditorCell: ...
    @property
    def PositionCell(self) -> IEditorCell: ...
    @property
    def BeamSize(self) -> float: ...
    @BeamSize.setter
    def BeamSize(self, value: float) -> None: ...
    @property
    def Position(self) -> float: ...
    @Position.setter
    def Position(self, value: float) -> None: ...

class IObjectSourceIESNAFile(IObjectSources, IObject):
    @property
    def LumensInFileCell(self) -> IEditorCell: ...
    @property
    def LumensInFile(self) -> float: ...
    @LumensInFile.setter
    def LumensInFile(self, value: float) -> None: ...

class IObjectSourceImported(IObjectSources, IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def CosFactorCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def CosFactor(self) -> float: ...
    @CosFactor.setter
    def CosFactor(self, value: float) -> None: ...

class IObjectSourceObject(IObjectSources, IObject):
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def ChordTolCell(self) -> IEditorCell: ...
    @property
    def CosFactorCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @property
    def ChordTol(self) -> float: ...
    @ChordTol.setter
    def ChordTol(self, value: float) -> None: ...
    @property
    def CosFactor(self) -> float: ...
    @CosFactor.setter
    def CosFactor(self, value: float) -> None: ...

class IObjectSourcePoint(IObjectSources, IObject):
    @property
    def ConeAngleCell(self) -> IEditorCell: ...
    @property
    def ConeAngle(self) -> float: ...
    @ConeAngle.setter
    def ConeAngle(self, value: float) -> None: ...

class IObjectSourceRadial(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinAngleCell(self) -> IEditorCell: ...
    @property
    def MaxAngleCell(self) -> IEditorCell: ...
    @property
    def NumberOfPointsCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def MinAngle(self) -> float: ...
    @MinAngle.setter
    def MinAngle(self, value: float) -> None: ...
    @property
    def MaxAngle(self) -> float: ...
    @MaxAngle.setter
    def MaxAngle(self, value: float) -> None: ...
    @property
    def NumberOfPoints(self) -> int: ...
    @NumberOfPoints.setter
    def NumberOfPoints(self, value: int) -> None: ...
    def GetSubAngleI(self, i: int) -> float: ...
    def SetSubAngleI(self, i: int, v: float) -> None: ...
    def SubAngleICell(self, i: int) -> IEditorCell: ...

class IObjectSourceRay(IObjectSources, IObject):
    @property
    def XCosineCell(self) -> IEditorCell: ...
    @property
    def YCosineCell(self) -> IEditorCell: ...
    @property
    def ZCosineCell(self) -> IEditorCell: ...
    @property
    def RandomSeedCell(self) -> IEditorCell: ...
    @property
    def XCosine(self) -> float: ...
    @XCosine.setter
    def XCosine(self, value: float) -> None: ...
    @property
    def YCosine(self) -> float: ...
    @YCosine.setter
    def YCosine(self, value: float) -> None: ...
    @property
    def ZCosine(self) -> float: ...
    @ZCosine.setter
    def ZCosine(self, value: float) -> None: ...
    @property
    def RandomSeed(self) -> bool: ...
    @RandomSeed.setter
    def RandomSeed(self, value: bool) -> None: ...

class IObjectSourceRectangle(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def SourceDistanceCell(self) -> IEditorCell: ...
    @property
    def CosineExponentCell(self) -> IEditorCell: ...
    @property
    def GaussGXCell(self) -> IEditorCell: ...
    @property
    def GaussGYCell(self) -> IEditorCell: ...
    @property
    def SourceXCell(self) -> IEditorCell: ...
    @property
    def SourceYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def SourceDistance(self) -> float: ...
    @SourceDistance.setter
    def SourceDistance(self, value: float) -> None: ...
    @property
    def CosineExponent(self) -> float: ...
    @CosineExponent.setter
    def CosineExponent(self, value: float) -> None: ...
    @property
    def GaussGX(self) -> float: ...
    @GaussGX.setter
    def GaussGX(self, value: float) -> None: ...
    @property
    def GaussGY(self) -> float: ...
    @GaussGY.setter
    def GaussGY(self, value: float) -> None: ...
    @property
    def SourceX(self) -> float: ...
    @SourceX.setter
    def SourceX(self, value: float) -> None: ...
    @property
    def SourceY(self) -> float: ...
    @SourceY.setter
    def SourceY(self, value: float) -> None: ...

class IObjectSources(IObject):
    @property
    def NumberOfLayoutRaysCell(self) -> IEditorCell: ...
    @property
    def NumberOfAnalysisRaysCell(self) -> IEditorCell: ...
    @property
    def PowerCell(self) -> IEditorCell: ...
    @property
    def WaveNumberCell(self) -> IEditorCell: ...
    @property
    def ColorNumberCell(self) -> IEditorCell: ...
    @property
    def NumberOfLayoutRays(self) -> int: ...
    @NumberOfLayoutRays.setter
    def NumberOfLayoutRays(self, value: int) -> None: ...
    @property
    def NumberOfAnalysisRays(self) -> int: ...
    @NumberOfAnalysisRays.setter
    def NumberOfAnalysisRays(self, value: int) -> None: ...
    @property
    def Power(self) -> float: ...
    @Power.setter
    def Power(self, value: float) -> None: ...
    @property
    def WaveNumber(self) -> int: ...
    @WaveNumber.setter
    def WaveNumber(self, value: int) -> None: ...
    @property
    def ColorNumber(self) -> int: ...
    @ColorNumber.setter
    def ColorNumber(self, value: int) -> None: ...

class IObjectSourceTube(IObjectSources, IObject):
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @property
    def RadiusA(self) -> float: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...

class IObjectSourceTwoAngle(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfAngleDegreeCell(self) -> IEditorCell: ...
    @property
    def YHalfAngleDegreeCell(self) -> IEditorCell: ...
    @property
    def SpatialShapeCell(self) -> IEditorCell: ...
    @property
    def AngularShapeCell(self) -> IEditorCell: ...
    @property
    def UniformAngleCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def XHalfAngleDegree(self) -> float: ...
    @XHalfAngleDegree.setter
    def XHalfAngleDegree(self, value: float) -> None: ...
    @property
    def YHalfAngleDegree(self) -> float: ...
    @YHalfAngleDegree.setter
    def YHalfAngleDegree(self, value: float) -> None: ...
    @property
    def SpatialShape(self) -> ShapeChoices: ...
    @SpatialShape.setter
    def SpatialShape(self, value: ShapeChoices) -> None: ...
    @property
    def AngularShape(self) -> ShapeChoices: ...
    @AngularShape.setter
    def AngularShape(self, value: ShapeChoices) -> None: ...
    @property
    def UniformAngle(self) -> UniformAngleChoices: ...
    @UniformAngle.setter
    def UniformAngle(self, value: UniformAngleChoices) -> None: ...

class IObjectSourceVolumeCylindrical(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSourceVolumeElliptical(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSourceVolumeRectangular(IObjectSources, IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSphere(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectStandardLens(IObject):
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Clear1(self) -> float: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @property
    def Edge1(self) -> float: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Clear2(self) -> float: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @property
    def Edge2(self) -> float: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...

class IObjectStandardSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def MinAperture(self) -> float: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...

class IObjectSwept(IObject):
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def CenterXCell(self) -> IEditorCell: ...
    @property
    def CenterYCell(self) -> IEditorCell: ...
    @property
    def CenterZCell(self) -> IEditorCell: ...
    @property
    def AxisXCell(self) -> IEditorCell: ...
    @property
    def AxisYCell(self) -> IEditorCell: ...
    @property
    def AxisZCell(self) -> IEditorCell: ...
    @property
    def PlaneXCell(self) -> IEditorCell: ...
    @property
    def PlaneYCell(self) -> IEditorCell: ...
    @property
    def PlaneZCell(self) -> IEditorCell: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def EndCapsCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @property
    def CenterX(self) -> float: ...
    @CenterX.setter
    def CenterX(self, value: float) -> None: ...
    @property
    def CenterY(self) -> float: ...
    @CenterY.setter
    def CenterY(self, value: float) -> None: ...
    @property
    def CenterZ(self) -> float: ...
    @CenterZ.setter
    def CenterZ(self, value: float) -> None: ...
    @property
    def AxisX(self) -> float: ...
    @AxisX.setter
    def AxisX(self, value: float) -> None: ...
    @property
    def AxisY(self) -> float: ...
    @AxisY.setter
    def AxisY(self, value: float) -> None: ...
    @property
    def AxisZ(self) -> float: ...
    @AxisZ.setter
    def AxisZ(self, value: float) -> None: ...
    @property
    def PlaneX(self) -> float: ...
    @PlaneX.setter
    def PlaneX(self, value: float) -> None: ...
    @property
    def PlaneY(self) -> float: ...
    @PlaneY.setter
    def PlaneY(self, value: float) -> None: ...
    @property
    def PlaneZ(self) -> float: ...
    @PlaneZ.setter
    def PlaneZ(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @property
    def EndCaps(self) -> EndCapOptions: ...
    @EndCaps.setter
    def EndCaps(self, value: EndCapOptions) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectTabulatedFactedRadial(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    def GetZoneIFacets(self, i: int) -> int: ...
    def SetZoneIFacets(self, i: int, v: int) -> None: ...
    def ZoneIFacetsCell(self, i: int) -> IEditorCell: ...

class IObjectTabulatedFactedToroid(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    def GetZoneIFacets(self, i: int) -> int: ...
    def SetZoneIFacets(self, i: int, v: int) -> None: ...
    def ZoneIFacetsCell(self, i: int) -> IEditorCell: ...

class IObjectTabulatedFrenselRadial(IObject):
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @property
    def IsVolume(self) -> bool: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...

class IObjectToroidalHologram(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RotationR1Cell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower12Cell(self) -> IEditorCell: ...
    @property
    def RotationR2Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower12Cell(self) -> IEditorCell: ...
    @property
    def HoloTypeCell(self) -> IEditorCell: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RotationR1(self) -> float: ...
    @RotationR1.setter
    def RotationR1(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Coeff1YPower2(self) -> float: ...
    @Coeff1YPower2.setter
    def Coeff1YPower2(self, value: float) -> None: ...
    @property
    def Coeff1YPower4(self) -> float: ...
    @Coeff1YPower4.setter
    def Coeff1YPower4(self, value: float) -> None: ...
    @property
    def Coeff1YPower6(self) -> float: ...
    @Coeff1YPower6.setter
    def Coeff1YPower6(self, value: float) -> None: ...
    @property
    def Coeff1YPower8(self) -> float: ...
    @Coeff1YPower8.setter
    def Coeff1YPower8(self, value: float) -> None: ...
    @property
    def Coeff1YPower10(self) -> float: ...
    @Coeff1YPower10.setter
    def Coeff1YPower10(self, value: float) -> None: ...
    @property
    def Coeff1YPower12(self) -> float: ...
    @Coeff1YPower12.setter
    def Coeff1YPower12(self, value: float) -> None: ...
    @property
    def RotationR2(self) -> float: ...
    @RotationR2.setter
    def RotationR2(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Coeff2YPower2(self) -> float: ...
    @Coeff2YPower2.setter
    def Coeff2YPower2(self, value: float) -> None: ...
    @property
    def Coeff2YPower4(self) -> float: ...
    @Coeff2YPower4.setter
    def Coeff2YPower4(self, value: float) -> None: ...
    @property
    def Coeff2YPower6(self) -> float: ...
    @Coeff2YPower6.setter
    def Coeff2YPower6(self, value: float) -> None: ...
    @property
    def Coeff2YPower8(self) -> float: ...
    @Coeff2YPower8.setter
    def Coeff2YPower8(self, value: float) -> None: ...
    @property
    def Coeff2YPower10(self) -> float: ...
    @Coeff2YPower10.setter
    def Coeff2YPower10(self, value: float) -> None: ...
    @property
    def Coeff2YPower12(self) -> float: ...
    @Coeff2YPower12.setter
    def Coeff2YPower12(self, value: float) -> None: ...
    @property
    def HologramType(self) -> int: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @property
    def Order(self) -> float: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @property
    def X1(self) -> float: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @property
    def Y1(self) -> float: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @property
    def Z1(self) -> float: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @property
    def X2(self) -> float: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @property
    def Y2(self) -> float: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @property
    def Z2(self) -> float: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @property
    def HologramThickness(self) -> float: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @property
    def n1(self) -> float: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @property
    def n2(self) -> float: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @property
    def n(self) -> float: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @property
    def dn(self) -> float: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @property
    def Shrinkage(self) -> float: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @property
    def IndexShift(self) -> float: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...

class IObjectToroidalLens(IObject):
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def RotationR1Cell(self) -> IEditorCell: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower12Cell(self) -> IEditorCell: ...
    @property
    def RotationR2Cell(self) -> IEditorCell: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower14Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def Thickness(self) -> float: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @property
    def RotationR1(self) -> float: ...
    @RotationR1.setter
    def RotationR1(self, value: float) -> None: ...
    @property
    def Radius1(self) -> float: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @property
    def Conic1(self) -> float: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @property
    def Coeff1YPower2(self) -> float: ...
    @Coeff1YPower2.setter
    def Coeff1YPower2(self, value: float) -> None: ...
    @property
    def Coeff1YPower4(self) -> float: ...
    @Coeff1YPower4.setter
    def Coeff1YPower4(self, value: float) -> None: ...
    @property
    def Coeff1YPower6(self) -> float: ...
    @Coeff1YPower6.setter
    def Coeff1YPower6(self, value: float) -> None: ...
    @property
    def Coeff1YPower8(self) -> float: ...
    @Coeff1YPower8.setter
    def Coeff1YPower8(self, value: float) -> None: ...
    @property
    def Coeff1YPower10(self) -> float: ...
    @Coeff1YPower10.setter
    def Coeff1YPower10(self, value: float) -> None: ...
    @property
    def Coeff1YPower12(self) -> float: ...
    @Coeff1YPower12.setter
    def Coeff1YPower12(self, value: float) -> None: ...
    @property
    def RotationR2(self) -> float: ...
    @RotationR2.setter
    def RotationR2(self, value: float) -> None: ...
    @property
    def Radius2(self) -> float: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @property
    def Conic2(self) -> float: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @property
    def Coeff2YPower2(self) -> float: ...
    @Coeff2YPower2.setter
    def Coeff2YPower2(self, value: float) -> None: ...
    @property
    def Coeff2YPower4(self) -> float: ...
    @Coeff2YPower4.setter
    def Coeff2YPower4(self, value: float) -> None: ...
    @property
    def Coeff2YPower6(self) -> float: ...
    @Coeff2YPower6.setter
    def Coeff2YPower6(self, value: float) -> None: ...
    @property
    def Coeff2YPower8(self) -> float: ...
    @Coeff2YPower8.setter
    def Coeff2YPower8(self, value: float) -> None: ...
    @property
    def Coeff2YPower10(self) -> float: ...
    @Coeff2YPower10.setter
    def Coeff2YPower10(self, value: float) -> None: ...
    @property
    def Coeff2YPower12(self) -> float: ...
    @Coeff2YPower12.setter
    def Coeff2YPower12(self, value: float) -> None: ...
    @property
    def Coeff1YPower14(self) -> float: ...
    @Coeff1YPower14.setter
    def Coeff1YPower14(self, value: float) -> None: ...
    @property
    def Coeff2YPower14(self) -> float: ...
    @Coeff2YPower14.setter
    def Coeff2YPower14(self, value: float) -> None: ...

class IObjectToroidalSurface(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RotationR(self) -> float: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @property
    def CoeffYPower10(self) -> float: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...

class IObjectToroidalSurfaceOddASphere(IObject):
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower1Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower5Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower7Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower8Cell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @property
    def YHalfWidth(self) -> float: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @property
    def RotationR(self) -> float: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def CoeffOnYPower1(self) -> float: ...
    @CoeffOnYPower1.setter
    def CoeffOnYPower1(self, value: float) -> None: ...
    @property
    def CoeffOnYPower2(self) -> float: ...
    @CoeffOnYPower2.setter
    def CoeffOnYPower2(self, value: float) -> None: ...
    @property
    def CoeffOnYPower3(self) -> float: ...
    @CoeffOnYPower3.setter
    def CoeffOnYPower3(self, value: float) -> None: ...
    @property
    def CoeffOnYPower4(self) -> float: ...
    @CoeffOnYPower4.setter
    def CoeffOnYPower4(self, value: float) -> None: ...
    @property
    def CoeffOnYPower5(self) -> float: ...
    @CoeffOnYPower5.setter
    def CoeffOnYPower5(self, value: float) -> None: ...
    @property
    def CoeffOnYPower6(self) -> float: ...
    @CoeffOnYPower6.setter
    def CoeffOnYPower6(self, value: float) -> None: ...
    @property
    def CoeffOnYPower7(self) -> float: ...
    @CoeffOnYPower7.setter
    def CoeffOnYPower7(self, value: float) -> None: ...
    @property
    def CoeffOnYPower8(self) -> float: ...
    @CoeffOnYPower8.setter
    def CoeffOnYPower8(self, value: float) -> None: ...

class IObjectTorusSurface(IObject):
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def RadiusRCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @property
    def RadiusR(self) -> float: ...
    @RadiusR.setter
    def RadiusR(self, value: float) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...

class IObjectTorusVolume(IObject):
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def RadiusRCell(self) -> IEditorCell: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @property
    def RadiusR(self) -> float: ...
    @RadiusR.setter
    def RadiusR(self, value: float) -> None: ...
    @property
    def StartAngle(self) -> float: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @property
    def StopAngle(self) -> float: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...

class IObjectTriangle(IObject):
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Cell(self) -> IEditorCell: ...
    @property
    def Y3Cell(self) -> IEditorCell: ...
    @property
    def X1(self) -> float: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @property
    def Y1(self) -> float: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @property
    def X2(self) -> float: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @property
    def Y2(self) -> float: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @property
    def X3(self) -> float: ...
    @X3.setter
    def X3(self, value: float) -> None: ...
    @property
    def Y3(self) -> float: ...
    @Y3.setter
    def Y3(self, value: float) -> None: ...

class IObjectTriangularCorner(IObject):
    @property
    def WidthCell(self) -> IEditorCell: ...
    @property
    def Width(self) -> float: ...
    @Width.setter
    def Width(self, value: float) -> None: ...

class IObjectTypeSettings:
    @property
    def Type(self) -> ObjectType: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def RequiresFile1(self) -> bool: ...
    @property
    def FileName1(self) -> str: ...
    @FileName1.setter
    def FileName1(self, value: str) -> None: ...
    @property
    def RequiresFile2(self) -> bool: ...
    @property
    def FileName2(self) -> str: ...
    @FileName2.setter
    def FileName2(self, value: str) -> None: ...
    def GetFileNames1(self) -> list[str]: ...
    def GetFileNames2(self) -> list[str]: ...

class IObjectUserDefinedObject(IObject): ...

class IObjectWolterSurface(IObject):
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @property
    def R0Cell(self) -> IEditorCell: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def CoeffZPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower5Cell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...
    @property
    def R0(self) -> float: ...
    @R0.setter
    def R0(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @property
    def CoeffZPower2(self) -> float: ...
    @CoeffZPower2.setter
    def CoeffZPower2(self, value: float) -> None: ...
    @property
    def CoeffZPower3(self) -> float: ...
    @CoeffZPower3.setter
    def CoeffZPower3(self, value: float) -> None: ...
    @property
    def CoeffZPower4(self) -> float: ...
    @CoeffZPower4.setter
    def CoeffZPower4(self, value: float) -> None: ...
    @property
    def CoeffZPower5(self) -> float: ...
    @CoeffZPower5.setter
    def CoeffZPower5(self, value: float) -> None: ...

class IObjectXYPolynomial(IObject):
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @property
    def X0Y1(self) -> float: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @property
    def X2Y0(self) -> float: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @property
    def X1Y1(self) -> float: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @property
    def X0Y2(self) -> float: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @property
    def X3Y0(self) -> float: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @property
    def X2Y1(self) -> float: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @property
    def X1Y2(self) -> float: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @property
    def X0Y3(self) -> float: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @property
    def X4Y0(self) -> float: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @property
    def X3Y1(self) -> float: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @property
    def X2Y2(self) -> float: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @property
    def X1Y3(self) -> float: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @property
    def X0Y4(self) -> float: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @property
    def X5Y0(self) -> float: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @property
    def X4Y1(self) -> float: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @property
    def X3Y2(self) -> float: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @property
    def X2Y3(self) -> float: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @property
    def X1Y4(self) -> float: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @property
    def X0Y5(self) -> float: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @property
    def X6Y0(self) -> float: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @property
    def X5Y1(self) -> float: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @property
    def X4Y2(self) -> float: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @property
    def X3Y3(self) -> float: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @property
    def X2Y4(self) -> float: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @property
    def X1Y5(self) -> float: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @property
    def X0Y6(self) -> float: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @property
    def X7Y0(self) -> float: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @property
    def X6Y1(self) -> float: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @property
    def X5Y2(self) -> float: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @property
    def X4Y3(self) -> float: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @property
    def X3Y4(self) -> float: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @property
    def X2Y5(self) -> float: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @property
    def X1Y6(self) -> float: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @property
    def X0Y7(self) -> float: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @property
    def X8Y0(self) -> float: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @property
    def X7Y1(self) -> float: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @property
    def X6Y2(self) -> float: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @property
    def X5Y3(self) -> float: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @property
    def X4Y4(self) -> float: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @property
    def X3Y5(self) -> float: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @property
    def X2Y6(self) -> float: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @property
    def X1Y7(self) -> float: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @property
    def X0Y8(self) -> float: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @property
    def X9Y0(self) -> float: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @property
    def X8Y1(self) -> float: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @property
    def X7Y2(self) -> float: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @property
    def X6Y3(self) -> float: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @property
    def X5Y4(self) -> float: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @property
    def X4Y5(self) -> float: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @property
    def X3Y6(self) -> float: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @property
    def X2Y7(self) -> float: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @property
    def X1Y8(self) -> float: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @property
    def X0Y9(self) -> float: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @property
    def X10Y0(self) -> float: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @property
    def X9Y1(self) -> float: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @property
    def X8Y2(self) -> float: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @property
    def X7Y3(self) -> float: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @property
    def X6Y4(self) -> float: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @property
    def X5Y5(self) -> float: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @property
    def X4Y6(self) -> float: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @property
    def X3Y7(self) -> float: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @property
    def X2Y8(self) -> float: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @property
    def X1Y9(self) -> float: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @property
    def X0Y10(self) -> float: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @property
    def X11Y0(self) -> float: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @property
    def X10Y1(self) -> float: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @property
    def X9Y2(self) -> float: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @property
    def X8Y3(self) -> float: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @property
    def X7Y4(self) -> float: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @property
    def X6Y5(self) -> float: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @property
    def X5Y6(self) -> float: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @property
    def X4Y7(self) -> float: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @property
    def X3Y8(self) -> float: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @property
    def X2Y9(self) -> float: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @property
    def X1Y10(self) -> float: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @property
    def X0Y11(self) -> float: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @property
    def X12Y0(self) -> float: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @property
    def X11Y1(self) -> float: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @property
    def X10Y2(self) -> float: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @property
    def X9Y3(self) -> float: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @property
    def X8Y4(self) -> float: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @property
    def X7Y5(self) -> float: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @property
    def X6Y6(self) -> float: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @property
    def X5Y7(self) -> float: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @property
    def X4Y8(self) -> float: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @property
    def X3Y9(self) -> float: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @property
    def X2Y10(self) -> float: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @property
    def X1Y11(self) -> float: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @property
    def X0Y12(self) -> float: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @property
    def X13Y0(self) -> float: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @property
    def X12Y1(self) -> float: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @property
    def X11Y2(self) -> float: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @property
    def X10Y3(self) -> float: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @property
    def X9Y4(self) -> float: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @property
    def X8Y5(self) -> float: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @property
    def X7Y6(self) -> float: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @property
    def X6Y7(self) -> float: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @property
    def X5Y8(self) -> float: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @property
    def X4Y9(self) -> float: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @property
    def X3Y10(self) -> float: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @property
    def X2Y11(self) -> float: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @property
    def X1Y12(self) -> float: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @property
    def X0Y13(self) -> float: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @property
    def X14Y0(self) -> float: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @property
    def X13Y1(self) -> float: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @property
    def X12Y2(self) -> float: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @property
    def X11Y3(self) -> float: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @property
    def X10Y4(self) -> float: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @property
    def X9Y5(self) -> float: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @property
    def X8Y6(self) -> float: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @property
    def X7Y7(self) -> float: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @property
    def X6Y8(self) -> float: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @property
    def X5Y9(self) -> float: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @property
    def X4Y10(self) -> float: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @property
    def X3Y11(self) -> float: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @property
    def X2Y12(self) -> float: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @property
    def X1Y13(self) -> float: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @property
    def X0Y14(self) -> float: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @property
    def X15Y0(self) -> float: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @property
    def X14Y1(self) -> float: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @property
    def X13Y2(self) -> float: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @property
    def X12Y3(self) -> float: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @property
    def X11Y4(self) -> float: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @property
    def X10Y5(self) -> float: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @property
    def X9Y6(self) -> float: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @property
    def X8Y7(self) -> float: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @property
    def X7Y8(self) -> float: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @property
    def X6Y9(self) -> float: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @property
    def X5Y10(self) -> float: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @property
    def X4Y11(self) -> float: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @property
    def X3Y12(self) -> float: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @property
    def X2Y13(self) -> float: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @property
    def X1Y14(self) -> float: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @property
    def X0Y15(self) -> float: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @property
    def X16Y0(self) -> float: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @property
    def X15Y1(self) -> float: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @property
    def X14Y2(self) -> float: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @property
    def X13Y3(self) -> float: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @property
    def X12Y4(self) -> float: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @property
    def X11Y5(self) -> float: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @property
    def X10Y6(self) -> float: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @property
    def X9Y7(self) -> float: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @property
    def X8Y8(self) -> float: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @property
    def X7Y9(self) -> float: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @property
    def X6Y10(self) -> float: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @property
    def X5Y11(self) -> float: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @property
    def X4Y12(self) -> float: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @property
    def X3Y13(self) -> float: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @property
    def X2Y14(self) -> float: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @property
    def X1Y15(self) -> float: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @property
    def X0Y16(self) -> float: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @property
    def X17Y0(self) -> float: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @property
    def X16Y1(self) -> float: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @property
    def X15Y2(self) -> float: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @property
    def X14Y3(self) -> float: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @property
    def X13Y4(self) -> float: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @property
    def X12Y5(self) -> float: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @property
    def X11Y6(self) -> float: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @property
    def X10Y7(self) -> float: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @property
    def X9Y8(self) -> float: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @property
    def X8Y9(self) -> float: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @property
    def X7Y10(self) -> float: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @property
    def X6Y11(self) -> float: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @property
    def X5Y12(self) -> float: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @property
    def X4Y13(self) -> float: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @property
    def X3Y14(self) -> float: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @property
    def X2Y15(self) -> float: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @property
    def X1Y16(self) -> float: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @property
    def X0Y17(self) -> float: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @property
    def X18Y0(self) -> float: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @property
    def X17Y1(self) -> float: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @property
    def X16Y2(self) -> float: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @property
    def X15Y3(self) -> float: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @property
    def X14Y4(self) -> float: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @property
    def X13Y5(self) -> float: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @property
    def X12Y6(self) -> float: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @property
    def X11Y7(self) -> float: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @property
    def X10Y8(self) -> float: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @property
    def X9Y9(self) -> float: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...
    @property
    def X8Y10(self) -> float: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @property
    def X7Y11(self) -> float: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @property
    def X6Y12(self) -> float: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @property
    def X5Y13(self) -> float: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @property
    def X4Y14(self) -> float: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @property
    def X3Y15(self) -> float: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @property
    def X2Y16(self) -> float: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @property
    def X1Y17(self) -> float: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @property
    def X0Y18(self) -> float: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @property
    def X19Y0(self) -> float: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @property
    def X18Y1(self) -> float: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @property
    def X17Y2(self) -> float: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @property
    def X16Y3(self) -> float: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @property
    def X15Y4(self) -> float: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @property
    def X14Y5(self) -> float: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @property
    def X13Y6(self) -> float: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @property
    def X12Y7(self) -> float: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @property
    def X11Y8(self) -> float: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @property
    def X10Y9(self) -> float: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @property
    def X9Y10(self) -> float: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @property
    def X8Y11(self) -> float: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @property
    def X7Y12(self) -> float: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @property
    def X6Y13(self) -> float: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @property
    def X5Y14(self) -> float: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @property
    def X4Y15(self) -> float: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @property
    def X3Y16(self) -> float: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @property
    def X2Y17(self) -> float: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @property
    def X1Y18(self) -> float: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @property
    def X0Y19(self) -> float: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @property
    def X20Y0(self) -> float: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @property
    def X19Y1(self) -> float: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @property
    def X18Y2(self) -> float: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @property
    def X17Y3(self) -> float: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @property
    def X16Y4(self) -> float: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @property
    def X15Y5(self) -> float: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @property
    def X14Y6(self) -> float: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @property
    def X13Y7(self) -> float: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @property
    def X12Y8(self) -> float: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @property
    def X11Y9(self) -> float: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @property
    def X10Y10(self) -> float: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @property
    def X9Y11(self) -> float: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @property
    def X8Y12(self) -> float: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @property
    def X7Y13(self) -> float: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @property
    def X6Y14(self) -> float: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @property
    def X5Y15(self) -> float: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @property
    def X4Y16(self) -> float: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @property
    def X3Y17(self) -> float: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @property
    def X2Y18(self) -> float: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @property
    def X1Y19(self) -> float: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @property
    def X0Y20(self) -> float: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @property
    def X21Y0(self) -> float: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @property
    def X20Y1(self) -> float: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @property
    def X19Y2(self) -> float: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @property
    def X18Y3(self) -> float: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @property
    def X17Y4(self) -> float: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @property
    def X16Y5(self) -> float: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @property
    def X15Y6(self) -> float: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @property
    def X14Y7(self) -> float: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @property
    def X13Y8(self) -> float: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @property
    def X12Y9(self) -> float: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @property
    def X11Y10(self) -> float: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @property
    def X10Y11(self) -> float: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @property
    def X9Y12(self) -> float: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @property
    def X8Y13(self) -> float: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @property
    def X7Y14(self) -> float: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @property
    def X6Y15(self) -> float: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @property
    def X5Y16(self) -> float: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @property
    def X4Y17(self) -> float: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @property
    def X3Y18(self) -> float: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @property
    def X2Y19(self) -> float: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...

class IObjectZernikeSurface(IObject):
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def NormRadCell(self) -> IEditorCell: ...
    @property
    def XDecenterCell(self) -> IEditorCell: ...
    @property
    def YDecenterCellCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def NumberOfZTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @property
    def Conic(self) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @property
    def MaxAperture(self) -> float: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @property
    def NormRad(self) -> float: ...
    @NormRad.setter
    def NormRad(self, value: float) -> None: ...
    @property
    def XDecenter(self) -> float: ...
    @XDecenter.setter
    def XDecenter(self, value: float) -> None: ...
    @property
    def YDecenter(self) -> float: ...
    @YDecenter.setter
    def YDecenter(self, value: float) -> None: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @property
    def NumberOfZTerms(self) -> int: ...
    @NumberOfZTerms.setter
    def NumberOfZTerms(self, value: int) -> None: ...
    def GetFrontTerm(self, i: int) -> float: ...
    def GetZICell(self, i: int) -> IEditorCell: ...
    def SetFrontTerm(self, i: int, Value: float) -> None: ...

class IOSS_ABg(IObjectScatteringSettings):
    @property
    def ReflectName(self) -> str: ...
    @ReflectName.setter
    def ReflectName(self, value: str) -> None: ...
    @property
    def TransmitName(self) -> str: ...
    @TransmitName.setter
    def TransmitName(self, value: str) -> None: ...
    def GetAvailableABgNames(self) -> list[str]: ...

class IOSS_ABgFile(IObjectScatteringSettings):
    @property
    def ReflectFile(self) -> str: ...
    @ReflectFile.setter
    def ReflectFile(self, value: str) -> None: ...
    @property
    def TransmitFile(self) -> str: ...
    @TransmitFile.setter
    def TransmitFile(self, value: str) -> None: ...
    def GetAvailableFiles(self) -> list[str]: ...

class IOSS_BSDF(IObjectScatteringSettings):
    @property
    def ReflectFile(self) -> str: ...
    @ReflectFile.setter
    def ReflectFile(self, value: str) -> None: ...
    @property
    def TransmitFile(self) -> str: ...
    @TransmitFile.setter
    def TransmitFile(self, value: str) -> None: ...
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    def GetAvailableFileNames(self) -> list[str]: ...

class IOSS_Gaussian(IObjectScatteringSettings):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @property
    def Sigma(self) -> float: ...
    @Sigma.setter
    def Sigma(self, value: float) -> None: ...

class IOSS_ISScatterCatalog(IObjectScatteringSettings):
    @property
    def SampleSideR(self) -> SampleSides: ...
    @SampleSideR.setter
    def SampleSideR(self, value: SampleSides) -> None: ...
    @property
    def SamplingR(self) -> Samplings: ...
    @SamplingR.setter
    def SamplingR(self, value: Samplings) -> None: ...
    @property
    def SampleSideT(self) -> SampleSides: ...
    @SampleSideT.setter
    def SampleSideT(self, value: SampleSides) -> None: ...
    @property
    def SamplingT(self) -> Samplings: ...
    @SamplingT.setter
    def SamplingT(self, value: Samplings) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    def GetAvailableISFiles(self) -> list[str]: ...
    def GetReflectFile(self) -> str: ...
    def GetSampleSidesR(self) -> list[SampleSides]: ...
    def GetSampleSidesT(self) -> list[SampleSides]: ...
    def GetTransmitFile(self) -> str: ...
    def SetReflectFile(self, File: str) -> ReflectTransmitCode: ...
    def SetTransmitFile(self, File: str) -> ReflectTransmitCode: ...

class IOSS_Lambertian(IObjectScatteringSettings):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...

class IOSS_None(IObjectScatteringSettings): ...

class IOSS_User(IObjectScatteringSettings):
    @property
    def DLLName(self) -> str: ...
    @DLLName.setter
    def DLLName(self, value: str) -> None: ...
    @property
    def FileName(self) -> str: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    @property
    def FileNameRequired(self) -> bool: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    def GetAvailableDLLNames(self) -> list[str]: ...
    def GetAvailableFileNames(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class ISCS_BlackBodySpectrum(ISourceColorSettings):
    @property
    def TemperatureK(self) -> float: ...
    @TemperatureK.setter
    def TemperatureK(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_CIE1931Chromaticity(ISourceColorSettings):
    @property
    def cx(self) -> float: ...
    @cx.setter
    def cx(self, value: float) -> None: ...
    @property
    def cy(self) -> float: ...
    @cy.setter
    def cy(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_CIE1931RGB(ISourceColorSettings):
    @property
    def R(self) -> float: ...
    @R.setter
    def R(self, value: float) -> None: ...
    @property
    def G(self) -> float: ...
    @G.setter
    def G(self, value: float) -> None: ...
    @property
    def B(self) -> float: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_CIE1931Tristimulus(ISourceColorSettings):
    @property
    def X(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @property
    def Y(self) -> float: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @property
    def Z(self) -> float: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_CIE1976(ISourceColorSettings):
    @property
    def u(self) -> float: ...
    @u.setter
    def u(self, value: float) -> None: ...
    @property
    def v(self) -> float: ...
    @v.setter
    def v(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_ColorTemperature(ISourceColorSettings):
    @property
    def TemperatureK(self) -> float: ...
    @TemperatureK.setter
    def TemperatureK(self, value: float) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_D65White(ISourceColorSettings):
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISCS_SpectrumFile(ISourceColorSettings):
    @property
    def SpectrumFile(self) -> str: ...
    @SpectrumFile.setter
    def SpectrumFile(self, value: str) -> None: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @property
    def Fit(self) -> str: ...
    def GetAvailableSpectrumFiles(self) -> list[str]: ...

class ISCS_SystemWavelengths(ISourceColorSettings): ...

class ISCS_UniformPowerSpectrum(ISourceColorSettings):
    @property
    def SpectrumCount(self) -> int: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @property
    def WavelengthTo(self) -> float: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @property
    def Fit(self) -> str: ...

class ISourceColorSettings:
    @property
    def Mode(self) -> SourceColorMode: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def _S_SystemWavelengths(self) -> ISCS_SystemWavelengths: ...
    @property
    def _S_CIE1931Tristimulus(self) -> ISCS_CIE1931Tristimulus: ...
    @property
    def _S_CIE1931Chromaticity(self) -> ISCS_CIE1931Chromaticity: ...
    @property
    def _S_CIE1931RGB(self) -> ISCS_CIE1931RGB: ...
    @property
    def _S_UniformPowerSpectrum(self) -> ISCS_UniformPowerSpectrum: ...
    @property
    def _S_D65White(self) -> ISCS_D65White: ...
    @property
    def _S_ColorTemperature(self) -> ISCS_ColorTemperature: ...
    @property
    def _S_BlackBodySpectrum(self) -> ISCS_BlackBodySpectrum: ...
    @property
    def _S_SpectrumFile(self) -> ISCS_SpectrumFile: ...
    @property
    def _S_CIE1976(self) -> ISCS_CIE1976: ...

class IVMPS_AngleScattering(IVolumePhysicsModelSettings):
    @property
    def MeanPath(self) -> float: ...
    @MeanPath.setter
    def MeanPath(self, value: float) -> None: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...

class IVMPS_DLLDefinedScattering(IVolumePhysicsModelSettings):
    @property
    def DLL(self) -> str: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @property
    def MeanPath(self) -> float: ...
    @MeanPath.setter
    def MeanPath(self, value: float) -> None: ...
    @property
    def MeanPathRequired(self) -> bool: ...
    @property
    def Angle(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @property
    def AngleRequired(self) -> bool: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class IVMPS_PhotoluminscenceModel(IVolumePhysicsModelSettings):
    @property
    def AreSettingsValid(self) -> bool: ...
    @property
    def AbsorptionFile(self) -> str: ...
    @AbsorptionFile.setter
    def AbsorptionFile(self, value: str) -> None: ...
    @property
    def EmissionFile(self) -> str: ...
    @EmissionFile.setter
    def EmissionFile(self, value: str) -> None: ...
    @property
    def ExcitationFile(self) -> str: ...
    @ExcitationFile.setter
    def ExcitationFile(self, value: str) -> None: ...
    @property
    def QuantumYield(self) -> str: ...
    @QuantumYield.setter
    def QuantumYield(self, value: str) -> None: ...
    @property
    def ParticleIndex(self) -> float: ...
    @ParticleIndex.setter
    def ParticleIndex(self, value: float) -> None: ...
    @property
    def ParticleDensity(self) -> float: ...
    @ParticleDensity.setter
    def ParticleDensity(self, value: float) -> None: ...
    @property
    def ParticleRadius(self) -> float: ...
    @ParticleRadius.setter
    def ParticleRadius(self, value: float) -> None: ...
    @property
    def Threshold(self) -> float: ...
    @Threshold.setter
    def Threshold(self, value: float) -> None: ...
    @property
    def BasicAlgorithm(self) -> bool: ...
    @BasicAlgorithm.setter
    def BasicAlgorithm(self, value: bool) -> None: ...
    @property
    def PLMeanPath(self) -> float: ...
    @PLMeanPath.setter
    def PLMeanPath(self, value: float) -> None: ...
    @property
    def UseMieDensity(self) -> bool: ...
    @UseMieDensity.setter
    def UseMieDensity(self, value: bool) -> None: ...
    @property
    def MieMeanPath(self) -> float: ...
    @MieMeanPath.setter
    def MieMeanPath(self, value: float) -> None: ...
    @property
    def EfficiencySpectrum(self) -> EfficiencySpectrumType: ...
    @EfficiencySpectrum.setter
    def EfficiencySpectrum(self, value: EfficiencySpectrumType) -> None: ...
    @property
    def ExtinctionCoefficient(self) -> float: ...
    @ExtinctionCoefficient.setter
    def ExtinctionCoefficient(self, value: float) -> None: ...
    @property
    def ExtinctionWavelength(self) -> float: ...
    @ExtinctionWavelength.setter
    def ExtinctionWavelength(self, value: float) -> None: ...
    @property
    def PLDensity(self) -> float: ...
    @PLDensity.setter
    def PLDensity(self, value: float) -> None: ...
    @property
    def ConsiderMieScattering(self) -> bool: ...
    @ConsiderMieScattering.setter
    def ConsiderMieScattering(self, value: bool) -> None: ...
    def GetAvailableAbsorptionFiles(self) -> list[str]: ...
    def GetAvailableEmissionFiles(self) -> list[str]: ...
    def GetAvailableQuantumYieldFiles(self) -> list[str]: ...

class IVolumePhysicsModelSettings:
    @property
    def Type(self) -> VolumePhysicsModelType: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def _S_None(self) -> IVPMS_None: ...
    @property
    def _S_AngleScattering(self) -> IVMPS_AngleScattering: ...
    @property
    def _S_DLLDefinedScattering(self) -> IVMPS_DLLDefinedScattering: ...
    @property
    def _S_PhotoluminescenceModel(self) -> IVMPS_PhotoluminscenceModel: ...

class IVPMS_None(IVolumePhysicsModelSettings): ...

class NCEIndexType:
    Isotropic = 0
    Birefringent = 1
    GRIN = 2

class ObjectColumn:
    Comment = 1
    RefObject = 2
    InsideOf = 3
    XPosition = 4
    YPosition = 5
    ZPosition = 6
    TiltX = 7
    TiltY = 8
    TiltZ = 9
    Material = 10
    Par1 = 11
    Par2 = 12
    Par3 = 13
    Par4 = 14
    Par5 = 15
    Par6 = 16
    Par7 = 17
    Par8 = 18
    Par9 = 19
    Par10 = 20
    Par11 = 21
    Par12 = 22
    Par13 = 23
    Par14 = 24
    Par15 = 25
    Par16 = 26
    Par17 = 27
    Par18 = 28
    Par19 = 29
    Par20 = 30
    Par21 = 31
    Par22 = 32
    Par23 = 33
    Par24 = 34
    Par25 = 35
    Par26 = 36
    Par27 = 37
    Par28 = 38
    Par29 = 39
    Par30 = 40
    Par31 = 41
    Par32 = 42
    Par33 = 43
    Par34 = 44
    Par35 = 45
    Par36 = 46
    Par37 = 47
    Par38 = 48
    Par39 = 49
    Par40 = 50
    Par41 = 51
    Par42 = 52
    Par43 = 53
    Par44 = 54
    Par45 = 55
    Par46 = 56
    Par47 = 57
    Par48 = 58
    Par49 = 59
    Par50 = 60
    Par51 = 61
    Par52 = 62
    Par53 = 63
    Par54 = 64
    Par55 = 65
    Par56 = 66
    Par57 = 67
    Par58 = 68
    Par59 = 69
    Par60 = 70
    Par61 = 71
    Par62 = 72
    Par63 = 73
    Par64 = 74
    Par65 = 75
    Par66 = 76
    Par67 = 77
    Par68 = 78
    Par69 = 79
    Par70 = 80
    Par71 = 81
    Par72 = 82
    Par73 = 83
    Par74 = 84
    Par75 = 85
    Par76 = 86
    Par77 = 87
    Par78 = 88
    Par79 = 89
    Par80 = 90
    Par81 = 91
    Par82 = 92
    Par83 = 93
    Par84 = 94
    Par85 = 95
    Par86 = 96
    Par87 = 97
    Par88 = 98
    Par89 = 99
    Par90 = 100
    Par91 = 101
    Par92 = 102
    Par93 = 103
    Par94 = 104
    Par95 = 105
    Par96 = 106
    Par97 = 107
    Par98 = 108
    Par99 = 109
    Par100 = 110
    Par101 = 111
    Par102 = 112
    Par103 = 113
    Par104 = 114
    Par105 = 115
    Par106 = 116
    Par107 = 117
    Par108 = 118
    Par109 = 119
    Par110 = 120
    Par111 = 121
    Par112 = 122
    Par113 = 123
    Par114 = 124
    Par115 = 125
    Par116 = 126
    Par117 = 127
    Par118 = 128
    Par119 = 129
    Par120 = 130
    Par121 = 131
    Par122 = 132
    Par123 = 133
    Par124 = 134
    Par125 = 135
    Par126 = 136
    Par127 = 137
    Par128 = 138
    Par129 = 139
    Par130 = 140
    Par131 = 141
    Par132 = 142
    Par133 = 143
    Par134 = 144
    Par135 = 145
    Par136 = 146
    Par137 = 147
    Par138 = 148
    Par139 = 149
    Par140 = 150
    Par141 = 151
    Par142 = 152
    Par143 = 153
    Par144 = 154
    Par145 = 155
    Par146 = 156
    Par147 = 157
    Par148 = 158
    Par149 = 159
    Par150 = 160
    Par151 = 161
    Par152 = 162
    Par153 = 163
    Par154 = 164
    Par155 = 165
    Par156 = 166
    Par157 = 167
    Par158 = 168
    Par159 = 169
    Par160 = 170
    Par161 = 171
    Par162 = 172
    Par163 = 173
    Par164 = 174
    Par165 = 175
    Par166 = 176
    Par167 = 177
    Par168 = 178
    Par169 = 179
    Par170 = 180
    Par171 = 181
    Par172 = 182
    Par173 = 183
    Par174 = 184
    Par175 = 185
    Par176 = 186
    Par177 = 187
    Par178 = 188
    Par179 = 189
    Par180 = 190
    Par181 = 191
    Par182 = 192
    Par183 = 193
    Par184 = 194
    Par185 = 195
    Par186 = 196
    Par187 = 197
    Par188 = 198
    Par189 = 199
    Par190 = 200
    Par191 = 201
    Par192 = 202
    Par193 = 203
    Par194 = 204
    Par195 = 205
    Par196 = 206
    Par197 = 207
    Par198 = 208
    Par199 = 209
    Par200 = 210
    Par201 = 211
    Par202 = 212
    Par203 = 213
    Par204 = 214
    Par205 = 215
    Par206 = 216
    Par207 = 217
    Par208 = 218
    Par209 = 219
    Par210 = 220
    Par211 = 221
    Par212 = 222
    Par213 = 223
    Par214 = 224
    Par215 = 225
    Par216 = 226
    Par217 = 227
    Par218 = 228
    Par219 = 229
    Par220 = 230
    Par221 = 231
    Par222 = 232
    Par223 = 233
    Par224 = 234
    Par225 = 235
    Par226 = 236
    Par227 = 237
    Par228 = 238
    Par229 = 239
    Par230 = 240
    Par231 = 241
    Par232 = 242
    Par233 = 243
    Par234 = 244
    Par235 = 245
    Par236 = 246
    Par237 = 247
    Par238 = 248
    Par239 = 249
    Par240 = 250
    Par241 = 251
    Par242 = 252
    Par243 = 253
    Par244 = 254
    Par245 = 255
    Par246 = 256
    Par247 = 257
    Par248 = 258
    Par249 = 259
    Par250 = 260

class ObjectScatteringTypes:
    # None = 0
    Lambertian = 1
    Gaussian = 2
    ABg = 3
    ABgFile = 4
    BSDF = 5
    ISScatterCatalog = 6
    User = 7

class ObjectType:
    AnnularAsphericLens = 0
    AnnularAxialLens = 1
    AnnularVolume = 2
    Annulus = 3
    Array = 4
    ArrayRing = 5
    AsphericSurface = 6
    AsphericSurface2 = 7
    AxiconSurface = 8
    BiconicLens = 9
    BiconicSurface = 10
    BiconicZernike = 11
    BiconicZernikeSurface = 12
    Binary1 = 13
    Binary2 = 14
    Binary2A = 15
    Boolean = 16
    BooleanCAD = 16
    CADAssemblyAutodeskInventor = 17
    CADAssemblyCreoParametric = 18
    CADAssemblySolidWorks = 19
    CADPartAutodeskInventor = 20
    CADPartCreoParametric = 21
    CADPartSolidWorks = 22
    CADPartSTEPIGESSAT = 23
    CADPartSTL = 24
    CADPartZPD = 25
    Cone = 26
    CPC = 27
    CPCRectangular = 28
    CylinderPipe = 29
    CylinderVolume = 30
    Cylinder2Pipe = 31
    Cylinder2Volume = 32
    DetectorColor = 33
    DetectorPolar = 34
    DetectorRectangle = 35
    DetectorSurface = 36
    DetectorVolume = 37
    DiffractionGrating = 38
    DualBEFSurface = 39
    Ellipse = 40
    EllipticalVolume = 41
    EvenAsphereLens = 42
    ExtendedOddAsphereLens = 43
    ExtendedPolynomialLens = 44
    ExtendedPolynomialSurface = 45
    Extruded = 46
    FacetedSurface = 47
    FreeformZ = 48
    Fresnel1 = 49
    Fresnel2 = 50
    GridSagLens = 51
    GridSagSurface = 52
    GridSagFrontBack = 53
    HexagonalLensletArray = 54
    HologramLens = 55
    HologramSurface = 56
    JonesMatrix = 57
    LensletArray1 = 58
    LensletArray2 = 59
    MEMS = 60
    NullObject = 61
    OddAsphereLens = 62
    ParaxialLens = 63
    PolygonObject = 64
    RayRotator = 65
    RectangularCorner = 66
    Rectangle = 67
    RectangularPipe = 68
    RectangularPipeGrating = 69
    RectangularRoof = 70
    RectangularTorusSurface = 71
    RectangularTorusVolume = 72
    RectangularVolume = 73
    RectangularVolumeGrating = 74
    ReverseRadianceDetector = 75
    ReverseRadianceTarget = 76
    Slide = 77
    SourceDiffractive = 78
    SourceDiode = 79
    SourceDLL = 80
    SourceEllipse = 81
    SourceEULUMDATFile = 82
    SourceFilament = 83
    SourceFile = 84
    SourceGaussian = 85
    SourceIESNAFile = 86
    SourceImported = 87
    SourceObject = 88
    SourcePoint = 89
    SourceRadial = 90
    SourceRay = 91
    SourceRectangle = 92
    SourceTube = 93
    SourceTwoAngle = 94
    SourceVolumeCylindrical = 95
    SourceVolumeElliptical = 96
    SourceVolumeRectangular = 97
    Sphere = 98
    StandardLens = 99
    StandardSurface = 100
    Swept = 101
    TabulatedFactedRadial = 102
    TabulatedFactedToroid = 103
    TabulatedFrenselRadial = 104
    ToroidalHologram = 105
    ToroidalLens = 106
    ToroidalSurface = 107
    ToroidalSurfaceOddASphere = 108
    TorusSurface = 109
    TorusVolume = 110
    TriangularCorner = 111
    Triangle = 112
    UserDefinedObject = 113
    WolterSurface = 114
    ZernikeSurface = 115
    BooleanNative = 116
    CompoundLens = 117
    QTypeAsphereSurface = 118
    OffAxisMirror = 119

class OrderChoices:
    Before = 0
    After = 1

class PixelAddressing:
    ByRow = 0
    ByColumn = 1
    Individually = 2

class PolarDetectorDataType:
    Power = 1
    PowerSolidAngle = 2
    Lumens = 3
    LumensSolidAngle = 4
    Cx = 5
    Cy = 6
    u_T = 7
    u_V = 8
    TriX = 9
    TriY = 10
    TriZ = 11

class RaysIgnoreObjectType:
    Never = 0
    Always = 1
    OnLaunch = 2

class RayTraceModes:
    Standard = 0
    Flat = 1
    Shaded = 2
    Kernel = 3

class ScatterToType:
    ScatterToList = 0
    ImportanceSampling = 1

class ShapeChoices:
    Rectangular = 0
    Elliptical = 1

class SourceBulkScatterMode:
    Many = 0
    Once = 1
    Never = 2

class SourceColorMode:
    SystemWavelengths = 0
    CIE1931Tristimulus = 1
    CIE1931Chromaticity = 2
    CIE1931RGB = 3
    UniformPowerSpectrum = 4
    D65White = 5
    ColorTemperature = 6
    BlackBodySpectrum = 7
    SpectrumFile = 8
    CIE1976 = 9

class SourceSamplingMethod:
    Random = 0
    Sobol = 1

class UniformAngleChoices:
    UniformIrradiance = 0
    UniformInAngleSpace = 1

class VolumePhysicsModelType:
    # None = 0
    AngleScattering = 1
    DLLDefinedScattering = 2
    PhotoluminescenceModel = 3
