"""This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import IMessage
from zospy.api._ZOSAPI.Common import IMetadata, ISettingsData
from zospy.api._ZOSAPI.Tools.General import IDataDictionary, ZemaxFileTypes

from . import Analysis, Common, Editors, Preferences, SystemData, Tools, Wizards

__all__ = (
    "Analysis",
    "Common",
    "Editors",
    "Preferences",
    "SystemData",
    "Tools",
    "Wizards",
    "IOpticalSystem",
    "IPreferences",
    "ISTARMaterials",
    "ISTARSubsystem",
    "IZAPI_BaseObject",
    "IZOSAPI_Application",
    "IZOSAPI_Callback",
    "IZOSAPI_Connection",
    "LensUpdateMode",
    "LicenseStatusType",
    "OpticalSystemStatusChangedHandler",
    "SessionModes",
    "STARUpdateMode",
    "SystemType",
    "UpdateStatus",
    "ZOSAPI_Mode",
)

class IOpticalSystem:
    @property
    def SystemName(self) -> str: ...
    @SystemName.setter
    def SystemName(self, value: str) -> None: ...
    @property
    def SystemID(self) -> int: ...
    @property
    def Mode(self) -> SystemType: ...
    @property
    def SystemFile(self) -> str: ...
    @property
    def IsNonAxial(self) -> bool: ...
    @property
    def NeedsSave(self) -> bool: ...
    @property
    def SystemData(self) -> ISystemData: ...
    @property
    def LDE(self) -> ILensDataEditor: ...
    @property
    def NCE(self) -> INonSeqEditor: ...
    @property
    def TDE(self) -> IToleranceDataEditor: ...
    @property
    def MFE(self) -> IMeritFunctionEditor: ...
    @property
    def MCE(self) -> IMultiConfigEditor: ...
    @property
    def Analyses(self) -> I_Analyses: ...
    @property
    def Tools(self) -> IOpticalSystemTools: ...
    @property
    def TheApplication(self) -> IZOSAPI_Application: ...
    @property
    def UpdateMode(self) -> LensUpdateMode: ...
    @UpdateMode.setter
    def UpdateMode(self, value: LensUpdateMode) -> None: ...
    @property
    def SessionMode(self) -> SessionModes: ...
    @SessionMode.setter
    def SessionMode(self, value: SessionModes) -> None: ...
    @property
    def STARSubsystem(self) -> ISTARSubsystem: ...
    @property
    def IsProjectDirectory(self) -> bool: ...
    def Close(self, saveIfNeeded: bool) -> bool: ...
    def ConvertToProjectDirectory(self, folderPath: str) -> bool: ...
    def CopySystem(self) -> IOpticalSystem: ...
    def GetCurrentStatus(self) -> str: ...
    def GetMetadata(self) -> IMetadata: ...
    def LoadFile(self, LensFile: str, saveIfNeeded: bool) -> bool: ...
    def MakeNonSequential(self) -> bool: ...
    def MakeSequential(self) -> bool: ...
    def New(self, saveIfNeeded: bool) -> None: ...
    def Save(self) -> None: ...
    def SaveAs(self, fileName: str) -> None: ...
    def TurnOffProjectDirectory(self) -> bool: ...
    def UpdateFileLists(self) -> None: ...
    def UpdateStatus(self) -> str: ...

class IPreferences:
    @property
    def General(self) -> IPreferencesGeneral: ...
    @property
    def Folders(self) -> IPreferencesFolders: ...
    @property
    def Editor(self) -> IPreferencesEditor: ...
    @property
    def IsReadOnly(self) -> bool: ...
    def ResetToDefaults(self) -> None: ...

class ISTARMaterials:
    def GetDNDT(
        self,
        MaterialCatalog: str,
        Material: str,
        Wavelength: float,
        EnvironmentPressure: float,
        EnvironmentTemperature: float,
        MaterialPressure: float,
        MaterialTemperature: float,
        DeltaT: float,
    ) -> float: ...
    def GetRefractiveIndex(
        self,
        MaterialCatalog: str,
        Material: str,
        Wavelength: float,
        EnvironmentPressure: float,
        EnvironmentTemperature: float,
        MaterialPressure: float,
        MaterialTemperature: float,
    ) -> float: ...

class ISTARSubsystem:
    @property
    def UpdateMode(self) -> STARUpdateMode: ...
    @UpdateMode.setter
    def UpdateMode(self, value: STARUpdateMode) -> None: ...
    @property
    def Materials(self) -> ISTARMaterials: ...
    def DoManualUpdate(self) -> None: ...

class IZAPI_BaseObject:
    @property
    def Parent(self) -> IZAPI_BaseObject: ...
    def AddChild(self, child: IZAPI_BaseObject) -> None: ...
    def Disconnect(self) -> None: ...
    def RemoveChild(self, child: IZAPI_BaseObject) -> None: ...

class IZOSAPI_Application:
    @property
    def LicenseStatus(self) -> LicenseStatusType: ...
    @property
    def IsValidLicenseForAPI(self) -> bool: ...
    @property
    def InitializationErrors(self) -> str: ...
    @property
    def InitializationErrorCode(self) -> str: ...
    @property
    def Mode(self) -> ZOSAPI_Mode: ...
    @property
    def SerialCode(self) -> str: ...
    @property
    def OpticStudioVersion(self) -> int: ...
    @property
    def ExpirationYear(self) -> int: ...
    @property
    def ExpirationMonth(self) -> int: ...
    @property
    def ExpirationDay(self) -> int: ...
    @property
    def NumberOfOpticalSystems(self) -> int: ...
    @property
    def PrimarySystem(self) -> IOpticalSystem: ...
    @property
    def NumberOfCPUs(self) -> int: ...
    @property
    def ProgramDir(self) -> str: ...
    @property
    def LensDir(self) -> str: ...
    @property
    def ObjectsDir(self) -> str: ...
    @property
    def GlassDir(self) -> str: ...
    @property
    def ZPLDir(self) -> str: ...
    @property
    def CoatingDir(self) -> str: ...
    @property
    def POPDir(self) -> str: ...
    @property
    def ImagesDir(self) -> str: ...
    @property
    def SolidWorksFilesDir(self) -> str: ...
    @property
    def AutodeskInventorFilesDir(self) -> str: ...
    @property
    def CreoParametricFilesDir(self) -> str: ...
    @property
    def MATLABFilesDir(self) -> str: ...
    @property
    def ScatterDir(self) -> str: ...
    @property
    def UndoDir(self) -> str: ...
    @property
    def SamplesDir(self) -> str: ...
    @property
    def ZemaxDataDir(self) -> str: ...
    @property
    def OperandResults(self) -> IVectorData: ...
    @property
    def OperandArgument1(self) -> float: ...
    @property
    def OperandArgument2(self) -> float: ...
    @property
    def OperandArgument3(self) -> float: ...
    @property
    def OperandArgument4(self) -> float: ...
    @property
    def UserAnalysisData(self) -> IUserAnalysisData: ...
    @property
    def TerminateRequested(self) -> bool: ...
    @property
    def ShowChangesInUI(self) -> bool: ...
    @ShowChangesInUI.setter
    def ShowChangesInUI(self, value: bool) -> None: ...
    @property
    def ProgressMessage(self) -> str: ...
    @ProgressMessage.setter
    def ProgressMessage(self, value: str) -> None: ...
    @property
    def ProgressPercent(self) -> float: ...
    @ProgressPercent.setter
    def ProgressPercent(self, value: float) -> None: ...
    @property
    def CheckForUpdatesStatus(self) -> UpdateStatus: ...
    @property
    def CheckForUpdatesData(self) -> str: ...
    @property
    def CheckForUpdatesVersion(self) -> int: ...
    @property
    def Preferences(self) -> IPreferences: ...
    @property
    def IsLoggingMessages(self) -> bool: ...
    @property
    def ZOSMajorVersion(self) -> int: ...
    @property
    def ZOSMinorVersion(self) -> int: ...
    @property
    def ZOSSPVersion(self) -> int: ...
    @property
    def IsSubscriptionLicense(self) -> bool: ...
    @property
    def IsSTARModuleEnabled(self) -> bool: ...
    def BeginMessageLogging(self) -> bool: ...
    def CheckForUpdates(self) -> None: ...
    def ClearMessageLog(self) -> None: ...
    def CloseApplication(self) -> None: ...
    def CloseSystemAt(self, pos: int, saveIfNeeded: bool) -> bool: ...
    def CopySettingsData(self, from_: ISettingsData, to: ISettingsData) -> bool: ...
    def CreateDataFile(self, fileName: str, type: ZemaxFileTypes, data1: int, data2: int) -> IDataDictionary: ...
    def CreateNewSystem(self, mode: SystemType) -> IOpticalSystem: ...
    def CreateSettings(self) -> ISettingsData: ...
    def CreateSettingsFromParent(self, parent: IZAPI_BaseObject) -> ISettingsData: ...
    def EndMessageLogging(self) -> bool: ...
    def GetDate(self) -> str: ...
    def GetSystemAt(self, pos: int) -> IOpticalSystem: ...
    def LoadCCallback(self, cLib: str, callbackName: str, settings: ISettingsData) -> IZOSAPI_Callback: ...
    def LoadNETCallback(self, fromAssembly: str, typeName: str, settings: ISettingsData) -> IZOSAPI_Callback: ...
    def LoadNewSystem(self, LensFile: str) -> IOpticalSystem: ...
    def OpenDataFile(self, fileName: str) -> IDataDictionary: ...
    def RegisterCOperandCallback(self, cLib: str, callbackName: str, settings: ISettingsData) -> IMessage: ...
    def RegisterNETOperandCallback(self, fromAssembly: str, typeName: str, settings: ISettingsData) -> IMessage: ...
    def RetrieveLogMessages(self) -> str: ...
    def RunCommand(self, command: str) -> str: ...
    def UpdateFileLists(self) -> None: ...

class IZOSAPI_Callback:
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @property
    def IsLocal(self) -> bool: ...
    @property
    def Settings(self) -> ISettingsData: ...
    @property
    def TheApp(self) -> IZOSAPI_Application: ...
    def Copy(self, app: IZOSAPI_Application) -> IZOSAPI_Callback: ...
    def Execute(self) -> int: ...

class IZOSAPI_Connection:
    @property
    def IsAlive(self) -> bool: ...
    @property
    def InitializationSettings(self) -> str: ...
    @InitializationSettings.setter
    def InitializationSettings(self, value: str) -> None: ...
    @property
    def IntializationProgress(self) -> list[int]: ...
    @property
    def ConnectionTimeoutSeconds(self) -> float: ...
    @ConnectionTimeoutSeconds.setter
    def ConnectionTimeoutSeconds(self, value: float) -> None: ...
    @property
    def FormattingCulture(self) -> str: ...
    @FormattingCulture.setter
    def FormattingCulture(self, value: str) -> None: ...
    @property
    def PreferencesFile(self) -> str: ...
    @PreferencesFile.setter
    def PreferencesFile(self, value: str) -> None: ...
    def ConnectAsExtension(self, zemaxInstance: int) -> IZOSAPI_Application: ...
    def ConnectToApplication(self) -> IZOSAPI_Application: ...
    def CreateNewApplication(self) -> IZOSAPI_Application: ...
    def CreateZemaxServer(self, applicationName: str) -> IZOSAPI_Application: ...
    def CreateZemaxServerEx(self, applicationName: str, libraryPath: str) -> IZOSAPI_Application: ...
    def GetConfigSetting(self, setting: str) -> str: ...
    def RunCommand(self, command: str) -> str: ...
    def SetConfigSetting(self, setting: str, Value: str) -> None: ...
    def SetCreoInstallPath(self, path: str) -> None: ...

class LensUpdateMode:
    # None = 0
    EditorsOnly = 1
    AllWindows = 2

class LicenseStatusType:
    Unknown = 0
    KeyNotWorking = 1
    NewLicenseNeeded = 2
    StandardEdition = 3
    ProfessionalEdition = 4
    PremiumEdition = 5
    TooManyInstances = 6
    NotAuthorized = 7
    KeyNotFound = 8
    KeyExpired = 9
    Timeout = 10
    InstanceConflict = 11
    OpticsViewer = 12
    OpticStudioHPCEdition = 13
    EnterpriseEdition = 14

class OpticalSystemStatusChangedHandler:
    def __init__(self, object: Object, method: IntPtr): ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> Object: ...
    def BeginInvoke(self, systemId: int, newStatus: str, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, systemId: int, newStatus: str) -> None: ...

class SessionModes:
    FromPreferences = 0
    SessionOn = 1
    SessionOff = 2

class STARUpdateMode:
    Normal = 0
    Suspended = 1

class SystemType:
    Sequential = 0
    NonSequential = 1

class UpdateStatus:
    NotChecked = 0
    UpToDate = 1
    AvailableEligible = 2
    AvailableIneligible = 3
    CheckFailed = -2
    NotSupported = -1

class ZOSAPI_Mode:
    Server = 0
    Operand = 1
    Plugin = 2
    UserAnalysis = 3
    UserAnalysisSettings = 4
