/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import scala.collection.immutable.List;
import scala.package$;
import scala.xml.Utility$;
import scala.xml.include.sax.XIncludeFilter;

public class XIncluder
implements ContentHandler,
LexicalHandler {
    private final String encoding;
    private OutputStreamWriter out;
    private boolean inDTD;
    private List<String> entities;
    private XIncludeFilter filter;

    public XIncluder(OutputStream outs, String encoding) {
        this.encoding = encoding;
        this.out = new OutputStreamWriter(outs, encoding);
        this.inDTD = false;
        this.entities = package$.MODULE$.List().empty();
        this.filter = null;
    }

    public OutputStreamWriter out() {
        return this.out;
    }

    public void out_$eq(OutputStreamWriter x$1) {
        this.out = x$1;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
        try {
            this.out().write("<?xml version='1.0' encoding='" + this.encoding + "'?>\r\n");
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void endDocument() {
        try {
            this.out().flush();
        }
        catch (IOException e) {
            throw new SAXException("Flush failed", e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
        try {
            this.out().write("<" + qualifiedName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.out().write(" ");
                this.out().write(atts.getQName(i));
                this.out().write("='");
                String value = atts.getValue(i);
                this.out().write(Utility$.MODULE$.escape(value));
                this.out().write("'");
            }
            this.out().write(">");
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        try {
            this.out().write("</" + qualifiedName + ">");
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                char c = ch[start + i];
                if (c == '&') {
                    this.out().write("&amp;");
                    continue;
                }
                if (c == '<') {
                    this.out().write("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.out().write("&gt;");
                    continue;
                }
                this.out().write(c);
            }
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) {
        try {
            this.out().write("<?" + target + " " + data + "?>");
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void skippedEntity(String name) {
        try {
            this.out().write("&" + name + ";");
        }
        catch (IOException e) {
            throw new SAXException("Write failed", e);
        }
    }

    @Override
    public void startDTD(String name, String publicID, String systemID) {
        this.inDTD = true;
        if (this.entities.isEmpty()) {
            String id = "";
            if (publicID != null) {
                id = " PUBLIC \"" + publicID + "\" \"" + systemID + '\"';
            } else if (systemID != null) {
                id = " SYSTEM \"" + systemID + '\"';
            }
            try {
                this.out().write("<!DOCTYPE " + name + id + ">\r\n");
            }
            catch (IOException e) {
                throw new SAXException("Error while writing DOCTYPE", e);
            }
        }
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
        this.entities = this.entities.$colon$colon(name);
    }

    @Override
    public void endEntity(String name) {
        this.entities = (List)this.entities.tail();
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    public void setFilter(XIncludeFilter filter) {
        this.filter = filter;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        if (!this.inDTD && !this.filter.insideIncludeElement()) {
            try {
                this.out().write("<!--");
                this.out().write(ch, start, length);
                this.out().write("-->");
            }
            catch (IOException e) {
                throw new SAXException("Write failed", e);
            }
        }
    }
}

