/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BufferedIterator;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.xml.Utility$;
import scala.xml.parsing.TokenTests;

public interface MarkupParserCommon
extends TokenTests {
    public static Nothing$ unreachable$(MarkupParserCommon $this) {
        return $this.unreachable();
    }

    default public Nothing$ unreachable() {
        return this.truncatedError("Cannot be reached.");
    }

    public Object mkAttributes(String var1, Object var2);

    public Object mkProcInstr(Object var1, String var2, String var3);

    public static Tuple2 xTag$(MarkupParserCommon $this, Object pscope) {
        return $this.xTag(pscope);
    }

    default public Tuple2<String, Object> xTag(Object pscope) {
        String name = this.xName();
        this.xSpaceOpt();
        return Tuple2$.MODULE$.apply(name, this.mkAttributes(name, pscope));
    }

    public static Object xProcInstr$(MarkupParserCommon $this) {
        return $this.xProcInstr();
    }

    default public Object xProcInstr() {
        String n = this.xName();
        this.xSpaceOpt();
        return this.xTakeUntil((Function2<Object, String, Object> & Serializable)(_$1, _$2) -> this.mkProcInstr(_$1, n, (String)_$2), (Function0<Object> & Serializable)() -> this.tmppos(), "?>");
    }

    public static String xAttributeValue$(MarkupParserCommon $this, char endCh) {
        return $this.xAttributeValue(endCh);
    }

    default public String xAttributeValue(char endCh) {
        StringBuilder buf = new StringBuilder();
        while (this.ch() != endCh && !this.eof()) {
            if (this.ch() == '<') {
                this.reportSyntaxError("'<' not allowed in attrib value");
                continue;
            }
            if (this.ch() == '\u001a') {
                throw this.truncatedError("");
            }
            buf.append(this.ch_returning_nextch());
        }
        this.ch_returning_nextch();
        return buf.toString();
    }

    public static String xAttributeValue$(MarkupParserCommon $this) {
        return $this.xAttributeValue();
    }

    default public String xAttributeValue() {
        String str = this.xAttributeValue(this.ch_returning_nextch());
        return this.normalizeAttributeValue(str);
    }

    private String takeUntilChar(Iterator<Object> it, char end) {
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            char c = BoxesRunTime.unboxToChar(it.next());
            if (end == c) {
                return buf.toString();
            }
            char ch = c;
            buf.append(ch);
        }
        throw package$.MODULE$.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected '%s'"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToCharacter(end)})));
    }

    public static void xEndTag$(MarkupParserCommon $this, String startName) {
        $this.xEndTag(startName);
    }

    default public void xEndTag(String startName) {
        this.xToken('/');
        String string2 = this.xName();
        String string3 = startName;
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            throw this.errorNoEnd(startName);
        }
        this.xSpaceOpt();
        this.xToken('>');
    }

    public static String xName$(MarkupParserCommon $this) {
        return $this.xName();
    }

    default public String xName() {
        String string2;
        if (this.ch() == '\u001a') {
            throw this.truncatedError("");
        }
        if (!this.isNameStart(this.ch())) {
            return this.errorAndResult(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("name expected, but char '%s' cannot start a name"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToCharacter(this.ch())})), "");
        }
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(this.ch_returning_nextch());
        } while (this.isNameChar(this.ch()));
        if (BoxesRunTime.unboxToChar(buf.last()) == ':') {
            this.reportSyntaxError("name cannot end in ':'");
            string2 = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(buf.toString()), 1);
        } else {
            string2 = buf.toString();
        }
        return string2;
    }

    private String attr_unescape(String s) {
        String string2 = s;
        return "lt".equals(string2) ? "<" : ("gt".equals(string2) ? ">" : ("amp".equals(string2) ? "&" : ("apos".equals(string2) ? "'" : ("quot".equals(string2) ? "\"" : ("quote".equals(string2) ? "\"" : "&" + s + ";")))));
    }

    private String normalizeAttributeValue(String attval) {
        StringBuilder buf = new StringBuilder();
        BufferedIterator<Object> it = StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(attval)).buffered();
        while (it.hasNext()) {
            Object object;
            char c = BoxesRunTime.unboxToChar(it.next());
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    object = " ";
                    break;
                }
                case '&': {
                    if (BoxesRunTime.unboxToChar(it.head()) == '#') {
                        it.next();
                        object = this.xCharRef(it);
                        break;
                    }
                    object = this.attr_unescape(this.takeUntilChar(it, ';'));
                    break;
                }
                default: {
                    char c2 = c;
                    object = BoxesRunTime.boxToCharacter(c2);
                    break;
                }
            }
            buf.append(object);
        }
        return buf.toString();
    }

    public static String xCharRef$(MarkupParserCommon $this, Function0 ch, Function0 nextch) {
        return $this.xCharRef(ch, nextch);
    }

    default public String xCharRef(Function0<Object> ch, Function0<BoxedUnit> nextch) {
        return Utility$.MODULE$.parseCharRef(ch, nextch, str -> this.reportSyntaxError((String)str), msg -> {
            throw this.truncatedError((String)msg);
        });
    }

    public static String xCharRef$(MarkupParserCommon $this, Iterator it) {
        return $this.xCharRef(it);
    }

    default public String xCharRef(Iterator<Object> it) {
        CharRef c = CharRef.create(BoxesRunTime.unboxToChar(it.next()));
        return Utility$.MODULE$.parseCharRef((Function0<Object>)(Function0<char> & Serializable)() -> c$1.elem, () -> {
            char c;
            c$2.elem = c = BoxesRunTime.unboxToChar(it.next());
        }, str -> this.reportSyntaxError((String)str), msg -> {
            throw this.truncatedError((String)msg);
        });
    }

    public static String xCharRef$(MarkupParserCommon $this) {
        return $this.xCharRef();
    }

    default public String xCharRef() {
        return this.xCharRef((Function0<Object>)(Function0<char> & Serializable)() -> this.ch(), () -> this.nextch());
    }

    public BufferedIterator<Object> lookahead();

    public char ch();

    public void nextch();

    public char ch_returning_nextch();

    public boolean eof();

    public Object tmppos();

    public void tmppos_$eq(Object var1);

    public void xHandleError(char var1, String var2);

    public void reportSyntaxError(String var1);

    public void reportSyntaxError(int var1, String var2);

    public Nothing$ truncatedError(String var1);

    public Nothing$ errorNoEnd(String var1);

    public static Object errorAndResult$(MarkupParserCommon $this, String msg, Object x) {
        return $this.errorAndResult(msg, x);
    }

    default public <T> T errorAndResult(String msg, T x) {
        this.reportSyntaxError(msg);
        return x;
    }

    public static void xToken$(MarkupParserCommon $this, char that) {
        $this.xToken(that);
    }

    default public void xToken(char that) {
        if (this.ch() == that) {
            this.nextch();
        } else {
            this.xHandleError(that, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("'%s' expected instead of '%s'"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToCharacter(that), BoxesRunTime.boxToCharacter(this.ch())})));
        }
    }

    public static void xToken$(MarkupParserCommon $this, Seq that) {
        $this.xToken(that);
    }

    default public void xToken(Seq<Object> that) {
        that.foreach((Function1<Object, Object> & Serializable)v1 -> {
            this.xToken$$anonfun$1(BoxesRunTime.unboxToChar(v1));
            return BoxedUnit.UNIT;
        });
    }

    public static void xEQ$(MarkupParserCommon $this) {
        $this.xEQ();
    }

    default public void xEQ() {
        this.xSpaceOpt();
        this.xToken('=');
        this.xSpaceOpt();
    }

    public static void xSpaceOpt$(MarkupParserCommon $this) {
        $this.xSpaceOpt();
    }

    default public void xSpaceOpt() {
        while (this.isSpace(this.ch()) && !this.eof()) {
            this.nextch();
        }
    }

    public static void xSpace$(MarkupParserCommon $this) {
        $this.xSpace();
    }

    default public void xSpace() {
        if (this.isSpace(this.ch())) {
            this.nextch();
            this.xSpaceOpt();
        } else {
            this.xHandleError(this.ch(), "whitespace expected");
        }
    }

    public static Object returning$(MarkupParserCommon $this, Object x, Function1 f) {
        return $this.returning(x, f);
    }

    default public <T> T returning(T x, Function1<T, BoxedUnit> f) {
        f.apply(x);
        return x;
    }

    public static Object saving$(MarkupParserCommon $this, Object getter2, Function1 setter2, Function0 body) {
        return $this.saving(getter2, setter2, body);
    }

    default public <A, B> B saving(A getter2, Function1<A, BoxedUnit> setter2, Function0<B> body) {
        B b;
        A saved = getter2;
        try {
            b = body.apply();
        }
        finally {
            setter2.apply(saved);
        }
        return b;
    }

    public static Object xTakeUntil$(MarkupParserCommon $this, Function2 handler, Function0 positioner, String until) {
        return $this.xTakeUntil(handler, positioner, until);
    }

    default public <T> T xTakeUntil(Function2<Object, String, T> handler, Function0<Object> positioner, String until) {
        StringBuilder sb = new StringBuilder();
        char head = StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(until));
        String rest = StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(until));
        while (!this.eof()) {
            if (this.ch() == head && this.peek(rest)) {
                return handler.apply(positioner.apply(), sb.toString());
            }
            if (this.ch() == '\u001a' || this.eof()) {
                throw this.truncatedError("died parsing until " + until);
            }
            sb.append(this.ch());
            this.nextch();
        }
        throw this.unreachable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean peek(String lookingFor) {
        if (!this.lookahead().take(lookingFor.length()).sameElements(StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(lookingFor)))) return false;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), lookingFor.length()).foreach(_$3 -> this.nextch());
        if (!true) return false;
        return true;
    }

    private /* synthetic */ void xToken$$anonfun$1(char that) {
        this.xToken(that);
    }
}

