/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import org.pytorch.serve.http.ExtendedSSLHandler;
import org.pytorch.serve.http.HttpRequestHandler;
import org.pytorch.serve.http.HttpRequestHandlerChain;
import org.pytorch.serve.http.InvalidRequestHandler;
import org.pytorch.serve.http.TokenAuthorizationHandler;
import org.pytorch.serve.http.api.rest.ApiDescriptionRequestHandler;
import org.pytorch.serve.http.api.rest.InferenceRequestHandler;
import org.pytorch.serve.http.api.rest.ManagementRequestHandler;
import org.pytorch.serve.http.api.rest.OpenInferenceProtocolRequestHandler;
import org.pytorch.serve.http.api.rest.PrometheusMetricsRequestHandler;
import org.pytorch.serve.servingsdk.impl.PluginsManager;
import org.pytorch.serve.util.ConfigManager;
import org.pytorch.serve.util.ConnectorType;
import org.pytorch.serve.util.TokenType;
import org.pytorch.serve.workflow.api.http.WorkflowInferenceRequestHandler;
import org.pytorch.serve.workflow.api.http.WorkflowMgmtRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInitializer
extends ChannelInitializer<Channel> {
    private ConnectorType connectorType;
    private SslContext sslCtx;
    private static final Logger logger = LoggerFactory.getLogger(ServerInitializer.class);

    public ServerInitializer(SslContext sslCtx, ConnectorType type) {
        this.sslCtx = sslCtx;
        this.connectorType = type;
    }

    @Override
    public void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        ApiDescriptionRequestHandler apiDescriptionRequestHandler = new ApiDescriptionRequestHandler(this.connectorType);
        InvalidRequestHandler invalidRequestHandler = new InvalidRequestHandler();
        int maxRequestSize = ConfigManager.getInstance().getMaxRequestSize();
        if (this.sslCtx != null) {
            pipeline.addLast("ssl", (ChannelHandler)new ExtendedSSLHandler(this.sslCtx, this.connectorType));
        }
        pipeline.addLast("http", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxRequestSize));
        HttpRequestHandlerChain httpRequestHandlerChain = apiDescriptionRequestHandler;
        if (ConnectorType.ALL.equals((Object)this.connectorType) || ConnectorType.INFERENCE_CONNECTOR.equals((Object)this.connectorType)) {
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new TokenAuthorizationHandler(TokenType.INFERENCE));
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new InferenceRequestHandler(PluginsManager.getInstance().getInferenceEndpoints()));
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new WorkflowInferenceRequestHandler());
            if (ConfigManager.getInstance().isOpenInferenceProtocol()) {
                logger.info("OIP added with handler chain");
                httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new OpenInferenceProtocolRequestHandler());
            }
        }
        if (ConnectorType.ALL.equals((Object)this.connectorType) || ConnectorType.MANAGEMENT_CONNECTOR.equals((Object)this.connectorType)) {
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new TokenAuthorizationHandler(TokenType.MANAGEMENT));
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new ManagementRequestHandler(PluginsManager.getInstance().getManagementEndpoints()));
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new WorkflowMgmtRequestHandler());
        }
        if (ConfigManager.getInstance().isMetricApiEnable() && ConnectorType.ALL.equals((Object)this.connectorType) || ConnectorType.METRICS_CONNECTOR.equals((Object)this.connectorType)) {
            httpRequestHandlerChain = httpRequestHandlerChain.setNextHandler(new PrometheusMetricsRequestHandler());
        }
        httpRequestHandlerChain.setNextHandler(invalidRequestHandler);
        pipeline.addLast("handler", (ChannelHandler)new HttpRequestHandler(apiDescriptionRequestHandler));
    }
}

