/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.archive.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.pytorch.serve.archive.DownloadArchiveException;
import org.pytorch.serve.archive.model.InvalidModelException;
import org.pytorch.serve.archive.model.Manifest;
import org.pytorch.serve.archive.model.ModelConfig;
import org.pytorch.serve.archive.model.ModelException;
import org.pytorch.serve.archive.model.ModelNotFoundException;
import org.pytorch.serve.archive.utils.ArchiveUtils;
import org.pytorch.serve.archive.utils.InvalidArchiveURLException;
import org.pytorch.serve.archive.utils.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelArchive {
    private static final Logger logger = LoggerFactory.getLogger(ModelArchive.class);
    private static final String MANIFEST_FILE = "MANIFEST.json";
    private Manifest manifest;
    private String url;
    private File modelDir;
    private boolean extracted;
    private ModelConfig modelConfig;

    public ModelArchive(Manifest manifest, String url, File modelDir, boolean extracted) {
        this.manifest = manifest;
        this.url = url;
        this.modelDir = modelDir;
        this.extracted = extracted;
        this.modelConfig = null;
    }

    public static ModelArchive downloadModel(List<String> allowedUrls, String modelStore, String url) throws ModelException, FileAlreadyExistsException, IOException, DownloadArchiveException {
        return ModelArchive.downloadModel(allowedUrls, modelStore, url, false);
    }

    public static ModelArchive downloadModel(List<String> allowedUrls, String modelStore, String url, boolean s3SseKmsEnabled) throws ModelException, FileAlreadyExistsException, IOException, DownloadArchiveException {
        if (modelStore == null) {
            throw new ModelNotFoundException("Model store has not been configured.");
        }
        if (url == null || url.isEmpty()) {
            throw new ModelNotFoundException("empty url");
        }
        String marFileName = ArchiveUtils.getFilenameFromUrl(url);
        File modelLocation = new File(modelStore, marFileName);
        try {
            ArchiveUtils.downloadArchive(allowedUrls, modelLocation, marFileName, url, s3SseKmsEnabled);
        }
        catch (InvalidArchiveURLException e) {
            throw new ModelNotFoundException(e.getMessage());
        }
        if (url.contains("..")) {
            throw new ModelNotFoundException("Relative path is not allowed in url: " + url);
        }
        if (modelLocation.isFile()) {
            try (InputStream is = Files.newInputStream(modelLocation.toPath(), new OpenOption[0]);){
                File unzipDir = modelLocation.getName().endsWith(".mar") ? ZipUtils.unzip(is, null, "models", true) : ZipUtils.unzip(is, null, "models", false);
                ModelArchive modelArchive = ModelArchive.load(url, unzipDir, true);
                return modelArchive;
            }
        }
        File tempDir = ZipUtils.createTempDir(null, "models");
        logger.info("createTempDir {}", (Object)tempDir.getAbsolutePath());
        File directory = new File(url);
        if (directory.isDirectory()) {
            File[] fileList = directory.listFiles();
            if (fileList.length == 1 && fileList[0].isDirectory()) {
                File targetLink = ZipUtils.createSymbolicDir(fileList[0], tempDir);
                logger.info("createSymbolicDir {}", (Object)targetLink.getAbsolutePath());
                return ModelArchive.load(url, targetLink, false);
            }
            File targetLink = ZipUtils.createSymbolicDir(directory, tempDir);
            logger.info("createSymbolicDir {}", (Object)targetLink.getAbsolutePath());
            return ModelArchive.load(url, targetLink, false);
        }
        if (modelLocation.exists()) {
            File[] fileList = modelLocation.listFiles();
            if (fileList.length == 1 && fileList[0].isDirectory()) {
                File targetLink = ZipUtils.createSymbolicDir(fileList[0], tempDir);
                logger.info("createSymbolicDir {}", (Object)targetLink.getAbsolutePath());
                return ModelArchive.load(url, targetLink, false);
            }
            File targetLink = ZipUtils.createSymbolicDir(modelLocation, tempDir);
            logger.info("createSymbolicDir {}", (Object)targetLink.getAbsolutePath());
            return ModelArchive.load(url, targetLink, false);
        }
        throw new ModelNotFoundException("Model not found at: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModelArchive load(String url, File dir, boolean extracted) throws InvalidModelException, IOException {
        boolean failed = true;
        try {
            File manifestFile = new File(dir, "MAR-INF/MANIFEST.json");
            Manifest manifest = manifestFile.exists() ? ArchiveUtils.readFile(manifestFile, Manifest.class) : new Manifest();
            failed = false;
            ModelArchive modelArchive = new ModelArchive(manifest, url, dir, extracted);
            return modelArchive;
        }
        finally {
            if (failed) {
                if (Files.isSymbolicLink(dir.toPath())) {
                    FileUtils.deleteQuietly(dir.getParentFile());
                } else {
                    FileUtils.deleteQuietly(dir);
                }
            }
        }
    }

    public void validate() throws InvalidModelException {
        Manifest.Model model = this.manifest.getModel();
        try {
            if (model == null) {
                throw new InvalidModelException("Missing Model entry in manifest file.");
            }
            if (model.getModelName() == null) {
                throw new InvalidModelException("Model name is not defined.");
            }
            if (model.getModelVersion() == null) {
                throw new InvalidModelException("Model version is not defined.");
            }
            if (this.manifest.getRuntime() == null) {
                throw new InvalidModelException("Runtime is not defined or invalid.");
            }
            if (this.manifest.getArchiverVersion() == null) {
                logger.warn("Model archive version is not defined. Please upgrade to torch-model-archiver 0.2.0 or higher");
            }
            if (this.manifest.getCreatedOn() == null) {
                logger.warn("Model archive createdOn is not defined. Please upgrade to torch-model-archiver 0.2.0 or higher");
            }
        }
        catch (InvalidModelException e) {
            this.clean();
            throw e;
        }
    }

    public static void removeModel(String modelStore, String marURL) {
        if (ArchiveUtils.isValidURL(marURL)) {
            String marFileName = ArchiveUtils.getFilenameFromUrl(marURL);
            File modelLocation = new File(modelStore, marFileName);
            FileUtils.deleteQuietly(modelLocation);
        }
    }

    public String getHandler() {
        return this.manifest.getModel().getHandler();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getUrl() {
        return this.url;
    }

    public File getModelDir() {
        return this.modelDir;
    }

    public String getModelName() {
        return this.manifest.getModel().getModelName();
    }

    public String getModelVersion() {
        return this.manifest.getModel().getModelVersion();
    }

    public void clean() {
        if (this.url != null) {
            if (Files.isSymbolicLink(this.modelDir.toPath())) {
                FileUtils.deleteQuietly(this.modelDir.getParentFile());
            } else {
                FileUtils.deleteQuietly(this.modelDir);
            }
        }
    }

    public ModelConfig getModelConfig() {
        if (this.modelConfig == null && this.manifest.getModel().getConfigFile() != null) {
            try {
                File configFile = new File(this.modelDir.getAbsolutePath(), this.manifest.getModel().getConfigFile());
                Map<String, Object> modelConfigMap = ArchiveUtils.readYamlFile(configFile);
                this.modelConfig = ModelConfig.build(modelConfigMap);
            }
            catch (IOException | InvalidModelException e) {
                logger.error("Failed to parse model config file {}", (Object)this.manifest.getModel().getConfigFile(), (Object)e);
            }
        }
        return this.modelConfig;
    }
}

