/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.archive.s3;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.pytorch.serve.archive.s3.BinaryUtils;
import org.pytorch.serve.archive.s3.HttpUtils;

public class AWS4SignerBase {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    public static final String SCHEME = "AWS4";
    public static final String ALGORITHM = "HMAC-SHA256";
    public static final String TERMINATOR = "aws4_request";
    public static final String ISO8601BASICFORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DATASTRINGFORMAT = "yyyyMMdd";
    protected URL endpointUrl;
    protected String httpMethod;
    protected String serviceName;
    protected String regionName;
    protected final SimpleDateFormat dateTimeFormat;
    protected final SimpleDateFormat dateStampFormat;

    public AWS4SignerBase(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        this.endpointUrl = endpointUrl;
        this.httpMethod = httpMethod;
        this.serviceName = serviceName;
        this.regionName = regionName;
        this.dateTimeFormat = new SimpleDateFormat(ISO8601BASICFORMAT);
        this.dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        this.dateStampFormat = new SimpleDateFormat(DATASTRINGFORMAT);
        this.dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    protected static String getCanonicalizeHeaderNames(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }

    protected static String getCanonicalizedHeaderString(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(headers.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String key : sortedHeaders) {
            buffer.append(key.toLowerCase().replaceAll("\\s+", " ") + ":" + headers.get(key).replaceAll("\\s+", " "));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected static String getCanonicalRequest(URL endpoint, String httpMethod, String queryParameters, String canonicalizedHeaderNames, String canonicalizedHeaders, String bodyHash) throws UnsupportedEncodingException {
        return httpMethod + "\n" + AWS4SignerBase.getCanonicalizedResourcePath(endpoint) + "\n" + queryParameters + "\n" + canonicalizedHeaders + "\n" + canonicalizedHeaderNames + "\n" + bodyHash;
    }

    protected static String getCanonicalizedResourcePath(URL endpoint) throws UnsupportedEncodingException {
        if (endpoint == null) {
            return "/";
        }
        String path = endpoint.getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String encodedPath = HttpUtils.urlEncode(path, true);
        if (encodedPath.startsWith("/")) {
            return encodedPath;
        }
        return "/".concat(encodedPath);
    }

    public static String getCanonicalizedQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            sorted.put(HttpUtils.urlEncode(key, false), HttpUtils.urlEncode(value, false));
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            builder.append(pair.getKey());
            builder.append('=');
            builder.append(pair.getValue());
            if (!pairs.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    protected static String getStringToSign(String scheme, String algorithm, String dateTime, String scope, String canonicalRequest) {
        return scheme + "-" + algorithm + "\n" + dateTime + "\n" + scope + "\n" + BinaryUtils.toHex(AWS4SignerBase.hash(canonicalRequest));
    }

    public static byte[] hash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes("UTF-8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public static byte[] hash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected static byte[] sign(String stringData, byte[] key, String algorithm) {
        try {
            byte[] data = stringData.getBytes("UTF-8");
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }
}

