/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.archive.s3;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.pytorch.serve.archive.s3.AWS4SignerBase;
import org.pytorch.serve.archive.s3.BinaryUtils;

public class AWS4SignerForAuthorizationHeader
extends AWS4SignerBase {
    public AWS4SignerForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) throws UnsupportedEncodingException {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        StringBuilder hostHeader = new StringBuilder(this.endpointUrl.getHost());
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.append(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader.toString());
        String canonicalizedHeaderNames = AWS4SignerForAuthorizationHeader.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4SignerForAuthorizationHeader.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AWS4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4SignerForAuthorizationHeader.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        String stringToSign = AWS4SignerForAuthorizationHeader.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes();
        byte[] kDate = AWS4SignerForAuthorizationHeader.sign(dateStamp, kSecret, "HmacSHA256");
        byte[] kRegion = AWS4SignerForAuthorizationHeader.sign(this.regionName, kDate, "HmacSHA256");
        byte[] kService = AWS4SignerForAuthorizationHeader.sign(this.serviceName, kRegion, "HmacSHA256");
        byte[] kSigning = AWS4SignerForAuthorizationHeader.sign("aws4_request", kService, "HmacSHA256");
        byte[] signature = AWS4SignerForAuthorizationHeader.sign(stringToSign, kSigning, "HmacSHA256");
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + BinaryUtils.toHex(signature);
        return "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
    }
}

