/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.archive.s3;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.FileAlreadyExistsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.pytorch.serve.archive.s3.AWS4SignerForAuthorizationHeader;
import org.pytorch.serve.archive.utils.ArchiveUtils;
import org.pytorch.serve.archive.utils.InvalidArchiveURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyURLToFile(List<String> allowedUrls, String url, File modelLocation, boolean s3SseKmsEnabled, String archiveName) throws FileAlreadyExistsException, IOException, InvalidArchiveURLException {
        if (ArchiveUtils.validateURL(allowedUrls, url)) {
            if (modelLocation.exists()) {
                throw new FileAlreadyExistsException(archiveName);
            }
            if (archiveName.contains("/") || archiveName.contains("\\")) {
                throw new IOException("Security alert slash or backslash appear in archiveName:" + archiveName);
            }
            if (s3SseKmsEnabled) {
                String awsAccessKey = System.getenv("AWS_ACCESS_KEY_ID");
                String awsSecretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
                String regionName = System.getenv("AWS_DEFAULT_REGION");
                if (regionName.isEmpty() || awsAccessKey.isEmpty() || awsSecretKey.isEmpty()) {
                    throw new IOException("Miss environment variables AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY or AWS_DEFAULT_REGION");
                }
                HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
                AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(connection.getURL(), "GET", "s3", regionName);
                String authorization = signer.computeSignature(headers, null, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", awsAccessKey, awsSecretKey);
                headers.put("Authorization", authorization);
                HttpUtils.setHttpConnection(connection, "GET", headers);
                try {
                    FileUtils.copyInputStreamToFile(connection.getInputStream(), modelLocation);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            } else {
                URL endpointUrl = new URL(url);
                FileUtils.copyURLToFile(endpointUrl, modelLocation);
            }
        }
        return false;
    }

    public static void setHttpConnection(HttpURLConnection connection, String httpMethod, Map<String, String> headers) throws IOException {
        connection.setRequestMethod(httpMethod);
        if (headers != null) {
            for (String headerKey : headers.keySet()) {
                connection.setRequestProperty(headerKey, headers.get(headerKey));
            }
        }
    }

    public static String urlEncode(String url, boolean keepPathSlash) throws UnsupportedEncodingException {
        String encoded;
        try {
            encoded = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 encoding is not supported.", e);
            throw e;
        }
        if (keepPathSlash) {
            encoded = encoded.replace("%2F", "/");
        }
        return encoded;
    }
}

