/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.archive.workflow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.pytorch.serve.archive.DownloadArchiveException;
import org.pytorch.serve.archive.utils.ArchiveUtils;
import org.pytorch.serve.archive.utils.InvalidArchiveURLException;
import org.pytorch.serve.archive.utils.ZipUtils;
import org.pytorch.serve.archive.workflow.InvalidWorkflowException;
import org.pytorch.serve.archive.workflow.Manifest;
import org.pytorch.serve.archive.workflow.WorkflowException;
import org.pytorch.serve.archive.workflow.WorkflowNotFoundException;

public class WorkflowArchive {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String MANIFEST_FILE = "MANIFEST.json";
    private Manifest manifest;
    private String url;
    private File workflowDir;
    private boolean extracted;

    public WorkflowArchive(Manifest manifest, String url, File workflowDir, boolean extracted) {
        this.manifest = manifest;
        this.url = url;
        this.workflowDir = workflowDir;
        this.extracted = extracted;
    }

    public static WorkflowArchive downloadWorkflow(List<String> allowedUrls, String workflowStore, String url) throws WorkflowException, FileAlreadyExistsException, IOException, DownloadArchiveException {
        return WorkflowArchive.downloadWorkflow(allowedUrls, workflowStore, url, false);
    }

    public static WorkflowArchive downloadWorkflow(List<String> allowedUrls, String workflowStore, String url, boolean s3SseKmsEnabled) throws WorkflowException, FileAlreadyExistsException, IOException, DownloadArchiveException {
        if (workflowStore == null) {
            throw new WorkflowNotFoundException("Workflow store has not been configured.");
        }
        String warFileName = ArchiveUtils.getFilenameFromUrl(url);
        File workflowLocation = new File(workflowStore, warFileName);
        try {
            ArchiveUtils.downloadArchive(allowedUrls, workflowLocation, warFileName, url, s3SseKmsEnabled);
        }
        catch (InvalidArchiveURLException e) {
            throw new WorkflowNotFoundException(e.getMessage());
        }
        if (url.contains("..")) {
            throw new WorkflowNotFoundException("Relative path is not allowed in url: " + url);
        }
        if (!workflowLocation.exists()) {
            throw new WorkflowNotFoundException("Workflow not found in workflow store: " + url);
        }
        if (workflowLocation.isFile()) {
            try (InputStream is = Files.newInputStream(workflowLocation.toPath(), new OpenOption[0]);){
                File unzipDir = workflowLocation.getName().endsWith(".war") ? ZipUtils.unzip(is, null, "workflows", true) : ZipUtils.unzip(is, null, "workflows", false);
                WorkflowArchive workflowArchive = WorkflowArchive.load(url, unzipDir, true);
                return workflowArchive;
            }
        }
        throw new WorkflowNotFoundException("Workflow not found at: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkflowArchive load(String url, File dir, boolean extracted) throws InvalidWorkflowException, IOException {
        boolean failed = true;
        try {
            File manifestFile = new File(dir, "WAR-INF/MANIFEST.json");
            Manifest manifest = manifestFile.exists() ? WorkflowArchive.readFile(manifestFile, Manifest.class) : new Manifest();
            failed = false;
            WorkflowArchive workflowArchive = new WorkflowArchive(manifest, url, dir, extracted);
            return workflowArchive;
        }
        finally {
            if (extracted && failed) {
                FileUtils.deleteQuietly(dir);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readFile(File file, Class<T> type) throws InvalidWorkflowException, IOException {
        try (InputStreamReader r = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            T t = GSON.fromJson((Reader)r, type);
            return t;
        }
        catch (JsonParseException e) {
            throw new InvalidWorkflowException("Failed to parse signature.json.", e);
        }
    }

    public void validate() throws InvalidWorkflowException {
        Manifest.Workflow workflow = this.manifest.getWorkflow();
        try {
            if (workflow == null) {
                throw new InvalidWorkflowException("Missing Workflow entry in manifest file.");
            }
            if (workflow.getWorkflowName() == null) {
                throw new InvalidWorkflowException("Workflow name is not defined.");
            }
            if (this.manifest.getArchiverVersion() == null) {
                throw new InvalidWorkflowException("Workflow archive version is not defined.");
            }
            if (this.manifest.getCreatedOn() == null) {
                throw new InvalidWorkflowException("Workflow archive createdOn is not defined.");
            }
        }
        catch (InvalidWorkflowException e) {
            this.clean();
            throw e;
        }
    }

    public static void removeWorkflow(String workflowStore, String warURL) {
        if (ArchiveUtils.isValidURL(warURL)) {
            String warFileName = ArchiveUtils.getFilenameFromUrl(warURL);
            File workflowLocation = new File(workflowStore, warFileName);
            FileUtils.deleteQuietly(workflowLocation);
        }
    }

    public String getHandler() {
        return this.manifest.getWorkflow().getHandler();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getUrl() {
        return this.url;
    }

    public File getWorkflowDir() {
        return this.workflowDir;
    }

    public String getWorkflowName() {
        return this.manifest.getWorkflow().getWorkflowName();
    }

    public void clean() {
        if (this.url != null && this.extracted) {
            FileUtils.deleteQuietly(this.workflowDir);
        }
    }
}

