/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.ensemble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pytorch.serve.ensemble.DagExecutor;
import org.pytorch.serve.ensemble.InvalidDAGException;
import org.pytorch.serve.ensemble.Node;

public class Dag {
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Map<String, Map<String, Set<String>>> dagMap = new HashMap<String, Map<String, Set<String>>>();

    public void addNode(Node node) {
        if (!this.checkNodeExist(node)) {
            this.nodes.put(node.getName(), node);
            HashMap degreeMap = new HashMap();
            degreeMap.put("inDegree", new HashSet());
            degreeMap.put("outDegree", new HashSet());
            this.dagMap.put(node.getName(), degreeMap);
        }
    }

    public boolean checkNodeExist(Node node) {
        return this.nodes.containsKey(node.getName());
    }

    public boolean hasEdgeTo(Node from, Node to) {
        return this.dagMap.get(from.getName()).get("inDegree").contains(to.getName());
    }

    public void addEdge(Node from, Node to) throws InvalidDAGException {
        if (!this.checkNodeExist(from)) {
            this.addNode(from);
        }
        if (!this.checkNodeExist(to)) {
            this.addNode(to);
        }
        if (from.getName().equals(to.getName())) {
            throw new InvalidDAGException("Self loop exception");
        }
        if (this.hasEdgeTo(to, from)) {
            throw new InvalidDAGException("loop exception");
        }
        this.dagMap.get(from.getName()).get("outDegree").add(to.getName());
        this.dagMap.get(to.getName()).get("inDegree").add(from.getName());
    }

    public Set<String> getEndNodeNames(String degree) {
        HashSet<String> startNodes = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.dagMap.entrySet()) {
            Set<String> value = entry.getValue().get(degree);
            if (!value.isEmpty()) continue;
            startNodes.add(entry.getKey());
        }
        return startNodes;
    }

    public Set<String> getStartNodeNames() {
        return this.getEndNodeNames("inDegree");
    }

    public Set<String> getLeafNodeNames() {
        return this.getEndNodeNames("outDegree");
    }

    public Map<String, Integer> getDegreeMap(String degree) {
        HashMap<String, Integer> inDegreeMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.dagMap.entrySet()) {
            inDegreeMap.put(entry.getKey(), entry.getValue().get(degree).size());
        }
        return inDegreeMap;
    }

    public Map<String, Integer> getInDegreeMap() {
        return this.getDegreeMap("inDegree");
    }

    public Map<String, Integer> getOutDegreeMap() {
        return this.getDegreeMap("outDegree");
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    public Map<String, Map<String, Set<String>>> getDagMap() {
        return this.dagMap;
    }

    public ArrayList<String> validate() throws InvalidDAGException {
        Set<String> startNodes = this.getStartNodeNames();
        if (startNodes.size() != 1) {
            throw new InvalidDAGException("DAG should have only one start node");
        }
        ArrayList<String> topoSortedList = new ArrayList<String>();
        DagExecutor de = new DagExecutor(this);
        de.execute(null, topoSortedList);
        if (topoSortedList.size() != this.nodes.size()) {
            throw new InvalidDAGException("Not a valid DAG");
        }
        return topoSortedList;
    }
}

