/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.ensemble;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pytorch.serve.archive.workflow.InvalidWorkflowException;
import org.pytorch.serve.archive.workflow.WorkflowArchive;
import org.pytorch.serve.ensemble.Dag;
import org.pytorch.serve.ensemble.InvalidDAGException;
import org.pytorch.serve.ensemble.Node;
import org.pytorch.serve.ensemble.WorkflowModel;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class WorkFlow {
    private Map<String, Object> workflowSpec;
    private WorkflowArchive workflowArchive;
    private int minWorkers = 1;
    private int maxWorkers = 1;
    private int batchSize = 1;
    private int maxBatchDelay = 50;
    private int timeOutMs = 10000;
    private int retryAttempts = 1;
    private Dag dag = new Dag();

    public WorkFlow(WorkflowArchive workflowArchive) throws IOException, InvalidDAGException, InvalidWorkflowException {
        LinkedHashMap spec;
        this.workflowArchive = workflowArchive;
        File specFile = new File(this.workflowArchive.getWorkflowDir(), this.workflowArchive.getManifest().getWorkflow().getSpecFile());
        File handlerFile = new File(this.workflowArchive.getWorkflowDir(), this.workflowArchive.getManifest().getWorkflow().getHandler());
        String workFlowName = this.workflowArchive.getWorkflowName();
        HashMap<String, WorkflowModel> models = new HashMap<String, WorkflowModel>();
        this.workflowSpec = spec = (LinkedHashMap)WorkFlow.readSpecFile(specFile);
        Map modelsInfo = (Map)this.workflowSpec.get("models");
        block16: for (Map.Entry entry : modelsInfo.entrySet()) {
            String keyName;
            switch (keyName = (String)entry.getKey()) {
                case "min-workers": {
                    this.minWorkers = (Integer)entry.getValue();
                    continue block16;
                }
                case "max-workers": {
                    this.maxWorkers = (Integer)entry.getValue();
                    continue block16;
                }
                case "batch-size": {
                    this.batchSize = (Integer)entry.getValue();
                    continue block16;
                }
                case "max-batch-delay": {
                    this.maxBatchDelay = (Integer)entry.getValue();
                    continue block16;
                }
                case "retry-attempts": {
                    this.retryAttempts = (Integer)entry.getValue();
                    continue block16;
                }
                case "timeout-ms": {
                    this.timeOutMs = (Integer)entry.getValue();
                    continue block16;
                }
            }
            LinkedHashMap model = (LinkedHashMap)entry.getValue();
            String modelName = workFlowName + "__" + keyName;
            WorkflowModel wfm = new WorkflowModel(modelName, (String)model.get("url"), model.getOrDefault("min-workers", this.minWorkers), model.getOrDefault("max-workers", this.maxWorkers), model.getOrDefault("batch-size", this.batchSize), model.getOrDefault("max-batch-delay", this.maxBatchDelay), model.getOrDefault("retry-attempts", this.retryAttempts), model.getOrDefault("timeout-ms", this.timeOutMs), null);
            models.put(modelName, wfm);
        }
        Map dagInfo = (Map)this.workflowSpec.get("dag");
        for (Map.Entry entry : dagInfo.entrySet()) {
            String nodeName = (String)entry.getKey();
            String modelName = workFlowName + "__" + nodeName;
            WorkflowModel wfm = !models.containsKey(modelName) ? new WorkflowModel(modelName, null, 1, 1, 1, 0, this.retryAttempts, this.timeOutMs, handlerFile.getPath() + ":" + nodeName) : (WorkflowModel)models.get(modelName);
            Node fromNode = new Node(nodeName, wfm);
            this.dag.addNode(fromNode);
            ArrayList values = (ArrayList)entry.getValue();
            for (String toNodeName : values) {
                if (toNodeName == null || "".equals(toNodeName.strip())) continue;
                String toModelName = workFlowName + "__" + toNodeName;
                WorkflowModel toWfm = !models.containsKey(toModelName) ? new WorkflowModel(toModelName, null, 1, 1, 1, 0, this.retryAttempts, this.timeOutMs, handlerFile.getPath() + ":" + toNodeName) : (WorkflowModel)models.get(toModelName);
                Node toNode = new Node(toNodeName, toWfm);
                this.dag.addNode(toNode);
                this.dag.addEdge(fromNode, toNode);
            }
        }
        this.dag.validate();
    }

    private static Map<String, Object> readSpecFile(File file) throws IOException, InvalidWorkflowException {
        Map map;
        Yaml yaml = new Yaml();
        InputStreamReader r = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
        try {
            Map loadedYaml;
            map = loadedYaml = (Map)yaml.load(r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (YAMLException e) {
                throw new InvalidWorkflowException("Failed to parse yaml.", e);
            }
        }
        ((Reader)r).close();
        return map;
    }

    public Object getWorkflowSpec() {
        return this.workflowSpec;
    }

    public Dag getDag() {
        return this.dag;
    }

    public WorkflowArchive getWorkflowArchive() {
        return this.workflowArchive;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(int maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public String getWorkflowDag() {
        return this.workflowSpec.get("dag").toString();
    }
}

