/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.pytorch.serve.archive.DownloadArchiveException;
import org.pytorch.serve.archive.model.ModelException;
import org.pytorch.serve.archive.model.ModelNotFoundException;
import org.pytorch.serve.archive.model.ModelVersionNotFoundException;
import org.pytorch.serve.archive.workflow.WorkflowNotFoundException;
import org.pytorch.serve.http.BadRequestException;
import org.pytorch.serve.http.ConflictStatusException;
import org.pytorch.serve.http.HttpRequestHandlerChain;
import org.pytorch.serve.http.MethodNotAllowedException;
import org.pytorch.serve.http.RequestTimeoutException;
import org.pytorch.serve.http.ResourceNotFoundException;
import org.pytorch.serve.http.ServiceUnavailableException;
import org.pytorch.serve.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private HttpRequestHandlerChain handlerChain;

    public HttpRequestHandler() {
    }

    public HttpRequestHandler(HttpRequestHandlerChain chain) {
        this.handlerChain = chain;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        try {
            NettyUtils.requestReceived(ctx.channel(), req);
            if (!req.decoderResult().isSuccess()) {
                throw new BadRequestException("Invalid HTTP message.");
            }
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            String path = decoder.path();
            String[] segments = path.split("/");
            this.handlerChain.handleRequest(ctx, req, decoder, segments);
        }
        catch (ModelNotFoundException | ModelVersionNotFoundException | WorkflowNotFoundException | ResourceNotFoundException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.NOT_FOUND, e);
        }
        catch (DownloadArchiveException | ModelException | BadRequestException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.BAD_REQUEST, e);
        }
        catch (ConflictStatusException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.CONFLICT, e);
        }
        catch (RequestTimeoutException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.REQUEST_TIMEOUT, e);
        }
        catch (MethodNotAllowedException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, e);
        }
        catch (ServiceUnavailableException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, e);
        }
        catch (OutOfMemoryError e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.INSUFFICIENT_STORAGE, e);
        }
        catch (IllegalArgumentException e) {
            logger.error("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.FORBIDDEN, e);
        }
        catch (Throwable t) {
            logger.error("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, t);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("", cause);
        if (cause instanceof OutOfMemoryError) {
            NettyUtils.sendError(ctx, HttpResponseStatus.INSUFFICIENT_STORAGE, cause);
        }
        ctx.close();
    }
}

