/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.http.messages;

import com.google.gson.annotations.SerializedName;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.pytorch.serve.util.ConfigManager;
import org.pytorch.serve.util.GRPCUtils;
import org.pytorch.serve.util.NettyUtils;

public class RegisterModelRequest {
    public static final Integer DEFAULT_BATCH_SIZE = 1;
    public static final Integer DEFAULT_MAX_BATCH_DELAY = 100;
    @SerializedName(value="model_name")
    private String modelName;
    @SerializedName(value="runtime")
    private String runtime;
    @SerializedName(value="handler")
    private String handler;
    @SerializedName(value="batch_size")
    private int batchSize;
    @SerializedName(value="max_batch_delay")
    private int maxBatchDelay;
    @SerializedName(value="initial_workers")
    private int initialWorkers;
    @SerializedName(value="synchronous")
    private boolean synchronous;
    @SerializedName(value="response_timeout")
    private int responseTimeout;
    @SerializedName(value="url")
    private String modelUrl;
    @SerializedName(value="s3_sse_kms")
    private boolean s3SseKms;

    public RegisterModelRequest(QueryStringDecoder decoder) {
        this.modelName = NettyUtils.getParameter(decoder, "model_name", null);
        this.runtime = NettyUtils.getParameter(decoder, "runtime", null);
        this.handler = NettyUtils.getParameter(decoder, "handler", null);
        this.batchSize = NettyUtils.getIntParameter(decoder, "batch_size", -1 * DEFAULT_BATCH_SIZE);
        this.maxBatchDelay = NettyUtils.getIntParameter(decoder, "max_batch_delay", -1 * DEFAULT_MAX_BATCH_DELAY);
        this.initialWorkers = NettyUtils.getIntParameter(decoder, "initial_workers", ConfigManager.getInstance().getConfiguredDefaultWorkersPerModel());
        this.synchronous = Boolean.parseBoolean(NettyUtils.getParameter(decoder, "synchronous", "true"));
        this.responseTimeout = NettyUtils.getIntParameter(decoder, "response_timeout", -1);
        this.modelUrl = NettyUtils.getParameter(decoder, "url", null);
        this.s3SseKms = Boolean.parseBoolean(NettyUtils.getParameter(decoder, "s3_sse_kms", "false"));
    }

    public RegisterModelRequest(org.pytorch.serve.grpc.management.RegisterModelRequest request) {
        this.modelName = GRPCUtils.getRegisterParam(request.getModelName(), null);
        this.runtime = GRPCUtils.getRegisterParam(request.getRuntime(), null);
        this.handler = GRPCUtils.getRegisterParam(request.getHandler(), null);
        this.batchSize = GRPCUtils.getRegisterParam(request.getBatchSize(), -1 * DEFAULT_BATCH_SIZE);
        this.maxBatchDelay = GRPCUtils.getRegisterParam(request.getMaxBatchDelay(), -1 * DEFAULT_MAX_BATCH_DELAY);
        this.initialWorkers = GRPCUtils.getRegisterParam(request.getInitialWorkers(), ConfigManager.getInstance().getConfiguredDefaultWorkersPerModel());
        this.synchronous = request.getSynchronous();
        this.responseTimeout = GRPCUtils.getRegisterParam(request.getResponseTimeout(), -1);
        this.modelUrl = GRPCUtils.getRegisterParam(request.getUrl(), null);
        this.s3SseKms = request.getS3SseKms();
    }

    public RegisterModelRequest() {
        this.batchSize = -1 * DEFAULT_BATCH_SIZE;
        this.maxBatchDelay = -100 * DEFAULT_MAX_BATCH_DELAY;
        this.synchronous = true;
        this.initialWorkers = ConfigManager.getInstance().getConfiguredDefaultWorkersPerModel();
        this.responseTimeout = -1;
        this.s3SseKms = false;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getHandler() {
        return this.handler;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public Integer getInitialWorkers() {
        return this.initialWorkers;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public String getModelUrl() {
        return this.modelUrl;
    }

    public Boolean getS3SseKms() {
        return this.s3SseKms;
    }
}

