/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.job;

import java.util.Map;
import org.pytorch.serve.util.messages.RequestInput;
import org.pytorch.serve.util.messages.WorkerCommands;

public abstract class Job {
    private String modelName;
    private String modelVersion;
    private WorkerCommands cmd;
    private RequestInput input;
    private long begin;
    private long scheduled;

    public Job(String modelName, String version, WorkerCommands cmd, RequestInput input) {
        this.modelName = modelName;
        this.cmd = cmd;
        this.input = input;
        this.modelVersion = version;
        this.scheduled = this.begin = System.nanoTime();
        switch (cmd) {
            case STREAMPREDICT: {
                input.updateHeaders("ts_stream_next", "true");
                break;
            }
            case STREAMPREDICT2: {
                input.updateHeaders("ts_stream_next", "true");
                input.updateHeaders("ts_request_sequence_id", input.getSequenceId());
                break;
            }
        }
    }

    public String getJobId() {
        return this.input.getRequestId();
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public WorkerCommands getCmd() {
        return this.cmd;
    }

    public boolean isControlCmd() {
        switch (this.cmd) {
            case STREAMPREDICT: 
            case STREAMPREDICT2: 
            case PREDICT: 
            case OIPPREDICT: 
            case DESCRIBE: {
                return false;
            }
        }
        return true;
    }

    public RequestInput getPayload() {
        return this.input;
    }

    public void setScheduled() {
        this.scheduled = System.nanoTime();
    }

    public long getBegin() {
        return this.begin;
    }

    public long getScheduled() {
        return this.scheduled;
    }

    public abstract void response(byte[] var1, CharSequence var2, int var3, String var4, Map<String, String> var5);

    public abstract void sendError(int var1, String var2);

    public String getGroupId() {
        if (this.input != null) {
            return this.input.getSequenceId();
        }
        return null;
    }

    public abstract boolean isOpen();
}

