/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.pytorch.serve.metrics.IMetric;
import org.pytorch.serve.metrics.MetricBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMetric
extends IMetric {
    private static final Logger loggerTsMetrics = LoggerFactory.getLogger("TS_METRICS");
    private static final Logger loggerModelMetrics = LoggerFactory.getLogger("MODEL_METRICS");

    public LogMetric(MetricBuilder.MetricType type, String name, String unit, List<String> dimensionNames) {
        super(type, name, unit, dimensionNames);
    }

    @Override
    public void addOrUpdate(List<String> dimensionValues, double value) {
        String metricString = this.buildMetricString(dimensionValues, value);
        loggerTsMetrics.info(metricString);
    }

    @Override
    public void addOrUpdate(List<String> dimensionValues, String requestIds, double value) {
        String metricString = this.buildMetricString(dimensionValues, requestIds, value);
        loggerModelMetrics.info(metricString);
    }

    private String buildMetricString(List<String> dimensionValues, double value) {
        StringBuilder metricStringBuilder = new StringBuilder();
        metricStringBuilder.append(this.name).append('.').append(this.unit).append(':').append(value).append("|#");
        int dimensionsCount = Math.min(this.dimensionNames.size() - 1, dimensionValues.size() - 1);
        ArrayList<String> dimensions = new ArrayList<String>();
        for (int index = 0; index < dimensionsCount; ++index) {
            dimensions.add((String)this.dimensionNames.get(index) + ":" + dimensionValues.get(index));
        }
        metricStringBuilder.append(dimensions.stream().collect(Collectors.joining(",")));
        metricStringBuilder.append("|#hostname:").append(dimensionValues.get(dimensionValues.size() - 1));
        metricStringBuilder.append(",timestamp:").append(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return metricStringBuilder.toString();
    }

    private String buildMetricString(List<String> dimensionValues, String requestIds, double value) {
        StringBuilder metricStringBuilder = new StringBuilder();
        metricStringBuilder.append(this.name).append('.').append(this.unit).append(':').append(value).append("|#");
        int dimensionsCount = Math.min(this.dimensionNames.size() - 1, dimensionValues.size() - 1);
        ArrayList<String> dimensions = new ArrayList<String>();
        for (int index = 0; index < dimensionsCount; ++index) {
            dimensions.add((String)this.dimensionNames.get(index) + ":" + dimensionValues.get(index));
        }
        metricStringBuilder.append(dimensions.stream().collect(Collectors.joining(",")));
        metricStringBuilder.append("|#hostname:").append(dimensionValues.get(dimensionValues.size() - 1));
        metricStringBuilder.append(",requestID:").append(requestIds);
        metricStringBuilder.append(",timestamp:").append(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return metricStringBuilder.toString();
    }
}

