/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.openapi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pytorch.serve.openapi.MediaType;

public class Response {
    private transient String code;
    private String description;
    private Map<String, MediaType> content;

    public Response() {
    }

    public Response(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public Response(String code, String description, MediaType mediaType) {
        this.code = code;
        this.description = description;
        this.content = new LinkedHashMap<String, MediaType>();
        this.content.put(mediaType.getContentType(), mediaType);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, MediaType> getContent() {
        return this.content;
    }

    public void setContent(Map<String, MediaType> content) {
        this.content = content;
    }

    public void addContent(MediaType mediaType) {
        if (this.content == null) {
            this.content = new LinkedHashMap<String, MediaType>();
        }
        this.content.put(mediaType.getContentType(), mediaType);
    }
}

