/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.servingsdk.impl;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pytorch.serve.servingsdk.http.Request;
import org.pytorch.serve.util.NettyUtils;

public class ModelServerRequest
implements Request {
    private FullHttpRequest req;
    private QueryStringDecoder decoder;

    public ModelServerRequest(FullHttpRequest r, QueryStringDecoder d) {
        this.req = r;
        this.decoder = d;
    }

    @Override
    public List<String> getHeaderNames() {
        return new ArrayList<String>(this.req.headers().names());
    }

    @Override
    public String getRequestURI() {
        return this.req.uri();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.decoder.parameters();
    }

    @Override
    public List<String> getParameter(String k) {
        return this.decoder.parameters().get(k);
    }

    @Override
    public String getContentType() {
        return HttpUtil.getMimeType(this.req).toString();
    }

    @Override
    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(NettyUtils.getBytes(this.req.content()));
    }
}

