/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.servingsdk.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.pytorch.serve.http.InvalidPluginException;
import org.pytorch.serve.http.TokenAuthorizationHandler;
import org.pytorch.serve.servingsdk.ModelServerEndpoint;
import org.pytorch.serve.servingsdk.annotations.Endpoint;
import org.pytorch.serve.servingsdk.annotations.helpers.EndpointTypes;
import org.pytorch.serve.servingsdk.snapshot.SnapshotSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginsManager {
    private static final PluginsManager INSTANCE = new PluginsManager();
    private Logger logger = LoggerFactory.getLogger(PluginsManager.class);
    private Map<String, ModelServerEndpoint> inferenceEndpoints;
    private Map<String, ModelServerEndpoint> managementEndpoints;

    private PluginsManager() {
    }

    public static PluginsManager getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        this.logger.info("Initializing plugins manager...");
        this.inferenceEndpoints = this.initInferenceEndpoints();
        this.managementEndpoints = this.initManagementEndpoints();
        if (this.managementEndpoints.containsKey("token")) {
            TokenAuthorizationHandler.setupTokenClass();
        }
    }

    private boolean validateEndpointPlugin(Annotation a, EndpointTypes type) {
        return a instanceof Endpoint && !((Endpoint)a).urlPattern().isEmpty() && ((Endpoint)a).endpointType().equals((Object)type);
    }

    public SnapshotSerializer getSnapShotSerializer() {
        this.logger.info(" Loading snapshot serializer plugin...");
        ServiceLoader<SnapshotSerializer> loader = ServiceLoader.load(SnapshotSerializer.class);
        if (loader.findFirst().isPresent()) {
            SnapshotSerializer snapShotSerializer = loader.findFirst().get();
            this.logger.info("Snapshot serializer plugin has been loaded successfully");
            return snapShotSerializer;
        }
        return null;
    }

    private HashMap<String, ModelServerEndpoint> getEndpoints(EndpointTypes type) throws InvalidPluginException {
        ServiceLoader<ModelServerEndpoint> loader = ServiceLoader.load(ModelServerEndpoint.class);
        HashMap<String, ModelServerEndpoint> ep = new HashMap<String, ModelServerEndpoint>();
        for (ModelServerEndpoint mep : loader) {
            Annotation[] annotations;
            Class<?> modelServerEndpointClassObj = mep.getClass();
            for (Annotation a : annotations = modelServerEndpointClassObj.getAnnotations()) {
                if (!this.validateEndpointPlugin(a, type)) continue;
                if (ep.get(((Endpoint)a).urlPattern()) != null) {
                    throw new InvalidPluginException("Multiple plugins found for endpoint \"" + ((Endpoint)a).urlPattern() + "\"");
                }
                this.logger.info("Loading plugin for endpoint {}", (Object)((Endpoint)a).urlPattern());
                ep.put(((Endpoint)a).urlPattern(), mep);
            }
        }
        return ep;
    }

    private HashMap<String, ModelServerEndpoint> initInferenceEndpoints() {
        return this.getEndpoints(EndpointTypes.INFERENCE);
    }

    private HashMap<String, ModelServerEndpoint> initManagementEndpoints() {
        return this.getEndpoints(EndpointTypes.MANAGEMENT);
    }

    public Map<String, ModelServerEndpoint> getInferenceEndpoints() {
        return this.inferenceEndpoints;
    }

    public Map<String, ModelServerEndpoint> getManagementEndpoints() {
        return this.managementEndpoints;
    }
}

