/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.pytorch.serve.archive.model.Manifest;
import org.pytorch.serve.metrics.MetricBuilder;
import org.pytorch.serve.servingsdk.snapshot.SnapshotSerializer;
import org.pytorch.serve.snapshot.SnapshotSerializerFactory;
import org.pytorch.serve.util.Connector;
import org.pytorch.serve.util.ConnectorType;
import org.pytorch.serve.util.JsonUtils;
import org.pytorch.serve.util.OpenSslKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigManager {
    private static final String TS_DEBUG = "debug";
    private static final String TS_INFERENCE_ADDRESS = "inference_address";
    private static final String TS_MANAGEMENT_ADDRESS = "management_address";
    private static final String TS_METRICS_ADDRESS = "metrics_address";
    private static final String TS_LOAD_MODELS = "load_models";
    private static final String TS_BLACKLIST_ENV_VARS = "blacklist_env_vars";
    private static final String TS_DEFAULT_WORKERS_PER_MODEL = "default_workers_per_model";
    private static final String TS_DEFAULT_RESPONSE_TIMEOUT = "default_response_timeout";
    private static final String TS_UNREGISTER_MODEL_TIMEOUT = "unregister_model_timeout";
    private static final String TS_NUMBER_OF_NETTY_THREADS = "number_of_netty_threads";
    private static final String TS_NETTY_CLIENT_THREADS = "netty_client_threads";
    private static final String TS_JOB_QUEUE_SIZE = "job_queue_size";
    private static final String TS_NUMBER_OF_GPU = "number_of_gpu";
    private static final String TS_METRICS_CONFIG = "metrics_config";
    private static final String TS_METRICS_MODE = "metrics_mode";
    private static final String TS_MODEL_METRICS_AUTO_DETECT = "model_metrics_auto_detect";
    private static final String TS_DISABLE_SYSTEM_METRICS = "disable_system_metrics";
    private static final String TS_IPEX_ENABLE = "ipex_enable";
    private static final String TS_CPU_LAUNCHER_ENABLE = "cpu_launcher_enable";
    private static final String TS_CPU_LAUNCHER_ARGS = "cpu_launcher_args";
    private static final String TS_ASYNC_LOGGING = "async_logging";
    private static final String TS_CORS_ALLOWED_ORIGIN = "cors_allowed_origin";
    private static final String TS_CORS_ALLOWED_METHODS = "cors_allowed_methods";
    private static final String TS_CORS_ALLOWED_HEADERS = "cors_allowed_headers";
    private static final String TS_DECODE_INPUT_REQUEST = "decode_input_request";
    private static final String TS_KEYSTORE = "keystore";
    private static final String TS_KEYSTORE_PASS = "keystore_pass";
    private static final String TS_KEYSTORE_TYPE = "keystore_type";
    private static final String TS_CERTIFICATE_FILE = "certificate_file";
    private static final String TS_PRIVATE_KEY_FILE = "private_key_file";
    private static final String TS_MAX_REQUEST_SIZE = "max_request_size";
    private static final String TS_MAX_RESPONSE_SIZE = "max_response_size";
    private static final String TS_LIMIT_MAX_IMAGE_PIXELS = "limit_max_image_pixels";
    private static final String TS_DEFAULT_SERVICE_HANDLER = "default_service_handler";
    private static final String TS_SERVICE_ENVELOPE = "service_envelope";
    private static final String TS_MODEL_SERVER_HOME = "model_server_home";
    private static final String TS_MODEL_STORE = "model_store";
    private static final String TS_PREFER_DIRECT_BUFFER = "prefer_direct_buffer";
    private static final String TS_ALLOWED_URLS = "allowed_urls";
    private static final String TS_INSTALL_PY_DEP_PER_MODEL = "install_py_dep_per_model";
    private static final String TS_ENABLE_METRICS_API = "enable_metrics_api";
    private static final String TS_GRPC_INFERENCE_PORT = "grpc_inference_port";
    private static final String TS_GRPC_MANAGEMENT_PORT = "grpc_management_port";
    private static final String TS_ENABLE_GRPC_SSL = "enable_grpc_ssl";
    private static final String TS_INITIAL_WORKER_PORT = "initial_worker_port";
    private static final String TS_INITIAL_DISTRIBUTION_PORT = "initial_distribution_port";
    private static final String TS_WORKFLOW_STORE = "workflow_store";
    private static final String TS_CPP_LOG_CONFIG = "cpp_log_config";
    private static final String TS_OPEN_INFERENCE_PROTOCOL = "ts_open_inference_protocol";
    private static final String TS_TOKEN_EXPIRATION_TIME_MIN = "token_expiration_min";
    private static final String USE_NATIVE_IO = "use_native_io";
    private static final String IO_RATIO = "io_ratio";
    private static final String METRIC_TIME_INTERVAL = "metric_time_interval";
    private static final String ENABLE_ENVVARS_CONFIG = "enable_envvars_config";
    private static final String MODEL_SNAPSHOT = "model_snapshot";
    private static final String MODEL_CONFIG = "models";
    private static final String VERSION = "version";
    private static final String SYSTEM_METRICS_CMD = "system_metrics_cmd";
    private static final String DEFAULT_TS_ALLOWED_URLS = "file://.*|http(s)?://.*";
    private static final String USE_ENV_ALLOWED_URLS = "use_env_allowed_urls";
    public static final String MODEL_METRICS_LOGGER = "MODEL_METRICS";
    public static final String MODEL_LOGGER = "MODEL_LOG";
    public static final String MODEL_SERVER_METRICS_LOGGER = "TS_METRICS";
    public static final String MODEL_SERVER_TELEMETRY_LOGGER = "TELEMETRY_METRICS";
    public static final String METRIC_FORMAT_PROMETHEUS = "prometheus";
    public static final String PYTHON_EXECUTABLE = "python";
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("((https|http)://([^:^/]+)(:([0-9]+))?)|(unix:(/.*))", 2);
    private static Pattern pattern = Pattern.compile("\\$\\$([^$]+[^$])\\$\\$");
    private Pattern blacklistPattern;
    private Properties prop;
    private boolean snapshotDisabled;
    private static ConfigManager instance;
    private String hostName;
    private Map<String, Map<String, JsonObject>> modelConfig = new HashMap<String, Map<String, JsonObject>>();
    private String torchrunLogDir;
    private boolean telemetryEnabled;
    private Logger logger = LoggerFactory.getLogger(ConfigManager.class);

    private ConfigManager(Arguments args) throws IOException {
        CharSequence[] models;
        String workflowStore;
        File tsConfigFile;
        String logLocation;
        this.prop = new Properties();
        this.snapshotDisabled = args.isSnapshotDisabled();
        String version = ConfigManager.readFile(this.getModelServerHome() + "/ts/version.txt");
        if (version != null) {
            version = version.replaceAll("[\\n\\t ]", "");
            this.prop.setProperty(VERSION, version);
        }
        if ((logLocation = System.getenv("LOG_LOCATION")) != null) {
            System.setProperty("LOG_LOCATION", logLocation);
        } else if (System.getProperty("LOG_LOCATION") == null) {
            System.setProperty("LOG_LOCATION", "logs");
        }
        String metricsLocation = System.getenv("METRICS_LOCATION");
        if (metricsLocation != null) {
            System.setProperty("METRICS_LOCATION", metricsLocation);
        } else if (System.getProperty("METRICS_LOCATION") == null) {
            System.setProperty("METRICS_LOCATION", "logs");
        }
        String filePath = System.getenv("TS_CONFIG_FILE");
        Properties snapshotConfig = null;
        if (filePath == null && (filePath = args.getTsConfigFile()) == null) {
            snapshotConfig = this.getLastSnapshot();
            if (snapshotConfig == null) {
                filePath = System.getProperty("tsConfigFile", "config.properties");
            } else {
                this.prop.putAll((Map<?, ?>)snapshotConfig);
            }
        }
        if (filePath != null && (tsConfigFile = new File(filePath)).exists()) {
            try (InputStream stream = Files.newInputStream(tsConfigFile.toPath(), new OpenOption[0]);){
                this.prop.load(stream);
                this.prop.put("tsConfigFile", filePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read configuration file", e);
            }
        }
        this.telemetryEnabled = System.getenv("SM_TELEMETRY_LOG") != null;
        this.resolveEnvVarVals(this.prop);
        String modelStore = args.getModelStore();
        if (modelStore != null) {
            this.prop.setProperty(TS_MODEL_STORE, modelStore);
        }
        if ((workflowStore = args.getWorkflowStore()) != null) {
            this.prop.setProperty(TS_WORKFLOW_STORE, workflowStore);
        } else if (this.prop.getProperty(TS_WORKFLOW_STORE) == null) {
            this.prop.setProperty(TS_WORKFLOW_STORE, this.prop.getProperty(TS_MODEL_STORE));
        }
        String cppLogConfigFile = args.getCppLogConfigFile();
        if (cppLogConfigFile != null) {
            this.prop.setProperty(TS_CPP_LOG_CONFIG, cppLogConfigFile);
        }
        if ((models = args.getModels()) != null) {
            this.prop.setProperty(TS_LOAD_MODELS, String.join((CharSequence)",", models));
        }
        this.prop.setProperty(TS_NUMBER_OF_GPU, String.valueOf(Integer.min(ConfigManager.getAvailableGpu(), this.getIntProperty(TS_NUMBER_OF_GPU, Integer.MAX_VALUE))));
        String pythonExecutable = args.getPythonExecutable();
        if (pythonExecutable != null) {
            this.prop.setProperty(PYTHON_EXECUTABLE, pythonExecutable);
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            this.hostName = ip.getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "Unknown";
        }
        if (Boolean.parseBoolean(this.prop.getProperty(TS_ASYNC_LOGGING))) {
            this.enableAsyncLogging();
        }
        if (Boolean.parseBoolean(this.getEnableEnvVarsConfig())) {
            this.setSystemVars();
        }
        this.setModelConfig();
        if (this.prop.getProperty(TS_ALLOWED_URLS, DEFAULT_TS_ALLOWED_URLS) == DEFAULT_TS_ALLOWED_URLS) {
            this.logger.warn("Your torchserve instance can access any URL to load models. When deploying to production, make sure to limit the set of allowed_urls in config.properties");
        }
    }

    public static String readFile(String path) throws IOException {
        return Files.readString(Paths.get(path, new String[0]));
    }

    private void resolveEnvVarVals(Properties prop) {
        Set<String> keys = prop.stringPropertyNames();
        for (String key : keys) {
            String val = prop.getProperty(key);
            Matcher matcher = pattern.matcher(val);
            if (!matcher.find()) continue;
            StringBuffer sb = new StringBuffer();
            do {
                String envVar;
                if (System.getenv(envVar = matcher.group(1)) == null) {
                    throw new IllegalArgumentException("Invalid Environment Variable " + envVar);
                }
                matcher.appendReplacement(sb, System.getenv(envVar));
            } while (matcher.find());
            matcher.appendTail(sb);
            prop.setProperty(key, sb.toString());
        }
    }

    private void setSystemVars() {
        Field[] fields;
        Class<ConfigManager> configClass = ConfigManager.class;
        for (Field f : fields = configClass.getDeclaredFields()) {
            String val;
            if ("TS_ALLOWED_URLS".equals(f.getName()) && !"true".equals(this.prop.getProperty(USE_ENV_ALLOWED_URLS, "false").toLowerCase()) || !f.getName().startsWith("TS_") || (val = System.getenv(f.getName())) == null) continue;
            try {
                this.prop.setProperty((String)f.get(ConfigManager.class), val);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public String getEnableEnvVarsConfig() {
        return this.prop.getProperty(ENABLE_ENVVARS_CONFIG, "false");
    }

    public String getHostName() {
        return this.hostName;
    }

    public static void init(Arguments args) throws IOException {
        instance = new ConfigManager(args);
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public boolean isDebug() {
        return Boolean.getBoolean("TS_DEBUG") || Boolean.parseBoolean(this.prop.getProperty(TS_DEBUG, "false"));
    }

    public Connector getListener(ConnectorType connectorType) {
        String binding;
        switch (connectorType) {
            case MANAGEMENT_CONNECTOR: {
                binding = this.prop.getProperty(TS_MANAGEMENT_ADDRESS, "http://127.0.0.1:8081");
                break;
            }
            case METRICS_CONNECTOR: {
                binding = this.prop.getProperty(TS_METRICS_ADDRESS, "http://127.0.0.1:8082");
                break;
            }
            default: {
                binding = this.prop.getProperty(TS_INFERENCE_ADDRESS, "http://127.0.0.1:8080");
            }
        }
        return Connector.parse(binding, connectorType);
    }

    public int getGRPCPort(ConnectorType connectorType) {
        String port = connectorType == ConnectorType.MANAGEMENT_CONNECTOR ? this.prop.getProperty(TS_GRPC_MANAGEMENT_PORT, "7071") : this.prop.getProperty(TS_GRPC_INFERENCE_PORT, "7070");
        return Integer.parseInt(port);
    }

    public boolean isOpenInferenceProtocol() {
        String inferenceProtocol = System.getenv("TS_OPEN_INFERENCE_PROTOCOL");
        if (inferenceProtocol != null && inferenceProtocol != "") {
            return "oip".equals(inferenceProtocol);
        }
        return Boolean.parseBoolean(this.prop.getProperty(TS_OPEN_INFERENCE_PROTOCOL, "false"));
    }

    public boolean isGRPCSSLEnabled() {
        return Boolean.parseBoolean(this.getProperty(TS_ENABLE_GRPC_SSL, "false"));
    }

    public boolean getPreferDirectBuffer() {
        return Boolean.parseBoolean(this.getProperty(TS_PREFER_DIRECT_BUFFER, "false"));
    }

    public boolean getInstallPyDepPerModel() {
        return Boolean.parseBoolean(this.getProperty(TS_INSTALL_PY_DEP_PER_MODEL, "false"));
    }

    public boolean isMetricApiEnable() {
        return Boolean.parseBoolean(this.getProperty(TS_ENABLE_METRICS_API, "true"));
    }

    public boolean isCPULauncherEnabled() {
        return Boolean.parseBoolean(this.getProperty(TS_CPU_LAUNCHER_ENABLE, "false"));
    }

    public String getCPULauncherArgs() {
        return this.getProperty(TS_CPU_LAUNCHER_ARGS, null);
    }

    public int getNettyThreads() {
        return this.getIntProperty(TS_NUMBER_OF_NETTY_THREADS, 0);
    }

    public int getNettyClientThreads() {
        return this.getIntProperty(TS_NETTY_CLIENT_THREADS, 0);
    }

    public int getJobQueueSize() {
        return this.getIntProperty(TS_JOB_QUEUE_SIZE, 100);
    }

    public int getNumberOfGpu() {
        return this.getIntProperty(TS_NUMBER_OF_GPU, 0);
    }

    public String getMetricsConfigPath() {
        String path = ConfigManager.getCanonicalPath(this.prop.getProperty(TS_METRICS_CONFIG));
        if (path == null) {
            path = this.getModelServerHome() + "/ts/configs/metrics.yaml";
        }
        return path;
    }

    public String getTorchRunLogDir() {
        if (this.torchrunLogDir == null) {
            this.torchrunLogDir = Paths.get(ConfigManager.getCanonicalPath(System.getProperty("LOG_LOCATION")), "torchelastic_ts").toString();
        }
        return this.torchrunLogDir;
    }

    public MetricBuilder.MetricMode getMetricsMode() {
        String metricsMode = this.getProperty(TS_METRICS_MODE, "log");
        try {
            return MetricBuilder.MetricMode.valueOf(metricsMode.replaceAll("\\s", "").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.logger.error("Configured metrics mode \"{}\" not supported. Defaulting to \"{}\" mode: {}", new Object[]{metricsMode, MetricBuilder.MetricMode.LOG, e});
            return MetricBuilder.MetricMode.LOG;
        }
    }

    public boolean isModelMetricsAutoDetectEnabled() {
        return Boolean.parseBoolean(this.getProperty(TS_MODEL_METRICS_AUTO_DETECT, "false"));
    }

    public boolean isSystemMetricsDisabled() {
        return Boolean.parseBoolean(this.getProperty(TS_DISABLE_SYSTEM_METRICS, "false"));
    }

    public String getTsDefaultServiceHandler() {
        return this.getProperty(TS_DEFAULT_SERVICE_HANDLER, null);
    }

    public String getTsServiceEnvelope() {
        return this.getProperty(TS_SERVICE_ENVELOPE, null);
    }

    public Properties getConfiguration() {
        return (Properties)this.prop.clone();
    }

    public int getConfiguredDefaultWorkersPerModel() {
        return this.getIntProperty(TS_DEFAULT_WORKERS_PER_MODEL, 0);
    }

    public int getDefaultWorkers() {
        if (this.isDebug()) {
            return 1;
        }
        int workers = this.getConfiguredDefaultWorkersPerModel();
        if (workers == 0) {
            workers = this.getNumberOfGpu();
        }
        if (workers == 0) {
            workers = Runtime.getRuntime().availableProcessors();
        }
        return workers;
    }

    public int getMetricTimeInterval() {
        return this.getIntProperty(METRIC_TIME_INTERVAL, 60);
    }

    public String getModelServerHome() {
        String tsHome = System.getenv("TS_MODEL_SERVER_HOME");
        if (tsHome == null && (tsHome = System.getProperty(TS_MODEL_SERVER_HOME)) == null && (tsHome = this.getProperty(TS_MODEL_SERVER_HOME, null)) == null) {
            tsHome = ConfigManager.getCanonicalPath(this.findTsHome());
            return tsHome;
        }
        File dir = new File(tsHome);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Model server home not exist: " + tsHome);
        }
        tsHome = ConfigManager.getCanonicalPath(dir);
        return tsHome;
    }

    public String getPythonExecutable() {
        return this.prop.getProperty(PYTHON_EXECUTABLE, PYTHON_EXECUTABLE);
    }

    public String getModelStore() {
        return ConfigManager.getCanonicalPath(this.prop.getProperty(TS_MODEL_STORE));
    }

    public String getWorkflowStore() {
        return ConfigManager.getCanonicalPath(this.prop.getProperty(TS_WORKFLOW_STORE));
    }

    public String getTsCppLogConfig() {
        return this.prop.getProperty(TS_CPP_LOG_CONFIG, null);
    }

    public String getModelSnapshot() {
        return this.prop.getProperty(MODEL_SNAPSHOT, null);
    }

    public String getLoadModels() {
        return this.prop.getProperty(TS_LOAD_MODELS);
    }

    public Pattern getBlacklistPattern() {
        return this.blacklistPattern;
    }

    public String getCorsAllowedOrigin() {
        return this.prop.getProperty(TS_CORS_ALLOWED_ORIGIN);
    }

    public String getCorsAllowedMethods() {
        return this.prop.getProperty(TS_CORS_ALLOWED_METHODS);
    }

    public String getCorsAllowedHeaders() {
        return this.prop.getProperty(TS_CORS_ALLOWED_HEADERS);
    }

    public String getPrivateKeyFile() {
        return this.prop.getProperty(TS_PRIVATE_KEY_FILE);
    }

    public String getCertificateFile() {
        return this.prop.getProperty(TS_CERTIFICATE_FILE);
    }

    public String getSystemMetricsCmd() {
        return this.prop.getProperty(SYSTEM_METRICS_CMD, "");
    }

    public SslContext getSslContext() throws IOException, GeneralSecurityException {
        X509Certificate[] chain;
        PrivateKey privateKey;
        List<String> supportedCiphers = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        String keyStoreFile = this.prop.getProperty(TS_KEYSTORE);
        String privateKeyFile = this.prop.getProperty(TS_PRIVATE_KEY_FILE);
        String certificateFile = this.prop.getProperty(TS_CERTIFICATE_FILE);
        if (keyStoreFile != null) {
            char[] keystorePass = this.getProperty(TS_KEYSTORE_PASS, "changeit").toCharArray();
            String keystoreType = this.getProperty(TS_KEYSTORE_TYPE, "PKCS12");
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            try (InputStream is = Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyStore.load(is, keystorePass);
            }
            Enumeration<String> en = keyStore.aliases();
            String keyAlias = null;
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                keyAlias = alias;
                break;
            }
            if (keyAlias == null) {
                throw new KeyException("No key entry found in keystore.");
            }
            privateKey = (PrivateKey)keyStore.getKey(keyAlias, keystorePass);
            Certificate[] certs = keyStore.getCertificateChain(keyAlias);
            chain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                chain[i] = (X509Certificate)certs[i];
            }
        } else if (privateKeyFile != null && certificateFile != null) {
            privateKey = this.loadPrivateKey(privateKeyFile);
            chain = this.loadCertificateChain(certificateFile);
        } else {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            privateKey = ssc.key();
            chain = new X509Certificate[]{ssc.cert()};
        }
        return SslContextBuilder.forServer(privateKey, chain).protocols("TLSv1.2").ciphers(supportedCiphers).build();
    }

    private PrivateKey loadPrivateKey(String keyFile) throws IOException, GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        try (InputStream is = Files.newInputStream(Paths.get(keyFile, new String[0]), new OpenOption[0]);){
            String content = IOUtils.toString(is, StandardCharsets.UTF_8);
            content = content.replaceAll("-----(BEGIN|END)( RSA)? PRIVATE KEY-----\\s*", "");
            byte[] buf = Base64.getMimeDecoder().decode(content);
            try {
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                PrivateKey privateKey = keyFactory.generatePrivate(privKeySpec);
                return privateKey;
            }
            catch (InvalidKeySpecException e) {
                PrivateKey privateKey;
                block9: {
                    buf = OpenSslKey.convertPrivateKey(buf);
                    PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                    privateKey = keyFactory.generatePrivate(privKeySpec);
                    if (is == null) break block9;
                    is.close();
                }
                return privateKey;
            }
        }
    }

    private X509Certificate[] loadCertificateChain(String keyFile) throws IOException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get(keyFile, new String[0]), new OpenOption[0]);){
            Collection<? extends Certificate> certs = cf.generateCertificates(is);
            int i = 0;
            X509Certificate[] chain = new X509Certificate[certs.size()];
            for (Certificate certificate : certs) {
                chain[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = chain;
            return x509CertificateArray;
        }
    }

    private Properties getLastSnapshot() {
        if (this.isSnapshotDisabled()) {
            return null;
        }
        SnapshotSerializer serializer = SnapshotSerializerFactory.getSerializer();
        return serializer.getLastSnapshot();
    }

    public String getProperty(String key, String def) {
        return this.prop.getProperty(key, def);
    }

    public void validateConfigurations() throws InvalidPropertiesFormatException {
        String blacklistVars = this.prop.getProperty(TS_BLACKLIST_ENV_VARS, "");
        try {
            this.blacklistPattern = Pattern.compile(blacklistVars);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidPropertiesFormatException(e);
        }
    }

    public String dumpConfigurations() {
        Runtime runtime = Runtime.getRuntime();
        return "\nTorchserve version: " + this.prop.getProperty(VERSION) + "\nTS Home: " + this.getModelServerHome() + "\nCurrent directory: " + ConfigManager.getCanonicalPath(".") + "\nTemp directory: " + System.getProperty("java.io.tmpdir") + "\nMetrics config path: " + this.getMetricsConfigPath() + "\nNumber of GPUs: " + this.getNumberOfGpu() + "\nNumber of CPUs: " + runtime.availableProcessors() + "\nMax heap size: " + runtime.maxMemory() / 1024L / 1024L + " M\nPython executable: " + (this.getPythonExecutable() == null ? "N/A" : this.getPythonExecutable()) + "\nConfig file: " + this.prop.getProperty("tsConfigFile", "N/A") + "\nInference address: " + this.getListener(ConnectorType.INFERENCE_CONNECTOR) + "\nManagement address: " + this.getListener(ConnectorType.MANAGEMENT_CONNECTOR) + "\nMetrics address: " + this.getListener(ConnectorType.METRICS_CONNECTOR) + "\nModel Store: " + (this.getModelStore() == null ? "N/A" : this.getModelStore()) + "\nInitial Models: " + (this.getLoadModels() == null ? "N/A" : this.getLoadModels()) + "\nLog dir: " + ConfigManager.getCanonicalPath(System.getProperty("LOG_LOCATION")) + "\nMetrics dir: " + ConfigManager.getCanonicalPath(System.getProperty("METRICS_LOCATION")) + "\nNetty threads: " + this.getNettyThreads() + "\nNetty client threads: " + this.getNettyClientThreads() + "\nDefault workers per model: " + this.getDefaultWorkers() + "\nBlacklist Regex: " + this.prop.getProperty(TS_BLACKLIST_ENV_VARS, "N/A") + "\nMaximum Response Size: " + this.prop.getProperty(TS_MAX_RESPONSE_SIZE, "6553500") + "\nMaximum Request Size: " + this.prop.getProperty(TS_MAX_REQUEST_SIZE, "6553500") + "\nLimit Maximum Image Pixels: " + this.prop.getProperty(TS_LIMIT_MAX_IMAGE_PIXELS, "true") + "\nPrefer direct buffer: " + this.prop.getProperty(TS_PREFER_DIRECT_BUFFER, "false") + "\nAllowed Urls: " + this.getAllowedUrls() + "\nCustom python dependency for model allowed: " + this.prop.getProperty(TS_INSTALL_PY_DEP_PER_MODEL, "false") + "\nEnable metrics API: " + this.prop.getProperty(TS_ENABLE_METRICS_API, "true") + "\nMetrics mode: " + (Object)((Object)this.getMetricsMode()) + "\nDisable system metrics: " + this.isSystemMetricsDisabled() + "\nWorkflow Store: " + (this.getWorkflowStore() == null ? "N/A" : this.getWorkflowStore()) + "\nCPP log config: " + (this.getTsCppLogConfig() == null ? "N/A" : this.getTsCppLogConfig()) + "\nModel config: " + this.prop.getProperty(MODEL_CONFIG, "N/A") + "\nSystem metrics command: " + (this.getSystemMetricsCmd().isEmpty() ? "default" : this.getSystemMetricsCmd());
    }

    public boolean useNativeIo() {
        return Boolean.parseBoolean(this.prop.getProperty(USE_NATIVE_IO, "true"));
    }

    public int getIoRatio() {
        return this.getIntProperty(IO_RATIO, 50);
    }

    public int getMaxResponseSize() {
        return this.getIntProperty(TS_MAX_RESPONSE_SIZE, 6553500);
    }

    public int getMaxRequestSize() {
        return this.getIntProperty(TS_MAX_REQUEST_SIZE, 6553500);
    }

    public boolean isLimitMaxImagePixels() {
        return Boolean.parseBoolean(this.prop.getProperty(TS_LIMIT_MAX_IMAGE_PIXELS, "true"));
    }

    public void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    private int getIntProperty(String key, int def) {
        String value = this.prop.getProperty(key);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public int getDefaultResponseTimeout() {
        return Integer.parseInt(this.prop.getProperty(TS_DEFAULT_RESPONSE_TIMEOUT, "120"));
    }

    public int getUnregisterModelTimeout() {
        return Integer.parseInt(this.prop.getProperty(TS_UNREGISTER_MODEL_TIMEOUT, "120"));
    }

    private File findTsHome() {
        File cwd;
        for (File file = cwd = new File(ConfigManager.getCanonicalPath(".")); file != null; file = file.getParentFile()) {
            File ts = new File(file, "ts");
            if (!ts.exists()) continue;
            return file;
        }
        return cwd;
    }

    private void enableAsyncLogging() {
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
    }

    public HashMap<String, String> getBackendConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("TS_DECODE_INPUT_REQUEST", this.prop.getProperty(TS_DECODE_INPUT_REQUEST, "true"));
        config.put("TS_IPEX_ENABLE", this.prop.getProperty(TS_IPEX_ENABLE, "false"));
        return config;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return ConfigManager.getCanonicalPath(new File(path));
    }

    private static int getAvailableGpu() {
        try {
            ArrayList<Integer> gpuIds = new ArrayList<Integer>();
            String visibleCuda = System.getenv("CUDA_VISIBLE_DEVICES");
            if (visibleCuda != null && !visibleCuda.isEmpty()) {
                String[] ids;
                for (String id : ids = visibleCuda.split(",")) {
                    gpuIds.add(Integer.parseInt(id));
                }
            } else {
                Process process = Runtime.getRuntime().exec("nvidia-smi --query-gpu=index --format=csv");
                int ret = process.waitFor();
                if (ret != 0) {
                    return 0;
                }
                List<String> list = IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
                if (list.isEmpty() || !"index".equals(list.get(0))) {
                    throw new AssertionError((Object)"Unexpected nvidia-smi response.");
                }
                for (int i = 1; i < list.size(); ++i) {
                    gpuIds.add(Integer.parseInt(list.get(i)));
                }
            }
            return gpuIds.size();
        }
        catch (IOException | InterruptedException e) {
            return 0;
        }
    }

    public List<String> getAllowedUrls() {
        String allowedURL = this.prop.getProperty(TS_ALLOWED_URLS, DEFAULT_TS_ALLOWED_URLS);
        return Arrays.asList(allowedURL.split(","));
    }

    public boolean isSnapshotDisabled() {
        return this.snapshotDisabled;
    }

    public Double getTimeToExpiration() {
        if (this.prop.getProperty(TS_TOKEN_EXPIRATION_TIME_MIN) != null) {
            try {
                return Double.valueOf(this.prop.getProperty(TS_TOKEN_EXPIRATION_TIME_MIN));
            }
            catch (NumberFormatException e) {
                this.logger.error("Token expiration not a valid integer");
            }
        }
        return 0.0;
    }

    public boolean isSSLEnabled(ConnectorType connectorType) {
        String address = this.prop.getProperty(TS_INFERENCE_ADDRESS, "http://127.0.0.1:8080");
        switch (connectorType) {
            case MANAGEMENT_CONNECTOR: {
                address = this.prop.getProperty(TS_MANAGEMENT_ADDRESS, "http://127.0.0.1:8081");
                break;
            }
            case METRICS_CONNECTOR: {
                address = this.prop.getProperty(TS_METRICS_ADDRESS, "http://127.0.0.1:8082");
                break;
            }
        }
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid binding address: " + address);
        }
        String protocol = matcher.group(2);
        return "https".equalsIgnoreCase(protocol);
    }

    public int getInitialWorkerPort() {
        return Integer.parseInt(this.prop.getProperty(TS_INITIAL_WORKER_PORT, "9000"));
    }

    public void setInitialWorkerPort(int initialPort) {
        this.prop.setProperty(TS_INITIAL_WORKER_PORT, String.valueOf(initialPort));
    }

    public int getInitialDistributionPort() {
        return Integer.parseInt(this.prop.getProperty(TS_INITIAL_DISTRIBUTION_PORT, "29500"));
    }

    public void setInitialDistributionPort(int initialPort) {
        this.prop.setProperty(TS_INITIAL_DISTRIBUTION_PORT, String.valueOf(initialPort));
    }

    private void setModelConfig() {
        String modelConfigStr = this.prop.getProperty(MODEL_CONFIG, null);
        Type type = new TypeToken<Map<String, Map<String, JsonObject>>>(){}.getType();
        if (modelConfigStr != null) {
            this.modelConfig = (Map)JsonUtils.GSON.fromJson(modelConfigStr, type);
        }
    }

    public int getJsonIntValue(String modelName, String version, String element, int defaultVal) {
        Map<String, JsonObject> versionModel;
        JsonObject jsonObject;
        int value = defaultVal;
        if (this.modelConfig.containsKey(modelName) && (jsonObject = (JsonObject)(versionModel = this.modelConfig.get(modelName)).getOrDefault(version, null)) != null && jsonObject.get(element) != null) {
            try {
                value = jsonObject.get(element).getAsInt();
                if (value <= 0) {
                    value = defaultVal;
                }
            }
            catch (ClassCastException | IllegalStateException e) {
                LoggerFactory.getLogger(ConfigManager.class).error("Invalid value for model: {}:{}, parameter: {}", modelName, version, element);
                return defaultVal;
            }
        }
        return value;
    }

    public Manifest.RuntimeType getJsonRuntimeTypeValue(String modelName, String version, String element, Manifest.RuntimeType defaultVal) {
        Map<String, JsonObject> versionModel;
        JsonObject jsonObject;
        Manifest.RuntimeType value = defaultVal;
        if (this.modelConfig.containsKey(modelName) && (jsonObject = (JsonObject)(versionModel = this.modelConfig.get(modelName)).getOrDefault(version, null)) != null && jsonObject.get(element) != null) {
            try {
                value = Manifest.RuntimeType.fromValue(jsonObject.get(element).getAsString());
            }
            catch (ClassCastException | IllegalArgumentException | IllegalStateException e) {
                LoggerFactory.getLogger(ConfigManager.class).error("Invalid value for model: {}:{}, parameter: {}", modelName, version, element);
                return defaultVal;
            }
        }
        return value;
    }

    public String getVersion() {
        return this.prop.getProperty(VERSION);
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public static final class Arguments {
        private String tsConfigFile;
        private String pythonExecutable;
        private String modelStore;
        private String[] models;
        private boolean snapshotDisabled;
        private String workflowStore;
        private String cppLogConfigFile;

        public Arguments() {
        }

        public Arguments(CommandLine cmd) {
            this.tsConfigFile = cmd.getOptionValue("ts-config-file");
            this.pythonExecutable = cmd.getOptionValue(ConfigManager.PYTHON_EXECUTABLE);
            this.modelStore = cmd.getOptionValue("model-store");
            this.models = cmd.getOptionValues(ConfigManager.MODEL_CONFIG);
            this.snapshotDisabled = cmd.hasOption("no-config-snapshot");
            this.workflowStore = cmd.getOptionValue("workflow-store");
            this.cppLogConfigFile = cmd.getOptionValue("cpp-log-config");
        }

        public static Options getOptions() {
            Options options = new Options();
            options.addOption(Option.builder("f").longOpt("ts-config-file").hasArg().argName("TS-CONFIG-FILE").desc("Path to the configuration properties file.").build());
            options.addOption(Option.builder("e").longOpt(ConfigManager.PYTHON_EXECUTABLE).hasArg().argName("PYTHON").desc("Python runtime executable path.").build());
            options.addOption(Option.builder("m").longOpt(ConfigManager.MODEL_CONFIG).hasArgs().argName("MODELS").desc("Models to be loaded at startup.").build());
            options.addOption(Option.builder("s").longOpt("model-store").hasArg().argName("MODELS-STORE").desc("Model store location where models can be loaded.").build());
            options.addOption(Option.builder("ncs").longOpt("no-config-snapshot").argName("NO-CONFIG-SNAPSHOT").desc("disable torchserve snapshot").build());
            options.addOption(Option.builder("w").longOpt("workflow-store").hasArg().argName("WORKFLOW-STORE").desc("Workflow store location where workflow can be loaded.").build());
            options.addOption(Option.builder("clog").longOpt("cpp-log-config").hasArg().argName("CPP-LOG-CONFIG").desc("log configuration file for cpp backend.").build());
            return options;
        }

        public String getTsConfigFile() {
            return this.tsConfigFile;
        }

        public String getPythonExecutable() {
            return this.pythonExecutable;
        }

        public void setTsConfigFile(String tsConfigFile) {
            this.tsConfigFile = tsConfigFile;
        }

        public String getModelStore() {
            return this.modelStore;
        }

        public String getWorkflowStore() {
            return this.workflowStore;
        }

        public void setModelStore(String modelStore) {
            this.modelStore = modelStore;
        }

        public String[] getModels() {
            return this.models;
        }

        public void setModels(String[] models) {
            this.models = (String[])models.clone();
        }

        public boolean isSnapshotDisabled() {
            return this.snapshotDisabled;
        }

        public void setSnapshotDisabled(boolean snapshotDisabled) {
            this.snapshotDisabled = snapshotDisabled;
        }

        public String getCppLogConfigFile() {
            return this.cppLogConfigFile;
        }

        public void setCppLogConfigFile(String cppLogConfigFile) {
            this.cppLogConfigFile = cppLogConfigFile;
        }
    }
}

