/*
 * Decompiled with CFR 0.152.
 */
package org.pytorch.serve.util;

public final class OpenSslKey {
    private static final int[] RSA_ENCRYPTION = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static final byte[] NULL_BYTES = new byte[]{5, 0};

    private OpenSslKey() {
    }

    public static byte[] convertPrivateKey(byte[] keySpec) {
        if (keySpec == null) {
            return null;
        }
        byte[] bytes = new byte[keySpec.length];
        System.arraycopy(keySpec, 0, bytes, 0, keySpec.length);
        byte[] octetBytes = OpenSslKey.encodeOctetString(bytes);
        byte[] oidBytes = OpenSslKey.encodeOID(RSA_ENCRYPTION);
        byte[] verBytes = new byte[]{2, 1, 0};
        byte[][] seqBytes = new byte[4][];
        seqBytes[0] = oidBytes;
        seqBytes[1] = NULL_BYTES;
        seqBytes[2] = null;
        byte[] oidSeqBytes = OpenSslKey.encodeSequence(seqBytes);
        seqBytes[0] = verBytes;
        seqBytes[1] = oidSeqBytes;
        seqBytes[2] = octetBytes;
        seqBytes[3] = null;
        return OpenSslKey.encodeSequence(seqBytes);
    }

    private static byte[] encodeOID(int[] oid) {
        if (oid == null) {
            return null;
        }
        int oLen = 1;
        for (int i = 2; i < oid.length; ++i) {
            oLen += OpenSslKey.getOIDCompLength(oid[i]);
        }
        int len = oLen + OpenSslKey.getLengthOfLengthField(oLen) + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 6;
        int offset = OpenSslKey.writeLengthField(bytes, oLen);
        bytes[offset++] = (byte)(40 * oid[0] + oid[1]);
        for (int i = 2; i < oid.length; ++i) {
            offset = OpenSslKey.writeOIDComp(oid[i], bytes, offset);
        }
        return bytes;
    }

    private static byte[] encodeOctetString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int oLen = bytes.length;
        int len = oLen + OpenSslKey.getLengthOfLengthField(oLen) + 1;
        byte[] newBytes = new byte[len];
        newBytes[0] = 4;
        int offset = OpenSslKey.writeLengthField(newBytes, oLen);
        if (len - oLen != offset) {
            return null;
        }
        System.arraycopy(bytes, 0, newBytes, offset, oLen);
        return newBytes;
    }

    private static byte[] encodeSequence(byte[][] byteArrays) {
        if (byteArrays == null) {
            return null;
        }
        int oLen = 0;
        for (byte[] b : byteArrays) {
            if (b == null) break;
            oLen += b.length;
        }
        int len = oLen + OpenSslKey.getLengthOfLengthField(oLen) + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 48;
        int offset = OpenSslKey.writeLengthField(bytes, oLen);
        if (len - oLen != offset) {
            return null;
        }
        for (byte[] b : byteArrays) {
            if (b == null) break;
            System.arraycopy(b, 0, bytes, offset, b.length);
            offset += b.length;
        }
        return bytes;
    }

    private static int writeLengthField(byte[] bytes, int len) {
        if (len < 127) {
            bytes[1] = (byte)len;
            return 2;
        }
        int lenOfLenField = OpenSslKey.getLengthOfLengthField(len);
        bytes[1] = (byte)(lenOfLenField - 1 | 0x80);
        for (int i = lenOfLenField; i >= 2; --i) {
            bytes[i] = (byte)(len >> (lenOfLenField - i) * 8);
        }
        return lenOfLenField + 1;
    }

    private static int getLengthOfLengthField(int len) {
        if (len <= 127) {
            return 1;
        }
        if (len <= 255) {
            return 2;
        }
        if (len <= 65535) {
            return 3;
        }
        if (len <= 0xFFFFFF) {
            return 4;
        }
        return 5;
    }

    private static int getOIDCompLength(int comp) {
        if (comp <= 127) {
            return 1;
        }
        if (comp <= 16383) {
            return 2;
        }
        if (comp <= 0x1FFFFF) {
            return 3;
        }
        if (comp <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    private static int writeOIDComp(int comp, byte[] bytes, int offset) {
        int len = OpenSslKey.getOIDCompLength(comp);
        int off = offset;
        for (int i = len - 1; i > 0; --i) {
            bytes[off++] = (byte)(comp >>> i * 7 | 0x80);
        }
        bytes[off++] = (byte)(comp & 0x7F);
        return off;
    }
}

